/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.protocol.game;

import it.unimi.dsi.fastutil.shorts.ShortIterator;
import it.unimi.dsi.fastutil.shorts.ShortSet;
import java.util.function.BiConsumer;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.SectionPosition;
import net.minecraft.network.PacketDataSerializer;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.PacketType;
import net.minecraft.network.protocol.game.GamePacketTypes;
import net.minecraft.network.protocol.game.PacketListenerPlayOut;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.chunk.ChunkSection;

public class PacketPlayOutMultiBlockChange
implements Packet<PacketListenerPlayOut> {
    public static final StreamCodec<PacketDataSerializer, PacketPlayOutMultiBlockChange> STREAM_CODEC = Packet.codec(PacketPlayOutMultiBlockChange::write, PacketPlayOutMultiBlockChange::new);
    private static final int POS_IN_SECTION_BITS = 12;
    private final SectionPosition sectionPos;
    private final short[] positions;
    private final IBlockData[] states;

    public PacketPlayOutMultiBlockChange(SectionPosition sectionposition, ShortSet shortset, ChunkSection chunksection) {
        this.sectionPos = sectionposition;
        int i2 = shortset.size();
        this.positions = new short[i2];
        this.states = new IBlockData[i2];
        int j2 = 0;
        ShortIterator shortiterator = shortset.iterator();
        while (shortiterator.hasNext()) {
            short short0;
            this.positions[j2] = short0 = shortiterator.next().shortValue();
            this.states[j2] = chunksection != null ? chunksection.getBlockState(SectionPosition.sectionRelativeX(short0), SectionPosition.sectionRelativeY(short0), SectionPosition.sectionRelativeZ(short0)) : Blocks.AIR.defaultBlockState();
            ++j2;
        }
    }

    public PacketPlayOutMultiBlockChange(SectionPosition sectionposition, ShortSet shortset, IBlockData[] states) {
        this.sectionPos = sectionposition;
        this.positions = shortset.toShortArray();
        this.states = states;
    }

    private PacketPlayOutMultiBlockChange(PacketDataSerializer packetdataserializer) {
        this.sectionPos = SectionPosition.of(packetdataserializer.readLong());
        int i2 = packetdataserializer.readVarInt();
        this.positions = new short[i2];
        this.states = new IBlockData[i2];
        for (int j2 = 0; j2 < i2; ++j2) {
            long k2 = packetdataserializer.readVarLong();
            this.positions[j2] = (short)(k2 & 0xFFFL);
            this.states[j2] = Block.BLOCK_STATE_REGISTRY.byId((int)(k2 >>> 12));
        }
    }

    private void write(PacketDataSerializer packetdataserializer) {
        packetdataserializer.writeLong(this.sectionPos.asLong());
        packetdataserializer.writeVarInt(this.positions.length);
        for (int i2 = 0; i2 < this.positions.length; ++i2) {
            packetdataserializer.writeVarLong((long)Block.getId(this.states[i2]) << 12 | (long)this.positions[i2]);
        }
    }

    @Override
    public PacketType<PacketPlayOutMultiBlockChange> type() {
        return GamePacketTypes.CLIENTBOUND_SECTION_BLOCKS_UPDATE;
    }

    @Override
    public void handle(PacketListenerPlayOut packetlistenerplayout) {
        packetlistenerplayout.handleChunkBlocksUpdate(this);
    }

    public void runUpdates(BiConsumer<BlockPosition, IBlockData> biconsumer) {
        BlockPosition.MutableBlockPosition blockposition_mutableblockposition = new BlockPosition.MutableBlockPosition();
        for (int i2 = 0; i2 < this.positions.length; ++i2) {
            short short0 = this.positions[i2];
            blockposition_mutableblockposition.set(this.sectionPos.relativeToBlockX(short0), this.sectionPos.relativeToBlockY(short0), this.sectionPos.relativeToBlockZ(short0));
            biconsumer.accept(blockposition_mutableblockposition, this.states[i2]);
        }
    }
}

