/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.protocol.game;

import java.util.Set;
import net.minecraft.network.PacketDataSerializer;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.PacketType;
import net.minecraft.network.protocol.game.GamePacketTypes;
import net.minecraft.network.protocol.game.PacketListenerPlayOut;
import net.minecraft.world.entity.RelativeMovement;

public class PacketPlayOutPosition
implements Packet<PacketListenerPlayOut> {
    public static final StreamCodec<PacketDataSerializer, PacketPlayOutPosition> STREAM_CODEC = Packet.codec(PacketPlayOutPosition::write, PacketPlayOutPosition::new);
    private final double x;
    private final double y;
    private final double z;
    private final float yRot;
    private final float xRot;
    private final Set<RelativeMovement> relativeArguments;
    private final int id;

    public PacketPlayOutPosition(double var0, double var2, double var4, float var6, float var7, Set<RelativeMovement> var8, int var9) {
        this.x = var0;
        this.y = var2;
        this.z = var4;
        this.yRot = var6;
        this.xRot = var7;
        this.relativeArguments = var8;
        this.id = var9;
    }

    private PacketPlayOutPosition(PacketDataSerializer var0) {
        this.x = var0.readDouble();
        this.y = var0.readDouble();
        this.z = var0.readDouble();
        this.yRot = var0.readFloat();
        this.xRot = var0.readFloat();
        this.relativeArguments = RelativeMovement.unpack(var0.readUnsignedByte());
        this.id = var0.readVarInt();
    }

    private void write(PacketDataSerializer var0) {
        var0.writeDouble(this.x);
        var0.writeDouble(this.y);
        var0.writeDouble(this.z);
        var0.writeFloat(this.yRot);
        var0.writeFloat(this.xRot);
        var0.writeByte(RelativeMovement.pack(this.relativeArguments));
        var0.writeVarInt(this.id);
    }

    @Override
    public PacketType<PacketPlayOutPosition> type() {
        return GamePacketTypes.CLIENTBOUND_PLAYER_POSITION;
    }

    @Override
    public void handle(PacketListenerPlayOut var0) {
        var0.handleMovePlayer(this);
    }

    public double getX() {
        return this.x;
    }

    public double getY() {
        return this.y;
    }

    public double getZ() {
        return this.z;
    }

    public float getYRot() {
        return this.yRot;
    }

    public float getXRot() {
        return this.xRot;
    }

    public int getId() {
        return this.id;
    }

    public Set<RelativeMovement> getRelativeArguments() {
        return this.relativeArguments;
    }
}

