/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.protocol.game;

import java.util.UUID;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.PacketType;
import net.minecraft.network.protocol.game.GamePacketTypes;
import net.minecraft.network.protocol.game.PacketListenerPlayOut;
import net.minecraft.server.level.EntityTrackerEntry;
import net.minecraft.util.MathHelper;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.phys.Vec3D;

public class PacketPlayOutSpawnEntity
implements Packet<PacketListenerPlayOut> {
    public static final StreamCodec<RegistryFriendlyByteBuf, PacketPlayOutSpawnEntity> STREAM_CODEC = Packet.codec(PacketPlayOutSpawnEntity::write, PacketPlayOutSpawnEntity::new);
    private static final double MAGICAL_QUANTIZATION = 8000.0;
    private static final double LIMIT = 3.9;
    private final int id;
    private final UUID uuid;
    private final EntityTypes<?> type;
    private final double x;
    private final double y;
    private final double z;
    private final int xa;
    private final int ya;
    private final int za;
    private final byte xRot;
    private final byte yRot;
    private final byte yHeadRot;
    private final int data;

    public PacketPlayOutSpawnEntity(Entity var0, EntityTrackerEntry var1) {
        this(var0, var1, 0);
    }

    public PacketPlayOutSpawnEntity(Entity var0, EntityTrackerEntry var1, int var2) {
        this(var0.getId(), var0.getUUID(), var1.getPositionBase().x(), var1.getPositionBase().y(), var1.getPositionBase().z(), var1.getLastSentXRot(), var1.getLastSentYRot(), var0.getType(), var2, var1.getLastSentMovement(), var1.getLastSentYHeadRot());
    }

    public PacketPlayOutSpawnEntity(Entity var0, int var1, BlockPosition var2) {
        this(var0.getId(), var0.getUUID(), var2.getX(), var2.getY(), var2.getZ(), var0.getXRot(), var0.getYRot(), var0.getType(), var1, var0.getDeltaMovement(), var0.getYHeadRot());
    }

    public PacketPlayOutSpawnEntity(int var0, UUID var1, double var2, double var4, double var6, float var8, float var9, EntityTypes<?> var10, int var11, Vec3D var12, double var13) {
        this.id = var0;
        this.uuid = var1;
        this.x = var2;
        this.y = var4;
        this.z = var6;
        this.xRot = (byte)MathHelper.floor(var8 * 256.0f / 360.0f);
        this.yRot = (byte)MathHelper.floor(var9 * 256.0f / 360.0f);
        this.yHeadRot = (byte)MathHelper.floor(var13 * 256.0 / 360.0);
        this.type = var10;
        this.data = var11;
        this.xa = (int)(MathHelper.clamp(var12.x, -3.9, 3.9) * 8000.0);
        this.ya = (int)(MathHelper.clamp(var12.y, -3.9, 3.9) * 8000.0);
        this.za = (int)(MathHelper.clamp(var12.z, -3.9, 3.9) * 8000.0);
    }

    private PacketPlayOutSpawnEntity(RegistryFriendlyByteBuf var0) {
        this.id = var0.readVarInt();
        this.uuid = var0.readUUID();
        this.type = (EntityTypes)ByteBufCodecs.registry(Registries.ENTITY_TYPE).decode(var0);
        this.x = var0.readDouble();
        this.y = var0.readDouble();
        this.z = var0.readDouble();
        this.xRot = var0.readByte();
        this.yRot = var0.readByte();
        this.yHeadRot = var0.readByte();
        this.data = var0.readVarInt();
        this.xa = var0.readShort();
        this.ya = var0.readShort();
        this.za = var0.readShort();
    }

    private void write(RegistryFriendlyByteBuf var0) {
        var0.writeVarInt(this.id);
        var0.writeUUID(this.uuid);
        ByteBufCodecs.registry(Registries.ENTITY_TYPE).encode(var0, this.type);
        var0.writeDouble(this.x);
        var0.writeDouble(this.y);
        var0.writeDouble(this.z);
        var0.writeByte(this.xRot);
        var0.writeByte(this.yRot);
        var0.writeByte(this.yHeadRot);
        var0.writeVarInt(this.data);
        var0.writeShort(this.xa);
        var0.writeShort(this.ya);
        var0.writeShort(this.za);
    }

    @Override
    public PacketType<PacketPlayOutSpawnEntity> type() {
        return GamePacketTypes.CLIENTBOUND_ADD_ENTITY;
    }

    @Override
    public void handle(PacketListenerPlayOut var0) {
        var0.handleAddEntity(this);
    }

    public int getId() {
        return this.id;
    }

    public UUID getUUID() {
        return this.uuid;
    }

    public EntityTypes<?> getType() {
        return this.type;
    }

    public double getX() {
        return this.x;
    }

    public double getY() {
        return this.y;
    }

    public double getZ() {
        return this.z;
    }

    public double getXa() {
        return (double)this.xa / 8000.0;
    }

    public double getYa() {
        return (double)this.ya / 8000.0;
    }

    public double getZa() {
        return (double)this.za / 8000.0;
    }

    public float getXRot() {
        return (float)(this.xRot * 360) / 256.0f;
    }

    public float getYRot() {
        return (float)(this.yRot * 360) / 256.0f;
    }

    public float getYHeadRot() {
        return (float)(this.yHeadRot * 360) / 256.0f;
    }

    public int getData() {
        return this.data;
    }
}

