/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.protocol.game;

import java.util.function.BiFunction;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.IRegistryCustom;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.PacketType;
import net.minecraft.network.protocol.game.GamePacketTypes;
import net.minecraft.network.protocol.game.PacketListenerPlayOut;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.entity.TileEntityTypes;

public class PacketPlayOutTileEntityData
implements Packet<PacketListenerPlayOut> {
    public static final StreamCodec<RegistryFriendlyByteBuf, PacketPlayOutTileEntityData> STREAM_CODEC = StreamCodec.composite(BlockPosition.STREAM_CODEC, PacketPlayOutTileEntityData::getPos, ByteBufCodecs.registry(Registries.BLOCK_ENTITY_TYPE), PacketPlayOutTileEntityData::getType, ByteBufCodecs.TRUSTED_COMPOUND_TAG, PacketPlayOutTileEntityData::getTag, PacketPlayOutTileEntityData::new);
    private final BlockPosition pos;
    private final TileEntityTypes<?> type;
    private final NBTTagCompound tag;

    public static PacketPlayOutTileEntityData create(TileEntity var0, BiFunction<TileEntity, IRegistryCustom, NBTTagCompound> var1) {
        IRegistryCustom var2 = var0.getLevel().registryAccess();
        return new PacketPlayOutTileEntityData(var0.getBlockPos(), var0.getType(), var1.apply(var0, var2));
    }

    public static PacketPlayOutTileEntityData create(TileEntity var0) {
        return PacketPlayOutTileEntityData.create(var0, TileEntity::getUpdateTag);
    }

    public PacketPlayOutTileEntityData(BlockPosition var0, TileEntityTypes<?> var1, NBTTagCompound var2) {
        this.pos = var0;
        this.type = var1;
        this.tag = var2;
    }

    @Override
    public PacketType<PacketPlayOutTileEntityData> type() {
        return GamePacketTypes.CLIENTBOUND_BLOCK_ENTITY_DATA;
    }

    @Override
    public void handle(PacketListenerPlayOut var0) {
        var0.handleBlockEntityData(this);
    }

    public BlockPosition getPos() {
        return this.pos;
    }

    public TileEntityTypes<?> getType() {
        return this.type;
    }

    public NBTTagCompound getTag() {
        return this.tag;
    }
}

