/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.protocol.game;

import net.minecraft.network.PacketDataSerializer;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.PacketType;
import net.minecraft.network.protocol.game.GamePacketTypes;
import net.minecraft.network.protocol.game.PacketListenerPlayOut;

public class PacketPlayOutUpdateTime
implements Packet<PacketListenerPlayOut> {
    public static final StreamCodec<PacketDataSerializer, PacketPlayOutUpdateTime> STREAM_CODEC = Packet.codec(PacketPlayOutUpdateTime::write, PacketPlayOutUpdateTime::new);
    private final long gameTime;
    private final long dayTime;

    public PacketPlayOutUpdateTime(long var0, long var2, boolean var4) {
        this.gameTime = var0;
        long var5 = var2;
        if (!var4 && (var5 = -var5) == 0L) {
            var5 = -1L;
        }
        this.dayTime = var5;
    }

    private PacketPlayOutUpdateTime(PacketDataSerializer var0) {
        this.gameTime = var0.readLong();
        this.dayTime = var0.readLong();
    }

    private void write(PacketDataSerializer var0) {
        var0.writeLong(this.gameTime);
        var0.writeLong(this.dayTime);
    }

    @Override
    public PacketType<PacketPlayOutUpdateTime> type() {
        return GamePacketTypes.CLIENTBOUND_SET_TIME;
    }

    @Override
    public void handle(PacketListenerPlayOut var0) {
        var0.handleSetTime(this);
    }

    public long getGameTime() {
        return this.gameTime;
    }

    public long getDayTime() {
        return this.dayTime;
    }
}

