/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.syncher;

import com.mojang.logging.LogUtils;
import io.netty.handler.codec.DecoderException;
import io.netty.handler.codec.EncoderException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.network.syncher.DataWatcherSerializer;
import net.minecraft.network.syncher.SyncedDataHolder;
import net.minecraft.util.ClassTreeIdRegistry;
import org.apache.commons.lang3.ObjectUtils;
import org.slf4j.Logger;

public class DataWatcher {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final int MAX_ID_VALUE = 254;
    static final ClassTreeIdRegistry ID_REGISTRY = new ClassTreeIdRegistry();
    private final SyncedDataHolder entity;
    private final Item<?>[] itemsById;
    private boolean isDirty;

    DataWatcher(SyncedDataHolder synceddataholder, Item<?>[] adatawatcher_item) {
        this.entity = synceddataholder;
        this.itemsById = adatawatcher_item;
    }

    public static <T> DataWatcherObject<T> defineId(Class<? extends SyncedDataHolder> oclass, DataWatcherSerializer<T> datawatcherserializer) {
        int i2;
        if (LOGGER.isDebugEnabled()) {
            try {
                Class<?> oclass1 = Class.forName(Thread.currentThread().getStackTrace()[2].getClassName());
                if (!oclass1.equals(oclass)) {
                    LOGGER.debug("defineId called for: {} from {}", new Object[]{oclass, oclass1, new RuntimeException()});
                }
            }
            catch (ClassNotFoundException oclass1) {
                // empty catch block
            }
        }
        if ((i2 = ID_REGISTRY.define(oclass)) > 254) {
            throw new IllegalArgumentException("Data value id is too big with " + i2 + "! (Max is 254)");
        }
        return datawatcherserializer.createAccessor(i2);
    }

    private <T> Item<T> getItem(DataWatcherObject<T> datawatcherobject) {
        return this.itemsById[datawatcherobject.id()];
    }

    public <T> T get(DataWatcherObject<T> datawatcherobject) {
        return this.getItem(datawatcherobject).getValue();
    }

    public <T> void set(DataWatcherObject<T> datawatcherobject, T t0) {
        this.set(datawatcherobject, t0, false);
    }

    public <T> void set(DataWatcherObject<T> datawatcherobject, T t0, boolean flag) {
        Item<T> datawatcher_item = this.getItem(datawatcherobject);
        if (flag || ObjectUtils.notEqual(t0, datawatcher_item.getValue())) {
            datawatcher_item.setValue(t0);
            this.entity.onSyncedDataUpdated(datawatcherobject);
            datawatcher_item.setDirty(true);
            this.isDirty = true;
        }
    }

    public <T> void markDirty(DataWatcherObject<T> datawatcherobject) {
        this.getItem(datawatcherobject).setDirty(true);
        this.isDirty = true;
    }

    public boolean isDirty() {
        return this.isDirty;
    }

    @Nullable
    public List<c<?>> packDirty() {
        if (!this.isDirty) {
            return null;
        }
        this.isDirty = false;
        ArrayList list = new ArrayList();
        for (Item<?> datawatcher_item : this.itemsById) {
            if (!datawatcher_item.isDirty()) continue;
            datawatcher_item.setDirty(false);
            list.add(datawatcher_item.value());
        }
        return list;
    }

    @Nullable
    public List<c<?>> getNonDefaultValues() {
        ArrayList list = null;
        for (Item<?> datawatcher_item : this.itemsById) {
            if (datawatcher_item.isSetToDefault()) continue;
            if (list == null) {
                list = new ArrayList();
            }
            list.add(datawatcher_item.value());
        }
        return list;
    }

    public void assignValues(List<c<?>> list) {
        for (c<?> datawatcher_c : list) {
            Item<?> datawatcher_item = this.itemsById[datawatcher_c.id];
            this.assignValue(datawatcher_item, datawatcher_c);
            this.entity.onSyncedDataUpdated(datawatcher_item.getAccessor());
        }
        this.entity.onSyncedDataUpdated(list);
    }

    private <T> void assignValue(Item<T> datawatcher_item, c<?> datawatcher_c) {
        if (!Objects.equals(datawatcher_c.serializer(), datawatcher_item.accessor.serializer())) {
            throw new IllegalStateException(String.format(Locale.ROOT, "Invalid entity data item type for field %d on entity %s: old=%s(%s), new=%s(%s)", datawatcher_item.accessor.id(), this.entity, datawatcher_item.value, datawatcher_item.value.getClass(), datawatcher_c.value, datawatcher_c.value.getClass()));
        }
        datawatcher_item.setValue(datawatcher_c.value);
    }

    public static class Item<T> {
        final DataWatcherObject<T> accessor;
        T value;
        private final T initialValue;
        private boolean dirty;

        public Item(DataWatcherObject<T> datawatcherobject, T t0) {
            this.accessor = datawatcherobject;
            this.initialValue = t0;
            this.value = t0;
        }

        public DataWatcherObject<T> getAccessor() {
            return this.accessor;
        }

        public void setValue(T t0) {
            this.value = t0;
        }

        public T getValue() {
            return this.value;
        }

        public boolean isDirty() {
            return this.dirty;
        }

        public void setDirty(boolean flag) {
            this.dirty = flag;
        }

        public boolean isSetToDefault() {
            return this.initialValue.equals(this.value);
        }

        public c<T> value() {
            return c.create(this.accessor, this.value);
        }
    }

    public record c<T>(int id, DataWatcherSerializer<T> serializer, T value) {
        public static <T> c<T> create(DataWatcherObject<T> datawatcherobject, T t0) {
            DataWatcherSerializer<T> datawatcherserializer = datawatcherobject.serializer();
            return new c<T>(datawatcherobject.id(), datawatcherserializer, datawatcherserializer.copy(t0));
        }

        public void write(RegistryFriendlyByteBuf registryfriendlybytebuf) {
            int i2 = DataWatcherRegistry.getSerializedId(this.serializer);
            if (i2 < 0) {
                throw new EncoderException("Unknown serializer type " + String.valueOf(this.serializer));
            }
            registryfriendlybytebuf.writeByte(this.id);
            registryfriendlybytebuf.writeVarInt(i2);
            this.serializer.codec().encode(registryfriendlybytebuf, this.value);
        }

        public static c<?> read(RegistryFriendlyByteBuf registryfriendlybytebuf, int i2) {
            int j2 = registryfriendlybytebuf.readVarInt();
            DataWatcherSerializer<?> datawatcherserializer = DataWatcherRegistry.getSerializer(j2);
            if (datawatcherserializer == null) {
                throw new DecoderException("Unknown serializer type " + j2);
            }
            return c.read(registryfriendlybytebuf, i2, datawatcherserializer);
        }

        private static <T> c<T> read(RegistryFriendlyByteBuf registryfriendlybytebuf, int i2, DataWatcherSerializer<T> datawatcherserializer) {
            return new c<T>(i2, datawatcherserializer, datawatcherserializer.codec().decode(registryfriendlybytebuf));
        }
    }

    public static class a {
        private final SyncedDataHolder entity;
        private final Item<?>[] itemsById;

        public a(SyncedDataHolder synceddataholder) {
            this.entity = synceddataholder;
            this.itemsById = new Item[ID_REGISTRY.getCount(synceddataholder.getClass())];
        }

        public <T> a define(DataWatcherObject<T> datawatcherobject, T t0) {
            int i2 = datawatcherobject.id();
            if (i2 > this.itemsById.length) {
                throw new IllegalArgumentException("Data value id is too big with " + i2 + "! (Max is " + this.itemsById.length + ")");
            }
            if (this.itemsById[i2] != null) {
                throw new IllegalArgumentException("Duplicate id value for " + i2 + "!");
            }
            if (DataWatcherRegistry.getSerializedId(datawatcherobject.serializer()) < 0) {
                String s2 = String.valueOf(datawatcherobject.serializer());
                throw new IllegalArgumentException("Unregistered serializer " + s2 + " for " + i2 + "!");
            }
            this.itemsById[datawatcherobject.id()] = new Item<T>(datawatcherobject, t0);
            return this;
        }

        public DataWatcher build() {
            for (int i2 = 0; i2 < this.itemsById.length; ++i2) {
                if (this.itemsById[i2] != null) continue;
                String s2 = String.valueOf(this.entity.getClass());
                throw new IllegalStateException("Entity " + s2 + " has not defined synched data value " + i2);
            }
            return new DataWatcher(this.entity, this.itemsById);
        }
    }
}

