/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.resources;

import java.util.List;
import java.util.Map;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.server.packs.resources.IResource;
import net.minecraft.server.packs.resources.IResourceManager;

public class FileToIdConverter {
    private final String prefix;
    private final String extension;

    public FileToIdConverter(String var0, String var1) {
        this.prefix = var0;
        this.extension = var1;
    }

    public static FileToIdConverter json(String var0) {
        return new FileToIdConverter(var0, ".json");
    }

    public MinecraftKey idToFile(MinecraftKey var0) {
        return var0.withPath(this.prefix + "/" + var0.getPath() + this.extension);
    }

    public MinecraftKey fileToId(MinecraftKey var0) {
        String var1 = var0.getPath();
        return var0.withPath(var1.substring(this.prefix.length() + 1, var1.length() - this.extension.length()));
    }

    public Map<MinecraftKey, IResource> listMatchingResources(IResourceManager var02) {
        return var02.listResources(this.prefix, var0 -> var0.getPath().endsWith(this.extension));
    }

    public Map<MinecraftKey, List<IResource>> listMatchingResourceStacks(IResourceManager var02) {
        return var02.listResourceStacks(this.prefix, var0 -> var0.getPath().endsWith(this.extension));
    }
}

