/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server;

import com.google.common.collect.ImmutableMap;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementHolder;
import net.minecraft.advancements.AdvancementNode;
import net.minecraft.advancements.AdvancementTree;
import net.minecraft.advancements.TreeNodePosition;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.resources.RegistryOps;
import net.minecraft.server.packs.resources.IResourceManager;
import net.minecraft.server.packs.resources.ResourceDataJson;
import net.minecraft.util.ProblemReporter;
import net.minecraft.util.profiling.GameProfilerFiller;
import org.slf4j.Logger;
import org.spigotmc.SpigotConfig;

public class AdvancementDataWorld
extends ResourceDataJson {
    private static final Logger LOGGER = LogUtils.getLogger();
    public static final Gson GSON = new GsonBuilder().create();
    public Map<MinecraftKey, AdvancementHolder> advancements = new HashMap<MinecraftKey, AdvancementHolder>();
    private AdvancementTree tree = new AdvancementTree();
    private final HolderLookup.a registries;

    public AdvancementDataWorld(HolderLookup.a holderlookup_a) {
        super(GSON, Registries.elementsDirPath(Registries.ADVANCEMENT));
        this.registries = holderlookup_a;
    }

    @Override
    protected void apply(Map<MinecraftKey, JsonElement> map, IResourceManager iresourcemanager, GameProfilerFiller gameprofilerfiller) {
        RegistryOps registryops = this.registries.createSerializationContext(JsonOps.INSTANCE);
        ImmutableMap.Builder builder = ImmutableMap.builder();
        map.forEach((minecraftkey, jsonelement) -> {
            if (SpigotConfig.disabledAdvancements != null && (SpigotConfig.disabledAdvancements.contains("*") || SpigotConfig.disabledAdvancements.contains(minecraftkey.toString()) || SpigotConfig.disabledAdvancements.contains(minecraftkey.getNamespace()))) {
                return;
            }
            try {
                Advancement advancement = (Advancement)Advancement.CODEC.parse((DynamicOps)registryops, jsonelement).getOrThrow(JsonParseException::new);
                this.validate((MinecraftKey)minecraftkey, advancement);
                builder.put(minecraftkey, (Object)new AdvancementHolder((MinecraftKey)minecraftkey, advancement));
            }
            catch (Exception exception) {
                LOGGER.error("Parsing error loading custom advancement {}: {}", minecraftkey, (Object)exception.getMessage());
            }
        });
        this.advancements = new HashMap<MinecraftKey, AdvancementHolder>((Map<MinecraftKey, AdvancementHolder>)builder.buildOrThrow());
        AdvancementTree advancementtree = new AdvancementTree();
        advancementtree.addAll(this.advancements.values());
        for (AdvancementNode advancementnode : advancementtree.roots()) {
            if (!advancementnode.holder().value().display().isPresent()) continue;
            TreeNodePosition.run(advancementnode);
        }
        this.tree = advancementtree;
    }

    private void validate(MinecraftKey minecraftkey, Advancement advancement) {
        ProblemReporter.a problemreporter_a = new ProblemReporter.a();
        advancement.validate(problemreporter_a, this.registries.asGetterLookup());
        problemreporter_a.getReport().ifPresent(s2 -> LOGGER.warn("Found validation problems in advancement {}: \n{}", (Object)minecraftkey, s2));
    }

    @Nullable
    public AdvancementHolder get(MinecraftKey minecraftkey) {
        return this.advancements.get(minecraftkey);
    }

    public AdvancementTree tree() {
        return this.tree;
    }

    public Collection<AdvancementHolder> getAllAdvancements() {
        return this.advancements.values();
    }
}

