/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server;

import com.mojang.logging.LogUtils;
import java.io.PrintStream;
import java.time.Duration;
import java.time.Instant;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.SharedConstants;
import net.minecraft.commands.CommandDispatcher;
import net.minecraft.commands.arguments.selector.options.PlayerSelector;
import net.minecraft.core.cauldron.CauldronInteraction;
import net.minecraft.core.dispenser.IDispenseBehavior;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.locale.LocaleLanguage;
import net.minecraft.server.DebugOutputStream;
import net.minecraft.server.RedirectStream;
import net.minecraft.util.datafix.fixes.DataConverterFlattenData;
import net.minecraft.util.datafix.fixes.DataConverterMaterialId;
import net.minecraft.util.datafix.fixes.DataConverterSpawnEgg;
import net.minecraft.world.effect.MobEffectList;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.ai.attributes.AttributeBase;
import net.minecraft.world.entity.ai.attributes.AttributeDefaults;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockComposter;
import net.minecraft.world.level.block.BlockFire;
import org.slf4j.Logger;

public class DispenserRegistry {
    public static final PrintStream STDOUT = System.out;
    private static volatile boolean isBootstrapped;
    private static final Logger LOGGER;
    public static final AtomicLong bootstrapDuration;

    public static void bootStrap() {
        if (!isBootstrapped) {
            String name;
            switch (name = DispenserRegistry.class.getSimpleName()) {
                case "DispenserRegistry": {
                    break;
                }
                case "Bootstrap": {
                    System.err.println("***************************************************************************");
                    System.err.println("*** WARNING: This server jar may only be used for development purposes. ***");
                    System.err.println("***************************************************************************");
                    break;
                }
                default: {
                    System.err.println("**********************************************************************");
                    System.err.println("*** WARNING: This server jar is unsupported, use at your own risk. ***");
                    System.err.println("**********************************************************************");
                }
            }
            isBootstrapped = true;
            Instant instant = Instant.now();
            if (BuiltInRegistries.REGISTRY.keySet().isEmpty()) {
                throw new IllegalStateException("Unable to load registries");
            }
            BlockFire.bootStrap();
            BlockComposter.bootStrap();
            if (EntityTypes.getKey(EntityTypes.PLAYER) == null) {
                throw new IllegalStateException("Failed loading EntityTypes");
            }
            PlayerSelector.bootStrap();
            IDispenseBehavior.bootStrap();
            CauldronInteraction.bootStrap();
            BuiltInRegistries.bootStrap();
            CreativeModeTabs.validate();
            DispenserRegistry.wrapStreams();
            bootstrapDuration.set(Duration.between(instant, Instant.now()).toMillis());
            DataConverterFlattenData.register(1008, "{Name:'minecraft:oak_sign',Properties:{rotation:'0'}}", "{Name:'minecraft:standing_sign',Properties:{rotation:'0'}}");
            DataConverterFlattenData.register(1009, "{Name:'minecraft:oak_sign',Properties:{rotation:'1'}}", "{Name:'minecraft:standing_sign',Properties:{rotation:'1'}}");
            DataConverterFlattenData.register(1010, "{Name:'minecraft:oak_sign',Properties:{rotation:'2'}}", "{Name:'minecraft:standing_sign',Properties:{rotation:'2'}}");
            DataConverterFlattenData.register(1011, "{Name:'minecraft:oak_sign',Properties:{rotation:'3'}}", "{Name:'minecraft:standing_sign',Properties:{rotation:'3'}}");
            DataConverterFlattenData.register(1012, "{Name:'minecraft:oak_sign',Properties:{rotation:'4'}}", "{Name:'minecraft:standing_sign',Properties:{rotation:'4'}}");
            DataConverterFlattenData.register(1013, "{Name:'minecraft:oak_sign',Properties:{rotation:'5'}}", "{Name:'minecraft:standing_sign',Properties:{rotation:'5'}}");
            DataConverterFlattenData.register(1014, "{Name:'minecraft:oak_sign',Properties:{rotation:'6'}}", "{Name:'minecraft:standing_sign',Properties:{rotation:'6'}}");
            DataConverterFlattenData.register(1015, "{Name:'minecraft:oak_sign',Properties:{rotation:'7'}}", "{Name:'minecraft:standing_sign',Properties:{rotation:'7'}}");
            DataConverterFlattenData.register(1016, "{Name:'minecraft:oak_sign',Properties:{rotation:'8'}}", "{Name:'minecraft:standing_sign',Properties:{rotation:'8'}}");
            DataConverterFlattenData.register(1017, "{Name:'minecraft:oak_sign',Properties:{rotation:'9'}}", "{Name:'minecraft:standing_sign',Properties:{rotation:'9'}}");
            DataConverterFlattenData.register(1018, "{Name:'minecraft:oak_sign',Properties:{rotation:'10'}}", "{Name:'minecraft:standing_sign',Properties:{rotation:'10'}}");
            DataConverterFlattenData.register(1019, "{Name:'minecraft:oak_sign',Properties:{rotation:'11'}}", "{Name:'minecraft:standing_sign',Properties:{rotation:'11'}}");
            DataConverterFlattenData.register(1020, "{Name:'minecraft:oak_sign',Properties:{rotation:'12'}}", "{Name:'minecraft:standing_sign',Properties:{rotation:'12'}}");
            DataConverterFlattenData.register(1021, "{Name:'minecraft:oak_sign',Properties:{rotation:'13'}}", "{Name:'minecraft:standing_sign',Properties:{rotation:'13'}}");
            DataConverterFlattenData.register(1022, "{Name:'minecraft:oak_sign',Properties:{rotation:'14'}}", "{Name:'minecraft:standing_sign',Properties:{rotation:'14'}}");
            DataConverterFlattenData.register(1023, "{Name:'minecraft:oak_sign',Properties:{rotation:'15'}}", "{Name:'minecraft:standing_sign',Properties:{rotation:'15'}}");
            DataConverterMaterialId.ITEM_NAMES.put(323, (Object)"minecraft:oak_sign");
            DataConverterFlattenData.register(1440, "{Name:'minecraft:portal',Properties:{axis:'x'}}", "{Name:'minecraft:portal',Properties:{axis:'x'}}");
            DataConverterMaterialId.ITEM_NAMES.put(409, (Object)"minecraft:prismarine_shard");
            DataConverterMaterialId.ITEM_NAMES.put(410, (Object)"minecraft:prismarine_crystals");
            DataConverterMaterialId.ITEM_NAMES.put(411, (Object)"minecraft:rabbit");
            DataConverterMaterialId.ITEM_NAMES.put(412, (Object)"minecraft:cooked_rabbit");
            DataConverterMaterialId.ITEM_NAMES.put(413, (Object)"minecraft:rabbit_stew");
            DataConverterMaterialId.ITEM_NAMES.put(414, (Object)"minecraft:rabbit_foot");
            DataConverterMaterialId.ITEM_NAMES.put(415, (Object)"minecraft:rabbit_hide");
            DataConverterMaterialId.ITEM_NAMES.put(416, (Object)"minecraft:armor_stand");
            DataConverterMaterialId.ITEM_NAMES.put(423, (Object)"minecraft:mutton");
            DataConverterMaterialId.ITEM_NAMES.put(424, (Object)"minecraft:cooked_mutton");
            DataConverterMaterialId.ITEM_NAMES.put(425, (Object)"minecraft:banner");
            DataConverterMaterialId.ITEM_NAMES.put(426, (Object)"minecraft:end_crystal");
            DataConverterMaterialId.ITEM_NAMES.put(427, (Object)"minecraft:spruce_door");
            DataConverterMaterialId.ITEM_NAMES.put(428, (Object)"minecraft:birch_door");
            DataConverterMaterialId.ITEM_NAMES.put(429, (Object)"minecraft:jungle_door");
            DataConverterMaterialId.ITEM_NAMES.put(430, (Object)"minecraft:acacia_door");
            DataConverterMaterialId.ITEM_NAMES.put(431, (Object)"minecraft:dark_oak_door");
            DataConverterMaterialId.ITEM_NAMES.put(432, (Object)"minecraft:chorus_fruit");
            DataConverterMaterialId.ITEM_NAMES.put(433, (Object)"minecraft:chorus_fruit_popped");
            DataConverterMaterialId.ITEM_NAMES.put(434, (Object)"minecraft:beetroot");
            DataConverterMaterialId.ITEM_NAMES.put(435, (Object)"minecraft:beetroot_seeds");
            DataConverterMaterialId.ITEM_NAMES.put(436, (Object)"minecraft:beetroot_soup");
            DataConverterMaterialId.ITEM_NAMES.put(437, (Object)"minecraft:dragon_breath");
            DataConverterMaterialId.ITEM_NAMES.put(438, (Object)"minecraft:splash_potion");
            DataConverterMaterialId.ITEM_NAMES.put(439, (Object)"minecraft:spectral_arrow");
            DataConverterMaterialId.ITEM_NAMES.put(440, (Object)"minecraft:tipped_arrow");
            DataConverterMaterialId.ITEM_NAMES.put(441, (Object)"minecraft:lingering_potion");
            DataConverterMaterialId.ITEM_NAMES.put(442, (Object)"minecraft:shield");
            DataConverterMaterialId.ITEM_NAMES.put(443, (Object)"minecraft:elytra");
            DataConverterMaterialId.ITEM_NAMES.put(444, (Object)"minecraft:spruce_boat");
            DataConverterMaterialId.ITEM_NAMES.put(445, (Object)"minecraft:birch_boat");
            DataConverterMaterialId.ITEM_NAMES.put(446, (Object)"minecraft:jungle_boat");
            DataConverterMaterialId.ITEM_NAMES.put(447, (Object)"minecraft:acacia_boat");
            DataConverterMaterialId.ITEM_NAMES.put(448, (Object)"minecraft:dark_oak_boat");
            DataConverterMaterialId.ITEM_NAMES.put(449, (Object)"minecraft:totem_of_undying");
            DataConverterMaterialId.ITEM_NAMES.put(450, (Object)"minecraft:shulker_shell");
            DataConverterMaterialId.ITEM_NAMES.put(452, (Object)"minecraft:iron_nugget");
            DataConverterMaterialId.ITEM_NAMES.put(453, (Object)"minecraft:knowledge_book");
            DataConverterSpawnEgg.ID_TO_ENTITY[23] = "Arrow";
        }
    }

    private static <T> void checkTranslations(Iterable<T> iterable, Function<T, String> function, Set<String> set) {
        LocaleLanguage localelanguage = LocaleLanguage.getInstance();
        iterable.forEach(object -> {
            String s2 = (String)function.apply(object);
            if (!localelanguage.has(s2)) {
                set.add(s2);
            }
        });
    }

    private static void checkGameruleTranslations(final Set<String> set) {
        final LocaleLanguage localelanguage = LocaleLanguage.getInstance();
        GameRules.visitGameRuleTypes(new GameRules.GameRuleVisitor(){

            @Override
            public <T extends GameRules.GameRuleValue<T>> void visit(GameRules.GameRuleKey<T> gamerules_gamerulekey, GameRules.GameRuleDefinition<T> gamerules_gameruledefinition) {
                if (!localelanguage.has(gamerules_gamerulekey.getDescriptionId())) {
                    set.add(gamerules_gamerulekey.getId());
                }
            }
        });
    }

    public static Set<String> getMissingTranslations() {
        TreeSet<String> set = new TreeSet<String>();
        DispenserRegistry.checkTranslations(BuiltInRegistries.ATTRIBUTE, AttributeBase::getDescriptionId, set);
        DispenserRegistry.checkTranslations(BuiltInRegistries.ENTITY_TYPE, EntityTypes::getDescriptionId, set);
        DispenserRegistry.checkTranslations(BuiltInRegistries.MOB_EFFECT, MobEffectList::getDescriptionId, set);
        DispenserRegistry.checkTranslations(BuiltInRegistries.ITEM, Item::getDescriptionId, set);
        DispenserRegistry.checkTranslations(BuiltInRegistries.BLOCK, Block::getDescriptionId, set);
        DispenserRegistry.checkTranslations(BuiltInRegistries.CUSTOM_STAT, minecraftkey -> {
            String s2 = minecraftkey.toString();
            return "stat." + s2.replace(':', '.');
        }, set);
        DispenserRegistry.checkGameruleTranslations(set);
        return set;
    }

    public static void checkBootstrapCalled(Supplier<String> supplier) {
        if (!isBootstrapped) {
            throw DispenserRegistry.createBootstrapException(supplier);
        }
    }

    private static RuntimeException createBootstrapException(Supplier<String> supplier) {
        try {
            String s2 = supplier.get();
            return new IllegalArgumentException("Not bootstrapped (called from " + s2 + ")");
        }
        catch (Exception exception) {
            IllegalArgumentException illegalargumentexception = new IllegalArgumentException("Not bootstrapped (failed to resolve location)");
            illegalargumentexception.addSuppressed(exception);
            return illegalargumentexception;
        }
    }

    public static void validate() {
        DispenserRegistry.checkBootstrapCalled(() -> "validate");
        if (SharedConstants.IS_RUNNING_IN_IDE) {
            DispenserRegistry.getMissingTranslations().forEach(s2 -> LOGGER.error("Missing translations: {}", s2));
            CommandDispatcher.validate();
        }
        AttributeDefaults.validate();
    }

    private static void wrapStreams() {
        if (LOGGER.isDebugEnabled()) {
            System.setErr(new DebugOutputStream("STDERR", System.err));
            System.setOut(new DebugOutputStream("STDOUT", STDOUT));
        } else {
            System.setErr(new RedirectStream("STDERR", System.err));
            System.setOut(new RedirectStream("STDOUT", STDOUT));
        }
    }

    public static void realStdoutPrintln(String s2) {
        STDOUT.println(s2);
    }

    static {
        LOGGER = LogUtils.getLogger();
        bootstrapDuration = new AtomicLong(-1L);
    }
}

