/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server;

import com.google.common.base.Charsets;
import com.mojang.authlib.yggdrasil.YggdrasilAuthenticationService;
import com.mojang.datafixers.DataFixer;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.Lifecycle;
import java.awt.GraphicsEnvironment;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UncheckedIOException;
import java.net.Proxy;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BooleanSupplier;
import javax.annotation.Nullable;
import joptsimple.OptionSet;
import net.minecraft.CrashReport;
import net.minecraft.SharedConstants;
import net.minecraft.SystemUtils;
import net.minecraft.commands.CommandDispatcher;
import net.minecraft.core.IRegistry;
import net.minecraft.core.IRegistryCustom;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.NbtException;
import net.minecraft.nbt.ReportedNbtException;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.obfuscate.DontObfuscate;
import net.minecraft.server.DispenserRegistry;
import net.minecraft.server.EULA;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.Services;
import net.minecraft.server.WorldLoader;
import net.minecraft.server.WorldStem;
import net.minecraft.server.dedicated.DedicatedServer;
import net.minecraft.server.dedicated.DedicatedServerProperties;
import net.minecraft.server.dedicated.DedicatedServerSettings;
import net.minecraft.server.level.progress.WorldLoadListenerLogger;
import net.minecraft.server.packs.EnumResourcePackType;
import net.minecraft.server.packs.repository.ResourcePackRepository;
import net.minecraft.server.packs.repository.ResourcePackSourceVanilla;
import net.minecraft.util.MathHelper;
import net.minecraft.util.datafix.DataConverterRegistry;
import net.minecraft.util.profiling.jfr.Environment;
import net.minecraft.util.profiling.jfr.JvmProfiler;
import net.minecraft.util.worldupdate.WorldUpgrader;
import net.minecraft.world.flag.FeatureFlags;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.WorldDataConfiguration;
import net.minecraft.world.level.WorldSettings;
import net.minecraft.world.level.chunk.storage.RegionFileCompression;
import net.minecraft.world.level.dimension.WorldDimension;
import net.minecraft.world.level.levelgen.WorldDimensions;
import net.minecraft.world.level.levelgen.WorldOptions;
import net.minecraft.world.level.levelgen.presets.WorldPresets;
import net.minecraft.world.level.storage.Convertable;
import net.minecraft.world.level.storage.LevelDataAndDimensions;
import net.minecraft.world.level.storage.SaveData;
import net.minecraft.world.level.storage.SavedFile;
import net.minecraft.world.level.storage.WorldDataServer;
import net.minecraft.world.level.storage.WorldInfo;
import org.bukkit.configuration.Configuration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.slf4j.Logger;

public class Main {
    private static final Logger LOGGER = LogUtils.getLogger();

    @DontObfuscate
    public static void main(OptionSet optionset) {
        SharedConstants.tryDetectVersion();
        try {
            WorldStem worldstem;
            Dynamic<?> dynamic;
            Path path = (Path)optionset.valueOf("pidFile");
            if (path != null) {
                Main.writePidFile(path);
            }
            CrashReport.preload();
            if (optionset.has("jfrProfile")) {
                JvmProfiler.INSTANCE.start(Environment.SERVER);
            }
            DispenserRegistry.bootStrap();
            DispenserRegistry.validate();
            SystemUtils.startTimerHackThread();
            Path path1 = Paths.get("server.properties", new String[0]);
            DedicatedServerSettings dedicatedserversettings = new DedicatedServerSettings(optionset);
            dedicatedserversettings.forceSave();
            RegionFileCompression.configure(dedicatedserversettings.getProperties().regionFileComression);
            Path path2 = Paths.get("eula.txt", new String[0]);
            EULA eula = new EULA(path2);
            if (optionset.has("initSettings")) {
                File configFile = (File)optionset.valueOf("bukkit-settings");
                YamlConfiguration configuration = YamlConfiguration.loadConfiguration((File)configFile);
                configuration.options().copyDefaults(true);
                configuration.setDefaults((Configuration)YamlConfiguration.loadConfiguration((Reader)new InputStreamReader(Main.class.getClassLoader().getResourceAsStream("configurations/bukkit.yml"), Charsets.UTF_8)));
                configuration.save(configFile);
                File commandFile = (File)optionset.valueOf("commands-settings");
                YamlConfiguration commandsConfiguration = YamlConfiguration.loadConfiguration((File)commandFile);
                commandsConfiguration.options().copyDefaults(true);
                commandsConfiguration.setDefaults((Configuration)YamlConfiguration.loadConfiguration((Reader)new InputStreamReader(Main.class.getClassLoader().getResourceAsStream("configurations/commands.yml"), Charsets.UTF_8)));
                commandsConfiguration.save(commandFile);
                LOGGER.info("Initialized '{}' and '{}'", (Object)path1.toAbsolutePath(), (Object)path2.toAbsolutePath());
                return;
            }
            boolean eulaAgreed = Boolean.getBoolean("com.mojang.eula.agree");
            if (eulaAgreed) {
                System.err.println("You have used the Spigot command line EULA agreement flag.");
                System.err.println("By using this setting you are indicating your agreement to Mojang's EULA (https://account.mojang.com/documents/minecraft_eula).");
                System.err.println("If you do not agree to the above EULA please stop your server and remove this flag immediately.");
            }
            if (!eula.hasAgreedToEULA() && !eulaAgreed) {
                LOGGER.info("You need to agree to the EULA in order to run the server. Go to eula.txt for more info.");
                return;
            }
            File file = (File)optionset.valueOf("universe");
            Services services = Services.create(new YggdrasilAuthenticationService(Proxy.NO_PROXY), file);
            String s2 = Optional.ofNullable((String)optionset.valueOf("world")).orElse(dedicatedserversettings.getProperties().levelName);
            Convertable convertable = Convertable.createDefault(file.toPath());
            Convertable.ConversionSession convertable_conversionsession = convertable.validateAndCreateAccess(s2, WorldDimension.OVERWORLD);
            if (convertable_conversionsession.hasWorldData()) {
                WorldInfo worldinfo;
                try {
                    dynamic = convertable_conversionsession.getDataTag();
                    worldinfo = convertable_conversionsession.getSummary(dynamic);
                }
                catch (IOException | NbtException | ReportedNbtException ioexception) {
                    Convertable.b convertable_b = convertable_conversionsession.getLevelDirectory();
                    LOGGER.warn("Failed to load world data from {}", (Object)convertable_b.dataFile(), (Object)ioexception);
                    LOGGER.info("Attempting to use fallback");
                    try {
                        dynamic = convertable_conversionsession.getDataTagFallback();
                        worldinfo = convertable_conversionsession.getSummary(dynamic);
                    }
                    catch (IOException | NbtException | ReportedNbtException ioexception1) {
                        LOGGER.error("Failed to load world data from {}", (Object)convertable_b.oldDataFile(), (Object)ioexception1);
                        LOGGER.error("Failed to load world data from {} and {}. World files may be corrupted. Shutting down.", (Object)convertable_b.dataFile(), (Object)convertable_b.oldDataFile());
                        return;
                    }
                    convertable_conversionsession.restoreLevelDataFromOld();
                }
                if (worldinfo.requiresManualConversion()) {
                    LOGGER.info("This world must be opened in an older version (like 1.6.4) to be safely converted");
                    return;
                }
                if (!worldinfo.isCompatible()) {
                    LOGGER.info("This world was created by an incompatible version.");
                    return;
                }
            } else {
                dynamic = null;
            }
            Dynamic<?> dynamic1 = dynamic;
            boolean flag = optionset.has("safeMode");
            if (flag) {
                LOGGER.warn("Safe mode active, only vanilla datapack will be loaded");
            }
            ResourcePackRepository resourcepackrepository = ResourcePackSourceVanilla.createPackRepository(convertable_conversionsession);
            File bukkitDataPackFolder = new File(convertable_conversionsession.getLevelPath(SavedFile.DATAPACK_DIR).toFile(), "bukkit");
            if (!bukkitDataPackFolder.exists()) {
                bukkitDataPackFolder.mkdirs();
            }
            File mcMeta = new File(bukkitDataPackFolder, "pack.mcmeta");
            try {
                com.google.common.io.Files.write((CharSequence)("{\n    \"pack\": {\n        \"description\": \"Data pack for resources provided by Bukkit plugins\",\n        \"pack_format\": " + SharedConstants.getCurrentVersion().getPackVersion(EnumResourcePackType.SERVER_DATA) + "\n    }\n}\n"), (File)mcMeta, (Charset)Charsets.UTF_8);
            }
            catch (IOException ex) {
                throw new RuntimeException("Could not initialize Bukkit datapack", ex);
            }
            AtomicReference worldLoader = new AtomicReference();
            try {
                WorldLoader.c worldloader_c = Main.loadOrCreateConfig(dedicatedserversettings.getProperties(), dynamic1, flag, resourcepackrepository);
                worldstem = (WorldStem)SystemUtils.blockUntilDone(executor -> WorldLoader.load(worldloader_c, worldloader_a -> {
                    WorldDimensions worlddimensions;
                    WorldOptions worldoptions;
                    WorldSettings worldsettings;
                    worldLoader.set(worldloader_a);
                    IRegistry<WorldDimension> iregistry = worldloader_a.datapackDimensions().registryOrThrow(Registries.LEVEL_STEM);
                    if (dynamic1 != null) {
                        LevelDataAndDimensions leveldataanddimensions = Convertable.getLevelDataAndDimensions(dynamic1, worldloader_a.dataConfiguration(), iregistry, worldloader_a.datapackWorldgen());
                        return new WorldLoader.b<SaveData>(leveldataanddimensions.worldData(), leveldataanddimensions.dimensions().dimensionsRegistryAccess());
                    }
                    LOGGER.info("No existing world data, creating new world");
                    if (optionset.has("demo")) {
                        worldsettings = MinecraftServer.DEMO_SETTINGS;
                        worldoptions = WorldOptions.DEMO_OPTIONS;
                        worlddimensions = WorldPresets.createNormalWorldDimensions(worldloader_a.datapackWorldgen());
                    } else {
                        DedicatedServerProperties dedicatedserverproperties = dedicatedserversettings.getProperties();
                        worldsettings = new WorldSettings(dedicatedserverproperties.levelName, dedicatedserverproperties.gamemode, dedicatedserverproperties.hardcore, dedicatedserverproperties.difficulty, false, new GameRules(), worldloader_a.dataConfiguration());
                        worldoptions = optionset.has("bonusChest") ? dedicatedserverproperties.worldOptions.withBonusChest(true) : dedicatedserverproperties.worldOptions;
                        worlddimensions = dedicatedserverproperties.createDimensions(worldloader_a.datapackWorldgen());
                    }
                    WorldDimensions.b worlddimensions_b = worlddimensions.bake(iregistry);
                    Lifecycle lifecycle = worlddimensions_b.lifecycle().add(worldloader_a.datapackWorldgen().allRegistriesLifecycle());
                    return new WorldLoader.b<WorldDataServer>(new WorldDataServer(worldsettings, worldoptions, worlddimensions_b.specialWorldProperty(), lifecycle), worlddimensions_b.dimensionsRegistryAccess());
                }, WorldStem::new, SystemUtils.backgroundExecutor(), executor)).get();
            }
            catch (Exception exception) {
                LOGGER.warn("Failed to load datapacks, can't proceed with server load. You can either fix your datapacks or reset to vanilla with --safeMode", (Throwable)exception);
                return;
            }
            DedicatedServer dedicatedServer = MinecraftServer.spin(thread -> {
                int port;
                boolean flag2;
                DedicatedServer dedicatedserver1 = new DedicatedServer(optionset, (WorldLoader.a)worldLoader.get(), (Thread)thread, convertable_conversionsession, resourcepackrepository, worldstem, dedicatedserversettings, DataConverterRegistry.getDataFixer(), services, WorldLoadListenerLogger::createFromGameruleRadius);
                boolean bl = flag2 = !optionset.has("nogui") && !optionset.nonOptionArguments().contains("nogui");
                if (flag2 && !GraphicsEnvironment.isHeadless()) {
                    dedicatedserver1.showGui();
                }
                if (optionset.has("port") && (port = ((Integer)optionset.valueOf("port")).intValue()) > 0) {
                    dedicatedserver1.setPort(port);
                }
                return dedicatedserver1;
            });
        }
        catch (Exception exception1) {
            LOGGER.error(LogUtils.FATAL_MARKER, "Failed to start the minecraft server", (Throwable)exception1);
        }
    }

    private static void writePidFile(Path path) {
        try {
            long i2 = ProcessHandle.current().pid();
            Files.writeString(path, (CharSequence)Long.toString(i2), new OpenOption[0]);
        }
        catch (IOException ioexception) {
            throw new UncheckedIOException(ioexception);
        }
    }

    private static WorldLoader.c loadOrCreateConfig(DedicatedServerProperties dedicatedserverproperties, @Nullable Dynamic<?> dynamic, boolean flag, ResourcePackRepository resourcepackrepository) {
        WorldDataConfiguration worlddataconfiguration;
        boolean flag1;
        if (dynamic != null) {
            WorldDataConfiguration worlddataconfiguration1 = Convertable.readDataConfig(dynamic);
            flag1 = false;
            worlddataconfiguration = worlddataconfiguration1;
        } else {
            flag1 = true;
            worlddataconfiguration = new WorldDataConfiguration(dedicatedserverproperties.initialDataPackConfiguration, FeatureFlags.DEFAULT_FLAGS);
        }
        WorldLoader.d worldloader_d = new WorldLoader.d(resourcepackrepository, worlddataconfiguration, flag, flag1);
        return new WorldLoader.c(worldloader_d, CommandDispatcher.ServerType.DEDICATED, dedicatedserverproperties.functionPermissionLevel);
    }

    public static void forceUpgrade(Convertable.ConversionSession convertable_conversionsession, DataFixer datafixer, boolean flag, BooleanSupplier booleansupplier, IRegistryCustom iregistrycustom, boolean flag1) {
        LOGGER.info("Forcing world upgrade! {}", (Object)convertable_conversionsession.getLevelId());
        WorldUpgrader worldupgrader = new WorldUpgrader(convertable_conversionsession, datafixer, iregistrycustom, flag, flag1);
        IChatBaseComponent ichatbasecomponent = null;
        while (!worldupgrader.isFinished()) {
            int i2;
            IChatBaseComponent ichatbasecomponent1 = worldupgrader.getStatus();
            if (ichatbasecomponent != ichatbasecomponent1) {
                ichatbasecomponent = ichatbasecomponent1;
                LOGGER.info(worldupgrader.getStatus().getString());
            }
            if ((i2 = worldupgrader.getTotalChunks()) > 0) {
                int j2 = worldupgrader.getConverted() + worldupgrader.getSkipped();
                LOGGER.info("{}% completed ({} / {} chunks)...", new Object[]{MathHelper.floor((float)j2 / (float)i2 * 100.0f), j2, i2});
            }
            if (!booleansupplier.getAsBoolean()) {
                worldupgrader.cancel();
                continue;
            }
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }
}

