/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server;

import com.mojang.datafixers.util.Either;
import io.netty.buffer.ByteBuf;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.net.URI;
import java.util.List;
import java.util.Optional;
import java.util.function.IntFunction;
import net.minecraft.network.chat.ComponentSerialization;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.util.ByIdMap;

public record ServerLinks(List<Entry> entries) {
    public static final ServerLinks EMPTY = new ServerLinks(List.of());
    public static final StreamCodec<ByteBuf, Either<KnownLinkType, IChatBaseComponent>> TYPE_STREAM_CODEC = ByteBufCodecs.either(KnownLinkType.STREAM_CODEC, ComponentSerialization.TRUSTED_CONTEXT_FREE_STREAM_CODEC);
    public static final StreamCodec<ByteBuf, List<UntrustedEntry>> UNTRUSTED_LINKS_STREAM_CODEC = UntrustedEntry.STREAM_CODEC.apply(ByteBufCodecs.list());

    public boolean isEmpty() {
        return this.entries.isEmpty();
    }

    public Optional<Entry> findKnownType(KnownLinkType var0) {
        return this.entries.stream().filter(var12 -> (Boolean)var12.type.map(var1 -> var1 == var0, var0 -> false)).findFirst();
    }

    public List<UntrustedEntry> untrust() {
        return this.entries.stream().map(var0 -> new UntrustedEntry(var0.type, var0.link.toString())).toList();
    }

    public static final class KnownLinkType
    extends Enum<KnownLinkType> {
        public static final /* enum */ KnownLinkType BUG_REPORT = new KnownLinkType(0, "report_bug");
        public static final /* enum */ KnownLinkType COMMUNITY_GUIDELINES = new KnownLinkType(1, "community_guidelines");
        public static final /* enum */ KnownLinkType SUPPORT = new KnownLinkType(2, "support");
        public static final /* enum */ KnownLinkType STATUS = new KnownLinkType(3, "status");
        public static final /* enum */ KnownLinkType FEEDBACK = new KnownLinkType(4, "feedback");
        public static final /* enum */ KnownLinkType COMMUNITY = new KnownLinkType(5, "community");
        public static final /* enum */ KnownLinkType WEBSITE = new KnownLinkType(6, "website");
        public static final /* enum */ KnownLinkType FORUMS = new KnownLinkType(7, "forums");
        public static final /* enum */ KnownLinkType NEWS = new KnownLinkType(8, "news");
        public static final /* enum */ KnownLinkType ANNOUNCEMENTS = new KnownLinkType(9, "announcements");
        private static final IntFunction<KnownLinkType> BY_ID;
        public static final StreamCodec<ByteBuf, KnownLinkType> STREAM_CODEC;
        private final int id;
        private final String name;
        private static final /* synthetic */ KnownLinkType[] o;

        public static KnownLinkType[] values() {
            return (KnownLinkType[])o.clone();
        }

        public static KnownLinkType valueOf(String var0) {
            return Enum.valueOf(KnownLinkType.class, var0);
        }

        private KnownLinkType(int var2, String var3) {
            this.id = var2;
            this.name = var3;
        }

        private IChatBaseComponent displayName() {
            return IChatBaseComponent.translatable("known_server_link." + this.name);
        }

        public Entry create(URI var0) {
            return Entry.knownType(this, var0);
        }

        private static /* synthetic */ KnownLinkType[] b() {
            return new KnownLinkType[]{BUG_REPORT, COMMUNITY_GUIDELINES, SUPPORT, STATUS, FEEDBACK, COMMUNITY, WEBSITE, FORUMS, NEWS, ANNOUNCEMENTS};
        }

        static {
            o = KnownLinkType.b();
            BY_ID = ByIdMap.continuous(var0 -> var0.id, KnownLinkType.values(), ByIdMap.a.ZERO);
            STREAM_CODEC = ByteBufCodecs.idMapper(BY_ID, var0 -> var0.id);
        }
    }

    public record UntrustedEntry(Either<KnownLinkType, IChatBaseComponent> type, String link) {
        public static final StreamCodec<ByteBuf, UntrustedEntry> STREAM_CODEC = StreamCodec.composite(TYPE_STREAM_CODEC, UntrustedEntry::type, ByteBufCodecs.STRING_UTF8, UntrustedEntry::link, UntrustedEntry::new);
    }

    public static final class Entry
    extends Record {
        final Either<KnownLinkType, IChatBaseComponent> type;
        final URI link;

        public Entry(Either<KnownLinkType, IChatBaseComponent> var0, URI var1) {
            this.type = var0;
            this.link = var1;
        }

        public static Entry knownType(KnownLinkType var0, URI var1) {
            return new Entry((Either<KnownLinkType, IChatBaseComponent>)Either.left((Object)((Object)var0)), var1);
        }

        public static Entry custom(IChatBaseComponent var0, URI var1) {
            return new Entry((Either<KnownLinkType, IChatBaseComponent>)Either.right((Object)var0), var1);
        }

        public IChatBaseComponent displayName() {
            return (IChatBaseComponent)this.type.map(KnownLinkType::displayName, var0 -> var0);
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{Entry.class, "type;link", "type", "link"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{Entry.class, "type;link", "type", "link"}, this);
        }

        @Override
        public final boolean equals(Object var0) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{Entry.class, "type;link", "type", "link"}, this, var0);
        }

        public Either<KnownLinkType, IChatBaseComponent> type() {
            return this.type;
        }

        public URI link() {
            return this.link;
        }
    }
}

