/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server;

import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.protocol.game.ClientboundTickingStatePacket;
import net.minecraft.network.protocol.game.ClientboundTickingStepPacket;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.util.TimeRange;
import net.minecraft.world.TickRateManager;

public class ServerTickRateManager
extends TickRateManager {
    private long remainingSprintTicks = 0L;
    private long sprintTickStartTime = 0L;
    private long sprintTimeSpend = 0L;
    private long scheduledCurrentSprintTicks = 0L;
    private boolean previousIsFrozen = false;
    private final MinecraftServer server;

    public ServerTickRateManager(MinecraftServer minecraftserver) {
        this.server = minecraftserver;
    }

    public boolean isSprinting() {
        return this.scheduledCurrentSprintTicks > 0L;
    }

    @Override
    public void setFrozen(boolean flag) {
        super.setFrozen(flag);
        this.updateStateToClients();
    }

    private void updateStateToClients() {
        this.server.getPlayerList().broadcastAll(ClientboundTickingStatePacket.from(this));
    }

    private void updateStepTicks() {
        this.server.getPlayerList().broadcastAll(ClientboundTickingStepPacket.from(this));
    }

    public boolean stepGameIfPaused(int i2) {
        if (!this.isFrozen()) {
            return false;
        }
        this.frozenTicksToRun = i2;
        this.updateStepTicks();
        return true;
    }

    public boolean stopStepping() {
        if (this.frozenTicksToRun > 0) {
            this.frozenTicksToRun = 0;
            this.updateStepTicks();
            return true;
        }
        return false;
    }

    public boolean stopSprinting() {
        return this.stopSprinting(true);
    }

    public boolean stopSprinting(boolean sendLog) {
        if (this.remainingSprintTicks > 0L) {
            this.finishTickSprint(sendLog);
            return true;
        }
        return false;
    }

    public boolean requestGameToSprint(int i2) {
        boolean flag = this.remainingSprintTicks > 0L;
        this.sprintTimeSpend = 0L;
        this.scheduledCurrentSprintTicks = i2;
        this.remainingSprintTicks = i2;
        this.previousIsFrozen = this.isFrozen();
        this.setFrozen(false);
        return flag;
    }

    private void finishTickSprint(boolean sendLog) {
        long i2 = this.scheduledCurrentSprintTicks - this.remainingSprintTicks;
        double d0 = Math.max(1.0, (double)this.sprintTimeSpend) / (double)TimeRange.NANOSECONDS_PER_MILLISECOND;
        int j2 = (int)((double)(TimeRange.MILLISECONDS_PER_SECOND * i2) / d0);
        String s2 = String.format("%.2f", i2 == 0L ? (double)this.millisecondsPerTick() : d0 / (double)i2);
        this.scheduledCurrentSprintTicks = 0L;
        this.sprintTimeSpend = 0L;
        if (sendLog) {
            this.server.createCommandSourceStack().sendSuccess(() -> IChatBaseComponent.translatable("commands.tick.sprint.report", j2, s2), true);
        }
        this.remainingSprintTicks = 0L;
        this.setFrozen(this.previousIsFrozen);
        this.server.onTickRateChanged();
    }

    public boolean checkShouldSprintThisTick() {
        if (!this.runGameElements) {
            return false;
        }
        if (this.remainingSprintTicks > 0L) {
            this.sprintTickStartTime = System.nanoTime();
            --this.remainingSprintTicks;
            return true;
        }
        this.finishTickSprint(true);
        return false;
    }

    public void endTickWork() {
        this.sprintTimeSpend += System.nanoTime() - this.sprintTickStartTime;
    }

    @Override
    public void setTickRate(float f2) {
        super.setTickRate(f2);
        this.server.onTickRateChanged();
        this.updateStateToClients();
    }

    public void updateJoiningPlayer(EntityPlayer entityplayer) {
        entityplayer.connection.send(ClientboundTickingStatePacket.from(this));
        entityplayer.connection.send(ClientboundTickingStepPacket.from(this));
    }
}

