/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server;

import com.mojang.datafixers.util.Pair;
import com.mojang.logging.LogUtils;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import net.minecraft.commands.CommandDispatcher;
import net.minecraft.core.IRegistryCustom;
import net.minecraft.core.LayeredRegistryAccess;
import net.minecraft.resources.RegistryDataLoader;
import net.minecraft.server.DataPackResources;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.RegistryLayer;
import net.minecraft.server.packs.EnumResourcePackType;
import net.minecraft.server.packs.IResourcePack;
import net.minecraft.server.packs.repository.ResourcePackRepository;
import net.minecraft.server.packs.resources.IReloadableResourceManager;
import net.minecraft.server.packs.resources.IResourceManager;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.world.level.WorldDataConfiguration;
import org.slf4j.Logger;

public class WorldLoader {
    private static final Logger LOGGER = LogUtils.getLogger();

    public static <D, R> CompletableFuture<R> load(c var0, f<D> var12, e<D, R> var22, Executor var3, Executor var42) {
        try {
            Pair<WorldDataConfiguration, IReloadableResourceManager> var5 = var0.packConfig.createResourceManager();
            IReloadableResourceManager var6 = (IReloadableResourceManager)var5.getSecond();
            LayeredRegistryAccess<RegistryLayer> var7 = RegistryLayer.createRegistryAccess();
            LayeredRegistryAccess<RegistryLayer> var8 = WorldLoader.loadAndReplaceLayer(var6, var7, RegistryLayer.WORLDGEN, RegistryDataLoader.WORLDGEN_REGISTRIES);
            IRegistryCustom.Dimension var9 = var8.getAccessForLoading(RegistryLayer.DIMENSIONS);
            IRegistryCustom.Dimension var10 = RegistryDataLoader.load(var6, (IRegistryCustom)var9, RegistryDataLoader.DIMENSION_REGISTRIES);
            WorldDataConfiguration var11 = (WorldDataConfiguration)var5.getFirst();
            b<D> var122 = var12.get(new a(var6, var11, var9, var10));
            LayeredRegistryAccess<RegistryLayer> var13 = var8.replaceFrom(RegistryLayer.DIMENSIONS, var122.finalDimensions);
            return ((CompletableFuture)DataPackResources.loadResources(var6, var13, var11.enabledFeatures(), var0.commandSelection(), var0.functionCompilationLevel(), var3, var42).whenComplete((var1, var2) -> {
                if (var2 != null) {
                    var6.close();
                }
            })).thenApplyAsync(var4 -> {
                var4.updateRegistryTags();
                return var22.create(var6, (DataPackResources)var4, var13, var3.cookie);
            }, var42);
        }
        catch (Exception var5) {
            return CompletableFuture.failedFuture(var5);
        }
    }

    private static IRegistryCustom.Dimension loadLayer(IResourceManager var0, LayeredRegistryAccess<RegistryLayer> var1, RegistryLayer var2, List<RegistryDataLoader.c<?>> var3) {
        IRegistryCustom.Dimension var4 = var1.getAccessForLoading(var2);
        return RegistryDataLoader.load(var0, (IRegistryCustom)var4, var3);
    }

    public static LayeredRegistryAccess<RegistryLayer> loadAndReplaceLayer(IResourceManager var0, LayeredRegistryAccess<RegistryLayer> var1, RegistryLayer var2, List<RegistryDataLoader.c<?>> var3) {
        IRegistryCustom.Dimension var4 = WorldLoader.loadLayer(var0, var1, var2, var3);
        return var1.replaceFrom(var2, var4);
    }

    public static final class c
    extends Record {
        final d packConfig;
        private final CommandDispatcher.ServerType commandSelection;
        private final int functionCompilationLevel;

        public c(d var0, CommandDispatcher.ServerType var1, int var2) {
            this.packConfig = var0;
            this.commandSelection = var1;
            this.functionCompilationLevel = var2;
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{c.class, "packConfig;commandSelection;functionCompilationLevel", "packConfig", "commandSelection", "functionCompilationLevel"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{c.class, "packConfig;commandSelection;functionCompilationLevel", "packConfig", "commandSelection", "functionCompilationLevel"}, this);
        }

        @Override
        public final boolean equals(Object var0) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{c.class, "packConfig;commandSelection;functionCompilationLevel", "packConfig", "commandSelection", "functionCompilationLevel"}, this, var0);
        }

        public d packConfig() {
            return this.packConfig;
        }

        public CommandDispatcher.ServerType commandSelection() {
            return this.commandSelection;
        }

        public int functionCompilationLevel() {
            return this.functionCompilationLevel;
        }
    }

    public record d(ResourcePackRepository packRepository, WorldDataConfiguration initialDataConfig, boolean safeMode, boolean initMode) {
        public Pair<WorldDataConfiguration, IReloadableResourceManager> createResourceManager() {
            WorldDataConfiguration var0 = MinecraftServer.configurePackRepository(this.packRepository, this.initialDataConfig, this.initMode, this.safeMode);
            List<IResourcePack> var1 = this.packRepository.openAllSelected();
            ResourceManager var2 = new ResourceManager(EnumResourcePackType.SERVER_DATA, var1);
            return Pair.of((Object)var0, (Object)var2);
        }
    }

    public record a(IResourceManager resources, WorldDataConfiguration dataConfiguration, IRegistryCustom.Dimension datapackWorldgen, IRegistryCustom.Dimension datapackDimensions) {
    }

    @FunctionalInterface
    public static interface f<D> {
        public b<D> get(a var1);
    }

    public static final class b<D>
    extends Record {
        final D cookie;
        final IRegistryCustom.Dimension finalDimensions;

        public b(D var0, IRegistryCustom.Dimension var1) {
            this.cookie = var0;
            this.finalDimensions = var1;
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{b.class, "cookie;finalDimensions", "cookie", "finalDimensions"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{b.class, "cookie;finalDimensions", "cookie", "finalDimensions"}, this);
        }

        @Override
        public final boolean equals(Object var0) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{b.class, "cookie;finalDimensions", "cookie", "finalDimensions"}, this, var0);
        }

        public D cookie() {
            return this.cookie;
        }

        public IRegistryCustom.Dimension finalDimensions() {
            return this.finalDimensions;
        }
    }

    @FunctionalInterface
    public static interface e<D, R> {
        public R create(IReloadableResourceManager var1, DataPackResources var2, LayeredRegistryAccess<RegistryLayer> var3, D var4);
    }
}

