/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.bossevents;

import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.GameProfileSerializer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.chat.ChatComponentUtils;
import net.minecraft.network.chat.ChatHoverable;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.server.level.BossBattleServer;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.util.MathHelper;
import net.minecraft.world.BossBattle;
import org.bukkit.boss.KeyedBossBar;
import org.bukkit.craftbukkit.v1_21_R1.boss.CraftKeyedBossbar;

public class BossBattleCustom
extends BossBattleServer {
    private final MinecraftKey id;
    private final Set<UUID> players = Sets.newHashSet();
    private int value;
    private int max = 100;
    private KeyedBossBar bossBar;

    public KeyedBossBar getBukkitEntity() {
        if (this.bossBar == null) {
            this.bossBar = new CraftKeyedBossbar(this);
        }
        return this.bossBar;
    }

    public BossBattleCustom(MinecraftKey minecraftkey, IChatBaseComponent ichatbasecomponent) {
        super(ichatbasecomponent, BossBattle.BarColor.WHITE, BossBattle.BarStyle.PROGRESS);
        this.id = minecraftkey;
        this.setProgress(0.0f);
    }

    public MinecraftKey getTextId() {
        return this.id;
    }

    @Override
    public void addPlayer(EntityPlayer entityplayer) {
        super.addPlayer(entityplayer);
        this.players.add(entityplayer.getUUID());
    }

    public void addOfflinePlayer(UUID uuid) {
        this.players.add(uuid);
    }

    @Override
    public void removePlayer(EntityPlayer entityplayer) {
        super.removePlayer(entityplayer);
        this.players.remove(entityplayer.getUUID());
    }

    @Override
    public void removeAllPlayers() {
        super.removeAllPlayers();
        this.players.clear();
    }

    public int getValue() {
        return this.value;
    }

    public int getMax() {
        return this.max;
    }

    public void setValue(int i2) {
        this.value = i2;
        this.setProgress(MathHelper.clamp((float)i2 / (float)this.max, 0.0f, 1.0f));
    }

    public void setMax(int i2) {
        this.max = i2;
        this.setProgress(MathHelper.clamp((float)this.value / (float)i2, 0.0f, 1.0f));
    }

    public final IChatBaseComponent getDisplayName() {
        return ChatComponentUtils.wrapInSquareBrackets(this.getName()).withStyle(chatmodifier -> chatmodifier.withColor(this.getColor().getFormatting()).withHoverEvent(new ChatHoverable(ChatHoverable.EnumHoverAction.SHOW_TEXT, IChatBaseComponent.literal(this.getTextId().toString()))).withInsertion(this.getTextId().toString()));
    }

    public boolean setPlayers(Collection<EntityPlayer> collection) {
        boolean flag;
        HashSet set = Sets.newHashSet();
        HashSet set1 = Sets.newHashSet();
        for (UUID uuid : this.players) {
            flag = false;
            for (EntityPlayer entityplayer : collection) {
                if (!entityplayer.getUUID().equals(uuid)) continue;
                flag = true;
                break;
            }
            if (flag) continue;
            set.add(uuid);
        }
        for (EntityPlayer entityplayer1 : collection) {
            flag = false;
            for (UUID uuid1 : this.players) {
                if (!entityplayer1.getUUID().equals(uuid1)) continue;
                flag = true;
                break;
            }
            if (flag) continue;
            set1.add(entityplayer1);
        }
        for (UUID uuid : set) {
            for (EntityPlayer entityplayer2 : this.getPlayers()) {
                if (!entityplayer2.getUUID().equals(uuid)) continue;
                this.removePlayer(entityplayer2);
                break;
            }
            this.players.remove(uuid);
        }
        for (EntityPlayer entityplayer1 : set1) {
            this.addPlayer(entityplayer1);
        }
        return !set.isEmpty() || !set1.isEmpty();
    }

    public NBTTagCompound save(HolderLookup.a holderlookup_a) {
        NBTTagCompound nbttagcompound = new NBTTagCompound();
        nbttagcompound.putString("Name", IChatBaseComponent.ChatSerializer.toJson(this.name, holderlookup_a));
        nbttagcompound.putBoolean("Visible", this.isVisible());
        nbttagcompound.putInt("Value", this.value);
        nbttagcompound.putInt("Max", this.max);
        nbttagcompound.putString("Color", this.getColor().getName());
        nbttagcompound.putString("Overlay", this.getOverlay().getName());
        nbttagcompound.putBoolean("DarkenScreen", this.shouldDarkenScreen());
        nbttagcompound.putBoolean("PlayBossMusic", this.shouldPlayBossMusic());
        nbttagcompound.putBoolean("CreateWorldFog", this.shouldCreateWorldFog());
        NBTTagList nbttaglist = new NBTTagList();
        for (UUID uuid : this.players) {
            nbttaglist.add(GameProfileSerializer.createUUID(uuid));
        }
        nbttagcompound.put("Players", nbttaglist);
        return nbttagcompound;
    }

    public static BossBattleCustom load(NBTTagCompound nbttagcompound, MinecraftKey minecraftkey, HolderLookup.a holderlookup_a) {
        BossBattleCustom bossbattlecustom = new BossBattleCustom(minecraftkey, IChatBaseComponent.ChatSerializer.fromJson(nbttagcompound.getString("Name"), holderlookup_a));
        bossbattlecustom.setVisible(nbttagcompound.getBoolean("Visible"));
        bossbattlecustom.setValue(nbttagcompound.getInt("Value"));
        bossbattlecustom.setMax(nbttagcompound.getInt("Max"));
        bossbattlecustom.setColor(BossBattle.BarColor.byName(nbttagcompound.getString("Color")));
        bossbattlecustom.setOverlay(BossBattle.BarStyle.byName(nbttagcompound.getString("Overlay")));
        bossbattlecustom.setDarkenScreen(nbttagcompound.getBoolean("DarkenScreen"));
        bossbattlecustom.setPlayBossMusic(nbttagcompound.getBoolean("PlayBossMusic"));
        bossbattlecustom.setCreateWorldFog(nbttagcompound.getBoolean("CreateWorldFog"));
        NBTTagList nbttaglist = nbttagcompound.getList("Players", 11);
        for (NBTBase nbtbase : nbttaglist) {
            bossbattlecustom.addOfflinePlayer(GameProfileSerializer.loadUUID(nbtbase));
        }
        return bossbattlecustom;
    }

    public void onPlayerConnect(EntityPlayer entityplayer) {
        if (this.players.contains(entityplayer.getUUID())) {
            this.addPlayer(entityplayer);
        }
    }

    public void onPlayerDisconnect(EntityPlayer entityplayer) {
        super.removePlayer(entityplayer);
    }
}

