/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.commands;

import com.google.common.collect.ImmutableList;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import java.util.Collection;
import javax.annotation.Nullable;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandListenerWrapper;
import net.minecraft.commands.arguments.ArgumentEntity;
import net.minecraft.commands.arguments.ResourceArgument;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectList;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityLiving;
import org.bukkit.event.entity.EntityPotionEffectEvent;

public class CommandEffect {
    private static final SimpleCommandExceptionType ERROR_GIVE_FAILED = new SimpleCommandExceptionType((Message)IChatBaseComponent.translatable("commands.effect.give.failed"));
    private static final SimpleCommandExceptionType ERROR_CLEAR_EVERYTHING_FAILED = new SimpleCommandExceptionType((Message)IChatBaseComponent.translatable("commands.effect.clear.everything.failed"));
    private static final SimpleCommandExceptionType ERROR_CLEAR_SPECIFIC_FAILED = new SimpleCommandExceptionType((Message)IChatBaseComponent.translatable("commands.effect.clear.specific.failed"));

    public static void register(CommandDispatcher<CommandListenerWrapper> commanddispatcher, CommandBuildContext commandbuildcontext) {
        commanddispatcher.register((LiteralArgumentBuilder<CommandListenerWrapper>)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)net.minecraft.commands.CommandDispatcher.literal("effect").requires(commandlistenerwrapper -> commandlistenerwrapper.hasPermission(2))).then(((LiteralArgumentBuilder)net.minecraft.commands.CommandDispatcher.literal("clear").executes(commandcontext -> CommandEffect.clearEffects((CommandListenerWrapper)commandcontext.getSource(), (Collection<? extends Entity>)ImmutableList.of((Object)((CommandListenerWrapper)commandcontext.getSource()).getEntityOrException())))).then(((RequiredArgumentBuilder)net.minecraft.commands.CommandDispatcher.argument("targets", ArgumentEntity.entities()).executes(commandcontext -> CommandEffect.clearEffects((CommandListenerWrapper)commandcontext.getSource(), ArgumentEntity.getEntities((CommandContext<CommandListenerWrapper>)commandcontext, "targets")))).then(net.minecraft.commands.CommandDispatcher.argument("effect", ResourceArgument.resource(commandbuildcontext, Registries.MOB_EFFECT)).executes(commandcontext -> CommandEffect.clearEffect((CommandListenerWrapper)commandcontext.getSource(), ArgumentEntity.getEntities((CommandContext<CommandListenerWrapper>)commandcontext, "targets"), ResourceArgument.getMobEffect((CommandContext<CommandListenerWrapper>)commandcontext, "effect"))))))).then(net.minecraft.commands.CommandDispatcher.literal("give").then(net.minecraft.commands.CommandDispatcher.argument("targets", ArgumentEntity.entities()).then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)net.minecraft.commands.CommandDispatcher.argument("effect", ResourceArgument.resource(commandbuildcontext, Registries.MOB_EFFECT)).executes(commandcontext -> CommandEffect.giveEffect((CommandListenerWrapper)commandcontext.getSource(), ArgumentEntity.getEntities((CommandContext<CommandListenerWrapper>)commandcontext, "targets"), ResourceArgument.getMobEffect((CommandContext<CommandListenerWrapper>)commandcontext, "effect"), null, 0, true))).then(((RequiredArgumentBuilder)net.minecraft.commands.CommandDispatcher.argument("seconds", IntegerArgumentType.integer((int)1, (int)1000000)).executes(commandcontext -> CommandEffect.giveEffect((CommandListenerWrapper)commandcontext.getSource(), ArgumentEntity.getEntities((CommandContext<CommandListenerWrapper>)commandcontext, "targets"), ResourceArgument.getMobEffect((CommandContext<CommandListenerWrapper>)commandcontext, "effect"), IntegerArgumentType.getInteger((CommandContext)commandcontext, (String)"seconds"), 0, true))).then(((RequiredArgumentBuilder)net.minecraft.commands.CommandDispatcher.argument("amplifier", IntegerArgumentType.integer((int)0, (int)255)).executes(commandcontext -> CommandEffect.giveEffect((CommandListenerWrapper)commandcontext.getSource(), ArgumentEntity.getEntities((CommandContext<CommandListenerWrapper>)commandcontext, "targets"), ResourceArgument.getMobEffect((CommandContext<CommandListenerWrapper>)commandcontext, "effect"), IntegerArgumentType.getInteger((CommandContext)commandcontext, (String)"seconds"), IntegerArgumentType.getInteger((CommandContext)commandcontext, (String)"amplifier"), true))).then(net.minecraft.commands.CommandDispatcher.argument("hideParticles", BoolArgumentType.bool()).executes(commandcontext -> CommandEffect.giveEffect((CommandListenerWrapper)commandcontext.getSource(), ArgumentEntity.getEntities((CommandContext<CommandListenerWrapper>)commandcontext, "targets"), ResourceArgument.getMobEffect((CommandContext<CommandListenerWrapper>)commandcontext, "effect"), IntegerArgumentType.getInteger((CommandContext)commandcontext, (String)"seconds"), IntegerArgumentType.getInteger((CommandContext)commandcontext, (String)"amplifier"), !BoolArgumentType.getBool((CommandContext)commandcontext, (String)"hideParticles"))))))).then(((LiteralArgumentBuilder)net.minecraft.commands.CommandDispatcher.literal("infinite").executes(commandcontext -> CommandEffect.giveEffect((CommandListenerWrapper)commandcontext.getSource(), ArgumentEntity.getEntities((CommandContext<CommandListenerWrapper>)commandcontext, "targets"), ResourceArgument.getMobEffect((CommandContext<CommandListenerWrapper>)commandcontext, "effect"), -1, 0, true))).then(((RequiredArgumentBuilder)net.minecraft.commands.CommandDispatcher.argument("amplifier", IntegerArgumentType.integer((int)0, (int)255)).executes(commandcontext -> CommandEffect.giveEffect((CommandListenerWrapper)commandcontext.getSource(), ArgumentEntity.getEntities((CommandContext<CommandListenerWrapper>)commandcontext, "targets"), ResourceArgument.getMobEffect((CommandContext<CommandListenerWrapper>)commandcontext, "effect"), -1, IntegerArgumentType.getInteger((CommandContext)commandcontext, (String)"amplifier"), true))).then(net.minecraft.commands.CommandDispatcher.argument("hideParticles", BoolArgumentType.bool()).executes(commandcontext -> CommandEffect.giveEffect((CommandListenerWrapper)commandcontext.getSource(), ArgumentEntity.getEntities((CommandContext<CommandListenerWrapper>)commandcontext, "targets"), ResourceArgument.getMobEffect((CommandContext<CommandListenerWrapper>)commandcontext, "effect"), -1, IntegerArgumentType.getInteger((CommandContext)commandcontext, (String)"amplifier"), !BoolArgumentType.getBool((CommandContext)commandcontext, (String)"hideParticles")))))))))));
    }

    private static int giveEffect(CommandListenerWrapper commandlistenerwrapper, Collection<? extends Entity> collection, Holder<MobEffectList> holder, @Nullable Integer integer, int i2, boolean flag) throws CommandSyntaxException {
        int k2;
        MobEffectList mobeffectlist = holder.value();
        int j2 = 0;
        if (integer != null) {
            k2 = mobeffectlist.isInstantenous() ? integer : (integer == -1 ? -1 : integer * 20);
        } else if (mobeffectlist.isInstantenous()) {
            boolean k22 = true;
        } else {
            k2 = 600;
        }
        for (Entity entity : collection) {
            MobEffect mobeffect;
            if (!(entity instanceof EntityLiving) || !((EntityLiving)entity).addEffect(mobeffect = new MobEffect(holder, k2, i2, false, flag), commandlistenerwrapper.getEntity(), EntityPotionEffectEvent.Cause.COMMAND)) continue;
            ++j2;
        }
        if (j2 == 0) {
            throw ERROR_GIVE_FAILED.create();
        }
        if (collection.size() == 1) {
            commandlistenerwrapper.sendSuccess(() -> IChatBaseComponent.translatable("commands.effect.give.success.single", mobeffectlist.getDisplayName(), ((Entity)collection.iterator().next()).getDisplayName(), k22 / 20), true);
        } else {
            commandlistenerwrapper.sendSuccess(() -> IChatBaseComponent.translatable("commands.effect.give.success.multiple", mobeffectlist.getDisplayName(), collection.size(), k22 / 20), true);
        }
        return j2;
    }

    private static int clearEffects(CommandListenerWrapper commandlistenerwrapper, Collection<? extends Entity> collection) throws CommandSyntaxException {
        int i2 = 0;
        for (Entity entity : collection) {
            if (!(entity instanceof EntityLiving) || !((EntityLiving)entity).removeAllEffects(EntityPotionEffectEvent.Cause.COMMAND)) continue;
            ++i2;
        }
        if (i2 == 0) {
            throw ERROR_CLEAR_EVERYTHING_FAILED.create();
        }
        if (collection.size() == 1) {
            commandlistenerwrapper.sendSuccess(() -> IChatBaseComponent.translatable("commands.effect.clear.everything.success.single", ((Entity)collection.iterator().next()).getDisplayName()), true);
        } else {
            commandlistenerwrapper.sendSuccess(() -> IChatBaseComponent.translatable("commands.effect.clear.everything.success.multiple", collection.size()), true);
        }
        return i2;
    }

    private static int clearEffect(CommandListenerWrapper commandlistenerwrapper, Collection<? extends Entity> collection, Holder<MobEffectList> holder) throws CommandSyntaxException {
        MobEffectList mobeffectlist = holder.value();
        int i2 = 0;
        for (Entity entity : collection) {
            if (!(entity instanceof EntityLiving) || !((EntityLiving)entity).removeEffect(holder, EntityPotionEffectEvent.Cause.COMMAND)) continue;
            ++i2;
        }
        if (i2 == 0) {
            throw ERROR_CLEAR_SPECIFIC_FAILED.create();
        }
        if (collection.size() == 1) {
            commandlistenerwrapper.sendSuccess(() -> IChatBaseComponent.translatable("commands.effect.clear.specific.success.single", mobeffectlist.getDisplayName(), ((Entity)collection.iterator().next()).getDisplayName()), true);
        } else {
            commandlistenerwrapper.sendSuccess(() -> IChatBaseComponent.translatable("commands.effect.clear.specific.success.multiple", mobeffectlist.getDisplayName(), collection.size()), true);
        }
        return i2;
    }
}

