/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.Collection;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandListenerWrapper;
import net.minecraft.commands.arguments.ArgumentEntity;
import net.minecraft.commands.arguments.item.ArgumentItemStack;
import net.minecraft.commands.arguments.item.ArgumentPredicateItemStack;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.world.entity.item.EntityItem;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.ItemStack;

public class CommandGive {
    public static final int MAX_ALLOWED_ITEMSTACKS = 100;

    public static void register(CommandDispatcher<CommandListenerWrapper> commanddispatcher, CommandBuildContext commandbuildcontext) {
        commanddispatcher.register((LiteralArgumentBuilder<CommandListenerWrapper>)((LiteralArgumentBuilder)((LiteralArgumentBuilder)net.minecraft.commands.CommandDispatcher.literal("give").requires(commandlistenerwrapper -> commandlistenerwrapper.hasPermission(2))).then(net.minecraft.commands.CommandDispatcher.argument("targets", ArgumentEntity.players()).then(((RequiredArgumentBuilder)net.minecraft.commands.CommandDispatcher.argument("item", ArgumentItemStack.item(commandbuildcontext)).executes(commandcontext -> CommandGive.giveItem((CommandListenerWrapper)commandcontext.getSource(), ArgumentItemStack.getItem(commandcontext, "item"), ArgumentEntity.getPlayers((CommandContext<CommandListenerWrapper>)commandcontext, "targets"), 1))).then(net.minecraft.commands.CommandDispatcher.argument("count", IntegerArgumentType.integer((int)1)).executes(commandcontext -> CommandGive.giveItem((CommandListenerWrapper)commandcontext.getSource(), ArgumentItemStack.getItem(commandcontext, "item"), ArgumentEntity.getPlayers((CommandContext<CommandListenerWrapper>)commandcontext, "targets"), IntegerArgumentType.getInteger((CommandContext)commandcontext, (String)"count"))))))));
    }

    private static int giveItem(CommandListenerWrapper commandlistenerwrapper, ArgumentPredicateItemStack argumentpredicateitemstack, Collection<EntityPlayer> collection, int i2) throws CommandSyntaxException {
        ItemStack itemstack = argumentpredicateitemstack.createItemStack(1, false);
        int j2 = itemstack.getMaxStackSize();
        int k2 = j2 * 100;
        if (i2 > k2) {
            commandlistenerwrapper.sendFailure(IChatBaseComponent.translatable("commands.give.failed.toomanyitems", k2, itemstack.getDisplayName()));
            return 0;
        }
        for (EntityPlayer entityplayer : collection) {
            int l2 = i2;
            while (l2 > 0) {
                EntityItem entityitem;
                int i1 = Math.min(j2, l2);
                l2 -= i1;
                ItemStack itemstack1 = argumentpredicateitemstack.createItemStack(i1, false);
                boolean flag = entityplayer.getInventory().add(itemstack1);
                if (flag && itemstack1.isEmpty()) {
                    entityitem = entityplayer.drop(itemstack, false, false, false);
                    if (entityitem != null) {
                        entityitem.makeFakeItem();
                    }
                    entityplayer.level().playSound((EntityHuman)null, entityplayer.getX(), entityplayer.getY(), entityplayer.getZ(), SoundEffects.ITEM_PICKUP, SoundCategory.PLAYERS, 0.2f, ((entityplayer.getRandom().nextFloat() - entityplayer.getRandom().nextFloat()) * 0.7f + 1.0f) * 2.0f);
                    entityplayer.containerMenu.broadcastChanges();
                    continue;
                }
                entityitem = entityplayer.drop(itemstack1, false);
                if (entityitem == null) continue;
                entityitem.setNoPickUpDelay();
                entityitem.setTarget(entityplayer.getUUID());
            }
        }
        if (collection.size() == 1) {
            commandlistenerwrapper.sendSuccess(() -> IChatBaseComponent.translatable("commands.give.success.single", i2, itemstack.getDisplayName(), ((EntityPlayer)collection.iterator().next()).getDisplayName()), true);
        } else {
            commandlistenerwrapper.sendSuccess(() -> IChatBaseComponent.translatable("commands.give.success.single", i2, itemstack.getDisplayName(), collection.size()), true);
        }
        return collection.size();
    }
}

