/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import java.util.Collection;
import net.minecraft.commands.CommandListenerWrapper;
import net.minecraft.commands.arguments.ArgumentChat;
import net.minecraft.commands.arguments.ArgumentEntity;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.server.level.EntityPlayer;

public class CommandKick {
    private static final SimpleCommandExceptionType ERROR_KICKING_OWNER = new SimpleCommandExceptionType((Message)IChatBaseComponent.translatable("commands.kick.owner.failed"));
    private static final SimpleCommandExceptionType ERROR_SINGLEPLAYER = new SimpleCommandExceptionType((Message)IChatBaseComponent.translatable("commands.kick.singleplayer.failed"));

    public static void register(CommandDispatcher<CommandListenerWrapper> var02) {
        var02.register((LiteralArgumentBuilder<CommandListenerWrapper>)((LiteralArgumentBuilder)((LiteralArgumentBuilder)net.minecraft.commands.CommandDispatcher.literal("kick").requires(var0 -> var0.hasPermission(3))).then(((RequiredArgumentBuilder)net.minecraft.commands.CommandDispatcher.argument("targets", ArgumentEntity.players()).executes(var0 -> CommandKick.kickPlayers((CommandListenerWrapper)var0.getSource(), ArgumentEntity.getPlayers((CommandContext<CommandListenerWrapper>)var0, "targets"), IChatBaseComponent.translatable("multiplayer.disconnect.kicked")))).then(net.minecraft.commands.CommandDispatcher.argument("reason", ArgumentChat.message()).executes(var0 -> CommandKick.kickPlayers((CommandListenerWrapper)var0.getSource(), ArgumentEntity.getPlayers((CommandContext<CommandListenerWrapper>)var0, "targets"), ArgumentChat.getMessage((CommandContext<CommandListenerWrapper>)var0, "reason")))))));
    }

    private static int kickPlayers(CommandListenerWrapper var0, Collection<EntityPlayer> var1, IChatBaseComponent var2) throws CommandSyntaxException {
        if (!var0.getServer().isPublished()) {
            throw ERROR_SINGLEPLAYER.create();
        }
        int var3 = 0;
        for (EntityPlayer var5 : var1) {
            if (var0.getServer().isSingleplayerOwner(var5.getGameProfile())) continue;
            var5.connection.disconnect(var2);
            var0.sendSuccess(() -> IChatBaseComponent.translatable("commands.kick.success", var5.getDisplayName(), var2), true);
            ++var3;
        }
        if (var3 == 0) {
            throw ERROR_KICKING_OWNER.create();
        }
        return var3;
    }
}

