/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minecraft.commands.CommandListenerWrapper;
import net.minecraft.network.chat.ChatComponentUtils;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.players.PlayerList;
import net.minecraft.world.entity.player.EntityHuman;
import org.bukkit.entity.Player;

public class CommandList {
    public static void register(CommandDispatcher<CommandListenerWrapper> commanddispatcher) {
        commanddispatcher.register((LiteralArgumentBuilder<CommandListenerWrapper>)((LiteralArgumentBuilder)((LiteralArgumentBuilder)net.minecraft.commands.CommandDispatcher.literal("list").executes(commandcontext -> CommandList.listPlayers((CommandListenerWrapper)commandcontext.getSource()))).then(net.minecraft.commands.CommandDispatcher.literal("uuids").executes(commandcontext -> CommandList.listPlayersWithUuids((CommandListenerWrapper)commandcontext.getSource())))));
    }

    private static int listPlayers(CommandListenerWrapper commandlistenerwrapper) {
        return CommandList.format(commandlistenerwrapper, EntityHuman::getDisplayName);
    }

    private static int listPlayersWithUuids(CommandListenerWrapper commandlistenerwrapper) {
        return CommandList.format(commandlistenerwrapper, entityplayer -> IChatBaseComponent.translatable("commands.list.nameAndId", entityplayer.getName(), IChatBaseComponent.translationArg(entityplayer.getGameProfile().getId())));
    }

    private static int format(CommandListenerWrapper commandlistenerwrapper, Function<EntityPlayer, IChatBaseComponent> function) {
        PlayerList playerlist = commandlistenerwrapper.getServer().getPlayerList();
        List<EntityPlayer> players = playerlist.getPlayers();
        if (commandlistenerwrapper.getBukkitSender() instanceof Player) {
            Player sender = (Player)commandlistenerwrapper.getBukkitSender();
            players = players.stream().filter(ep -> sender.canSee((Player)ep.getBukkitEntity())).collect(Collectors.toList());
        }
        List<EntityPlayer> list = players;
        IChatBaseComponent ichatbasecomponent = ChatComponentUtils.formatList(list, function);
        commandlistenerwrapper.sendSuccess(() -> IChatBaseComponent.translatable("commands.list.players", list.size(), playerlist.getMaxPlayers(), ichatbasecomponent), false);
        return list.size();
    }
}

