/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.commands;

import com.google.common.collect.Lists;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandListenerWrapper;
import net.minecraft.commands.ICompletionProvider;
import net.minecraft.commands.arguments.ArgumentEntity;
import net.minecraft.commands.arguments.ArgumentInventorySlot;
import net.minecraft.commands.arguments.ResourceOrIdArgument;
import net.minecraft.commands.arguments.coordinates.ArgumentPosition;
import net.minecraft.commands.arguments.coordinates.ArgumentVec3;
import net.minecraft.commands.arguments.item.ArgumentItemStack;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.ReloadableServerRegistries;
import net.minecraft.server.commands.ItemCommands;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.world.IInventory;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EnumItemSlot;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.item.EntityItem;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParameterSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParameters;
import net.minecraft.world.phys.Vec3D;

public class CommandLoot {
    public static final SuggestionProvider<CommandListenerWrapper> SUGGEST_LOOT_TABLE = (commandcontext, suggestionsbuilder) -> {
        ReloadableServerRegistries.b reloadableserverregistries_b = ((CommandListenerWrapper)commandcontext.getSource()).getServer().reloadableRegistries();
        return ICompletionProvider.suggestResource(reloadableserverregistries_b.getKeys(Registries.LOOT_TABLE), suggestionsbuilder);
    };
    private static final DynamicCommandExceptionType ERROR_NO_HELD_ITEMS = new DynamicCommandExceptionType(object -> IChatBaseComponent.translatableEscape("commands.drop.no_held_items", object));
    private static final DynamicCommandExceptionType ERROR_NO_LOOT_TABLE = new DynamicCommandExceptionType(object -> IChatBaseComponent.translatableEscape("commands.drop.no_loot_table", object));

    public static void register(CommandDispatcher<CommandListenerWrapper> commanddispatcher, CommandBuildContext commandbuildcontext) {
        commanddispatcher.register((LiteralArgumentBuilder<CommandListenerWrapper>)CommandLoot.addTargets((LiteralArgumentBuilder)net.minecraft.commands.CommandDispatcher.literal("loot").requires(commandlistenerwrapper -> commandlistenerwrapper.hasPermission(2)), (argumentbuilder, commandloot_b) -> argumentbuilder.then(net.minecraft.commands.CommandDispatcher.literal("fish").then(net.minecraft.commands.CommandDispatcher.argument("loot_table", ResourceOrIdArgument.lootTable(commandbuildcontext)).suggests(SUGGEST_LOOT_TABLE).then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)net.minecraft.commands.CommandDispatcher.argument("pos", ArgumentPosition.blockPos()).executes(commandcontext -> CommandLoot.dropFishingLoot((CommandContext<CommandListenerWrapper>)commandcontext, ResourceOrIdArgument.getLootTable((CommandContext<CommandListenerWrapper>)commandcontext, "loot_table"), ArgumentPosition.getLoadedBlockPos((CommandContext<CommandListenerWrapper>)commandcontext, "pos"), ItemStack.EMPTY, commandloot_b))).then(net.minecraft.commands.CommandDispatcher.argument("tool", ArgumentItemStack.item(commandbuildcontext)).executes(commandcontext -> CommandLoot.dropFishingLoot((CommandContext<CommandListenerWrapper>)commandcontext, ResourceOrIdArgument.getLootTable((CommandContext<CommandListenerWrapper>)commandcontext, "loot_table"), ArgumentPosition.getLoadedBlockPos((CommandContext<CommandListenerWrapper>)commandcontext, "pos"), ArgumentItemStack.getItem(commandcontext, "tool").createItemStack(1, false), commandloot_b)))).then(net.minecraft.commands.CommandDispatcher.literal("mainhand").executes(commandcontext -> CommandLoot.dropFishingLoot((CommandContext<CommandListenerWrapper>)commandcontext, ResourceOrIdArgument.getLootTable((CommandContext<CommandListenerWrapper>)commandcontext, "loot_table"), ArgumentPosition.getLoadedBlockPos((CommandContext<CommandListenerWrapper>)commandcontext, "pos"), CommandLoot.getSourceHandItem((CommandListenerWrapper)commandcontext.getSource(), EnumItemSlot.MAINHAND), commandloot_b)))).then(net.minecraft.commands.CommandDispatcher.literal("offhand").executes(commandcontext -> CommandLoot.dropFishingLoot((CommandContext<CommandListenerWrapper>)commandcontext, ResourceOrIdArgument.getLootTable((CommandContext<CommandListenerWrapper>)commandcontext, "loot_table"), ArgumentPosition.getLoadedBlockPos((CommandContext<CommandListenerWrapper>)commandcontext, "pos"), CommandLoot.getSourceHandItem((CommandListenerWrapper)commandcontext.getSource(), EnumItemSlot.OFFHAND), commandloot_b)))))).then(net.minecraft.commands.CommandDispatcher.literal("loot").then(net.minecraft.commands.CommandDispatcher.argument("loot_table", ResourceOrIdArgument.lootTable(commandbuildcontext)).suggests(SUGGEST_LOOT_TABLE).executes(commandcontext -> CommandLoot.dropChestLoot((CommandContext<CommandListenerWrapper>)commandcontext, ResourceOrIdArgument.getLootTable((CommandContext<CommandListenerWrapper>)commandcontext, "loot_table"), commandloot_b)))).then(net.minecraft.commands.CommandDispatcher.literal("kill").then(net.minecraft.commands.CommandDispatcher.argument("target", ArgumentEntity.entity()).executes(commandcontext -> CommandLoot.dropKillLoot((CommandContext<CommandListenerWrapper>)commandcontext, ArgumentEntity.getEntity((CommandContext<CommandListenerWrapper>)commandcontext, "target"), commandloot_b)))).then(net.minecraft.commands.CommandDispatcher.literal("mine").then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)net.minecraft.commands.CommandDispatcher.argument("pos", ArgumentPosition.blockPos()).executes(commandcontext -> CommandLoot.dropBlockLoot((CommandContext<CommandListenerWrapper>)commandcontext, ArgumentPosition.getLoadedBlockPos((CommandContext<CommandListenerWrapper>)commandcontext, "pos"), ItemStack.EMPTY, commandloot_b))).then(net.minecraft.commands.CommandDispatcher.argument("tool", ArgumentItemStack.item(commandbuildcontext)).executes(commandcontext -> CommandLoot.dropBlockLoot((CommandContext<CommandListenerWrapper>)commandcontext, ArgumentPosition.getLoadedBlockPos((CommandContext<CommandListenerWrapper>)commandcontext, "pos"), ArgumentItemStack.getItem(commandcontext, "tool").createItemStack(1, false), commandloot_b)))).then(net.minecraft.commands.CommandDispatcher.literal("mainhand").executes(commandcontext -> CommandLoot.dropBlockLoot((CommandContext<CommandListenerWrapper>)commandcontext, ArgumentPosition.getLoadedBlockPos((CommandContext<CommandListenerWrapper>)commandcontext, "pos"), CommandLoot.getSourceHandItem((CommandListenerWrapper)commandcontext.getSource(), EnumItemSlot.MAINHAND), commandloot_b)))).then(net.minecraft.commands.CommandDispatcher.literal("offhand").executes(commandcontext -> CommandLoot.dropBlockLoot((CommandContext<CommandListenerWrapper>)commandcontext, ArgumentPosition.getLoadedBlockPos((CommandContext<CommandListenerWrapper>)commandcontext, "pos"), CommandLoot.getSourceHandItem((CommandListenerWrapper)commandcontext.getSource(), EnumItemSlot.OFFHAND), commandloot_b)))))));
    }

    private static <T extends ArgumentBuilder<CommandListenerWrapper, T>> T addTargets(T t0, c commandloot_c) {
        return (T)t0.then(((LiteralArgumentBuilder)net.minecraft.commands.CommandDispatcher.literal("replace").then(net.minecraft.commands.CommandDispatcher.literal("entity").then(net.minecraft.commands.CommandDispatcher.argument("entities", ArgumentEntity.entities()).then(commandloot_c.construct((ArgumentBuilder<CommandListenerWrapper, ?>)net.minecraft.commands.CommandDispatcher.argument("slot", ArgumentInventorySlot.slot()), (commandcontext, list, commandloot_a) -> CommandLoot.entityReplace(ArgumentEntity.getEntities((CommandContext<CommandListenerWrapper>)commandcontext, "entities"), ArgumentInventorySlot.getSlot((CommandContext<CommandListenerWrapper>)commandcontext, "slot"), list.size(), list, commandloot_a)).then(commandloot_c.construct((ArgumentBuilder<CommandListenerWrapper, ?>)net.minecraft.commands.CommandDispatcher.argument("count", IntegerArgumentType.integer((int)0)), (commandcontext, list, commandloot_a) -> CommandLoot.entityReplace(ArgumentEntity.getEntities((CommandContext<CommandListenerWrapper>)commandcontext, "entities"), ArgumentInventorySlot.getSlot((CommandContext<CommandListenerWrapper>)commandcontext, "slot"), IntegerArgumentType.getInteger((CommandContext)commandcontext, (String)"count"), list, commandloot_a))))))).then(net.minecraft.commands.CommandDispatcher.literal("block").then(net.minecraft.commands.CommandDispatcher.argument("targetPos", ArgumentPosition.blockPos()).then(commandloot_c.construct((ArgumentBuilder<CommandListenerWrapper, ?>)net.minecraft.commands.CommandDispatcher.argument("slot", ArgumentInventorySlot.slot()), (commandcontext, list, commandloot_a) -> CommandLoot.blockReplace((CommandListenerWrapper)commandcontext.getSource(), ArgumentPosition.getLoadedBlockPos((CommandContext<CommandListenerWrapper>)commandcontext, "targetPos"), ArgumentInventorySlot.getSlot((CommandContext<CommandListenerWrapper>)commandcontext, "slot"), list.size(), list, commandloot_a)).then(commandloot_c.construct((ArgumentBuilder<CommandListenerWrapper, ?>)net.minecraft.commands.CommandDispatcher.argument("count", IntegerArgumentType.integer((int)0)), (commandcontext, list, commandloot_a) -> CommandLoot.blockReplace((CommandListenerWrapper)commandcontext.getSource(), ArgumentPosition.getLoadedBlockPos((CommandContext<CommandListenerWrapper>)commandcontext, "targetPos"), IntegerArgumentType.getInteger((CommandContext)commandcontext, (String)"slot"), IntegerArgumentType.getInteger((CommandContext)commandcontext, (String)"count"), list, commandloot_a))))))).then(net.minecraft.commands.CommandDispatcher.literal("insert").then(commandloot_c.construct((ArgumentBuilder<CommandListenerWrapper, ?>)net.minecraft.commands.CommandDispatcher.argument("targetPos", ArgumentPosition.blockPos()), (commandcontext, list, commandloot_a) -> CommandLoot.blockDistribute((CommandListenerWrapper)commandcontext.getSource(), ArgumentPosition.getLoadedBlockPos((CommandContext<CommandListenerWrapper>)commandcontext, "targetPos"), list, commandloot_a)))).then(net.minecraft.commands.CommandDispatcher.literal("give").then(commandloot_c.construct((ArgumentBuilder<CommandListenerWrapper, ?>)net.minecraft.commands.CommandDispatcher.argument("players", ArgumentEntity.players()), (commandcontext, list, commandloot_a) -> CommandLoot.playerGive(ArgumentEntity.getPlayers((CommandContext<CommandListenerWrapper>)commandcontext, "players"), list, commandloot_a)))).then(net.minecraft.commands.CommandDispatcher.literal("spawn").then(commandloot_c.construct((ArgumentBuilder<CommandListenerWrapper, ?>)net.minecraft.commands.CommandDispatcher.argument("targetPos", ArgumentVec3.vec3()), (commandcontext, list, commandloot_a) -> CommandLoot.dropInWorld((CommandListenerWrapper)commandcontext.getSource(), ArgumentVec3.getVec3((CommandContext<CommandListenerWrapper>)commandcontext, "targetPos"), list, commandloot_a))));
    }

    private static IInventory getContainer(CommandListenerWrapper commandlistenerwrapper, BlockPosition blockposition) throws CommandSyntaxException {
        TileEntity tileentity = commandlistenerwrapper.getLevel().getBlockEntity(blockposition);
        if (!(tileentity instanceof IInventory)) {
            throw ItemCommands.ERROR_TARGET_NOT_A_CONTAINER.create((Object)blockposition.getX(), (Object)blockposition.getY(), (Object)blockposition.getZ());
        }
        return (IInventory)((Object)tileentity);
    }

    private static int blockDistribute(CommandListenerWrapper commandlistenerwrapper, BlockPosition blockposition, List<ItemStack> list, a commandloot_a) throws CommandSyntaxException {
        IInventory iinventory = CommandLoot.getContainer(commandlistenerwrapper, blockposition);
        ArrayList list1 = Lists.newArrayListWithCapacity((int)list.size());
        for (ItemStack itemstack : list) {
            if (!CommandLoot.distributeToContainer(iinventory, itemstack.copy())) continue;
            iinventory.setChanged();
            list1.add(itemstack);
        }
        commandloot_a.accept(list1);
        return list1.size();
    }

    private static boolean distributeToContainer(IInventory iinventory, ItemStack itemstack) {
        boolean flag = false;
        for (int i2 = 0; i2 < iinventory.getContainerSize() && !itemstack.isEmpty(); ++i2) {
            ItemStack itemstack1 = iinventory.getItem(i2);
            if (!iinventory.canPlaceItem(i2, itemstack)) continue;
            if (itemstack1.isEmpty()) {
                iinventory.setItem(i2, itemstack);
                flag = true;
                break;
            }
            if (!CommandLoot.canMergeItems(itemstack1, itemstack)) continue;
            int j2 = itemstack.getMaxStackSize() - itemstack1.getCount();
            int k2 = Math.min(itemstack.getCount(), j2);
            itemstack.shrink(k2);
            itemstack1.grow(k2);
            flag = true;
        }
        return flag;
    }

    private static int blockReplace(CommandListenerWrapper commandlistenerwrapper, BlockPosition blockposition, int i2, int j2, List<ItemStack> list, a commandloot_a) throws CommandSyntaxException {
        IInventory iinventory = CommandLoot.getContainer(commandlistenerwrapper, blockposition);
        int k2 = iinventory.getContainerSize();
        if (i2 >= 0 && i2 < k2) {
            ArrayList list1 = Lists.newArrayListWithCapacity((int)list.size());
            for (int l2 = 0; l2 < j2; ++l2) {
                ItemStack itemstack;
                int i1 = i2 + l2;
                ItemStack itemStack = itemstack = l2 < list.size() ? list.get(l2) : ItemStack.EMPTY;
                if (!iinventory.canPlaceItem(i1, itemstack)) continue;
                iinventory.setItem(i1, itemstack);
                list1.add(itemstack);
            }
            commandloot_a.accept(list1);
            return list1.size();
        }
        throw ItemCommands.ERROR_TARGET_INAPPLICABLE_SLOT.create((Object)i2);
    }

    private static boolean canMergeItems(ItemStack itemstack, ItemStack itemstack1) {
        return itemstack.getCount() <= itemstack.getMaxStackSize() && ItemStack.isSameItemSameComponents(itemstack, itemstack1);
    }

    private static int playerGive(Collection<EntityPlayer> collection, List<ItemStack> list, a commandloot_a) throws CommandSyntaxException {
        ArrayList list1 = Lists.newArrayListWithCapacity((int)list.size());
        for (ItemStack itemstack : list) {
            for (EntityPlayer entityplayer : collection) {
                if (!entityplayer.getInventory().add(itemstack.copy())) continue;
                list1.add(itemstack);
            }
        }
        commandloot_a.accept(list1);
        return list1.size();
    }

    private static void setSlots(Entity entity, List<ItemStack> list, int i2, int j2, List<ItemStack> list1) {
        for (int k2 = 0; k2 < j2; ++k2) {
            ItemStack itemstack = k2 < list.size() ? list.get(k2) : ItemStack.EMPTY;
            SlotAccess slotaccess = entity.getSlot(i2 + k2);
            if (slotaccess == SlotAccess.NULL || !slotaccess.set(itemstack.copy())) continue;
            list1.add(itemstack);
        }
    }

    private static int entityReplace(Collection<? extends Entity> collection, int i2, int j2, List<ItemStack> list, a commandloot_a) throws CommandSyntaxException {
        ArrayList list1 = Lists.newArrayListWithCapacity((int)list.size());
        for (Entity entity : collection) {
            if (entity instanceof EntityPlayer) {
                EntityPlayer entityplayer = (EntityPlayer)entity;
                CommandLoot.setSlots(entity, list, i2, j2, list1);
                entityplayer.containerMenu.broadcastChanges();
                continue;
            }
            CommandLoot.setSlots(entity, list, i2, j2, list1);
        }
        commandloot_a.accept(list1);
        return list1.size();
    }

    private static int dropInWorld(CommandListenerWrapper commandlistenerwrapper, Vec3D vec3d, List<ItemStack> list, a commandloot_a) throws CommandSyntaxException {
        WorldServer worldserver = commandlistenerwrapper.getLevel();
        list.removeIf(ItemStack::isEmpty);
        list.forEach(itemstack -> {
            EntityItem entityitem = new EntityItem(worldserver, vec3d.x, vec3d.y, vec3d.z, itemstack.copy());
            entityitem.setDefaultPickUpDelay();
            worldserver.addFreshEntity(entityitem);
        });
        commandloot_a.accept(list);
        return list.size();
    }

    private static void callback(CommandListenerWrapper commandlistenerwrapper, List<ItemStack> list) {
        if (list.size() == 1) {
            ItemStack itemstack = list.get(0);
            commandlistenerwrapper.sendSuccess(() -> IChatBaseComponent.translatable("commands.drop.success.single", itemstack.getCount(), itemstack.getDisplayName()), false);
        } else {
            commandlistenerwrapper.sendSuccess(() -> IChatBaseComponent.translatable("commands.drop.success.multiple", list.size()), false);
        }
    }

    private static void callback(CommandListenerWrapper commandlistenerwrapper, List<ItemStack> list, ResourceKey<LootTable> resourcekey) {
        if (list.size() == 1) {
            ItemStack itemstack = list.get(0);
            commandlistenerwrapper.sendSuccess(() -> IChatBaseComponent.translatable("commands.drop.success.single_with_table", itemstack.getCount(), itemstack.getDisplayName(), IChatBaseComponent.translationArg(resourcekey.location())), false);
        } else {
            commandlistenerwrapper.sendSuccess(() -> IChatBaseComponent.translatable("commands.drop.success.multiple_with_table", list.size(), IChatBaseComponent.translationArg(resourcekey.location())), false);
        }
    }

    private static ItemStack getSourceHandItem(CommandListenerWrapper commandlistenerwrapper, EnumItemSlot enumitemslot) throws CommandSyntaxException {
        Entity entity = commandlistenerwrapper.getEntityOrException();
        if (entity instanceof EntityLiving) {
            return ((EntityLiving)entity).getItemBySlot(enumitemslot);
        }
        throw ERROR_NO_HELD_ITEMS.create((Object)entity.getDisplayName());
    }

    private static int dropBlockLoot(CommandContext<CommandListenerWrapper> commandcontext, BlockPosition blockposition, ItemStack itemstack, b commandloot_b) throws CommandSyntaxException {
        CommandListenerWrapper commandlistenerwrapper = (CommandListenerWrapper)commandcontext.getSource();
        WorldServer worldserver = commandlistenerwrapper.getLevel();
        IBlockData iblockdata = worldserver.getBlockState(blockposition);
        TileEntity tileentity = worldserver.getBlockEntity(blockposition);
        LootParams.a lootparams_a = new LootParams.a(worldserver).withParameter(LootContextParameters.ORIGIN, Vec3D.atCenterOf(blockposition)).withParameter(LootContextParameters.BLOCK_STATE, iblockdata).withOptionalParameter(LootContextParameters.BLOCK_ENTITY, tileentity).withOptionalParameter(LootContextParameters.THIS_ENTITY, commandlistenerwrapper.getEntity()).withParameter(LootContextParameters.TOOL, itemstack);
        List<ItemStack> list = iblockdata.getDrops(lootparams_a);
        return commandloot_b.accept(commandcontext, list, list1 -> CommandLoot.callback(commandlistenerwrapper, list1, iblockdata.getBlock().getLootTable()));
    }

    private static int dropKillLoot(CommandContext<CommandListenerWrapper> commandcontext, Entity entity, b commandloot_b) throws CommandSyntaxException {
        if (!(entity instanceof EntityLiving)) {
            throw ERROR_NO_LOOT_TABLE.create((Object)entity.getDisplayName());
        }
        ResourceKey<LootTable> resourcekey = ((EntityLiving)entity).getLootTable();
        CommandListenerWrapper commandlistenerwrapper = (CommandListenerWrapper)commandcontext.getSource();
        LootParams.a lootparams_a = new LootParams.a(commandlistenerwrapper.getLevel());
        Entity entity1 = commandlistenerwrapper.getEntity();
        if (entity1 instanceof EntityHuman) {
            EntityHuman entityhuman = (EntityHuman)entity1;
            lootparams_a.withParameter(LootContextParameters.LAST_DAMAGE_PLAYER, entityhuman);
        }
        lootparams_a.withParameter(LootContextParameters.DAMAGE_SOURCE, entity.damageSources().magic());
        lootparams_a.withOptionalParameter(LootContextParameters.DIRECT_ATTACKING_ENTITY, entity1);
        lootparams_a.withOptionalParameter(LootContextParameters.ATTACKING_ENTITY, entity1);
        lootparams_a.withParameter(LootContextParameters.THIS_ENTITY, entity);
        lootparams_a.withParameter(LootContextParameters.ORIGIN, commandlistenerwrapper.getPosition());
        LootParams lootparams = lootparams_a.create(LootContextParameterSets.ENTITY);
        LootTable loottable = commandlistenerwrapper.getServer().reloadableRegistries().getLootTable(resourcekey);
        ObjectArrayList<ItemStack> list = loottable.getRandomItems(lootparams);
        return commandloot_b.accept(commandcontext, (List<ItemStack>)list, list1 -> CommandLoot.callback(commandlistenerwrapper, list1, resourcekey));
    }

    private static int dropChestLoot(CommandContext<CommandListenerWrapper> commandcontext, Holder<LootTable> holder, b commandloot_b) throws CommandSyntaxException {
        CommandListenerWrapper commandlistenerwrapper = (CommandListenerWrapper)commandcontext.getSource();
        LootParams lootparams = new LootParams.a(commandlistenerwrapper.getLevel()).withOptionalParameter(LootContextParameters.THIS_ENTITY, commandlistenerwrapper.getEntity()).withParameter(LootContextParameters.ORIGIN, commandlistenerwrapper.getPosition()).create(LootContextParameterSets.CHEST);
        return CommandLoot.drop(commandcontext, holder, lootparams, commandloot_b);
    }

    private static int dropFishingLoot(CommandContext<CommandListenerWrapper> commandcontext, Holder<LootTable> holder, BlockPosition blockposition, ItemStack itemstack, b commandloot_b) throws CommandSyntaxException {
        CommandListenerWrapper commandlistenerwrapper = (CommandListenerWrapper)commandcontext.getSource();
        LootParams lootparams = new LootParams.a(commandlistenerwrapper.getLevel()).withParameter(LootContextParameters.ORIGIN, Vec3D.atCenterOf(blockposition)).withParameter(LootContextParameters.TOOL, itemstack).withOptionalParameter(LootContextParameters.THIS_ENTITY, commandlistenerwrapper.getEntity()).create(LootContextParameterSets.FISHING);
        return CommandLoot.drop(commandcontext, holder, lootparams, commandloot_b);
    }

    private static int drop(CommandContext<CommandListenerWrapper> commandcontext, Holder<LootTable> holder, LootParams lootparams, b commandloot_b) throws CommandSyntaxException {
        CommandListenerWrapper commandlistenerwrapper = (CommandListenerWrapper)commandcontext.getSource();
        ObjectArrayList<ItemStack> list = holder.value().getRandomItems(lootparams);
        return commandloot_b.accept(commandcontext, (List<ItemStack>)list, list1 -> CommandLoot.callback(commandlistenerwrapper, list1));
    }

    @FunctionalInterface
    private static interface c {
        public ArgumentBuilder<CommandListenerWrapper, ?> construct(ArgumentBuilder<CommandListenerWrapper, ?> var1, b var2);
    }

    @FunctionalInterface
    private static interface b {
        public int accept(CommandContext<CommandListenerWrapper> var1, List<ItemStack> var2, a var3) throws CommandSyntaxException;
    }

    @FunctionalInterface
    private static interface a {
        public void accept(List<ItemStack> var1) throws CommandSyntaxException;
    }
}

