/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import java.util.Collection;
import java.util.Collections;
import net.minecraft.commands.CommandListenerWrapper;
import net.minecraft.commands.arguments.ArgumentEntity;
import net.minecraft.commands.arguments.ArgumentMinecraftKeyRegistered;
import net.minecraft.commands.synchronization.CompletionProviders;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.world.item.crafting.RecipeHolder;

public class CommandRecipe {
    private static final SimpleCommandExceptionType ERROR_GIVE_FAILED = new SimpleCommandExceptionType((Message)IChatBaseComponent.translatable("commands.recipe.give.failed"));
    private static final SimpleCommandExceptionType ERROR_TAKE_FAILED = new SimpleCommandExceptionType((Message)IChatBaseComponent.translatable("commands.recipe.take.failed"));

    public static void register(CommandDispatcher<CommandListenerWrapper> var02) {
        var02.register((LiteralArgumentBuilder<CommandListenerWrapper>)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)net.minecraft.commands.CommandDispatcher.literal("recipe").requires(var0 -> var0.hasPermission(2))).then(net.minecraft.commands.CommandDispatcher.literal("give").then(((RequiredArgumentBuilder)net.minecraft.commands.CommandDispatcher.argument("targets", ArgumentEntity.players()).then(net.minecraft.commands.CommandDispatcher.argument("recipe", ArgumentMinecraftKeyRegistered.id()).suggests(CompletionProviders.ALL_RECIPES).executes(var0 -> CommandRecipe.giveRecipes((CommandListenerWrapper)var0.getSource(), ArgumentEntity.getPlayers((CommandContext<CommandListenerWrapper>)var0, "targets"), Collections.singleton(ArgumentMinecraftKeyRegistered.getRecipe((CommandContext<CommandListenerWrapper>)var0, "recipe")))))).then(net.minecraft.commands.CommandDispatcher.literal("*").executes(var0 -> CommandRecipe.giveRecipes((CommandListenerWrapper)var0.getSource(), ArgumentEntity.getPlayers((CommandContext<CommandListenerWrapper>)var0, "targets"), ((CommandListenerWrapper)var0.getSource()).getServer().getRecipeManager().getRecipes())))))).then(net.minecraft.commands.CommandDispatcher.literal("take").then(((RequiredArgumentBuilder)net.minecraft.commands.CommandDispatcher.argument("targets", ArgumentEntity.players()).then(net.minecraft.commands.CommandDispatcher.argument("recipe", ArgumentMinecraftKeyRegistered.id()).suggests(CompletionProviders.ALL_RECIPES).executes(var0 -> CommandRecipe.takeRecipes((CommandListenerWrapper)var0.getSource(), ArgumentEntity.getPlayers((CommandContext<CommandListenerWrapper>)var0, "targets"), Collections.singleton(ArgumentMinecraftKeyRegistered.getRecipe((CommandContext<CommandListenerWrapper>)var0, "recipe")))))).then(net.minecraft.commands.CommandDispatcher.literal("*").executes(var0 -> CommandRecipe.takeRecipes((CommandListenerWrapper)var0.getSource(), ArgumentEntity.getPlayers((CommandContext<CommandListenerWrapper>)var0, "targets"), ((CommandListenerWrapper)var0.getSource()).getServer().getRecipeManager().getRecipes())))))));
    }

    private static int giveRecipes(CommandListenerWrapper var0, Collection<EntityPlayer> var1, Collection<RecipeHolder<?>> var2) throws CommandSyntaxException {
        int var3 = 0;
        for (EntityPlayer var5 : var1) {
            var3 += var5.awardRecipes(var2);
        }
        if (var3 == 0) {
            throw ERROR_GIVE_FAILED.create();
        }
        if (var1.size() == 1) {
            var0.sendSuccess(() -> IChatBaseComponent.translatable("commands.recipe.give.success.single", var2.size(), ((EntityPlayer)var1.iterator().next()).getDisplayName()), true);
        } else {
            var0.sendSuccess(() -> IChatBaseComponent.translatable("commands.recipe.give.success.multiple", var2.size(), var1.size()), true);
        }
        return var3;
    }

    private static int takeRecipes(CommandListenerWrapper var0, Collection<EntityPlayer> var1, Collection<RecipeHolder<?>> var2) throws CommandSyntaxException {
        int var3 = 0;
        for (EntityPlayer var5 : var1) {
            var3 += var5.resetRecipes(var2);
        }
        if (var3 == 0) {
            throw ERROR_TAKE_FAILED.create();
        }
        if (var1.size() == 1) {
            var0.sendSuccess(() -> IChatBaseComponent.translatable("commands.recipe.take.success.single", var2.size(), ((EntityPlayer)var1.iterator().next()).getDisplayName()), true);
        } else {
            var0.sendSuccess(() -> IChatBaseComponent.translatable("commands.recipe.take.success.multiple", var2.size(), var1.size()), true);
        }
        return var3;
    }
}

