/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.commands;

import com.google.common.collect.Lists;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.logging.LogUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.minecraft.commands.CommandListenerWrapper;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.packs.repository.ResourcePackRepository;
import net.minecraft.world.level.storage.SaveData;
import org.slf4j.Logger;

public class CommandReload {
    private static final Logger LOGGER = LogUtils.getLogger();

    public static void reloadPacks(Collection<String> collection, CommandListenerWrapper commandlistenerwrapper) {
        commandlistenerwrapper.getServer().reloadResources(collection).exceptionally(throwable -> {
            LOGGER.warn("Failed to execute reload", throwable);
            commandlistenerwrapper.sendFailure(IChatBaseComponent.translatable("commands.reload.failure"));
            return null;
        });
    }

    private static Collection<String> discoverNewPacks(ResourcePackRepository resourcepackrepository, SaveData savedata, Collection<String> collection) {
        resourcepackrepository.reload();
        ArrayList collection1 = Lists.newArrayList(collection);
        List<String> collection2 = savedata.getDataConfiguration().dataPacks().getDisabled();
        for (String s2 : resourcepackrepository.getAvailableIds()) {
            if (collection2.contains(s2) || collection1.contains(s2)) continue;
            collection1.add(s2);
        }
        return collection1;
    }

    public static void reload(MinecraftServer minecraftserver) {
        ResourcePackRepository resourcepackrepository = minecraftserver.getPackRepository();
        SaveData savedata = minecraftserver.getWorldData();
        Collection<String> collection = resourcepackrepository.getSelectedIds();
        Collection<String> collection1 = CommandReload.discoverNewPacks(resourcepackrepository, savedata, collection);
        minecraftserver.reloadResources(collection1);
    }

    public static void register(CommandDispatcher<CommandListenerWrapper> commanddispatcher) {
        commanddispatcher.register((LiteralArgumentBuilder<CommandListenerWrapper>)((LiteralArgumentBuilder)((LiteralArgumentBuilder)net.minecraft.commands.CommandDispatcher.literal("reload").requires(commandlistenerwrapper -> commandlistenerwrapper.hasPermission(2))).executes(commandcontext -> {
            CommandListenerWrapper commandlistenerwrapper = (CommandListenerWrapper)commandcontext.getSource();
            MinecraftServer minecraftserver = commandlistenerwrapper.getServer();
            ResourcePackRepository resourcepackrepository = minecraftserver.getPackRepository();
            SaveData savedata = minecraftserver.getWorldData();
            Collection<String> collection = resourcepackrepository.getSelectedIds();
            Collection<String> collection1 = CommandReload.discoverNewPacks(resourcepackrepository, savedata, collection);
            commandlistenerwrapper.sendSuccess(() -> IChatBaseComponent.translatable("commands.reload.success"), true);
            CommandReload.reloadPacks(collection1, commandlistenerwrapper);
            return 0;
        })));
    }
}

