/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.datafixers.util.Either;
import com.mojang.datafixers.util.Pair;
import java.util.Collection;
import net.minecraft.commands.CommandListenerWrapper;
import net.minecraft.commands.ICompletionProvider;
import net.minecraft.commands.arguments.ArgumentTime;
import net.minecraft.commands.arguments.item.ArgumentTag;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.commands.CommandFunction;
import net.minecraft.world.level.timers.CustomFunctionCallback;
import net.minecraft.world.level.timers.CustomFunctionCallbackTag;
import net.minecraft.world.level.timers.CustomFunctionCallbackTimerQueue;

public class CommandSchedule {
    private static final SimpleCommandExceptionType ERROR_SAME_TICK = new SimpleCommandExceptionType((Message)IChatBaseComponent.translatable("commands.schedule.same_tick"));
    private static final DynamicCommandExceptionType ERROR_CANT_REMOVE = new DynamicCommandExceptionType(object -> IChatBaseComponent.translatableEscape("commands.schedule.cleared.failure", object));
    private static final SuggestionProvider<CommandListenerWrapper> SUGGEST_SCHEDULE = (commandcontext, suggestionsbuilder) -> ICompletionProvider.suggest(((CommandListenerWrapper)commandcontext.getSource()).getServer().getWorldData().overworldData().getScheduledEvents().getEventsIds(), suggestionsbuilder);

    public static void register(CommandDispatcher<CommandListenerWrapper> commanddispatcher) {
        commanddispatcher.register((LiteralArgumentBuilder<CommandListenerWrapper>)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)net.minecraft.commands.CommandDispatcher.literal("schedule").requires(commandlistenerwrapper -> commandlistenerwrapper.hasPermission(2))).then(net.minecraft.commands.CommandDispatcher.literal("function").then(net.minecraft.commands.CommandDispatcher.argument("function", ArgumentTag.functions()).suggests(CommandFunction.SUGGEST_FUNCTION).then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)net.minecraft.commands.CommandDispatcher.argument("time", ArgumentTime.time()).executes(commandcontext -> CommandSchedule.schedule((CommandListenerWrapper)commandcontext.getSource(), ArgumentTag.getFunctionOrTag((CommandContext<CommandListenerWrapper>)commandcontext, "function"), IntegerArgumentType.getInteger((CommandContext)commandcontext, (String)"time"), true))).then(net.minecraft.commands.CommandDispatcher.literal("append").executes(commandcontext -> CommandSchedule.schedule((CommandListenerWrapper)commandcontext.getSource(), ArgumentTag.getFunctionOrTag((CommandContext<CommandListenerWrapper>)commandcontext, "function"), IntegerArgumentType.getInteger((CommandContext)commandcontext, (String)"time"), false)))).then(net.minecraft.commands.CommandDispatcher.literal("replace").executes(commandcontext -> CommandSchedule.schedule((CommandListenerWrapper)commandcontext.getSource(), ArgumentTag.getFunctionOrTag((CommandContext<CommandListenerWrapper>)commandcontext, "function"), IntegerArgumentType.getInteger((CommandContext)commandcontext, (String)"time"), true))))))).then(net.minecraft.commands.CommandDispatcher.literal("clear").then(net.minecraft.commands.CommandDispatcher.argument("function", StringArgumentType.greedyString()).suggests(SUGGEST_SCHEDULE).executes(commandcontext -> CommandSchedule.remove((CommandListenerWrapper)commandcontext.getSource(), StringArgumentType.getString((CommandContext)commandcontext, (String)"function")))))));
    }

    private static int schedule(CommandListenerWrapper commandlistenerwrapper, Pair<MinecraftKey, Either<net.minecraft.commands.functions.CommandFunction<CommandListenerWrapper>, Collection<net.minecraft.commands.functions.CommandFunction<CommandListenerWrapper>>>> pair, int i2, boolean flag) throws CommandSyntaxException {
        if (i2 == 0) {
            throw ERROR_SAME_TICK.create();
        }
        long j2 = commandlistenerwrapper.getLevel().getGameTime() + (long)i2;
        MinecraftKey minecraftkey = (MinecraftKey)pair.getFirst();
        CustomFunctionCallbackTimerQueue<MinecraftServer> customfunctioncallbacktimerqueue = commandlistenerwrapper.getLevel().serverLevelData.overworldData().getScheduledEvents();
        ((Either)pair.getSecond()).ifLeft(net_minecraft_commands_functions_commandfunction -> {
            String s2 = minecraftkey.toString();
            if (flag) {
                customfunctioncallbacktimerqueue.remove(s2);
            }
            customfunctioncallbacktimerqueue.schedule(s2, j2, new CustomFunctionCallback(minecraftkey));
            commandlistenerwrapper.sendSuccess(() -> IChatBaseComponent.translatable("commands.schedule.created.function", IChatBaseComponent.translationArg(minecraftkey), i2, j2), true);
        }).ifRight(collection -> {
            String s2 = "#" + String.valueOf(minecraftkey);
            if (flag) {
                customfunctioncallbacktimerqueue.remove(s2);
            }
            customfunctioncallbacktimerqueue.schedule(s2, j2, new CustomFunctionCallbackTag(minecraftkey));
            commandlistenerwrapper.sendSuccess(() -> IChatBaseComponent.translatable("commands.schedule.created.tag", IChatBaseComponent.translationArg(minecraftkey), i2, j2), true);
        });
        return Math.floorMod(j2, Integer.MAX_VALUE);
    }

    private static int remove(CommandListenerWrapper commandlistenerwrapper, String s2) throws CommandSyntaxException {
        int i2 = commandlistenerwrapper.getServer().getWorldData().overworldData().getScheduledEvents().remove(s2);
        if (i2 == 0) {
            throw ERROR_CANT_REMOVE.create((Object)s2);
        }
        commandlistenerwrapper.sendSuccess(() -> IChatBaseComponent.translatable("commands.schedule.cleared.success", i2, s2), true);
        return i2;
    }
}

