/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.util.Collection;
import java.util.Collections;
import net.minecraft.commands.CommandListenerWrapper;
import net.minecraft.commands.arguments.ArgumentAngle;
import net.minecraft.commands.arguments.ArgumentEntity;
import net.minecraft.commands.arguments.coordinates.ArgumentPosition;
import net.minecraft.core.BlockPosition;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.world.level.World;
import org.bukkit.event.player.PlayerSpawnChangeEvent;

public class CommandSpawnpoint {
    public static void register(CommandDispatcher<CommandListenerWrapper> commanddispatcher) {
        commanddispatcher.register((LiteralArgumentBuilder<CommandListenerWrapper>)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)net.minecraft.commands.CommandDispatcher.literal("spawnpoint").requires(commandlistenerwrapper -> commandlistenerwrapper.hasPermission(2))).executes(commandcontext -> CommandSpawnpoint.setSpawn((CommandListenerWrapper)commandcontext.getSource(), Collections.singleton(((CommandListenerWrapper)commandcontext.getSource()).getPlayerOrException()), BlockPosition.containing(((CommandListenerWrapper)commandcontext.getSource()).getPosition()), 0.0f))).then(((RequiredArgumentBuilder)net.minecraft.commands.CommandDispatcher.argument("targets", ArgumentEntity.players()).executes(commandcontext -> CommandSpawnpoint.setSpawn((CommandListenerWrapper)commandcontext.getSource(), ArgumentEntity.getPlayers((CommandContext<CommandListenerWrapper>)commandcontext, "targets"), BlockPosition.containing(((CommandListenerWrapper)commandcontext.getSource()).getPosition()), 0.0f))).then(((RequiredArgumentBuilder)net.minecraft.commands.CommandDispatcher.argument("pos", ArgumentPosition.blockPos()).executes(commandcontext -> CommandSpawnpoint.setSpawn((CommandListenerWrapper)commandcontext.getSource(), ArgumentEntity.getPlayers((CommandContext<CommandListenerWrapper>)commandcontext, "targets"), ArgumentPosition.getSpawnablePos((CommandContext<CommandListenerWrapper>)commandcontext, "pos"), 0.0f))).then(net.minecraft.commands.CommandDispatcher.argument("angle", ArgumentAngle.angle()).executes(commandcontext -> CommandSpawnpoint.setSpawn((CommandListenerWrapper)commandcontext.getSource(), ArgumentEntity.getPlayers((CommandContext<CommandListenerWrapper>)commandcontext, "targets"), ArgumentPosition.getSpawnablePos((CommandContext<CommandListenerWrapper>)commandcontext, "pos"), ArgumentAngle.getAngle((CommandContext<CommandListenerWrapper>)commandcontext, "angle"))))))));
    }

    private static int setSpawn(CommandListenerWrapper commandlistenerwrapper, Collection<EntityPlayer> collection, BlockPosition blockposition, float f2) {
        ResourceKey<World> resourcekey = commandlistenerwrapper.getLevel().dimension();
        for (EntityPlayer entityplayer : collection) {
            entityplayer.setRespawnPosition(resourcekey, blockposition, f2, true, false, PlayerSpawnChangeEvent.Cause.COMMAND);
        }
        String s2 = resourcekey.location().toString();
        if (collection.size() == 1) {
            commandlistenerwrapper.sendSuccess(() -> IChatBaseComponent.translatable("commands.spawnpoint.success.single", blockposition.getX(), blockposition.getY(), blockposition.getZ(), Float.valueOf(f2), s2, ((EntityPlayer)collection.iterator().next()).getDisplayName()), true);
        } else {
            commandlistenerwrapper.sendSuccess(() -> IChatBaseComponent.translatable("commands.spawnpoint.success.multiple", blockposition.getX(), blockposition.getY(), blockposition.getZ(), Float.valueOf(f2), s2, collection.size()), true);
        }
        return collection.size();
    }
}

