/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.commands;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.FloatArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.Dynamic2CommandExceptionType;
import com.mojang.brigadier.exceptions.Dynamic4CommandExceptionType;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import net.minecraft.commands.CommandListenerWrapper;
import net.minecraft.commands.arguments.ArgumentEntity;
import net.minecraft.commands.arguments.coordinates.ArgumentVec2;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.server.level.WorldServer;
import net.minecraft.tags.TagsBlock;
import net.minecraft.util.MathHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.phys.Vec2F;
import net.minecraft.world.scores.ScoreboardTeam;
import org.bukkit.event.player.PlayerTeleportEvent;

public class CommandSpreadPlayers {
    private static final int MAX_ITERATION_COUNT = 10000;
    private static final Dynamic4CommandExceptionType ERROR_FAILED_TO_SPREAD_TEAMS = new Dynamic4CommandExceptionType((object, object1, object2, object3) -> IChatBaseComponent.translatableEscape("commands.spreadplayers.failed.teams", object, object1, object2, object3));
    private static final Dynamic4CommandExceptionType ERROR_FAILED_TO_SPREAD_ENTITIES = new Dynamic4CommandExceptionType((object, object1, object2, object3) -> IChatBaseComponent.translatableEscape("commands.spreadplayers.failed.entities", object, object1, object2, object3));
    private static final Dynamic2CommandExceptionType ERROR_INVALID_MAX_HEIGHT = new Dynamic2CommandExceptionType((object, object1) -> IChatBaseComponent.translatableEscape("commands.spreadplayers.failed.invalid.height", object, object1));

    public static void register(CommandDispatcher<CommandListenerWrapper> commanddispatcher) {
        commanddispatcher.register((LiteralArgumentBuilder<CommandListenerWrapper>)((LiteralArgumentBuilder)((LiteralArgumentBuilder)net.minecraft.commands.CommandDispatcher.literal("spreadplayers").requires(commandlistenerwrapper -> commandlistenerwrapper.hasPermission(2))).then(net.minecraft.commands.CommandDispatcher.argument("center", ArgumentVec2.vec2()).then(net.minecraft.commands.CommandDispatcher.argument("spreadDistance", FloatArgumentType.floatArg((float)0.0f)).then(((RequiredArgumentBuilder)net.minecraft.commands.CommandDispatcher.argument("maxRange", FloatArgumentType.floatArg((float)1.0f)).then(net.minecraft.commands.CommandDispatcher.argument("respectTeams", BoolArgumentType.bool()).then(net.minecraft.commands.CommandDispatcher.argument("targets", ArgumentEntity.entities()).executes(commandcontext -> CommandSpreadPlayers.spreadPlayers((CommandListenerWrapper)commandcontext.getSource(), ArgumentVec2.getVec2((CommandContext<CommandListenerWrapper>)commandcontext, "center"), FloatArgumentType.getFloat((CommandContext)commandcontext, (String)"spreadDistance"), FloatArgumentType.getFloat((CommandContext)commandcontext, (String)"maxRange"), ((CommandListenerWrapper)commandcontext.getSource()).getLevel().getMaxBuildHeight(), BoolArgumentType.getBool((CommandContext)commandcontext, (String)"respectTeams"), ArgumentEntity.getEntities((CommandContext<CommandListenerWrapper>)commandcontext, "targets")))))).then(net.minecraft.commands.CommandDispatcher.literal("under").then(net.minecraft.commands.CommandDispatcher.argument("maxHeight", IntegerArgumentType.integer()).then(net.minecraft.commands.CommandDispatcher.argument("respectTeams", BoolArgumentType.bool()).then(net.minecraft.commands.CommandDispatcher.argument("targets", ArgumentEntity.entities()).executes(commandcontext -> CommandSpreadPlayers.spreadPlayers((CommandListenerWrapper)commandcontext.getSource(), ArgumentVec2.getVec2((CommandContext<CommandListenerWrapper>)commandcontext, "center"), FloatArgumentType.getFloat((CommandContext)commandcontext, (String)"spreadDistance"), FloatArgumentType.getFloat((CommandContext)commandcontext, (String)"maxRange"), IntegerArgumentType.getInteger((CommandContext)commandcontext, (String)"maxHeight"), BoolArgumentType.getBool((CommandContext)commandcontext, (String)"respectTeams"), ArgumentEntity.getEntities((CommandContext<CommandListenerWrapper>)commandcontext, "targets"))))))))))));
    }

    private static int spreadPlayers(CommandListenerWrapper commandlistenerwrapper, Vec2F vec2f, float f2, float f1, int i2, boolean flag, Collection<? extends Entity> collection) throws CommandSyntaxException {
        WorldServer worldserver = commandlistenerwrapper.getLevel();
        int j2 = worldserver.getMinBuildHeight();
        if (i2 < j2) {
            throw ERROR_INVALID_MAX_HEIGHT.create((Object)i2, (Object)j2);
        }
        RandomSource randomsource = RandomSource.create();
        double d0 = vec2f.x - f1;
        double d1 = vec2f.y - f1;
        double d2 = vec2f.x + f1;
        double d3 = vec2f.y + f1;
        a[] acommandspreadplayers_a = CommandSpreadPlayers.createInitialPositions(randomsource, flag ? CommandSpreadPlayers.getNumberOfTeams(collection) : collection.size(), d0, d1, d2, d3);
        CommandSpreadPlayers.spreadPositions(vec2f, f2, worldserver, randomsource, d0, d1, d2, d3, i2, acommandspreadplayers_a, flag);
        double d4 = CommandSpreadPlayers.setPlayerPositions(collection, worldserver, acommandspreadplayers_a, i2, flag);
        commandlistenerwrapper.sendSuccess(() -> IChatBaseComponent.translatable("commands.spreadplayers.success." + (flag ? "teams" : "entities"), acommandspreadplayers_a.length, Float.valueOf(vec2f.x), Float.valueOf(vec2f.y), String.format(Locale.ROOT, "%.2f", d4)), true);
        return acommandspreadplayers_a.length;
    }

    private static int getNumberOfTeams(Collection<? extends Entity> collection) {
        HashSet set = Sets.newHashSet();
        for (Entity entity : collection) {
            if (entity instanceof EntityHuman) {
                set.add(entity.getTeam());
                continue;
            }
            set.add(null);
        }
        return set.size();
    }

    private static void spreadPositions(Vec2F vec2f, double d0, WorldServer worldserver, RandomSource randomsource, double d1, double d2, double d3, double d4, int i2, a[] acommandspreadplayers_a, boolean flag) throws CommandSyntaxException {
        int j2;
        boolean flag1 = true;
        double d5 = 3.4028234663852886E38;
        for (j2 = 0; j2 < 10000 && flag1; ++j2) {
            a commandspreadplayers_a;
            int k2;
            flag1 = false;
            d5 = 3.4028234663852886E38;
            for (int l2 = 0; l2 < acommandspreadplayers_a.length; ++l2) {
                a commandspreadplayers_a1 = acommandspreadplayers_a[l2];
                k2 = 0;
                commandspreadplayers_a = new a();
                for (int i1 = 0; i1 < acommandspreadplayers_a.length; ++i1) {
                    if (l2 == i1) continue;
                    a commandspreadplayers_a2 = acommandspreadplayers_a[i1];
                    double d6 = commandspreadplayers_a1.dist(commandspreadplayers_a2);
                    d5 = Math.min(d6, d5);
                    if (!(d6 < d0)) continue;
                    ++k2;
                    commandspreadplayers_a.x += commandspreadplayers_a2.x - commandspreadplayers_a1.x;
                    commandspreadplayers_a.z += commandspreadplayers_a2.z - commandspreadplayers_a1.z;
                }
                if (k2 > 0) {
                    commandspreadplayers_a.x /= (double)k2;
                    commandspreadplayers_a.z /= (double)k2;
                    double d7 = commandspreadplayers_a.getLength();
                    if (d7 > 0.0) {
                        commandspreadplayers_a.normalize();
                        commandspreadplayers_a1.moveAway(commandspreadplayers_a);
                    } else {
                        commandspreadplayers_a1.randomize(randomsource, d1, d2, d3, d4);
                    }
                    flag1 = true;
                }
                if (!commandspreadplayers_a1.clamp(d1, d2, d3, d4)) continue;
                flag1 = true;
            }
            if (flag1) continue;
            a[] acommandspreadplayers_a1 = acommandspreadplayers_a;
            int j1 = acommandspreadplayers_a.length;
            for (k2 = 0; k2 < j1; ++k2) {
                commandspreadplayers_a = acommandspreadplayers_a1[k2];
                if (commandspreadplayers_a.isSafe(worldserver, i2)) continue;
                commandspreadplayers_a.randomize(randomsource, d1, d2, d3, d4);
                flag1 = true;
            }
        }
        if (d5 == 3.4028234663852886E38) {
            d5 = 0.0;
        }
        if (j2 >= 10000) {
            if (flag) {
                throw ERROR_FAILED_TO_SPREAD_TEAMS.create((Object)acommandspreadplayers_a.length, (Object)Float.valueOf(vec2f.x), (Object)Float.valueOf(vec2f.y), (Object)String.format(Locale.ROOT, "%.2f", d5));
            }
            throw ERROR_FAILED_TO_SPREAD_ENTITIES.create((Object)acommandspreadplayers_a.length, (Object)Float.valueOf(vec2f.x), (Object)Float.valueOf(vec2f.y), (Object)String.format(Locale.ROOT, "%.2f", d5));
        }
    }

    private static double setPlayerPositions(Collection<? extends Entity> collection, WorldServer worldserver, a[] acommandspreadplayers_a, int i2, boolean flag) {
        double d0 = 0.0;
        int j2 = 0;
        HashMap map = Maps.newHashMap();
        for (Entity entity : collection) {
            a commandspreadplayers_a;
            if (flag) {
                ScoreboardTeam scoreboardteam;
                ScoreboardTeam scoreboardTeam = scoreboardteam = entity instanceof EntityHuman ? entity.getTeam() : null;
                if (!map.containsKey(scoreboardteam)) {
                    map.put(scoreboardteam, acommandspreadplayers_a[j2++]);
                }
                commandspreadplayers_a = (a)map.get(scoreboardteam);
            } else {
                commandspreadplayers_a = acommandspreadplayers_a[j2++];
            }
            entity.teleportTo(worldserver, (double)MathHelper.floor(commandspreadplayers_a.x) + 0.5, commandspreadplayers_a.getSpawnY(worldserver, i2), (double)MathHelper.floor(commandspreadplayers_a.z) + 0.5, Set.of(), entity.getYRot(), entity.getXRot(), PlayerTeleportEvent.TeleportCause.COMMAND);
            double d1 = Double.MAX_VALUE;
            a[] acommandspreadplayers_a1 = acommandspreadplayers_a;
            int k2 = acommandspreadplayers_a.length;
            for (int l2 = 0; l2 < k2; ++l2) {
                a commandspreadplayers_a1 = acommandspreadplayers_a1[l2];
                if (commandspreadplayers_a == commandspreadplayers_a1) continue;
                double d2 = commandspreadplayers_a.dist(commandspreadplayers_a1);
                d1 = Math.min(d2, d1);
            }
            d0 += d1;
        }
        if (collection.size() < 2) {
            return 0.0;
        }
        return d0 /= (double)collection.size();
    }

    private static a[] createInitialPositions(RandomSource randomsource, int i2, double d0, double d1, double d2, double d3) {
        a[] acommandspreadplayers_a = new a[i2];
        for (int j2 = 0; j2 < acommandspreadplayers_a.length; ++j2) {
            a commandspreadplayers_a = new a();
            commandspreadplayers_a.randomize(randomsource, d0, d1, d2, d3);
            acommandspreadplayers_a[j2] = commandspreadplayers_a;
        }
        return acommandspreadplayers_a;
    }

    private static class a {
        double x;
        double z;

        a() {
        }

        double dist(a commandspreadplayers_a) {
            double d0 = this.x - commandspreadplayers_a.x;
            double d1 = this.z - commandspreadplayers_a.z;
            return Math.sqrt(d0 * d0 + d1 * d1);
        }

        void normalize() {
            double d0 = this.getLength();
            this.x /= d0;
            this.z /= d0;
        }

        double getLength() {
            return Math.sqrt(this.x * this.x + this.z * this.z);
        }

        public void moveAway(a commandspreadplayers_a) {
            this.x -= commandspreadplayers_a.x;
            this.z -= commandspreadplayers_a.z;
        }

        public boolean clamp(double d0, double d1, double d2, double d3) {
            boolean flag = false;
            if (this.x < d0) {
                this.x = d0;
                flag = true;
            } else if (this.x > d2) {
                this.x = d2;
                flag = true;
            }
            if (this.z < d1) {
                this.z = d1;
                flag = true;
            } else if (this.z > d3) {
                this.z = d3;
                flag = true;
            }
            return flag;
        }

        public int getSpawnY(IBlockAccess iblockaccess, int i2) {
            BlockPosition.MutableBlockPosition blockposition_mutableblockposition = new BlockPosition.MutableBlockPosition(this.x, (double)(i2 + 1), this.z);
            boolean flag = iblockaccess.getBlockState(blockposition_mutableblockposition).isAir();
            blockposition_mutableblockposition.move(EnumDirection.DOWN);
            boolean flag2 = iblockaccess.getBlockState(blockposition_mutableblockposition).isAir();
            while (blockposition_mutableblockposition.getY() > iblockaccess.getMinBuildHeight()) {
                blockposition_mutableblockposition.move(EnumDirection.DOWN);
                boolean flag1 = iblockaccess.getBlockState(blockposition_mutableblockposition).isAir();
                if (!flag1 && flag2 && flag) {
                    return blockposition_mutableblockposition.getY() + 1;
                }
                flag = flag2;
                flag2 = flag1;
            }
            return i2 + 1;
        }

        public boolean isSafe(IBlockAccess iblockaccess, int i2) {
            BlockPosition blockposition = BlockPosition.containing(this.x, this.getSpawnY(iblockaccess, i2) - 1, this.z);
            IBlockData iblockdata = iblockaccess.getBlockState(blockposition);
            return blockposition.getY() < i2 && !iblockdata.liquid() && !iblockdata.is(TagsBlock.FIRE);
        }

        public void randomize(RandomSource randomsource, double d0, double d1, double d2, double d3) {
            this.x = MathHelper.nextDouble(randomsource, d0, d2);
            this.z = MathHelper.nextDouble(randomsource, d1, d3);
        }
    }
}

