/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.brigadier.tree.LiteralCommandNode;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Locale;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.commands.CommandListenerWrapper;
import net.minecraft.commands.arguments.ArgumentAnchor;
import net.minecraft.commands.arguments.ArgumentEntity;
import net.minecraft.commands.arguments.coordinates.ArgumentRotation;
import net.minecraft.commands.arguments.coordinates.ArgumentVec3;
import net.minecraft.commands.arguments.coordinates.IVectorPosition;
import net.minecraft.commands.arguments.coordinates.VectorPosition;
import net.minecraft.core.BlockPosition;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.util.MathHelper;
import net.minecraft.world.entity.EntityCreature;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.RelativeMovement;
import net.minecraft.world.level.World;
import net.minecraft.world.phys.Vec2F;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.Location;
import org.bukkit.craftbukkit.v1_21_R1.CraftWorld;
import org.bukkit.entity.Entity;
import org.bukkit.event.Event;
import org.bukkit.event.entity.EntityTeleportEvent;
import org.bukkit.event.player.PlayerTeleportEvent;

public class CommandTeleport {
    private static final SimpleCommandExceptionType INVALID_POSITION = new SimpleCommandExceptionType((Message)IChatBaseComponent.translatable("commands.teleport.invalidPosition"));

    public static void register(CommandDispatcher<CommandListenerWrapper> commanddispatcher) {
        LiteralCommandNode<CommandListenerWrapper> literalcommandnode = commanddispatcher.register((LiteralArgumentBuilder<CommandListenerWrapper>)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)net.minecraft.commands.CommandDispatcher.literal("teleport").requires(commandlistenerwrapper -> commandlistenerwrapper.hasPermission(2))).then(net.minecraft.commands.CommandDispatcher.argument("location", ArgumentVec3.vec3()).executes(commandcontext -> CommandTeleport.teleportToPos((CommandListenerWrapper)commandcontext.getSource(), Collections.singleton(((CommandListenerWrapper)commandcontext.getSource()).getEntityOrException()), ((CommandListenerWrapper)commandcontext.getSource()).getLevel(), ArgumentVec3.getCoordinates((CommandContext<CommandListenerWrapper>)commandcontext, "location"), VectorPosition.current(), null)))).then(net.minecraft.commands.CommandDispatcher.argument("destination", ArgumentEntity.entity()).executes(commandcontext -> CommandTeleport.teleportToEntity((CommandListenerWrapper)commandcontext.getSource(), Collections.singleton(((CommandListenerWrapper)commandcontext.getSource()).getEntityOrException()), ArgumentEntity.getEntity((CommandContext<CommandListenerWrapper>)commandcontext, "destination"))))).then(((RequiredArgumentBuilder)net.minecraft.commands.CommandDispatcher.argument("targets", ArgumentEntity.entities()).then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)net.minecraft.commands.CommandDispatcher.argument("location", ArgumentVec3.vec3()).executes(commandcontext -> CommandTeleport.teleportToPos((CommandListenerWrapper)commandcontext.getSource(), ArgumentEntity.getEntities((CommandContext<CommandListenerWrapper>)commandcontext, "targets"), ((CommandListenerWrapper)commandcontext.getSource()).getLevel(), ArgumentVec3.getCoordinates((CommandContext<CommandListenerWrapper>)commandcontext, "location"), null, null))).then(net.minecraft.commands.CommandDispatcher.argument("rotation", ArgumentRotation.rotation()).executes(commandcontext -> CommandTeleport.teleportToPos((CommandListenerWrapper)commandcontext.getSource(), ArgumentEntity.getEntities((CommandContext<CommandListenerWrapper>)commandcontext, "targets"), ((CommandListenerWrapper)commandcontext.getSource()).getLevel(), ArgumentVec3.getCoordinates((CommandContext<CommandListenerWrapper>)commandcontext, "location"), ArgumentRotation.getRotation((CommandContext<CommandListenerWrapper>)commandcontext, "rotation"), null)))).then(((LiteralArgumentBuilder)net.minecraft.commands.CommandDispatcher.literal("facing").then(net.minecraft.commands.CommandDispatcher.literal("entity").then(((RequiredArgumentBuilder)net.minecraft.commands.CommandDispatcher.argument("facingEntity", ArgumentEntity.entity()).executes(commandcontext -> CommandTeleport.teleportToPos((CommandListenerWrapper)commandcontext.getSource(), ArgumentEntity.getEntities((CommandContext<CommandListenerWrapper>)commandcontext, "targets"), ((CommandListenerWrapper)commandcontext.getSource()).getLevel(), ArgumentVec3.getCoordinates((CommandContext<CommandListenerWrapper>)commandcontext, "location"), null, new b(ArgumentEntity.getEntity((CommandContext<CommandListenerWrapper>)commandcontext, "facingEntity"), ArgumentAnchor.Anchor.FEET)))).then(net.minecraft.commands.CommandDispatcher.argument("facingAnchor", ArgumentAnchor.anchor()).executes(commandcontext -> CommandTeleport.teleportToPos((CommandListenerWrapper)commandcontext.getSource(), ArgumentEntity.getEntities((CommandContext<CommandListenerWrapper>)commandcontext, "targets"), ((CommandListenerWrapper)commandcontext.getSource()).getLevel(), ArgumentVec3.getCoordinates((CommandContext<CommandListenerWrapper>)commandcontext, "location"), null, new b(ArgumentEntity.getEntity((CommandContext<CommandListenerWrapper>)commandcontext, "facingEntity"), ArgumentAnchor.getAnchor((CommandContext<CommandListenerWrapper>)commandcontext, "facingAnchor")))))))).then(net.minecraft.commands.CommandDispatcher.argument("facingLocation", ArgumentVec3.vec3()).executes(commandcontext -> CommandTeleport.teleportToPos((CommandListenerWrapper)commandcontext.getSource(), ArgumentEntity.getEntities((CommandContext<CommandListenerWrapper>)commandcontext, "targets"), ((CommandListenerWrapper)commandcontext.getSource()).getLevel(), ArgumentVec3.getCoordinates((CommandContext<CommandListenerWrapper>)commandcontext, "location"), null, new c(ArgumentVec3.getVec3((CommandContext<CommandListenerWrapper>)commandcontext, "facingLocation")))))))).then(net.minecraft.commands.CommandDispatcher.argument("destination", ArgumentEntity.entity()).executes(commandcontext -> CommandTeleport.teleportToEntity((CommandListenerWrapper)commandcontext.getSource(), ArgumentEntity.getEntities((CommandContext<CommandListenerWrapper>)commandcontext, "targets"), ArgumentEntity.getEntity((CommandContext<CommandListenerWrapper>)commandcontext, "destination")))))));
        commanddispatcher.register((LiteralArgumentBuilder<CommandListenerWrapper>)((LiteralArgumentBuilder)((LiteralArgumentBuilder)net.minecraft.commands.CommandDispatcher.literal("tp").requires(commandlistenerwrapper -> commandlistenerwrapper.hasPermission(2))).redirect(literalcommandnode)));
    }

    private static int teleportToEntity(CommandListenerWrapper commandlistenerwrapper, Collection<? extends net.minecraft.world.entity.Entity> collection, net.minecraft.world.entity.Entity entity) throws CommandSyntaxException {
        for (net.minecraft.world.entity.Entity entity2 : collection) {
            CommandTeleport.performTeleport(commandlistenerwrapper, entity2, (WorldServer)entity.level(), entity.getX(), entity.getY(), entity.getZ(), EnumSet.noneOf(RelativeMovement.class), entity.getYRot(), entity.getXRot(), null);
        }
        if (collection.size() == 1) {
            commandlistenerwrapper.sendSuccess(() -> IChatBaseComponent.translatable("commands.teleport.success.entity.single", ((net.minecraft.world.entity.Entity)collection.iterator().next()).getDisplayName(), entity.getDisplayName()), true);
        } else {
            commandlistenerwrapper.sendSuccess(() -> IChatBaseComponent.translatable("commands.teleport.success.entity.multiple", collection.size(), entity.getDisplayName()), true);
        }
        return collection.size();
    }

    private static int teleportToPos(CommandListenerWrapper commandlistenerwrapper, Collection<? extends net.minecraft.world.entity.Entity> collection, WorldServer worldserver, IVectorPosition ivectorposition, @Nullable IVectorPosition ivectorposition1, @Nullable a commandteleport_a) throws CommandSyntaxException {
        Vec3D vec3d = ivectorposition.getPosition(commandlistenerwrapper);
        Vec2F vec2f = ivectorposition1 == null ? null : ivectorposition1.getRotation(commandlistenerwrapper);
        EnumSet<RelativeMovement> set = EnumSet.noneOf(RelativeMovement.class);
        if (ivectorposition.isXRelative()) {
            set.add(RelativeMovement.X);
        }
        if (ivectorposition.isYRelative()) {
            set.add(RelativeMovement.Y);
        }
        if (ivectorposition.isZRelative()) {
            set.add(RelativeMovement.Z);
        }
        if (ivectorposition1 == null) {
            set.add(RelativeMovement.X_ROT);
            set.add(RelativeMovement.Y_ROT);
        } else {
            if (ivectorposition1.isXRelative()) {
                set.add(RelativeMovement.X_ROT);
            }
            if (ivectorposition1.isYRelative()) {
                set.add(RelativeMovement.Y_ROT);
            }
        }
        for (net.minecraft.world.entity.Entity entity : collection) {
            if (ivectorposition1 == null) {
                CommandTeleport.performTeleport(commandlistenerwrapper, entity, worldserver, vec3d.x, vec3d.y, vec3d.z, set, entity.getYRot(), entity.getXRot(), commandteleport_a);
                continue;
            }
            CommandTeleport.performTeleport(commandlistenerwrapper, entity, worldserver, vec3d.x, vec3d.y, vec3d.z, set, vec2f.y, vec2f.x, commandteleport_a);
        }
        if (collection.size() == 1) {
            commandlistenerwrapper.sendSuccess(() -> IChatBaseComponent.translatable("commands.teleport.success.location.single", ((net.minecraft.world.entity.Entity)collection.iterator().next()).getDisplayName(), CommandTeleport.formatDouble(vec3d.x), CommandTeleport.formatDouble(vec3d.y), CommandTeleport.formatDouble(vec3d.z)), true);
        } else {
            commandlistenerwrapper.sendSuccess(() -> IChatBaseComponent.translatable("commands.teleport.success.location.multiple", collection.size(), CommandTeleport.formatDouble(vec3d.x), CommandTeleport.formatDouble(vec3d.y), CommandTeleport.formatDouble(vec3d.z)), true);
        }
        return collection.size();
    }

    private static String formatDouble(double d0) {
        return String.format(Locale.ROOT, "%f", d0);
    }

    private static void performTeleport(CommandListenerWrapper commandlistenerwrapper, net.minecraft.world.entity.Entity entity, WorldServer worldserver, double d0, double d1, double d2, Set<RelativeMovement> set, float f2, float f1, @Nullable a commandteleport_a) throws CommandSyntaxException {
        boolean result;
        BlockPosition blockposition = BlockPosition.containing(d0, d1, d2);
        if (!World.isInSpawnableBounds(blockposition)) {
            throw INVALID_POSITION.create();
        }
        float f22 = MathHelper.wrapDegrees(f2);
        float f3 = MathHelper.wrapDegrees(f1);
        if (entity instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)entity;
            result = player.teleportTo(worldserver, d0, d1, d2, set, f22, f3, PlayerTeleportEvent.TeleportCause.COMMAND);
        } else {
            Location to = new Location((org.bukkit.World)worldserver.getWorld(), d0, d1, d2, f22, f3);
            EntityTeleportEvent event = new EntityTeleportEvent((Entity)entity.getBukkitEntity(), entity.getBukkitEntity().getLocation(), to);
            worldserver.getCraftServer().getPluginManager().callEvent((Event)event);
            if (event.isCancelled()) {
                return;
            }
            d0 = to.getX();
            d1 = to.getY();
            d2 = to.getZ();
            f22 = to.getYaw();
            f3 = to.getPitch();
            worldserver = ((CraftWorld)to.getWorld()).getHandle();
            result = entity.teleportTo(worldserver, d0, d1, d2, set, f22, f3);
        }
        if (result) {
            EntityLiving entityliving;
            if (commandteleport_a != null) {
                commandteleport_a.perform(commandlistenerwrapper, entity);
            }
            if (!(entity instanceof EntityLiving) || !(entityliving = (EntityLiving)entity).isFallFlying()) {
                entity.setDeltaMovement(entity.getDeltaMovement().multiply(1.0, 0.0, 1.0));
                entity.setOnGround(true);
            }
            if (entity instanceof EntityCreature) {
                EntityCreature entitycreature = (EntityCreature)entity;
                entitycreature.getNavigation().stop();
            }
        }
    }

    @FunctionalInterface
    private static interface a {
        public void perform(CommandListenerWrapper var1, net.minecraft.world.entity.Entity var2);
    }

    private record c(Vec3D position) implements a
    {
        @Override
        public void perform(CommandListenerWrapper commandlistenerwrapper, net.minecraft.world.entity.Entity entity) {
            entity.lookAt(commandlistenerwrapper.getAnchor(), this.position);
        }
    }

    private record b(net.minecraft.world.entity.Entity entity, ArgumentAnchor.Anchor anchor) implements a
    {
        @Override
        public void perform(CommandListenerWrapper commandlistenerwrapper, net.minecraft.world.entity.Entity entity) {
            if (entity instanceof EntityPlayer) {
                EntityPlayer entityplayer = (EntityPlayer)entity;
                entityplayer.lookAt(commandlistenerwrapper.getAnchor(), this.entity, this.anchor);
            } else {
                entity.lookAt(commandlistenerwrapper.getAnchor(), this.anchor.apply(this.entity));
            }
        }
    }
}

