/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.commands;

import com.google.common.collect.Iterators;
import com.google.common.collect.UnmodifiableIterator;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import net.minecraft.commands.CommandListenerWrapper;
import net.minecraft.commands.arguments.ArgumentTime;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.server.level.WorldServer;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.bukkit.event.Event;
import org.bukkit.event.world.TimeSkipEvent;

public class CommandTime {
    public static void register(CommandDispatcher<CommandListenerWrapper> commanddispatcher) {
        commanddispatcher.register((LiteralArgumentBuilder<CommandListenerWrapper>)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)net.minecraft.commands.CommandDispatcher.literal("time").requires(commandlistenerwrapper -> commandlistenerwrapper.hasPermission(2))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)net.minecraft.commands.CommandDispatcher.literal("set").then(net.minecraft.commands.CommandDispatcher.literal("day").executes(commandcontext -> CommandTime.setTime((CommandListenerWrapper)commandcontext.getSource(), 1000)))).then(net.minecraft.commands.CommandDispatcher.literal("noon").executes(commandcontext -> CommandTime.setTime((CommandListenerWrapper)commandcontext.getSource(), 6000)))).then(net.minecraft.commands.CommandDispatcher.literal("night").executes(commandcontext -> CommandTime.setTime((CommandListenerWrapper)commandcontext.getSource(), 13000)))).then(net.minecraft.commands.CommandDispatcher.literal("midnight").executes(commandcontext -> CommandTime.setTime((CommandListenerWrapper)commandcontext.getSource(), 18000)))).then(net.minecraft.commands.CommandDispatcher.argument("time", ArgumentTime.time()).executes(commandcontext -> CommandTime.setTime((CommandListenerWrapper)commandcontext.getSource(), IntegerArgumentType.getInteger((CommandContext)commandcontext, (String)"time")))))).then(net.minecraft.commands.CommandDispatcher.literal("add").then(net.minecraft.commands.CommandDispatcher.argument("time", ArgumentTime.time()).executes(commandcontext -> CommandTime.addTime((CommandListenerWrapper)commandcontext.getSource(), IntegerArgumentType.getInteger((CommandContext)commandcontext, (String)"time")))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)net.minecraft.commands.CommandDispatcher.literal("query").then(net.minecraft.commands.CommandDispatcher.literal("daytime").executes(commandcontext -> CommandTime.queryTime((CommandListenerWrapper)commandcontext.getSource(), CommandTime.getDayTime(((CommandListenerWrapper)commandcontext.getSource()).getLevel()))))).then(net.minecraft.commands.CommandDispatcher.literal("gametime").executes(commandcontext -> CommandTime.queryTime((CommandListenerWrapper)commandcontext.getSource(), (int)(((CommandListenerWrapper)commandcontext.getSource()).getLevel().getGameTime() % Integer.MAX_VALUE))))).then(net.minecraft.commands.CommandDispatcher.literal("day").executes(commandcontext -> CommandTime.queryTime((CommandListenerWrapper)commandcontext.getSource(), (int)(((CommandListenerWrapper)commandcontext.getSource()).getLevel().getDayTime() / 24000L % Integer.MAX_VALUE)))))));
    }

    private static int getDayTime(WorldServer worldserver) {
        return (int)(worldserver.getDayTime() % 24000L);
    }

    private static int queryTime(CommandListenerWrapper commandlistenerwrapper, int i2) {
        commandlistenerwrapper.sendSuccess(() -> IChatBaseComponent.translatable("commands.time.query", i2), false);
        return i2;
    }

    public static int setTime(CommandListenerWrapper commandlistenerwrapper, int i2) {
        UnmodifiableIterator iterator = Iterators.singletonIterator((Object)commandlistenerwrapper.getLevel());
        while (iterator.hasNext()) {
            WorldServer worldserver = (WorldServer)iterator.next();
            TimeSkipEvent event = new TimeSkipEvent((World)worldserver.getWorld(), TimeSkipEvent.SkipReason.COMMAND, (long)i2 - worldserver.getDayTime());
            Bukkit.getPluginManager().callEvent((Event)event);
            if (event.isCancelled()) continue;
            worldserver.setDayTime(worldserver.getDayTime() + event.getSkipAmount());
        }
        commandlistenerwrapper.sendSuccess(() -> IChatBaseComponent.translatable("commands.time.set", i2), true);
        return CommandTime.getDayTime(commandlistenerwrapper.getLevel());
    }

    public static int addTime(CommandListenerWrapper commandlistenerwrapper, int i2) {
        UnmodifiableIterator iterator = Iterators.singletonIterator((Object)commandlistenerwrapper.getLevel());
        while (iterator.hasNext()) {
            WorldServer worldserver = (WorldServer)iterator.next();
            TimeSkipEvent event = new TimeSkipEvent((World)worldserver.getWorld(), TimeSkipEvent.SkipReason.COMMAND, (long)i2);
            Bukkit.getPluginManager().callEvent((Event)event);
            if (event.isCancelled()) continue;
            worldserver.setDayTime(worldserver.getDayTime() + event.getSkipAmount());
        }
        int j2 = CommandTime.getDayTime(commandlistenerwrapper.getLevel());
        commandlistenerwrapper.sendSuccess(() -> IChatBaseComponent.translatable("commands.time.set", j2), true);
        return j2;
    }
}

