/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.Collection;
import java.util.function.Function;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandListenerWrapper;
import net.minecraft.commands.arguments.ArgumentChatComponent;
import net.minecraft.commands.arguments.ArgumentEntity;
import net.minecraft.commands.arguments.ArgumentTime;
import net.minecraft.network.chat.ChatComponentUtils;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundClearTitlesPacket;
import net.minecraft.network.protocol.game.ClientboundSetActionBarTextPacket;
import net.minecraft.network.protocol.game.ClientboundSetSubtitleTextPacket;
import net.minecraft.network.protocol.game.ClientboundSetTitleTextPacket;
import net.minecraft.network.protocol.game.ClientboundSetTitlesAnimationPacket;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.world.entity.Entity;

public class CommandTitle {
    public static void register(CommandDispatcher<CommandListenerWrapper> var02, CommandBuildContext var1) {
        var02.register((LiteralArgumentBuilder<CommandListenerWrapper>)((LiteralArgumentBuilder)((LiteralArgumentBuilder)net.minecraft.commands.CommandDispatcher.literal("title").requires(var0 -> var0.hasPermission(2))).then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)net.minecraft.commands.CommandDispatcher.argument("targets", ArgumentEntity.players()).then(net.minecraft.commands.CommandDispatcher.literal("clear").executes(var0 -> CommandTitle.clearTitle((CommandListenerWrapper)var0.getSource(), ArgumentEntity.getPlayers((CommandContext<CommandListenerWrapper>)var0, "targets"))))).then(net.minecraft.commands.CommandDispatcher.literal("reset").executes(var0 -> CommandTitle.resetTitle((CommandListenerWrapper)var0.getSource(), ArgumentEntity.getPlayers((CommandContext<CommandListenerWrapper>)var0, "targets"))))).then(net.minecraft.commands.CommandDispatcher.literal("title").then(net.minecraft.commands.CommandDispatcher.argument("title", ArgumentChatComponent.textComponent(var1)).executes(var0 -> CommandTitle.showTitle((CommandListenerWrapper)var0.getSource(), ArgumentEntity.getPlayers((CommandContext<CommandListenerWrapper>)var0, "targets"), ArgumentChatComponent.getComponent((CommandContext<CommandListenerWrapper>)var0, "title"), "title", ClientboundSetTitleTextPacket::new))))).then(net.minecraft.commands.CommandDispatcher.literal("subtitle").then(net.minecraft.commands.CommandDispatcher.argument("title", ArgumentChatComponent.textComponent(var1)).executes(var0 -> CommandTitle.showTitle((CommandListenerWrapper)var0.getSource(), ArgumentEntity.getPlayers((CommandContext<CommandListenerWrapper>)var0, "targets"), ArgumentChatComponent.getComponent((CommandContext<CommandListenerWrapper>)var0, "title"), "subtitle", ClientboundSetSubtitleTextPacket::new))))).then(net.minecraft.commands.CommandDispatcher.literal("actionbar").then(net.minecraft.commands.CommandDispatcher.argument("title", ArgumentChatComponent.textComponent(var1)).executes(var0 -> CommandTitle.showTitle((CommandListenerWrapper)var0.getSource(), ArgumentEntity.getPlayers((CommandContext<CommandListenerWrapper>)var0, "targets"), ArgumentChatComponent.getComponent((CommandContext<CommandListenerWrapper>)var0, "title"), "actionbar", ClientboundSetActionBarTextPacket::new))))).then(net.minecraft.commands.CommandDispatcher.literal("times").then(net.minecraft.commands.CommandDispatcher.argument("fadeIn", ArgumentTime.time()).then(net.minecraft.commands.CommandDispatcher.argument("stay", ArgumentTime.time()).then(net.minecraft.commands.CommandDispatcher.argument("fadeOut", ArgumentTime.time()).executes(var0 -> CommandTitle.setTimes((CommandListenerWrapper)var0.getSource(), ArgumentEntity.getPlayers((CommandContext<CommandListenerWrapper>)var0, "targets"), IntegerArgumentType.getInteger((CommandContext)var0, (String)"fadeIn"), IntegerArgumentType.getInteger((CommandContext)var0, (String)"stay"), IntegerArgumentType.getInteger((CommandContext)var0, (String)"fadeOut"))))))))));
    }

    private static int clearTitle(CommandListenerWrapper var0, Collection<EntityPlayer> var1) {
        ClientboundClearTitlesPacket var2 = new ClientboundClearTitlesPacket(false);
        for (EntityPlayer var4 : var1) {
            var4.connection.send(var2);
        }
        if (var1.size() == 1) {
            var0.sendSuccess(() -> IChatBaseComponent.translatable("commands.title.cleared.single", ((EntityPlayer)var1.iterator().next()).getDisplayName()), true);
        } else {
            var0.sendSuccess(() -> IChatBaseComponent.translatable("commands.title.cleared.multiple", var1.size()), true);
        }
        return var1.size();
    }

    private static int resetTitle(CommandListenerWrapper var0, Collection<EntityPlayer> var1) {
        ClientboundClearTitlesPacket var2 = new ClientboundClearTitlesPacket(true);
        for (EntityPlayer var4 : var1) {
            var4.connection.send(var2);
        }
        if (var1.size() == 1) {
            var0.sendSuccess(() -> IChatBaseComponent.translatable("commands.title.reset.single", ((EntityPlayer)var1.iterator().next()).getDisplayName()), true);
        } else {
            var0.sendSuccess(() -> IChatBaseComponent.translatable("commands.title.reset.multiple", var1.size()), true);
        }
        return var1.size();
    }

    private static int showTitle(CommandListenerWrapper var0, Collection<EntityPlayer> var1, IChatBaseComponent var2, String var3, Function<IChatBaseComponent, Packet<?>> var4) throws CommandSyntaxException {
        for (EntityPlayer var6 : var1) {
            var6.connection.send(var4.apply(ChatComponentUtils.updateForEntity(var0, var2, (Entity)var6, 0)));
        }
        if (var1.size() == 1) {
            var0.sendSuccess(() -> IChatBaseComponent.translatable("commands.title.show." + var3 + ".single", ((EntityPlayer)var1.iterator().next()).getDisplayName()), true);
        } else {
            var0.sendSuccess(() -> IChatBaseComponent.translatable("commands.title.show." + var3 + ".multiple", var1.size()), true);
        }
        return var1.size();
    }

    private static int setTimes(CommandListenerWrapper var0, Collection<EntityPlayer> var1, int var2, int var3, int var4) {
        ClientboundSetTitlesAnimationPacket var5 = new ClientboundSetTitlesAnimationPacket(var2, var3, var4);
        for (EntityPlayer var7 : var1) {
            var7.connection.send(var5);
        }
        if (var1.size() == 1) {
            var0.sendSuccess(() -> IChatBaseComponent.translatable("commands.title.times.single", ((EntityPlayer)var1.iterator().next()).getDisplayName()), true);
        } else {
            var0.sendSuccess(() -> IChatBaseComponent.translatable("commands.title.times.multiple", var1.size()), true);
        }
        return var1.size();
    }
}

