/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import net.minecraft.commands.CommandListenerWrapper;
import net.minecraft.commands.arguments.ArgumentTime;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.server.level.WorldServer;
import net.minecraft.util.valueproviders.IntProvider;

public class CommandWeather {
    private static final int DEFAULT_TIME = -1;

    public static void register(CommandDispatcher<CommandListenerWrapper> commanddispatcher) {
        commanddispatcher.register((LiteralArgumentBuilder<CommandListenerWrapper>)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)net.minecraft.commands.CommandDispatcher.literal("weather").requires(commandlistenerwrapper -> commandlistenerwrapper.hasPermission(2))).then(((LiteralArgumentBuilder)net.minecraft.commands.CommandDispatcher.literal("clear").executes(commandcontext -> CommandWeather.setClear((CommandListenerWrapper)commandcontext.getSource(), -1))).then(net.minecraft.commands.CommandDispatcher.argument("duration", ArgumentTime.time(1)).executes(commandcontext -> CommandWeather.setClear((CommandListenerWrapper)commandcontext.getSource(), IntegerArgumentType.getInteger((CommandContext)commandcontext, (String)"duration")))))).then(((LiteralArgumentBuilder)net.minecraft.commands.CommandDispatcher.literal("rain").executes(commandcontext -> CommandWeather.setRain((CommandListenerWrapper)commandcontext.getSource(), -1))).then(net.minecraft.commands.CommandDispatcher.argument("duration", ArgumentTime.time(1)).executes(commandcontext -> CommandWeather.setRain((CommandListenerWrapper)commandcontext.getSource(), IntegerArgumentType.getInteger((CommandContext)commandcontext, (String)"duration")))))).then(((LiteralArgumentBuilder)net.minecraft.commands.CommandDispatcher.literal("thunder").executes(commandcontext -> CommandWeather.setThunder((CommandListenerWrapper)commandcontext.getSource(), -1))).then(net.minecraft.commands.CommandDispatcher.argument("duration", ArgumentTime.time(1)).executes(commandcontext -> CommandWeather.setThunder((CommandListenerWrapper)commandcontext.getSource(), IntegerArgumentType.getInteger((CommandContext)commandcontext, (String)"duration")))))));
    }

    private static int getDuration(CommandListenerWrapper commandlistenerwrapper, int i2, IntProvider intprovider) {
        return i2 == -1 ? intprovider.sample(commandlistenerwrapper.getLevel().getRandom()) : i2;
    }

    private static int setClear(CommandListenerWrapper commandlistenerwrapper, int i2) {
        commandlistenerwrapper.getLevel().setWeatherParameters(CommandWeather.getDuration(commandlistenerwrapper, i2, WorldServer.RAIN_DELAY), 0, false, false);
        commandlistenerwrapper.sendSuccess(() -> IChatBaseComponent.translatable("commands.weather.set.clear"), true);
        return i2;
    }

    private static int setRain(CommandListenerWrapper commandlistenerwrapper, int i2) {
        commandlistenerwrapper.getLevel().setWeatherParameters(0, CommandWeather.getDuration(commandlistenerwrapper, i2, WorldServer.RAIN_DURATION), true, false);
        commandlistenerwrapper.sendSuccess(() -> IChatBaseComponent.translatable("commands.weather.set.rain"), true);
        return i2;
    }

    private static int setThunder(CommandListenerWrapper commandlistenerwrapper, int i2) {
        commandlistenerwrapper.getLevel().setWeatherParameters(0, CommandWeather.getDuration(commandlistenerwrapper, i2, WorldServer.THUNDER_DURATION), true, true);
        commandlistenerwrapper.sendSuccess(() -> IChatBaseComponent.translatable("commands.weather.set.thunder"), true);
        return i2;
    }
}

