/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.DoubleArgumentType;
import com.mojang.brigadier.arguments.FloatArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import java.util.Locale;
import net.minecraft.commands.CommandListenerWrapper;
import net.minecraft.commands.arguments.coordinates.ArgumentVec2;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.util.MathHelper;
import net.minecraft.world.level.border.WorldBorder;
import net.minecraft.world.phys.Vec2F;

public class CommandWorldBorder {
    private static final SimpleCommandExceptionType ERROR_SAME_CENTER = new SimpleCommandExceptionType((Message)IChatBaseComponent.translatable("commands.worldborder.center.failed"));
    private static final SimpleCommandExceptionType ERROR_SAME_SIZE = new SimpleCommandExceptionType((Message)IChatBaseComponent.translatable("commands.worldborder.set.failed.nochange"));
    private static final SimpleCommandExceptionType ERROR_TOO_SMALL = new SimpleCommandExceptionType((Message)IChatBaseComponent.translatable("commands.worldborder.set.failed.small"));
    private static final SimpleCommandExceptionType ERROR_TOO_BIG = new SimpleCommandExceptionType((Message)IChatBaseComponent.translatable("commands.worldborder.set.failed.big", 5.9999968E7));
    private static final SimpleCommandExceptionType ERROR_TOO_FAR_OUT = new SimpleCommandExceptionType((Message)IChatBaseComponent.translatable("commands.worldborder.set.failed.far", 2.9999984E7));
    private static final SimpleCommandExceptionType ERROR_SAME_WARNING_TIME = new SimpleCommandExceptionType((Message)IChatBaseComponent.translatable("commands.worldborder.warning.time.failed"));
    private static final SimpleCommandExceptionType ERROR_SAME_WARNING_DISTANCE = new SimpleCommandExceptionType((Message)IChatBaseComponent.translatable("commands.worldborder.warning.distance.failed"));
    private static final SimpleCommandExceptionType ERROR_SAME_DAMAGE_BUFFER = new SimpleCommandExceptionType((Message)IChatBaseComponent.translatable("commands.worldborder.damage.buffer.failed"));
    private static final SimpleCommandExceptionType ERROR_SAME_DAMAGE_AMOUNT = new SimpleCommandExceptionType((Message)IChatBaseComponent.translatable("commands.worldborder.damage.amount.failed"));

    public static void register(CommandDispatcher<CommandListenerWrapper> commanddispatcher) {
        commanddispatcher.register((LiteralArgumentBuilder<CommandListenerWrapper>)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)net.minecraft.commands.CommandDispatcher.literal("worldborder").requires(commandlistenerwrapper -> commandlistenerwrapper.hasPermission(2))).then(net.minecraft.commands.CommandDispatcher.literal("add").then(((RequiredArgumentBuilder)net.minecraft.commands.CommandDispatcher.argument("distance", DoubleArgumentType.doubleArg((double)-5.9999968E7, (double)5.9999968E7)).executes(commandcontext -> CommandWorldBorder.setSize((CommandListenerWrapper)commandcontext.getSource(), ((CommandListenerWrapper)commandcontext.getSource()).getLevel().getWorldBorder().getSize() + DoubleArgumentType.getDouble((CommandContext)commandcontext, (String)"distance"), 0L))).then(net.minecraft.commands.CommandDispatcher.argument("time", IntegerArgumentType.integer((int)0)).executes(commandcontext -> CommandWorldBorder.setSize((CommandListenerWrapper)commandcontext.getSource(), ((CommandListenerWrapper)commandcontext.getSource()).getLevel().getWorldBorder().getSize() + DoubleArgumentType.getDouble((CommandContext)commandcontext, (String)"distance"), ((CommandListenerWrapper)commandcontext.getSource()).getLevel().getWorldBorder().getLerpRemainingTime() + (long)IntegerArgumentType.getInteger((CommandContext)commandcontext, (String)"time") * 1000L)))))).then(net.minecraft.commands.CommandDispatcher.literal("set").then(((RequiredArgumentBuilder)net.minecraft.commands.CommandDispatcher.argument("distance", DoubleArgumentType.doubleArg((double)-5.9999968E7, (double)5.9999968E7)).executes(commandcontext -> CommandWorldBorder.setSize((CommandListenerWrapper)commandcontext.getSource(), DoubleArgumentType.getDouble((CommandContext)commandcontext, (String)"distance"), 0L))).then(net.minecraft.commands.CommandDispatcher.argument("time", IntegerArgumentType.integer((int)0)).executes(commandcontext -> CommandWorldBorder.setSize((CommandListenerWrapper)commandcontext.getSource(), DoubleArgumentType.getDouble((CommandContext)commandcontext, (String)"distance"), (long)IntegerArgumentType.getInteger((CommandContext)commandcontext, (String)"time") * 1000L)))))).then(net.minecraft.commands.CommandDispatcher.literal("center").then(net.minecraft.commands.CommandDispatcher.argument("pos", ArgumentVec2.vec2()).executes(commandcontext -> CommandWorldBorder.setCenter((CommandListenerWrapper)commandcontext.getSource(), ArgumentVec2.getVec2((CommandContext<CommandListenerWrapper>)commandcontext, "pos")))))).then(((LiteralArgumentBuilder)net.minecraft.commands.CommandDispatcher.literal("damage").then(net.minecraft.commands.CommandDispatcher.literal("amount").then(net.minecraft.commands.CommandDispatcher.argument("damagePerBlock", FloatArgumentType.floatArg((float)0.0f)).executes(commandcontext -> CommandWorldBorder.setDamageAmount((CommandListenerWrapper)commandcontext.getSource(), FloatArgumentType.getFloat((CommandContext)commandcontext, (String)"damagePerBlock")))))).then(net.minecraft.commands.CommandDispatcher.literal("buffer").then(net.minecraft.commands.CommandDispatcher.argument("distance", FloatArgumentType.floatArg((float)0.0f)).executes(commandcontext -> CommandWorldBorder.setDamageBuffer((CommandListenerWrapper)commandcontext.getSource(), FloatArgumentType.getFloat((CommandContext)commandcontext, (String)"distance"))))))).then(net.minecraft.commands.CommandDispatcher.literal("get").executes(commandcontext -> CommandWorldBorder.getSize((CommandListenerWrapper)commandcontext.getSource())))).then(((LiteralArgumentBuilder)net.minecraft.commands.CommandDispatcher.literal("warning").then(net.minecraft.commands.CommandDispatcher.literal("distance").then(net.minecraft.commands.CommandDispatcher.argument("distance", IntegerArgumentType.integer((int)0)).executes(commandcontext -> CommandWorldBorder.setWarningDistance((CommandListenerWrapper)commandcontext.getSource(), IntegerArgumentType.getInteger((CommandContext)commandcontext, (String)"distance")))))).then(net.minecraft.commands.CommandDispatcher.literal("time").then(net.minecraft.commands.CommandDispatcher.argument("time", IntegerArgumentType.integer((int)0)).executes(commandcontext -> CommandWorldBorder.setWarningTime((CommandListenerWrapper)commandcontext.getSource(), IntegerArgumentType.getInteger((CommandContext)commandcontext, (String)"time"))))))));
    }

    private static int setDamageBuffer(CommandListenerWrapper commandlistenerwrapper, float f2) throws CommandSyntaxException {
        WorldBorder worldborder = commandlistenerwrapper.getLevel().getWorldBorder();
        if (worldborder.getDamageSafeZone() == (double)f2) {
            throw ERROR_SAME_DAMAGE_BUFFER.create();
        }
        worldborder.setDamageSafeZone(f2);
        commandlistenerwrapper.sendSuccess(() -> IChatBaseComponent.translatable("commands.worldborder.damage.buffer.success", String.format(Locale.ROOT, "%.2f", Float.valueOf(f2))), true);
        return (int)f2;
    }

    private static int setDamageAmount(CommandListenerWrapper commandlistenerwrapper, float f2) throws CommandSyntaxException {
        WorldBorder worldborder = commandlistenerwrapper.getLevel().getWorldBorder();
        if (worldborder.getDamagePerBlock() == (double)f2) {
            throw ERROR_SAME_DAMAGE_AMOUNT.create();
        }
        worldborder.setDamagePerBlock(f2);
        commandlistenerwrapper.sendSuccess(() -> IChatBaseComponent.translatable("commands.worldborder.damage.amount.success", String.format(Locale.ROOT, "%.2f", Float.valueOf(f2))), true);
        return (int)f2;
    }

    private static int setWarningTime(CommandListenerWrapper commandlistenerwrapper, int i2) throws CommandSyntaxException {
        WorldBorder worldborder = commandlistenerwrapper.getLevel().getWorldBorder();
        if (worldborder.getWarningTime() == i2) {
            throw ERROR_SAME_WARNING_TIME.create();
        }
        worldborder.setWarningTime(i2);
        commandlistenerwrapper.sendSuccess(() -> IChatBaseComponent.translatable("commands.worldborder.warning.time.success", i2), true);
        return i2;
    }

    private static int setWarningDistance(CommandListenerWrapper commandlistenerwrapper, int i2) throws CommandSyntaxException {
        WorldBorder worldborder = commandlistenerwrapper.getLevel().getWorldBorder();
        if (worldborder.getWarningBlocks() == i2) {
            throw ERROR_SAME_WARNING_DISTANCE.create();
        }
        worldborder.setWarningBlocks(i2);
        commandlistenerwrapper.sendSuccess(() -> IChatBaseComponent.translatable("commands.worldborder.warning.distance.success", i2), true);
        return i2;
    }

    private static int getSize(CommandListenerWrapper commandlistenerwrapper) {
        double d0 = commandlistenerwrapper.getLevel().getWorldBorder().getSize();
        commandlistenerwrapper.sendSuccess(() -> IChatBaseComponent.translatable("commands.worldborder.get", String.format(Locale.ROOT, "%.0f", d0)), false);
        return MathHelper.floor(d0 + 0.5);
    }

    private static int setCenter(CommandListenerWrapper commandlistenerwrapper, Vec2F vec2f) throws CommandSyntaxException {
        WorldBorder worldborder = commandlistenerwrapper.getLevel().getWorldBorder();
        if (worldborder.getCenterX() == (double)vec2f.x && worldborder.getCenterZ() == (double)vec2f.y) {
            throw ERROR_SAME_CENTER.create();
        }
        if ((double)Math.abs(vec2f.x) <= 2.9999984E7 && (double)Math.abs(vec2f.y) <= 2.9999984E7) {
            worldborder.setCenter(vec2f.x, vec2f.y);
            commandlistenerwrapper.sendSuccess(() -> IChatBaseComponent.translatable("commands.worldborder.center.success", String.format(Locale.ROOT, "%.2f", Float.valueOf(vec2f.x)), String.format(Locale.ROOT, "%.2f", Float.valueOf(vec2f.y))), true);
            return 0;
        }
        throw ERROR_TOO_FAR_OUT.create();
    }

    private static int setSize(CommandListenerWrapper commandlistenerwrapper, double d0, long i2) throws CommandSyntaxException {
        WorldBorder worldborder = commandlistenerwrapper.getLevel().getWorldBorder();
        double d1 = worldborder.getSize();
        if (d1 == d0) {
            throw ERROR_SAME_SIZE.create();
        }
        if (d0 < 1.0) {
            throw ERROR_TOO_SMALL.create();
        }
        if (d0 > 5.9999968E7) {
            throw ERROR_TOO_BIG.create();
        }
        if (i2 > 0L) {
            worldborder.lerpSizeBetween(d1, d0, i2);
            if (d0 > d1) {
                commandlistenerwrapper.sendSuccess(() -> IChatBaseComponent.translatable("commands.worldborder.set.grow", String.format(Locale.ROOT, "%.1f", d0), Long.toString(i2 / 1000L)), true);
            } else {
                commandlistenerwrapper.sendSuccess(() -> IChatBaseComponent.translatable("commands.worldborder.set.shrink", String.format(Locale.ROOT, "%.1f", d0), Long.toString(i2 / 1000L)), true);
            }
        } else {
            worldborder.setSize(d0);
            commandlistenerwrapper.sendSuccess(() -> IChatBaseComponent.translatable("commands.worldborder.set.immediate", String.format(Locale.ROOT, "%.1f", d0)), true);
        }
        return (int)(d0 - d1);
    }
}

