/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.Dynamic2CommandExceptionType;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.datafixers.util.Either;
import java.util.ArrayList;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandListenerWrapper;
import net.minecraft.commands.arguments.ResourceArgument;
import net.minecraft.commands.arguments.ResourceOrTagArgument;
import net.minecraft.commands.arguments.coordinates.ArgumentPosition;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.Holder;
import net.minecraft.core.QuartPos;
import net.minecraft.core.SectionPosition;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.server.level.WorldServer;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.biome.BiomeBase;
import net.minecraft.world.level.biome.BiomeResolver;
import net.minecraft.world.level.chunk.IChunkAccess;
import net.minecraft.world.level.chunk.status.ChunkStatus;
import net.minecraft.world.level.levelgen.structure.StructureBoundingBox;
import org.apache.commons.lang3.mutable.MutableInt;

public class FillBiomeCommand {
    public static final SimpleCommandExceptionType ERROR_NOT_LOADED = new SimpleCommandExceptionType((Message)IChatBaseComponent.translatable("argument.pos.unloaded"));
    private static final Dynamic2CommandExceptionType ERROR_VOLUME_TOO_LARGE = new Dynamic2CommandExceptionType((var0, var1) -> IChatBaseComponent.translatableEscape("commands.fillbiome.toobig", var0, var1));

    public static void register(CommandDispatcher<CommandListenerWrapper> var03, CommandBuildContext var1) {
        var03.register((LiteralArgumentBuilder<CommandListenerWrapper>)((LiteralArgumentBuilder)((LiteralArgumentBuilder)net.minecraft.commands.CommandDispatcher.literal("fillbiome").requires(var0 -> var0.hasPermission(2))).then(net.minecraft.commands.CommandDispatcher.argument("from", ArgumentPosition.blockPos()).then(net.minecraft.commands.CommandDispatcher.argument("to", ArgumentPosition.blockPos()).then(((RequiredArgumentBuilder)net.minecraft.commands.CommandDispatcher.argument("biome", ResourceArgument.resource(var1, Registries.BIOME)).executes(var02 -> FillBiomeCommand.fill((CommandListenerWrapper)var02.getSource(), ArgumentPosition.getLoadedBlockPos((CommandContext<CommandListenerWrapper>)var02, "from"), ArgumentPosition.getLoadedBlockPos((CommandContext<CommandListenerWrapper>)var02, "to"), ResourceArgument.getResource((CommandContext<CommandListenerWrapper>)var02, "biome", Registries.BIOME), var0 -> true))).then(net.minecraft.commands.CommandDispatcher.literal("replace").then(net.minecraft.commands.CommandDispatcher.argument("filter", ResourceOrTagArgument.resourceOrTag(var1, Registries.BIOME)).executes(var0 -> FillBiomeCommand.fill((CommandListenerWrapper)var0.getSource(), ArgumentPosition.getLoadedBlockPos((CommandContext<CommandListenerWrapper>)var0, "from"), ArgumentPosition.getLoadedBlockPos((CommandContext<CommandListenerWrapper>)var0, "to"), ResourceArgument.getResource((CommandContext<CommandListenerWrapper>)var0, "biome", Registries.BIOME), ResourceOrTagArgument.getResourceOrTag((CommandContext<CommandListenerWrapper>)var0, "filter", Registries.BIOME)::test)))))))));
    }

    private static int quantize(int var0) {
        return QuartPos.toBlock(QuartPos.fromBlock(var0));
    }

    private static BlockPosition quantize(BlockPosition var0) {
        return new BlockPosition(FillBiomeCommand.quantize(var0.getX()), FillBiomeCommand.quantize(var0.getY()), FillBiomeCommand.quantize(var0.getZ()));
    }

    private static BiomeResolver makeResolver(MutableInt var0, IChunkAccess var1, StructureBoundingBox var2, Holder<BiomeBase> var3, Predicate<Holder<BiomeBase>> var4) {
        return (var5, var6, var7, var8) -> {
            int var9 = QuartPos.toBlock(var5);
            int var10 = QuartPos.toBlock(var6);
            int var11 = QuartPos.toBlock(var7);
            Holder<BiomeBase> var12 = var1.getNoiseBiome(var5, var6, var7);
            if (var2.isInside(var9, var10, var11) && var4.test(var12)) {
                var0.increment();
                return var3;
            }
            return var12;
        };
    }

    public static Either<Integer, CommandSyntaxException> fill(WorldServer var02, BlockPosition var1, BlockPosition var2, Holder<BiomeBase> var3) {
        return FillBiomeCommand.fill(var02, var1, var2, var3, var0 -> true, var0 -> {});
    }

    public static Either<Integer, CommandSyntaxException> fill(WorldServer var0, BlockPosition var1, BlockPosition var2, Holder<BiomeBase> var3, Predicate<Holder<BiomeBase>> var4, Consumer<Supplier<IChatBaseComponent>> var5) {
        int var10;
        BlockPosition var7;
        BlockPosition var6 = FillBiomeCommand.quantize(var1);
        StructureBoundingBox var8 = StructureBoundingBox.fromCorners(var6, var7 = FillBiomeCommand.quantize(var2));
        int var9 = var8.getXSpan() * var8.getYSpan() * var8.getZSpan();
        if (var9 > (var10 = var0.getGameRules().getInt(GameRules.RULE_COMMAND_MODIFICATION_BLOCK_LIMIT))) {
            return Either.right((Object)((Object)ERROR_VOLUME_TOO_LARGE.create((Object)var10, (Object)var9)));
        }
        ArrayList<IChunkAccess> var11 = new ArrayList<IChunkAccess>();
        for (int var12 = SectionPosition.blockToSectionCoord(var8.minZ()); var12 <= SectionPosition.blockToSectionCoord(var8.maxZ()); ++var12) {
            for (int var13 = SectionPosition.blockToSectionCoord(var8.minX()); var13 <= SectionPosition.blockToSectionCoord(var8.maxX()); ++var13) {
                IChunkAccess var14 = var0.getChunk(var13, var12, ChunkStatus.FULL, false);
                if (var14 == null) {
                    return Either.right((Object)((Object)ERROR_NOT_LOADED.create()));
                }
                var11.add(var14);
            }
        }
        MutableInt var12 = new MutableInt(0);
        for (IChunkAccess var14 : var11) {
            var14.fillBiomesFromNoise(FillBiomeCommand.makeResolver(var12, var14, var8, var3, var4), var0.getChunkSource().randomState().sampler());
            var14.setUnsaved(true);
        }
        var0.getChunkSource().chunkMap.resendBiomesForChunks(var11);
        var5.accept(() -> IChatBaseComponent.translatable("commands.fillbiome.success.count", var12.getValue(), var8.minX(), var8.minY(), var8.minZ(), var8.maxX(), var8.maxY(), var8.maxZ()));
        return Either.left((Object)var12.getValue());
    }

    private static int fill(CommandListenerWrapper var0, BlockPosition var12, BlockPosition var2, Holder.c<BiomeBase> var3, Predicate<Holder<BiomeBase>> var4) throws CommandSyntaxException {
        Either<Integer, CommandSyntaxException> var5 = FillBiomeCommand.fill(var0.getLevel(), var12, var2, var3, var4, var1 -> var0.sendSuccess((Supplier<IChatBaseComponent>)var1, true));
        Optional var6 = var5.right();
        if (var6.isPresent()) {
            throw (CommandSyntaxException)((Object)var6.get());
        }
        return (Integer)var5.left().get();
    }
}

