/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.FloatArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import java.util.Optional;
import net.minecraft.ResourceKeyInvalidException;
import net.minecraft.commands.CommandListenerWrapper;
import net.minecraft.commands.ICompletionProvider;
import net.minecraft.commands.arguments.ArgumentMinecraftKeyRegistered;
import net.minecraft.commands.arguments.ResourceKeyArgument;
import net.minecraft.commands.arguments.TemplateMirrorArgument;
import net.minecraft.commands.arguments.TemplateRotationArgument;
import net.minecraft.commands.arguments.coordinates.ArgumentPosition;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.Holder;
import net.minecraft.core.SectionPosition;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.server.level.WorldServer;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.block.EnumBlockMirror;
import net.minecraft.world.level.block.EnumBlockRotation;
import net.minecraft.world.level.block.entity.TileEntityStructure;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.feature.WorldGenFeatureConfigured;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureBoundingBox;
import net.minecraft.world.level.levelgen.structure.StructureStart;
import net.minecraft.world.level.levelgen.structure.pools.WorldGenFeatureDefinedStructureJigsawPlacement;
import net.minecraft.world.level.levelgen.structure.pools.WorldGenFeatureDefinedStructurePoolTemplate;
import net.minecraft.world.level.levelgen.structure.templatesystem.DefinedStructure;
import net.minecraft.world.level.levelgen.structure.templatesystem.DefinedStructureInfo;
import net.minecraft.world.level.levelgen.structure.templatesystem.DefinedStructureProcessorRotation;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplateManager;
import org.bukkit.event.world.AsyncStructureGenerateEvent;

public class PlaceCommand {
    private static final SimpleCommandExceptionType ERROR_FEATURE_FAILED = new SimpleCommandExceptionType((Message)IChatBaseComponent.translatable("commands.place.feature.failed"));
    private static final SimpleCommandExceptionType ERROR_JIGSAW_FAILED = new SimpleCommandExceptionType((Message)IChatBaseComponent.translatable("commands.place.jigsaw.failed"));
    private static final SimpleCommandExceptionType ERROR_STRUCTURE_FAILED = new SimpleCommandExceptionType((Message)IChatBaseComponent.translatable("commands.place.structure.failed"));
    private static final DynamicCommandExceptionType ERROR_TEMPLATE_INVALID = new DynamicCommandExceptionType(object -> IChatBaseComponent.translatableEscape("commands.place.template.invalid", object));
    private static final SimpleCommandExceptionType ERROR_TEMPLATE_FAILED = new SimpleCommandExceptionType((Message)IChatBaseComponent.translatable("commands.place.template.failed"));
    private static final SuggestionProvider<CommandListenerWrapper> SUGGEST_TEMPLATES = (commandcontext, suggestionsbuilder) -> {
        StructureTemplateManager structuretemplatemanager = ((CommandListenerWrapper)commandcontext.getSource()).getLevel().getStructureManager();
        return ICompletionProvider.suggestResource(structuretemplatemanager.listTemplates(), suggestionsbuilder);
    };

    public static void register(CommandDispatcher<CommandListenerWrapper> commanddispatcher) {
        commanddispatcher.register((LiteralArgumentBuilder<CommandListenerWrapper>)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)net.minecraft.commands.CommandDispatcher.literal("place").requires(commandlistenerwrapper -> commandlistenerwrapper.hasPermission(2))).then(net.minecraft.commands.CommandDispatcher.literal("feature").then(((RequiredArgumentBuilder)net.minecraft.commands.CommandDispatcher.argument("feature", ResourceKeyArgument.key(Registries.CONFIGURED_FEATURE)).executes(commandcontext -> PlaceCommand.placeFeature((CommandListenerWrapper)commandcontext.getSource(), ResourceKeyArgument.getConfiguredFeature((CommandContext<CommandListenerWrapper>)commandcontext, "feature"), BlockPosition.containing(((CommandListenerWrapper)commandcontext.getSource()).getPosition())))).then(net.minecraft.commands.CommandDispatcher.argument("pos", ArgumentPosition.blockPos()).executes(commandcontext -> PlaceCommand.placeFeature((CommandListenerWrapper)commandcontext.getSource(), ResourceKeyArgument.getConfiguredFeature((CommandContext<CommandListenerWrapper>)commandcontext, "feature"), ArgumentPosition.getLoadedBlockPos((CommandContext<CommandListenerWrapper>)commandcontext, "pos"))))))).then(net.minecraft.commands.CommandDispatcher.literal("jigsaw").then(net.minecraft.commands.CommandDispatcher.argument("pool", ResourceKeyArgument.key(Registries.TEMPLATE_POOL)).then(net.minecraft.commands.CommandDispatcher.argument("target", ArgumentMinecraftKeyRegistered.id()).then(((RequiredArgumentBuilder)net.minecraft.commands.CommandDispatcher.argument("max_depth", IntegerArgumentType.integer((int)1, (int)20)).executes(commandcontext -> PlaceCommand.placeJigsaw((CommandListenerWrapper)commandcontext.getSource(), ResourceKeyArgument.getStructureTemplatePool((CommandContext<CommandListenerWrapper>)commandcontext, "pool"), ArgumentMinecraftKeyRegistered.getId((CommandContext<CommandListenerWrapper>)commandcontext, "target"), IntegerArgumentType.getInteger((CommandContext)commandcontext, (String)"max_depth"), BlockPosition.containing(((CommandListenerWrapper)commandcontext.getSource()).getPosition())))).then(net.minecraft.commands.CommandDispatcher.argument("position", ArgumentPosition.blockPos()).executes(commandcontext -> PlaceCommand.placeJigsaw((CommandListenerWrapper)commandcontext.getSource(), ResourceKeyArgument.getStructureTemplatePool((CommandContext<CommandListenerWrapper>)commandcontext, "pool"), ArgumentMinecraftKeyRegistered.getId((CommandContext<CommandListenerWrapper>)commandcontext, "target"), IntegerArgumentType.getInteger((CommandContext)commandcontext, (String)"max_depth"), ArgumentPosition.getLoadedBlockPos((CommandContext<CommandListenerWrapper>)commandcontext, "position"))))))))).then(net.minecraft.commands.CommandDispatcher.literal("structure").then(((RequiredArgumentBuilder)net.minecraft.commands.CommandDispatcher.argument("structure", ResourceKeyArgument.key(Registries.STRUCTURE)).executes(commandcontext -> PlaceCommand.placeStructure((CommandListenerWrapper)commandcontext.getSource(), ResourceKeyArgument.getStructure((CommandContext<CommandListenerWrapper>)commandcontext, "structure"), BlockPosition.containing(((CommandListenerWrapper)commandcontext.getSource()).getPosition())))).then(net.minecraft.commands.CommandDispatcher.argument("pos", ArgumentPosition.blockPos()).executes(commandcontext -> PlaceCommand.placeStructure((CommandListenerWrapper)commandcontext.getSource(), ResourceKeyArgument.getStructure((CommandContext<CommandListenerWrapper>)commandcontext, "structure"), ArgumentPosition.getLoadedBlockPos((CommandContext<CommandListenerWrapper>)commandcontext, "pos"))))))).then(net.minecraft.commands.CommandDispatcher.literal("template").then(((RequiredArgumentBuilder)net.minecraft.commands.CommandDispatcher.argument("template", ArgumentMinecraftKeyRegistered.id()).suggests(SUGGEST_TEMPLATES).executes(commandcontext -> PlaceCommand.placeTemplate((CommandListenerWrapper)commandcontext.getSource(), ArgumentMinecraftKeyRegistered.getId((CommandContext<CommandListenerWrapper>)commandcontext, "template"), BlockPosition.containing(((CommandListenerWrapper)commandcontext.getSource()).getPosition()), EnumBlockRotation.NONE, EnumBlockMirror.NONE, 1.0f, 0))).then(((RequiredArgumentBuilder)net.minecraft.commands.CommandDispatcher.argument("pos", ArgumentPosition.blockPos()).executes(commandcontext -> PlaceCommand.placeTemplate((CommandListenerWrapper)commandcontext.getSource(), ArgumentMinecraftKeyRegistered.getId((CommandContext<CommandListenerWrapper>)commandcontext, "template"), ArgumentPosition.getLoadedBlockPos((CommandContext<CommandListenerWrapper>)commandcontext, "pos"), EnumBlockRotation.NONE, EnumBlockMirror.NONE, 1.0f, 0))).then(((RequiredArgumentBuilder)net.minecraft.commands.CommandDispatcher.argument("rotation", TemplateRotationArgument.templateRotation()).executes(commandcontext -> PlaceCommand.placeTemplate((CommandListenerWrapper)commandcontext.getSource(), ArgumentMinecraftKeyRegistered.getId((CommandContext<CommandListenerWrapper>)commandcontext, "template"), ArgumentPosition.getLoadedBlockPos((CommandContext<CommandListenerWrapper>)commandcontext, "pos"), TemplateRotationArgument.getRotation((CommandContext<CommandListenerWrapper>)commandcontext, "rotation"), EnumBlockMirror.NONE, 1.0f, 0))).then(((RequiredArgumentBuilder)net.minecraft.commands.CommandDispatcher.argument("mirror", TemplateMirrorArgument.templateMirror()).executes(commandcontext -> PlaceCommand.placeTemplate((CommandListenerWrapper)commandcontext.getSource(), ArgumentMinecraftKeyRegistered.getId((CommandContext<CommandListenerWrapper>)commandcontext, "template"), ArgumentPosition.getLoadedBlockPos((CommandContext<CommandListenerWrapper>)commandcontext, "pos"), TemplateRotationArgument.getRotation((CommandContext<CommandListenerWrapper>)commandcontext, "rotation"), TemplateMirrorArgument.getMirror((CommandContext<CommandListenerWrapper>)commandcontext, "mirror"), 1.0f, 0))).then(((RequiredArgumentBuilder)net.minecraft.commands.CommandDispatcher.argument("integrity", FloatArgumentType.floatArg((float)0.0f, (float)1.0f)).executes(commandcontext -> PlaceCommand.placeTemplate((CommandListenerWrapper)commandcontext.getSource(), ArgumentMinecraftKeyRegistered.getId((CommandContext<CommandListenerWrapper>)commandcontext, "template"), ArgumentPosition.getLoadedBlockPos((CommandContext<CommandListenerWrapper>)commandcontext, "pos"), TemplateRotationArgument.getRotation((CommandContext<CommandListenerWrapper>)commandcontext, "rotation"), TemplateMirrorArgument.getMirror((CommandContext<CommandListenerWrapper>)commandcontext, "mirror"), FloatArgumentType.getFloat((CommandContext)commandcontext, (String)"integrity"), 0))).then(net.minecraft.commands.CommandDispatcher.argument("seed", IntegerArgumentType.integer()).executes(commandcontext -> PlaceCommand.placeTemplate((CommandListenerWrapper)commandcontext.getSource(), ArgumentMinecraftKeyRegistered.getId((CommandContext<CommandListenerWrapper>)commandcontext, "template"), ArgumentPosition.getLoadedBlockPos((CommandContext<CommandListenerWrapper>)commandcontext, "pos"), TemplateRotationArgument.getRotation((CommandContext<CommandListenerWrapper>)commandcontext, "rotation"), TemplateMirrorArgument.getMirror((CommandContext<CommandListenerWrapper>)commandcontext, "mirror"), FloatArgumentType.getFloat((CommandContext)commandcontext, (String)"integrity"), IntegerArgumentType.getInteger((CommandContext)commandcontext, (String)"seed"))))))))))));
    }

    public static int placeFeature(CommandListenerWrapper commandlistenerwrapper, Holder.c<WorldGenFeatureConfigured<?, ?>> holder_c, BlockPosition blockposition) throws CommandSyntaxException {
        WorldServer worldserver = commandlistenerwrapper.getLevel();
        WorldGenFeatureConfigured<?, ?> worldgenfeatureconfigured = holder_c.value();
        ChunkCoordIntPair chunkcoordintpair = new ChunkCoordIntPair(blockposition);
        PlaceCommand.checkLoaded(worldserver, new ChunkCoordIntPair(chunkcoordintpair.x - 1, chunkcoordintpair.z - 1), new ChunkCoordIntPair(chunkcoordintpair.x + 1, chunkcoordintpair.z + 1));
        if (!worldgenfeatureconfigured.place(worldserver, worldserver.getChunkSource().getGenerator(), worldserver.getRandom(), blockposition)) {
            throw ERROR_FEATURE_FAILED.create();
        }
        String s2 = holder_c.key().location().toString();
        commandlistenerwrapper.sendSuccess(() -> IChatBaseComponent.translatable("commands.place.feature.success", s2, blockposition.getX(), blockposition.getY(), blockposition.getZ()), true);
        return 1;
    }

    public static int placeJigsaw(CommandListenerWrapper commandlistenerwrapper, Holder<WorldGenFeatureDefinedStructurePoolTemplate> holder, MinecraftKey minecraftkey, int i2, BlockPosition blockposition) throws CommandSyntaxException {
        WorldServer worldserver = commandlistenerwrapper.getLevel();
        ChunkCoordIntPair chunkcoordintpair = new ChunkCoordIntPair(blockposition);
        PlaceCommand.checkLoaded(worldserver, chunkcoordintpair, chunkcoordintpair);
        if (!WorldGenFeatureDefinedStructureJigsawPlacement.generateJigsaw(worldserver, holder, minecraftkey, i2, blockposition, false)) {
            throw ERROR_JIGSAW_FAILED.create();
        }
        commandlistenerwrapper.sendSuccess(() -> IChatBaseComponent.translatable("commands.place.jigsaw.success", blockposition.getX(), blockposition.getY(), blockposition.getZ()), true);
        return 1;
    }

    public static int placeStructure(CommandListenerWrapper commandlistenerwrapper, Holder.c<Structure> holder_c, BlockPosition blockposition) throws CommandSyntaxException {
        WorldServer worldserver = commandlistenerwrapper.getLevel();
        Structure structure = holder_c.value();
        ChunkGenerator chunkgenerator = worldserver.getChunkSource().getGenerator();
        StructureStart structurestart = structure.generate(commandlistenerwrapper.registryAccess(), chunkgenerator, chunkgenerator.getBiomeSource(), worldserver.getChunkSource().randomState(), worldserver.getStructureManager(), worldserver.getSeed(), new ChunkCoordIntPair(blockposition), 0, worldserver, holder -> true);
        if (!structurestart.isValid()) {
            throw ERROR_STRUCTURE_FAILED.create();
        }
        structurestart.generationEventCause = AsyncStructureGenerateEvent.Cause.COMMAND;
        StructureBoundingBox structureboundingbox = structurestart.getBoundingBox();
        ChunkCoordIntPair chunkcoordintpair = new ChunkCoordIntPair(SectionPosition.blockToSectionCoord(structureboundingbox.minX()), SectionPosition.blockToSectionCoord(structureboundingbox.minZ()));
        ChunkCoordIntPair chunkcoordintpair1 = new ChunkCoordIntPair(SectionPosition.blockToSectionCoord(structureboundingbox.maxX()), SectionPosition.blockToSectionCoord(structureboundingbox.maxZ()));
        PlaceCommand.checkLoaded(worldserver, chunkcoordintpair, chunkcoordintpair1);
        ChunkCoordIntPair.rangeClosed(chunkcoordintpair, chunkcoordintpair1).forEach(chunkcoordintpair2 -> structurestart.placeInChunk(worldserver, worldserver.structureManager(), chunkgenerator, worldserver.getRandom(), new StructureBoundingBox(chunkcoordintpair2.getMinBlockX(), worldserver.getMinBuildHeight(), chunkcoordintpair2.getMinBlockZ(), chunkcoordintpair2.getMaxBlockX(), worldserver.getMaxBuildHeight(), chunkcoordintpair2.getMaxBlockZ()), (ChunkCoordIntPair)chunkcoordintpair2));
        String s2 = holder_c.key().location().toString();
        commandlistenerwrapper.sendSuccess(() -> IChatBaseComponent.translatable("commands.place.structure.success", s2, blockposition.getX(), blockposition.getY(), blockposition.getZ()), true);
        return 1;
    }

    public static int placeTemplate(CommandListenerWrapper commandlistenerwrapper, MinecraftKey minecraftkey, BlockPosition blockposition, EnumBlockRotation enumblockrotation, EnumBlockMirror enumblockmirror, float f2, int i2) throws CommandSyntaxException {
        boolean flag;
        Optional<DefinedStructure> optional;
        WorldServer worldserver = commandlistenerwrapper.getLevel();
        StructureTemplateManager structuretemplatemanager = worldserver.getStructureManager();
        try {
            optional = structuretemplatemanager.get(minecraftkey);
        }
        catch (ResourceKeyInvalidException resourcekeyinvalidexception) {
            throw ERROR_TEMPLATE_INVALID.create((Object)minecraftkey);
        }
        if (optional.isEmpty()) {
            throw ERROR_TEMPLATE_INVALID.create((Object)minecraftkey);
        }
        DefinedStructure definedstructure = optional.get();
        PlaceCommand.checkLoaded(worldserver, new ChunkCoordIntPair(blockposition), new ChunkCoordIntPair(blockposition.offset(definedstructure.getSize())));
        DefinedStructureInfo definedstructureinfo = new DefinedStructureInfo().setMirror(enumblockmirror).setRotation(enumblockrotation);
        if (f2 < 1.0f) {
            definedstructureinfo.clearProcessors().addProcessor(new DefinedStructureProcessorRotation(f2)).setRandom(TileEntityStructure.createRandom(i2));
        }
        if (!(flag = definedstructure.placeInWorld(worldserver, blockposition, blockposition, definedstructureinfo, TileEntityStructure.createRandom(i2), 2))) {
            throw ERROR_TEMPLATE_FAILED.create();
        }
        commandlistenerwrapper.sendSuccess(() -> IChatBaseComponent.translatable("commands.place.template.success", IChatBaseComponent.translationArg(minecraftkey), blockposition.getX(), blockposition.getY(), blockposition.getZ()), true);
        return 1;
    }

    private static void checkLoaded(WorldServer worldserver, ChunkCoordIntPair chunkcoordintpair, ChunkCoordIntPair chunkcoordintpair1) throws CommandSyntaxException {
        if (ChunkCoordIntPair.rangeClosed(chunkcoordintpair, chunkcoordintpair1).filter(chunkcoordintpair2 -> !worldserver.isLoaded(chunkcoordintpair2.getWorldPosition())).findAny().isPresent()) {
            throw ArgumentPosition.ERROR_NOT_LOADED.create();
        }
    }
}

