/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.dedicated;

import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import com.google.gson.JsonObject;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.JsonOps;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import joptsimple.OptionSet;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.IRegistry;
import net.minecraft.core.IRegistryCustom;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.dedicated.PropertyManager;
import net.minecraft.util.ChatDeserializer;
import net.minecraft.util.MathHelper;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.level.DataPackConfiguration;
import net.minecraft.world.level.EnumGamemode;
import net.minecraft.world.level.WorldDataConfiguration;
import net.minecraft.world.level.levelgen.ChunkProviderFlat;
import net.minecraft.world.level.levelgen.WorldDimensions;
import net.minecraft.world.level.levelgen.WorldOptions;
import net.minecraft.world.level.levelgen.flat.GeneratorSettingsFlat;
import net.minecraft.world.level.levelgen.presets.WorldPreset;
import net.minecraft.world.level.levelgen.presets.WorldPresets;
import org.slf4j.Logger;

public class DedicatedServerProperties
extends PropertyManager<DedicatedServerProperties> {
    static final Logger LOGGER = LogUtils.getLogger();
    private static final Pattern SHA1 = Pattern.compile("^[a-fA-F0-9]{40}$");
    private static final Splitter COMMA_SPLITTER = Splitter.on((char)',').trimResults();
    public final boolean debug = this.get("debug", false);
    public final boolean onlineMode = this.get("online-mode", true);
    public final boolean preventProxyConnections = this.get("prevent-proxy-connections", false);
    public final String serverIp = this.get("server-ip", "");
    public final boolean spawnAnimals = this.get("spawn-animals", true);
    public final boolean spawnNpcs = this.get("spawn-npcs", true);
    public final boolean pvp = this.get("pvp", true);
    public final boolean allowFlight = this.get("allow-flight", false);
    public final String motd = this.get("motd", "A Minecraft Server");
    public final String bugReportLink = this.get("bug-report-link", "");
    public final boolean forceGameMode = this.get("force-gamemode", false);
    public final boolean enforceWhitelist = this.get("enforce-whitelist", false);
    public final EnumDifficulty difficulty = this.get("difficulty", DedicatedServerProperties.dispatchNumberOrString(EnumDifficulty::byId, EnumDifficulty::byName), EnumDifficulty::getKey, EnumDifficulty.EASY);
    public final EnumGamemode gamemode = this.get("gamemode", DedicatedServerProperties.dispatchNumberOrString(EnumGamemode::byId, EnumGamemode::byName), EnumGamemode::getName, EnumGamemode.SURVIVAL);
    public final String levelName = this.get("level-name", "world");
    public final int serverPort = this.get("server-port", 25565);
    @Nullable
    public final Boolean announcePlayerAchievements = this.getLegacyBoolean("announce-player-achievements");
    public final boolean enableQuery = this.get("enable-query", false);
    public final int queryPort = this.get("query.port", 25565);
    public final boolean enableRcon = this.get("enable-rcon", false);
    public final int rconPort = this.get("rcon.port", 25575);
    public final String rconPassword = this.get("rcon.password", "");
    public final boolean hardcore = this.get("hardcore", false);
    public final boolean allowNether = this.get("allow-nether", true);
    public final boolean spawnMonsters = this.get("spawn-monsters", true);
    public final boolean useNativeTransport = this.get("use-native-transport", true);
    public final boolean enableCommandBlock = this.get("enable-command-block", false);
    public final int spawnProtection = this.get("spawn-protection", 16);
    public final int opPermissionLevel = this.get("op-permission-level", 4);
    public final int functionPermissionLevel = this.get("function-permission-level", 2);
    public final long maxTickTime = this.get("max-tick-time", TimeUnit.MINUTES.toMillis(1L));
    public final int maxChainedNeighborUpdates = this.get("max-chained-neighbor-updates", 1000000);
    public final int rateLimitPacketsPerSecond = this.get("rate-limit", 0);
    public final int viewDistance = this.get("view-distance", 10);
    public final int simulationDistance = this.get("simulation-distance", 10);
    public final int maxPlayers = this.get("max-players", 20);
    public final int networkCompressionThreshold = this.get("network-compression-threshold", 256);
    public final boolean broadcastRconToOps = this.get("broadcast-rcon-to-ops", true);
    public final boolean broadcastConsoleToOps = this.get("broadcast-console-to-ops", true);
    public final int maxWorldSize = this.get("max-world-size", integer -> MathHelper.clamp(integer, 1, 29999984), 29999984);
    public final boolean syncChunkWrites = this.get("sync-chunk-writes", true);
    public final String regionFileComression = this.get("region-file-compression", "deflate");
    public final boolean enableJmxMonitoring = this.get("enable-jmx-monitoring", false);
    public final boolean enableStatus = this.get("enable-status", true);
    public final boolean hideOnlinePlayers = this.get("hide-online-players", false);
    public final int entityBroadcastRangePercentage = this.get("entity-broadcast-range-percentage", integer -> MathHelper.clamp(integer, 10, 1000), 100);
    public final String textFilteringConfig = this.get("text-filtering-config", "");
    public final Optional<MinecraftServer.ServerResourcePackInfo> serverResourcePackInfo;
    public final DataPackConfiguration initialDataPackConfiguration;
    public final PropertyManager.EditableProperty<Integer> playerIdleTimeout = this.getMutable("player-idle-timeout", 0);
    public final PropertyManager.EditableProperty<Boolean> whiteList = this.getMutable("white-list", false);
    public final boolean enforceSecureProfile = this.get("enforce-secure-profile", true);
    public final boolean logIPs = this.get("log-ips", true);
    private final WorldDimensionData worldDimensionData;
    public final WorldOptions worldOptions;
    public boolean acceptsTransfers = this.get("accepts-transfers", false);

    public DedicatedServerProperties(Properties properties, OptionSet optionset) {
        super(properties, optionset);
        String s2 = this.get("level-seed", "");
        boolean flag = this.get("generate-structures", true);
        long i2 = WorldOptions.parseSeed(s2).orElse(WorldOptions.randomSeed());
        this.worldOptions = new WorldOptions(i2, flag, false);
        this.worldDimensionData = new WorldDimensionData(this.get("generator-settings", (String s1) -> ChatDeserializer.parse(!s1.isEmpty() ? s1 : "{}"), new JsonObject()), this.get("level-type", (String s1) -> s1.toLowerCase(Locale.ROOT), WorldPresets.NORMAL.location().toString()));
        this.serverResourcePackInfo = DedicatedServerProperties.getServerPackInfo(this.get("resource-pack-id", ""), this.get("resource-pack", ""), this.get("resource-pack-sha1", ""), this.getLegacyString("resource-pack-hash"), this.get("require-resource-pack", false), this.get("resource-pack-prompt", ""));
        this.initialDataPackConfiguration = DedicatedServerProperties.getDatapackConfig(this.get("initial-enabled-packs", String.join((CharSequence)",", WorldDataConfiguration.DEFAULT.dataPacks().getEnabled())), this.get("initial-disabled-packs", String.join((CharSequence)",", WorldDataConfiguration.DEFAULT.dataPacks().getDisabled())));
    }

    public static DedicatedServerProperties fromFile(Path path, OptionSet optionset) {
        return new DedicatedServerProperties(DedicatedServerProperties.loadFromFile(path), optionset);
    }

    @Override
    protected DedicatedServerProperties reload(IRegistryCustom iregistrycustom, Properties properties, OptionSet optionset) {
        return new DedicatedServerProperties(properties, optionset);
    }

    @Nullable
    private static IChatBaseComponent parseResourcePackPrompt(String s2) {
        if (!Strings.isNullOrEmpty((String)s2)) {
            try {
                return IChatBaseComponent.ChatSerializer.fromJson(s2, (HolderLookup.a)IRegistryCustom.EMPTY);
            }
            catch (Exception exception) {
                LOGGER.warn("Failed to parse resource pack prompt '{}'", (Object)s2, (Object)exception);
            }
        }
        return null;
    }

    private static Optional<MinecraftServer.ServerResourcePackInfo> getServerPackInfo(String s2, String s1, String s22, @Nullable String s3, boolean flag, String s4) {
        UUID uuid;
        String s5;
        if (s1.isEmpty()) {
            return Optional.empty();
        }
        if (!s22.isEmpty()) {
            s5 = s22;
            if (!Strings.isNullOrEmpty((String)s3)) {
                LOGGER.warn("resource-pack-hash is deprecated and found along side resource-pack-sha1. resource-pack-hash will be ignored.");
            }
        } else if (!Strings.isNullOrEmpty((String)s3)) {
            LOGGER.warn("resource-pack-hash is deprecated. Please use resource-pack-sha1 instead.");
            s5 = s3;
        } else {
            s5 = "";
        }
        if (s5.isEmpty()) {
            LOGGER.warn("You specified a resource pack without providing a sha1 hash. Pack will be updated on the client only if you change the name of the pack.");
        } else if (!SHA1.matcher(s5).matches()) {
            LOGGER.warn("Invalid sha1 for resource-pack-sha1");
        }
        IChatBaseComponent ichatbasecomponent = DedicatedServerProperties.parseResourcePackPrompt(s4);
        if (s2.isEmpty()) {
            uuid = UUID.nameUUIDFromBytes(s1.getBytes(StandardCharsets.UTF_8));
            LOGGER.warn("resource-pack-id missing, using default of {}", (Object)uuid);
        } else {
            try {
                uuid = UUID.fromString(s2);
            }
            catch (IllegalArgumentException illegalargumentexception) {
                LOGGER.warn("Failed to parse '{}' into UUID", (Object)s2);
                return Optional.empty();
            }
        }
        return Optional.of(new MinecraftServer.ServerResourcePackInfo(uuid, s1, s5, flag, ichatbasecomponent));
    }

    private static DataPackConfiguration getDatapackConfig(String s2, String s1) {
        List list = COMMA_SPLITTER.splitToList((CharSequence)s2);
        List list1 = COMMA_SPLITTER.splitToList((CharSequence)s1);
        return new DataPackConfiguration(list, list1);
    }

    public WorldDimensions createDimensions(IRegistryCustom iregistrycustom) {
        return this.worldDimensionData.create(iregistrycustom);
    }

    public record WorldDimensionData(JsonObject generatorSettings, String levelType) {
        private static final Map<String, ResourceKey<WorldPreset>> LEGACY_PRESET_NAMES = Map.of("default", WorldPresets.NORMAL, "largebiomes", WorldPresets.LARGE_BIOMES);

        public WorldDimensions create(IRegistryCustom iregistrycustom) {
            IRegistry<WorldPreset> iregistry = iregistrycustom.registryOrThrow(Registries.WORLD_PRESET);
            Holder.c<WorldPreset> holder_c = iregistry.getHolder(WorldPresets.NORMAL).or(() -> iregistry.holders().findAny()).orElseThrow(() -> new IllegalStateException("Invalid datapack contents: can't find default preset"));
            Optional<ResourceKey> optional = Optional.ofNullable(MinecraftKey.tryParse(this.levelType)).map(minecraftkey -> ResourceKey.create(Registries.WORLD_PRESET, minecraftkey)).or(() -> Optional.ofNullable(LEGACY_PRESET_NAMES.get(this.levelType)));
            Objects.requireNonNull(iregistry);
            Holder holder = optional.flatMap(iregistry::getHolder).orElseGet(() -> {
                LOGGER.warn("Failed to parse level-type {}, defaulting to {}", (Object)this.levelType, (Object)holder_c.key().location());
                return holder_c;
            });
            WorldDimensions worlddimensions = ((WorldPreset)holder.value()).createWorldDimensions();
            if (holder.is(WorldPresets.FLAT)) {
                RegistryOps registryops = iregistrycustom.createSerializationContext(JsonOps.INSTANCE);
                DataResult dataresult = GeneratorSettingsFlat.CODEC.parse(new Dynamic(registryops, (Object)this.generatorSettings()));
                Logger logger = LOGGER;
                Objects.requireNonNull(logger);
                Optional optional1 = dataresult.resultOrPartial(arg_0 -> ((Logger)logger).error(arg_0));
                if (optional1.isPresent()) {
                    return worlddimensions.replaceOverworldGenerator(iregistrycustom, new ChunkProviderFlat((GeneratorSettingsFlat)optional1.get()));
                }
            }
            return worlddimensions;
        }
    }
}

