/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.dedicated;

import com.google.common.base.MoreObjects;
import com.mojang.logging.LogUtils;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CodingErrorAction;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.function.Function;
import java.util.function.IntFunction;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import javax.annotation.Nullable;
import joptsimple.OptionSet;
import net.minecraft.core.IRegistryCustom;
import org.slf4j.Logger;

public abstract class PropertyManager<T extends PropertyManager<T>> {
    private static final Logger LOGGER = LogUtils.getLogger();
    public final Properties properties;
    private OptionSet options = null;

    public PropertyManager(Properties properties, OptionSet options) {
        this.properties = properties;
        this.options = options;
    }

    private String getOverride(String name, String value) {
        if (this.options != null && this.options.has(name)) {
            return String.valueOf(this.options.valueOf(name));
        }
        return value;
    }

    public static Properties loadFromFile(Path path) {
        try {
            if (!path.toFile().exists()) {
                return new Properties();
            }
            try {
                Properties properties1;
                try (InputStream inputstream = Files.newInputStream(path, new OpenOption[0]);){
                    CharsetDecoder charsetdecoder = StandardCharsets.UTF_8.newDecoder().onMalformedInput(CodingErrorAction.REPORT).onUnmappableCharacter(CodingErrorAction.REPORT);
                    Properties properties = new Properties();
                    properties.load(new InputStreamReader(inputstream, charsetdecoder));
                    properties1 = properties;
                }
                return properties1;
            }
            catch (CharacterCodingException charactercodingexception) {
                Properties properties1;
                LOGGER.info("Failed to load properties as UTF-8 from file {}, trying ISO_8859_1", (Object)path);
                try (BufferedReader bufferedreader = Files.newBufferedReader(path, StandardCharsets.ISO_8859_1);){
                    Properties properties = new Properties();
                    properties.load(bufferedreader);
                    properties1 = properties;
                }
                return properties1;
            }
        }
        catch (IOException ioexception) {
            LOGGER.error("Failed to load properties from file: {}", (Object)path, (Object)ioexception);
            return new Properties();
        }
    }

    public void store(Path path) {
        try {
            if (path.toFile().exists() && !path.toFile().canWrite()) {
                return;
            }
            try (BufferedWriter bufferedwriter = Files.newBufferedWriter(path, StandardCharsets.UTF_8, new OpenOption[0]);){
                this.properties.store(bufferedwriter, "Minecraft server properties");
            }
        }
        catch (IOException ioexception) {
            LOGGER.error("Failed to store properties to file: {}", (Object)path);
        }
    }

    private static <V extends Number> Function<String, V> wrapNumberDeserializer(Function<String, V> function) {
        return s2 -> {
            try {
                return (Number)function.apply((String)s2);
            }
            catch (NumberFormatException numberformatexception) {
                return null;
            }
        };
    }

    protected static <V> Function<String, V> dispatchNumberOrString(IntFunction<V> intfunction, Function<String, V> function) {
        return s2 -> {
            try {
                return intfunction.apply(Integer.parseInt(s2));
            }
            catch (NumberFormatException numberformatexception) {
                return function.apply((String)s2);
            }
        };
    }

    @Nullable
    private String getStringRaw(String s2) {
        return this.getOverride(s2, this.properties.getProperty(s2));
    }

    @Nullable
    protected <V> V getLegacy(String s2, Function<String, V> function) {
        String s1 = this.getStringRaw(s2);
        if (s1 == null) {
            return null;
        }
        this.properties.remove(s2);
        return function.apply(s1);
    }

    protected <V> V get(String s2, Function<String, V> function, Function<V, String> function1, V v0) {
        try {
            return this.get0(s2, function, function1, v0);
        }
        catch (Exception ex) {
            throw new RuntimeException("Could not load invalidly configured property '" + s2 + "'", ex);
        }
    }

    private <V> V get0(String s2, Function<String, V> function, Function<V, String> function1, V v0) {
        String s1 = this.getStringRaw(s2);
        Object v1 = MoreObjects.firstNonNull(s1 != null ? function.apply(s1) : null, v0);
        this.properties.put(s2, function1.apply(v1));
        return (V)v1;
    }

    protected <V> EditableProperty<V> getMutable(String s2, Function<String, V> function, Function<V, String> function1, V v0) {
        String s1 = this.getStringRaw(s2);
        Object v1 = MoreObjects.firstNonNull(s1 != null ? function.apply(s1) : null, v0);
        this.properties.put(s2, function1.apply(v1));
        return new EditableProperty<Object>(s2, v1, function1);
    }

    protected <V> V get(String s2, Function<String, V> function, UnaryOperator<V> unaryoperator, Function<V, String> function1, V v0) {
        return (V)this.get(s2, s1 -> {
            Object v1 = function.apply((String)s1);
            return v1 != null ? unaryoperator.apply(v1) : null;
        }, function1, v0);
    }

    protected <V> V get(String s2, Function<String, V> function, V v0) {
        return (V)this.get(s2, function, Objects::toString, v0);
    }

    protected <V> EditableProperty<V> getMutable(String s2, Function<String, V> function, V v0) {
        return this.getMutable(s2, function, Objects::toString, v0);
    }

    protected String get(String s2, String s1) {
        return this.get(s2, Function.identity(), Function.identity(), s1);
    }

    @Nullable
    protected String getLegacyString(String s2) {
        return (String)this.getLegacy(s2, Function.identity());
    }

    protected int get(String s2, int i2) {
        return this.get(s2, PropertyManager.wrapNumberDeserializer(Integer::parseInt), Integer.valueOf(i2));
    }

    protected EditableProperty<Integer> getMutable(String s2, int i2) {
        return this.getMutable(s2, PropertyManager.wrapNumberDeserializer(Integer::parseInt), i2);
    }

    protected int get(String s2, UnaryOperator<Integer> unaryoperator, int i2) {
        return this.get(s2, PropertyManager.wrapNumberDeserializer(Integer::parseInt), unaryoperator, Objects::toString, i2);
    }

    protected long get(String s2, long i2) {
        return this.get(s2, PropertyManager.wrapNumberDeserializer(Long::parseLong), i2);
    }

    protected boolean get(String s2, boolean flag) {
        return this.get(s2, Boolean::valueOf, flag);
    }

    protected EditableProperty<Boolean> getMutable(String s2, boolean flag) {
        return this.getMutable(s2, Boolean::valueOf, flag);
    }

    @Nullable
    protected Boolean getLegacyBoolean(String s2) {
        return this.getLegacy(s2, Boolean::valueOf);
    }

    protected Properties cloneProperties() {
        Properties properties = new Properties();
        properties.putAll((Map<?, ?>)this.properties);
        return properties;
    }

    protected abstract T reload(IRegistryCustom var1, Properties var2, OptionSet var3);

    public class EditableProperty<V>
    implements Supplier<V> {
        private final String key;
        private final V value;
        private final Function<V, String> serializer;

        EditableProperty(String s2, V object, Function function) {
            this.key = s2;
            this.value = object;
            this.serializer = function;
        }

        @Override
        public V get() {
            return this.value;
        }

        public T update(IRegistryCustom iregistrycustom, V v0) {
            Properties properties = PropertyManager.this.cloneProperties();
            properties.put(this.key, this.serializer.apply(v0));
            return PropertyManager.this.reload(iregistrycustom, properties, PropertyManager.this.options);
        }
    }
}

