/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.level;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import com.mojang.logging.LogUtils;
import it.unimi.dsi.fastutil.longs.Long2ByteMap;
import it.unimi.dsi.fastutil.longs.Long2ByteOpenHashMap;
import it.unimi.dsi.fastutil.longs.Long2IntMap;
import it.unimi.dsi.fastutil.longs.Long2IntMaps;
import it.unimi.dsi.fastutil.longs.Long2IntOpenHashMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.longs.LongIterator;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import it.unimi.dsi.fastutil.longs.LongSet;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import it.unimi.dsi.fastutil.objects.ObjectSet;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import javax.annotation.Nullable;
import net.minecraft.core.SectionPosition;
import net.minecraft.server.level.ChunkLevel;
import net.minecraft.server.level.ChunkMap;
import net.minecraft.server.level.ChunkResult;
import net.minecraft.server.level.ChunkTaskQueueSorter;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.FullChunkStatus;
import net.minecraft.server.level.PlayerChunk;
import net.minecraft.server.level.PlayerChunkMap;
import net.minecraft.server.level.Ticket;
import net.minecraft.server.level.TicketType;
import net.minecraft.server.level.TickingTracker;
import net.minecraft.util.ArraySetSorted;
import net.minecraft.util.thread.Mailbox;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.chunk.Chunk;
import org.slf4j.Logger;

public abstract class ChunkMapDistance {
    static final Logger LOGGER = LogUtils.getLogger();
    static final int PLAYER_TICKET_LEVEL = ChunkLevel.byStatus(FullChunkStatus.ENTITY_TICKING);
    private static final int INITIAL_TICKET_LIST_CAPACITY = 4;
    final Long2ObjectMap<ObjectSet<EntityPlayer>> playersPerChunk = new Long2ObjectOpenHashMap();
    public final Long2ObjectOpenHashMap<ArraySetSorted<Ticket<?>>> tickets = new Long2ObjectOpenHashMap();
    private final a ticketTracker = new a();
    private final b naturalSpawnChunkCounter = new b(8);
    private final TickingTracker tickingTicketsTracker = new TickingTracker();
    private final c playerTicketManager = new c(32);
    final Set<PlayerChunk> chunksToUpdateFutures = Sets.newHashSet();
    final ChunkTaskQueueSorter ticketThrottler;
    final Mailbox<ChunkTaskQueueSorter.a<Runnable>> ticketThrottlerInput;
    final Mailbox<ChunkTaskQueueSorter.b> ticketThrottlerReleaser;
    final LongSet ticketsToRelease = new LongOpenHashSet();
    final Executor mainThreadExecutor;
    private long ticketTickCounter;
    public int simulationDistance = 10;

    protected ChunkMapDistance(Executor executor, Executor executor1) {
        ChunkTaskQueueSorter chunktaskqueuesorter;
        Objects.requireNonNull(executor1);
        Mailbox<Runnable> mailbox = Mailbox.of("player ticket throttler", executor1::execute);
        this.ticketThrottler = chunktaskqueuesorter = new ChunkTaskQueueSorter((List<Mailbox<?>>)ImmutableList.of(mailbox), executor, 4);
        this.ticketThrottlerInput = chunktaskqueuesorter.getProcessor(mailbox, true);
        this.ticketThrottlerReleaser = chunktaskqueuesorter.getReleaseProcessor(mailbox);
        this.mainThreadExecutor = executor1;
    }

    protected void purgeStaleTickets() {
        ++this.ticketTickCounter;
        ObjectIterator objectiterator = this.tickets.long2ObjectEntrySet().fastIterator();
        while (objectiterator.hasNext()) {
            Long2ObjectMap.Entry entry = (Long2ObjectMap.Entry)objectiterator.next();
            Iterator iterator = ((ArraySetSorted)entry.getValue()).iterator();
            boolean flag = false;
            while (iterator.hasNext()) {
                Ticket ticket = (Ticket)iterator.next();
                if (!ticket.timedOut(this.ticketTickCounter)) continue;
                iterator.remove();
                flag = true;
                this.tickingTicketsTracker.removeTicket(entry.getLongKey(), ticket);
            }
            if (flag) {
                this.ticketTracker.update(entry.getLongKey(), ChunkMapDistance.getTicketLevelAt((ArraySetSorted)entry.getValue()), false);
            }
            if (!((ArraySetSorted)entry.getValue()).isEmpty()) continue;
            objectiterator.remove();
        }
    }

    private static int getTicketLevelAt(ArraySetSorted<Ticket<?>> arraysetsorted) {
        return !arraysetsorted.isEmpty() ? arraysetsorted.first().getTicketLevel() : ChunkLevel.MAX_LEVEL + 1;
    }

    protected abstract boolean isChunkToRemove(long var1);

    @Nullable
    protected abstract PlayerChunk getChunk(long var1);

    @Nullable
    protected abstract PlayerChunk updateChunkScheduling(long var1, int var3, @Nullable PlayerChunk var4, int var5);

    public boolean runAllUpdates(PlayerChunkMap playerchunkmap) {
        boolean flag;
        this.naturalSpawnChunkCounter.runAllUpdates();
        this.tickingTicketsTracker.runAllUpdates();
        this.playerTicketManager.runAllUpdates();
        int i2 = Integer.MAX_VALUE - this.ticketTracker.runDistanceUpdates(Integer.MAX_VALUE);
        boolean bl = flag = i2 != 0;
        if (flag) {
            // empty if block
        }
        if (!this.chunksToUpdateFutures.isEmpty()) {
            this.chunksToUpdateFutures.forEach(playerchunk -> playerchunk.callEventIfUnloading(playerchunkmap));
            this.chunksToUpdateFutures.forEach(playerchunk -> playerchunk.updateHighestAllowedStatus(playerchunkmap));
            this.chunksToUpdateFutures.forEach(playerchunk -> playerchunk.updateFutures(playerchunkmap, this.mainThreadExecutor));
            this.chunksToUpdateFutures.clear();
            return true;
        }
        if (!this.ticketsToRelease.isEmpty()) {
            LongIterator longiterator = this.ticketsToRelease.iterator();
            while (longiterator.hasNext()) {
                long j2 = longiterator.nextLong();
                if (!this.getTickets(j2).stream().anyMatch(ticket -> ticket.getType() == TicketType.PLAYER)) continue;
                PlayerChunk playerchunk2 = playerchunkmap.getUpdatingChunkIfPresent(j2);
                if (playerchunk2 == null) {
                    throw new IllegalStateException();
                }
                CompletableFuture<ChunkResult<Chunk>> completablefuture = playerchunk2.getEntityTickingChunkFuture();
                completablefuture.thenAccept(chunkresult -> this.mainThreadExecutor.execute(() -> this.ticketThrottlerReleaser.tell(ChunkTaskQueueSorter.release(() -> {}, j2, false))));
            }
            this.ticketsToRelease.clear();
        }
        return flag;
    }

    boolean addTicket(long i2, Ticket<?> ticket) {
        ArraySetSorted<Ticket<?>> arraysetsorted = this.getTickets(i2);
        int j2 = ChunkMapDistance.getTicketLevelAt(arraysetsorted);
        Ticket<?> ticket1 = arraysetsorted.addOrGet(ticket);
        ticket1.setCreatedTick(this.ticketTickCounter);
        if (ticket.getTicketLevel() < j2) {
            this.ticketTracker.update(i2, ticket.getTicketLevel(), true);
        }
        return ticket == ticket1;
    }

    boolean removeTicket(long i2, Ticket<?> ticket) {
        ArraySetSorted<Ticket<?>> arraysetsorted = this.getTickets(i2);
        boolean removed = false;
        if (arraysetsorted.remove(ticket)) {
            removed = true;
        }
        if (arraysetsorted.isEmpty()) {
            this.tickets.remove(i2);
        }
        this.ticketTracker.update(i2, ChunkMapDistance.getTicketLevelAt(arraysetsorted), false);
        return removed;
    }

    public <T> void addTicket(TicketType<T> tickettype, ChunkCoordIntPair chunkcoordintpair, int i2, T t0) {
        this.addTicket(chunkcoordintpair.toLong(), new Ticket<T>(tickettype, i2, t0));
    }

    public <T> void removeTicket(TicketType<T> tickettype, ChunkCoordIntPair chunkcoordintpair, int i2, T t0) {
        Ticket<T> ticket = new Ticket<T>(tickettype, i2, t0);
        this.removeTicket(chunkcoordintpair.toLong(), ticket);
    }

    public <T> void addRegionTicket(TicketType<T> tickettype, ChunkCoordIntPair chunkcoordintpair, int i2, T t0) {
        this.addRegionTicketAtDistance(tickettype, chunkcoordintpair, i2, t0);
    }

    public <T> boolean addRegionTicketAtDistance(TicketType<T> tickettype, ChunkCoordIntPair chunkcoordintpair, int i2, T t0) {
        Ticket<T> ticket = new Ticket<T>(tickettype, ChunkLevel.byStatus(FullChunkStatus.FULL) - i2, t0);
        long j2 = chunkcoordintpair.toLong();
        boolean added = this.addTicket(j2, ticket);
        this.tickingTicketsTracker.addTicket(j2, ticket);
        return added;
    }

    public <T> void removeRegionTicket(TicketType<T> tickettype, ChunkCoordIntPair chunkcoordintpair, int i2, T t0) {
        this.removeRegionTicketAtDistance(tickettype, chunkcoordintpair, i2, t0);
    }

    public <T> boolean removeRegionTicketAtDistance(TicketType<T> tickettype, ChunkCoordIntPair chunkcoordintpair, int i2, T t0) {
        Ticket<T> ticket = new Ticket<T>(tickettype, ChunkLevel.byStatus(FullChunkStatus.FULL) - i2, t0);
        long j2 = chunkcoordintpair.toLong();
        boolean removed = this.removeTicket(j2, ticket);
        this.tickingTicketsTracker.removeTicket(j2, ticket);
        return removed;
    }

    private ArraySetSorted<Ticket<?>> getTickets(long i2) {
        return (ArraySetSorted)this.tickets.computeIfAbsent(i2, j2 -> ArraySetSorted.create(4));
    }

    protected void updateChunkForced(ChunkCoordIntPair chunkcoordintpair, boolean flag) {
        Ticket<ChunkCoordIntPair> ticket = new Ticket<ChunkCoordIntPair>(TicketType.FORCED, PlayerChunkMap.FORCED_TICKET_LEVEL, chunkcoordintpair);
        long i2 = chunkcoordintpair.toLong();
        if (flag) {
            this.addTicket(i2, ticket);
            this.tickingTicketsTracker.addTicket(i2, ticket);
        } else {
            this.removeTicket(i2, ticket);
            this.tickingTicketsTracker.removeTicket(i2, ticket);
        }
    }

    public void addPlayer(SectionPosition sectionposition, EntityPlayer entityplayer) {
        ChunkCoordIntPair chunkcoordintpair = sectionposition.chunk();
        long i2 = chunkcoordintpair.toLong();
        ((ObjectSet)this.playersPerChunk.computeIfAbsent(i2, j2 -> new ObjectOpenHashSet())).add((Object)entityplayer);
        this.naturalSpawnChunkCounter.update(i2, 0, true);
        this.playerTicketManager.update(i2, 0, true);
        this.tickingTicketsTracker.addTicket(TicketType.PLAYER, chunkcoordintpair, this.getPlayerTicketLevel(), chunkcoordintpair);
    }

    public void removePlayer(SectionPosition sectionposition, EntityPlayer entityplayer) {
        ChunkCoordIntPair chunkcoordintpair = sectionposition.chunk();
        long i2 = chunkcoordintpair.toLong();
        ObjectSet objectset = (ObjectSet)this.playersPerChunk.get(i2);
        if (objectset == null) {
            return;
        }
        objectset.remove((Object)entityplayer);
        if (objectset.isEmpty()) {
            this.playersPerChunk.remove(i2);
            this.naturalSpawnChunkCounter.update(i2, Integer.MAX_VALUE, false);
            this.playerTicketManager.update(i2, Integer.MAX_VALUE, false);
            this.tickingTicketsTracker.removeTicket(TicketType.PLAYER, chunkcoordintpair, this.getPlayerTicketLevel(), chunkcoordintpair);
        }
    }

    private int getPlayerTicketLevel() {
        return Math.max(0, ChunkLevel.byStatus(FullChunkStatus.ENTITY_TICKING) - this.simulationDistance);
    }

    public boolean inEntityTickingRange(long i2) {
        return ChunkLevel.isEntityTicking(this.tickingTicketsTracker.getLevel(i2));
    }

    public boolean inBlockTickingRange(long i2) {
        return ChunkLevel.isBlockTicking(this.tickingTicketsTracker.getLevel(i2));
    }

    protected String getTicketDebugString(long i2) {
        ArraySetSorted arraysetsorted = (ArraySetSorted)this.tickets.get(i2);
        return arraysetsorted != null && !arraysetsorted.isEmpty() ? ((Ticket)arraysetsorted.first()).toString() : "no_ticket";
    }

    protected void updatePlayerTickets(int i2) {
        this.playerTicketManager.updateViewDistance(i2);
    }

    public void updateSimulationDistance(int i2) {
        if (i2 != this.simulationDistance) {
            this.simulationDistance = i2;
            this.tickingTicketsTracker.replacePlayerTicketsLevel(this.getPlayerTicketLevel());
        }
    }

    public int getNaturalSpawnChunkCount() {
        this.naturalSpawnChunkCounter.runAllUpdates();
        return this.naturalSpawnChunkCounter.chunks.size();
    }

    public boolean hasPlayersNearby(long i2) {
        this.naturalSpawnChunkCounter.runAllUpdates();
        return this.naturalSpawnChunkCounter.chunks.containsKey(i2);
    }

    public String getDebugStatus() {
        return this.ticketThrottler.getDebugStatus();
    }

    private void dumpTickets(String s2) {
        try (FileOutputStream fileoutputstream = new FileOutputStream(new File(s2));){
            for (Long2ObjectMap.Entry entry : this.tickets.long2ObjectEntrySet()) {
                ChunkCoordIntPair chunkcoordintpair = new ChunkCoordIntPair(entry.getLongKey());
                for (Ticket ticket : (ArraySetSorted)entry.getValue()) {
                    fileoutputstream.write((chunkcoordintpair.x + "\t" + chunkcoordintpair.z + "\t" + String.valueOf(ticket.getType()) + "\t" + ticket.getTicketLevel() + "\t\n").getBytes(StandardCharsets.UTF_8));
                }
            }
        }
        catch (IOException ioexception) {
            LOGGER.error("Failed to dump tickets to {}", (Object)s2, (Object)ioexception);
        }
    }

    @VisibleForTesting
    TickingTracker tickingTracker() {
        return this.tickingTicketsTracker;
    }

    public void removeTicketsOnClosing() {
        ImmutableSet immutableset = ImmutableSet.of(TicketType.UNKNOWN, TicketType.POST_TELEPORT);
        ObjectIterator objectiterator = this.tickets.long2ObjectEntrySet().fastIterator();
        while (objectiterator.hasNext()) {
            Long2ObjectMap.Entry entry = (Long2ObjectMap.Entry)objectiterator.next();
            Iterator iterator = ((ArraySetSorted)entry.getValue()).iterator();
            boolean flag = false;
            while (iterator.hasNext()) {
                Ticket ticket = (Ticket)iterator.next();
                if (immutableset.contains(ticket.getType())) continue;
                iterator.remove();
                flag = true;
                this.tickingTicketsTracker.removeTicket(entry.getLongKey(), ticket);
            }
            if (flag) {
                this.ticketTracker.update(entry.getLongKey(), ChunkMapDistance.getTicketLevelAt((ArraySetSorted)entry.getValue()), false);
            }
            if (!((ArraySetSorted)entry.getValue()).isEmpty()) continue;
            objectiterator.remove();
        }
    }

    public boolean hasTickets() {
        return !this.tickets.isEmpty();
    }

    public <T> void removeAllTicketsFor(TicketType<T> ticketType, int ticketLevel, T ticketIdentifier) {
        Ticket<T> target = new Ticket<T>(ticketType, ticketLevel, ticketIdentifier);
        ObjectIterator iterator = this.tickets.long2ObjectEntrySet().fastIterator();
        while (iterator.hasNext()) {
            Long2ObjectMap.Entry entry = (Long2ObjectMap.Entry)iterator.next();
            ArraySetSorted tickets = (ArraySetSorted)entry.getValue();
            if (!tickets.remove(target)) continue;
            this.ticketTracker.update(entry.getLongKey(), ChunkMapDistance.getTicketLevelAt(tickets), false);
            if (!tickets.isEmpty()) continue;
            iterator.remove();
        }
    }

    private class a
    extends ChunkMap {
        private static final int MAX_LEVEL = ChunkLevel.MAX_LEVEL + 1;

        public a() {
            super(MAX_LEVEL + 1, 16, 256);
        }

        @Override
        protected int getLevelFromSource(long i2) {
            ArraySetSorted arraysetsorted = (ArraySetSorted)ChunkMapDistance.this.tickets.get(i2);
            return arraysetsorted == null ? Integer.MAX_VALUE : (arraysetsorted.isEmpty() ? Integer.MAX_VALUE : ((Ticket)arraysetsorted.first()).getTicketLevel());
        }

        @Override
        protected int getLevel(long i2) {
            PlayerChunk playerchunk;
            if (!ChunkMapDistance.this.isChunkToRemove(i2) && (playerchunk = ChunkMapDistance.this.getChunk(i2)) != null) {
                return playerchunk.getTicketLevel();
            }
            return MAX_LEVEL;
        }

        @Override
        protected void setLevel(long i2, int j2) {
            int k2;
            PlayerChunk playerchunk = ChunkMapDistance.this.getChunk(i2);
            int n2 = k2 = playerchunk == null ? MAX_LEVEL : playerchunk.getTicketLevel();
            if (k2 != j2 && (playerchunk = ChunkMapDistance.this.updateChunkScheduling(i2, j2, playerchunk, k2)) != null) {
                ChunkMapDistance.this.chunksToUpdateFutures.add(playerchunk);
            }
        }

        public int runDistanceUpdates(int i2) {
            return this.runUpdates(i2);
        }
    }

    private class b
    extends ChunkMap {
        protected final Long2ByteMap chunks;
        protected final int maxDistance;

        protected b(int i2) {
            super(i2 + 2, 16, 256);
            this.chunks = new Long2ByteOpenHashMap();
            this.maxDistance = i2;
            this.chunks.defaultReturnValue((byte)(i2 + 2));
        }

        @Override
        protected int getLevel(long i2) {
            return this.chunks.get(i2);
        }

        @Override
        protected void setLevel(long i2, int j2) {
            byte b0 = j2 > this.maxDistance ? this.chunks.remove(i2) : this.chunks.put(i2, (byte)j2);
            this.onLevelChange(i2, b0, j2);
        }

        protected void onLevelChange(long i2, int j2, int k2) {
        }

        @Override
        protected int getLevelFromSource(long i2) {
            return this.havePlayer(i2) ? 0 : Integer.MAX_VALUE;
        }

        private boolean havePlayer(long i2) {
            ObjectSet objectset = (ObjectSet)ChunkMapDistance.this.playersPerChunk.get(i2);
            return objectset != null && !objectset.isEmpty();
        }

        public void runAllUpdates() {
            this.runUpdates(Integer.MAX_VALUE);
        }

        private void dumpChunks(String s2) {
            try (FileOutputStream fileoutputstream = new FileOutputStream(new File(s2));){
                for (Long2ByteMap.Entry it_unimi_dsi_fastutil_longs_long2bytemap_entry : this.chunks.long2ByteEntrySet()) {
                    ChunkCoordIntPair chunkcoordintpair = new ChunkCoordIntPair(it_unimi_dsi_fastutil_longs_long2bytemap_entry.getLongKey());
                    String s1 = Byte.toString(it_unimi_dsi_fastutil_longs_long2bytemap_entry.getByteValue());
                    fileoutputstream.write((chunkcoordintpair.x + "\t" + chunkcoordintpair.z + "\t" + s1 + "\n").getBytes(StandardCharsets.UTF_8));
                }
            }
            catch (IOException ioexception) {
                LOGGER.error("Failed to dump chunks to {}", (Object)s2, (Object)ioexception);
            }
        }
    }

    private class c
    extends b {
        private int viewDistance;
        private final Long2IntMap queueLevels;
        private final LongSet toUpdate;

        protected c(int i2) {
            super(i2);
            this.viewDistance = 0;
            this.queueLevels = Long2IntMaps.synchronize((Long2IntMap)new Long2IntOpenHashMap());
            this.toUpdate = new LongOpenHashSet();
            this.queueLevels.defaultReturnValue(i2 + 2);
        }

        @Override
        protected void onLevelChange(long i2, int j2, int k2) {
            this.toUpdate.add(i2);
        }

        public void updateViewDistance(int i2) {
            for (Long2ByteMap.Entry it_unimi_dsi_fastutil_longs_long2bytemap_entry : this.chunks.long2ByteEntrySet()) {
                byte b0 = it_unimi_dsi_fastutil_longs_long2bytemap_entry.getByteValue();
                long j2 = it_unimi_dsi_fastutil_longs_long2bytemap_entry.getLongKey();
                this.onLevelChange(j2, b0, this.haveTicketFor(b0), b0 <= i2);
            }
            this.viewDistance = i2;
        }

        private void onLevelChange(long i2, int j2, boolean flag, boolean flag1) {
            if (flag != flag1) {
                Ticket<ChunkCoordIntPair> ticket = new Ticket<ChunkCoordIntPair>(TicketType.PLAYER, PLAYER_TICKET_LEVEL, new ChunkCoordIntPair(i2));
                if (flag1) {
                    ChunkMapDistance.this.ticketThrottlerInput.tell(ChunkTaskQueueSorter.message(() -> ChunkMapDistance.this.mainThreadExecutor.execute(() -> {
                        if (this.haveTicketFor(this.getLevel(i2))) {
                            ChunkMapDistance.this.addTicket(i2, ticket);
                            ChunkMapDistance.this.ticketsToRelease.add(i2);
                        } else {
                            ChunkMapDistance.this.ticketThrottlerReleaser.tell(ChunkTaskQueueSorter.release(() -> {}, i2, false));
                        }
                    }), i2, () -> j2));
                } else {
                    ChunkMapDistance.this.ticketThrottlerReleaser.tell(ChunkTaskQueueSorter.release(() -> ChunkMapDistance.this.mainThreadExecutor.execute(() -> ChunkMapDistance.this.removeTicket(i2, ticket)), i2, true));
                }
            }
        }

        @Override
        public void runAllUpdates() {
            super.runAllUpdates();
            if (!this.toUpdate.isEmpty()) {
                LongIterator longiterator = this.toUpdate.iterator();
                while (longiterator.hasNext()) {
                    int k2;
                    long i2 = longiterator.nextLong();
                    int j2 = this.queueLevels.get(i2);
                    if (j2 == (k2 = this.getLevel(i2))) continue;
                    ChunkMapDistance.this.ticketThrottler.onLevelChange(new ChunkCoordIntPair(i2), () -> this.queueLevels.get(i2), k2, l2 -> {
                        if (l2 >= this.queueLevels.defaultReturnValue()) {
                            this.queueLevels.remove(i2);
                        } else {
                            this.queueLevels.put(i2, l2);
                        }
                    });
                    this.onLevelChange(i2, k2, this.haveTicketFor(j2), this.haveTicketFor(k2));
                }
                this.toUpdate.clear();
            }
        }

        private boolean haveTicketFor(int i2) {
            return i2 <= this.viewDistance;
        }
    }
}

