/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.level;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Lists;
import com.mojang.datafixers.DataFixer;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.function.BooleanSupplier;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.SystemUtils;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.SectionPosition;
import net.minecraft.network.protocol.Packet;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ChunkLevel;
import net.minecraft.server.level.ChunkMapDistance;
import net.minecraft.server.level.ChunkResult;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.FullChunkStatus;
import net.minecraft.server.level.GenerationChunkHolder;
import net.minecraft.server.level.LightEngineThreaded;
import net.minecraft.server.level.PlayerChunk;
import net.minecraft.server.level.PlayerChunkMap;
import net.minecraft.server.level.TicketType;
import net.minecraft.server.level.WorldServer;
import net.minecraft.server.level.progress.WorldLoadListener;
import net.minecraft.util.VisibleForDebug;
import net.minecraft.util.profiling.GameProfilerFiller;
import net.minecraft.util.thread.IAsyncTaskHandler;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.village.poi.VillagePlace;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.EnumSkyBlock;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.LocalMobCapCalculator;
import net.minecraft.world.level.SpawnerCreature;
import net.minecraft.world.level.World;
import net.minecraft.world.level.chunk.Chunk;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.chunk.ChunkGeneratorStructureState;
import net.minecraft.world.level.chunk.IChunkAccess;
import net.minecraft.world.level.chunk.IChunkProvider;
import net.minecraft.world.level.chunk.LightChunk;
import net.minecraft.world.level.chunk.status.ChunkStatus;
import net.minecraft.world.level.chunk.storage.ChunkScanAccess;
import net.minecraft.world.level.entity.ChunkStatusUpdateListener;
import net.minecraft.world.level.levelgen.RandomState;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplateManager;
import net.minecraft.world.level.storage.Convertable;
import net.minecraft.world.level.storage.WorldPersistentData;
import org.bukkit.entity.SpawnCategory;

public class ChunkProviderServer
extends IChunkProvider {
    private static final List<ChunkStatus> CHUNK_STATUSES = ChunkStatus.getStatusList();
    private final ChunkMapDistance distanceManager;
    final WorldServer level;
    final Thread mainThread;
    final LightEngineThreaded lightEngine;
    private final b mainThreadProcessor;
    public final PlayerChunkMap chunkMap;
    private final WorldPersistentData dataStorage;
    private long lastInhabitedUpdate;
    public boolean spawnEnemies = true;
    public boolean spawnFriendlies = true;
    private static final int CACHE_SIZE = 4;
    private final long[] lastChunkPos = new long[4];
    private final ChunkStatus[] lastChunkStatus = new ChunkStatus[4];
    private final IChunkAccess[] lastChunk = new IChunkAccess[4];
    @Nullable
    @VisibleForDebug
    private SpawnerCreature.d lastSpawnState;

    public ChunkProviderServer(WorldServer worldserver, Convertable.ConversionSession convertable_conversionsession, DataFixer datafixer, StructureTemplateManager structuretemplatemanager, Executor executor, ChunkGenerator chunkgenerator, int i2, int j2, boolean flag, WorldLoadListener worldloadlistener, ChunkStatusUpdateListener chunkstatusupdatelistener, Supplier<WorldPersistentData> supplier) {
        this.level = worldserver;
        this.mainThreadProcessor = new b(worldserver);
        this.mainThread = Thread.currentThread();
        File file = convertable_conversionsession.getDimensionPath(worldserver.dimension()).resolve("data").toFile();
        file.mkdirs();
        this.dataStorage = new WorldPersistentData(file, datafixer, worldserver.registryAccess());
        this.chunkMap = new PlayerChunkMap(worldserver, convertable_conversionsession, datafixer, structuretemplatemanager, executor, this.mainThreadProcessor, this, chunkgenerator, worldloadlistener, chunkstatusupdatelistener, supplier, i2, flag);
        this.lightEngine = this.chunkMap.getLightEngine();
        this.distanceManager = this.chunkMap.getDistanceManager();
        this.distanceManager.updateSimulationDistance(j2);
        this.clearCache();
    }

    public boolean isChunkLoaded(int chunkX, int chunkZ) {
        PlayerChunk chunk = this.chunkMap.getUpdatingChunkIfPresent(ChunkCoordIntPair.asLong(chunkX, chunkZ));
        if (chunk == null) {
            return false;
        }
        return chunk.getFullChunkNow() != null;
    }

    @Override
    public LightEngineThreaded getLightEngine() {
        return this.lightEngine;
    }

    @Nullable
    private PlayerChunk getVisibleChunkIfPresent(long i2) {
        return this.chunkMap.getVisibleChunkIfPresent(i2);
    }

    public int getTickingGenerated() {
        return this.chunkMap.getTickingGenerated();
    }

    private void storeInCache(long i2, @Nullable IChunkAccess ichunkaccess, ChunkStatus chunkstatus) {
        for (int j2 = 3; j2 > 0; --j2) {
            this.lastChunkPos[j2] = this.lastChunkPos[j2 - 1];
            this.lastChunkStatus[j2] = this.lastChunkStatus[j2 - 1];
            this.lastChunk[j2] = this.lastChunk[j2 - 1];
        }
        this.lastChunkPos[0] = i2;
        this.lastChunkStatus[0] = chunkstatus;
        this.lastChunk[0] = ichunkaccess;
    }

    @Override
    @Nullable
    public IChunkAccess getChunk(int i2, int j2, ChunkStatus chunkstatus, boolean flag) {
        if (Thread.currentThread() != this.mainThread) {
            return CompletableFuture.supplyAsync(() -> this.getChunk(i2, j2, chunkstatus, flag), this.mainThreadProcessor).join();
        }
        GameProfilerFiller gameprofilerfiller = this.level.getProfiler();
        gameprofilerfiller.incrementCounter("getChunk");
        long k2 = ChunkCoordIntPair.asLong(i2, j2);
        for (int l2 = 0; l2 < 4; ++l2) {
            IChunkAccess ichunkaccess;
            if (k2 != this.lastChunkPos[l2] || chunkstatus != this.lastChunkStatus[l2] || (ichunkaccess = this.lastChunk[l2]) == null) continue;
            return ichunkaccess;
        }
        gameprofilerfiller.incrementCounter("getChunkCacheMiss");
        this.level.timings.syncChunkLoadTimer.startTiming();
        CompletableFuture<ChunkResult<IChunkAccess>> completablefuture = this.getChunkFutureMainThread(i2, j2, chunkstatus, flag);
        b chunkproviderserver_b = this.mainThreadProcessor;
        Objects.requireNonNull(completablefuture);
        chunkproviderserver_b.managedBlock(completablefuture::isDone);
        this.level.timings.syncChunkLoadTimer.stopTiming();
        ChunkResult<IChunkAccess> chunkresult = completablefuture.join();
        IChunkAccess ichunkaccess1 = chunkresult.orElse(null);
        if (ichunkaccess1 == null && flag) {
            throw SystemUtils.pauseInIde(new IllegalStateException("Chunk not there when requested: " + chunkresult.getError()));
        }
        this.storeInCache(k2, ichunkaccess1, chunkstatus);
        return ichunkaccess1;
    }

    @Override
    @Nullable
    public Chunk getChunkNow(int i2, int j2) {
        if (Thread.currentThread() != this.mainThread) {
            return null;
        }
        this.level.getProfiler().incrementCounter("getChunkNow");
        long k2 = ChunkCoordIntPair.asLong(i2, j2);
        for (int l2 = 0; l2 < 4; ++l2) {
            if (k2 != this.lastChunkPos[l2] || this.lastChunkStatus[l2] != ChunkStatus.FULL) continue;
            IChunkAccess ichunkaccess = this.lastChunk[l2];
            return ichunkaccess instanceof Chunk ? (Chunk)ichunkaccess : null;
        }
        PlayerChunk playerchunk = this.getVisibleChunkIfPresent(k2);
        if (playerchunk == null) {
            return null;
        }
        IChunkAccess ichunkaccess = playerchunk.getChunkIfPresent(ChunkStatus.FULL);
        if (ichunkaccess != null) {
            this.storeInCache(k2, ichunkaccess, ChunkStatus.FULL);
            if (ichunkaccess instanceof Chunk) {
                return (Chunk)ichunkaccess;
            }
        }
        return null;
    }

    private void clearCache() {
        Arrays.fill(this.lastChunkPos, ChunkCoordIntPair.INVALID_CHUNK_POS);
        Arrays.fill(this.lastChunkStatus, null);
        Arrays.fill(this.lastChunk, null);
    }

    public CompletableFuture<ChunkResult<IChunkAccess>> getChunkFuture(int i2, int j2, ChunkStatus chunkstatus, boolean flag) {
        CompletionStage<ChunkResult<IChunkAccess>> completablefuture;
        boolean flag1;
        boolean bl = flag1 = Thread.currentThread() == this.mainThread;
        if (flag1) {
            completablefuture = this.getChunkFutureMainThread(i2, j2, chunkstatus, flag);
            b chunkproviderserver_b = this.mainThreadProcessor;
            Objects.requireNonNull(completablefuture);
            chunkproviderserver_b.managedBlock(() -> completablefuture.isDone());
        } else {
            completablefuture = CompletableFuture.supplyAsync(() -> this.getChunkFutureMainThread(i2, j2, chunkstatus, flag), this.mainThreadProcessor).thenCompose(completablefuture1 -> completablefuture1);
        }
        return completablefuture;
    }

    private CompletableFuture<ChunkResult<IChunkAccess>> getChunkFutureMainThread(int i2, int j2, ChunkStatus chunkstatus, boolean flag) {
        ChunkCoordIntPair chunkcoordintpair = new ChunkCoordIntPair(i2, j2);
        long k2 = chunkcoordintpair.toLong();
        int l2 = ChunkLevel.byStatus(chunkstatus);
        PlayerChunk playerchunk = this.getVisibleChunkIfPresent(k2);
        boolean currentlyUnloading = false;
        if (playerchunk != null) {
            FullChunkStatus oldChunkState = ChunkLevel.fullStatus(playerchunk.oldTicketLevel);
            FullChunkStatus currentChunkState = ChunkLevel.fullStatus(playerchunk.getTicketLevel());
            boolean bl = currentlyUnloading = oldChunkState.isOrAfter(FullChunkStatus.FULL) && !currentChunkState.isOrAfter(FullChunkStatus.FULL);
        }
        if (flag && !currentlyUnloading) {
            this.distanceManager.addTicket(TicketType.UNKNOWN, chunkcoordintpair, l2, chunkcoordintpair);
            if (this.chunkAbsent(playerchunk, l2)) {
                GameProfilerFiller gameprofilerfiller = this.level.getProfiler();
                gameprofilerfiller.push("chunkLoad");
                this.runDistanceManagerUpdates();
                playerchunk = this.getVisibleChunkIfPresent(k2);
                gameprofilerfiller.pop();
                if (this.chunkAbsent(playerchunk, l2)) {
                    throw SystemUtils.pauseInIde(new IllegalStateException("No chunk holder after ticket has been added"));
                }
            }
        }
        return this.chunkAbsent(playerchunk, l2) ? GenerationChunkHolder.UNLOADED_CHUNK_FUTURE : playerchunk.scheduleChunkGenerationTask(chunkstatus, this.chunkMap);
    }

    private boolean chunkAbsent(@Nullable PlayerChunk playerchunk, int i2) {
        return playerchunk == null || playerchunk.oldTicketLevel > i2;
    }

    @Override
    public boolean hasChunk(int i2, int j2) {
        int k2;
        PlayerChunk playerchunk = this.getVisibleChunkIfPresent(new ChunkCoordIntPair(i2, j2).toLong());
        return !this.chunkAbsent(playerchunk, k2 = ChunkLevel.byStatus(ChunkStatus.FULL));
    }

    @Override
    @Nullable
    public LightChunk getChunkForLighting(int i2, int j2) {
        long k2 = ChunkCoordIntPair.asLong(i2, j2);
        PlayerChunk playerchunk = this.getVisibleChunkIfPresent(k2);
        return playerchunk == null ? null : playerchunk.getChunkIfPresentUnchecked(ChunkStatus.INITIALIZE_LIGHT.getParent());
    }

    @Override
    public World getLevel() {
        return this.level;
    }

    public boolean pollTask() {
        return this.mainThreadProcessor.pollTask();
    }

    boolean runDistanceManagerUpdates() {
        boolean flag = this.distanceManager.runAllUpdates(this.chunkMap);
        boolean flag1 = this.chunkMap.promoteChunkMap();
        this.chunkMap.runGenerationTasks();
        if (!flag && !flag1) {
            return false;
        }
        this.clearCache();
        return true;
    }

    public boolean isPositionTicking(long i2) {
        PlayerChunk playerchunk = this.getVisibleChunkIfPresent(i2);
        return playerchunk == null ? false : (!this.level.shouldTickBlocksAt(i2) ? false : playerchunk.getTickingChunkFuture().getNow(PlayerChunk.UNLOADED_LEVEL_CHUNK).isSuccess());
    }

    public void save(boolean flag) {
        this.runDistanceManagerUpdates();
        this.chunkMap.saveAllChunks(flag);
    }

    @Override
    public void close() throws IOException {
        this.close(true);
    }

    public void close(boolean save) throws IOException {
        if (save) {
            this.save(true);
        }
        this.lightEngine.close();
        this.chunkMap.close();
    }

    public void purgeUnload() {
        this.level.getProfiler().push("purge");
        this.distanceManager.purgeStaleTickets();
        this.runDistanceManagerUpdates();
        this.level.getProfiler().popPush("unload");
        this.chunkMap.tick(() -> true);
        this.level.getProfiler().pop();
        this.clearCache();
    }

    @Override
    public void tick(BooleanSupplier booleansupplier, boolean flag) {
        this.level.getProfiler().push("purge");
        this.level.timings.doChunkMap.startTiming();
        if (this.level.tickRateManager().runsNormally() || !flag || this.level.spigotConfig.unloadFrozenChunks) {
            this.distanceManager.purgeStaleTickets();
        }
        this.runDistanceManagerUpdates();
        this.level.timings.doChunkMap.stopTiming();
        this.level.getProfiler().popPush("chunks");
        if (flag) {
            this.tickChunks();
            this.level.timings.tracker.startTiming();
            this.chunkMap.tick();
            this.level.timings.tracker.stopTiming();
        }
        this.level.timings.doChunkUnload.startTiming();
        this.level.getProfiler().popPush("unload");
        this.chunkMap.tick(booleansupplier);
        this.level.timings.doChunkUnload.stopTiming();
        this.level.getProfiler().pop();
        this.clearCache();
    }

    private void tickChunks() {
        long i2 = this.level.getGameTime();
        long j2 = i2 - this.lastInhabitedUpdate;
        this.lastInhabitedUpdate = i2;
        if (!this.level.isDebug()) {
            GameProfilerFiller gameprofilerfiller = this.level.getProfiler();
            gameprofilerfiller.push("pollingChunks");
            gameprofilerfiller.push("filteringLoadedChunks");
            ArrayList list = Lists.newArrayListWithCapacity((int)this.chunkMap.size());
            for (PlayerChunk playerchunk : this.chunkMap.getChunks()) {
                Chunk chunk = playerchunk.getTickingChunk();
                if (chunk == null) continue;
                list.add(new a(chunk, playerchunk));
            }
            if (this.level.tickRateManager().runsNormally()) {
                SpawnerCreature.d spawnercreature_d;
                gameprofilerfiller.popPush("naturalSpawnCount");
                int k2 = this.distanceManager.getNaturalSpawnChunkCount();
                this.lastSpawnState = spawnercreature_d = SpawnerCreature.createState(k2, this.level.getAllEntities(), this::getFullChunk, new LocalMobCapCalculator(this.chunkMap));
                gameprofilerfiller.popPush("spawnAndTick");
                boolean flag = this.level.getGameRules().getBoolean(GameRules.RULE_DOMOBSPAWNING) && !this.level.players().isEmpty();
                SystemUtils.shuffle(list, this.level.random);
                int l2 = this.level.getGameRules().getInt(GameRules.RULE_RANDOMTICKING);
                boolean flag1 = this.level.ticksPerSpawnCategory.getLong((Object)SpawnCategory.ANIMAL) != 0L && this.level.getLevelData().getGameTime() % this.level.ticksPerSpawnCategory.getLong((Object)SpawnCategory.ANIMAL) == 0L;
                for (a chunkproviderserver_a : list) {
                    Chunk chunk1 = chunkproviderserver_a.chunk;
                    ChunkCoordIntPair chunkcoordintpair = chunk1.getPos();
                    if (!this.level.isNaturalSpawningAllowed(chunkcoordintpair) || !this.chunkMap.anyPlayerCloseEnoughForSpawning(chunkcoordintpair)) continue;
                    chunk1.incrementInhabitedTime(j2);
                    if (flag && (this.spawnEnemies || this.spawnFriendlies) && this.level.getWorldBorder().isWithinBounds(chunkcoordintpair) && this.chunkMap.anyPlayerCloseEnoughForSpawning(chunkcoordintpair, true)) {
                        SpawnerCreature.spawnForChunk(this.level, chunk1, spawnercreature_d, this.spawnFriendlies, this.spawnEnemies, flag1);
                    }
                    if (!this.level.shouldTickBlocksAt(chunkcoordintpair.toLong())) continue;
                    this.level.timings.doTickTiles.startTiming();
                    this.level.tickChunk(chunk1, l2);
                    this.level.timings.doTickTiles.stopTiming();
                }
                gameprofilerfiller.popPush("customSpawners");
                if (flag) {
                    this.level.tickCustomSpawners(this.spawnEnemies, this.spawnFriendlies);
                }
            }
            gameprofilerfiller.popPush("broadcast");
            list.forEach(chunkproviderserver_a1 -> chunkproviderserver_a1.holder.broadcastChanges(chunkproviderserver_a1.chunk));
            gameprofilerfiller.pop();
            gameprofilerfiller.pop();
        }
    }

    private void getFullChunk(long i2, Consumer<Chunk> consumer) {
        PlayerChunk playerchunk = this.getVisibleChunkIfPresent(i2);
        if (playerchunk != null) {
            playerchunk.getFullChunkFuture().getNow(PlayerChunk.UNLOADED_LEVEL_CHUNK).ifSuccess(consumer);
        }
    }

    @Override
    public String gatherStats() {
        return Integer.toString(this.getLoadedChunksCount());
    }

    @VisibleForTesting
    public int getPendingTasksCount() {
        return this.mainThreadProcessor.getPendingTasksCount();
    }

    public ChunkGenerator getGenerator() {
        return this.chunkMap.generator();
    }

    public ChunkGeneratorStructureState getGeneratorState() {
        return this.chunkMap.generatorState();
    }

    public RandomState randomState() {
        return this.chunkMap.randomState();
    }

    @Override
    public int getLoadedChunksCount() {
        return this.chunkMap.size();
    }

    public void blockChanged(BlockPosition blockposition) {
        int j2;
        int i2 = SectionPosition.blockToSectionCoord(blockposition.getX());
        PlayerChunk playerchunk = this.getVisibleChunkIfPresent(ChunkCoordIntPair.asLong(i2, j2 = SectionPosition.blockToSectionCoord(blockposition.getZ())));
        if (playerchunk != null) {
            playerchunk.blockChanged(blockposition);
        }
    }

    @Override
    public void onLightUpdate(EnumSkyBlock enumskyblock, SectionPosition sectionposition) {
        this.mainThreadProcessor.execute(() -> {
            PlayerChunk playerchunk = this.getVisibleChunkIfPresent(sectionposition.chunk().toLong());
            if (playerchunk != null) {
                playerchunk.sectionLightChanged(enumskyblock, sectionposition.y());
            }
        });
    }

    public <T> void addRegionTicket(TicketType<T> tickettype, ChunkCoordIntPair chunkcoordintpair, int i2, T t0) {
        this.distanceManager.addRegionTicket(tickettype, chunkcoordintpair, i2, t0);
    }

    public <T> void removeRegionTicket(TicketType<T> tickettype, ChunkCoordIntPair chunkcoordintpair, int i2, T t0) {
        this.distanceManager.removeRegionTicket(tickettype, chunkcoordintpair, i2, t0);
    }

    @Override
    public void updateChunkForced(ChunkCoordIntPair chunkcoordintpair, boolean flag) {
        this.distanceManager.updateChunkForced(chunkcoordintpair, flag);
    }

    public void move(EntityPlayer entityplayer) {
        if (!entityplayer.isRemoved()) {
            this.chunkMap.move(entityplayer);
        }
    }

    public void removeEntity(Entity entity) {
        this.chunkMap.removeEntity(entity);
    }

    public void addEntity(Entity entity) {
        this.chunkMap.addEntity(entity);
    }

    public void broadcastAndSend(Entity entity, Packet<?> packet) {
        this.chunkMap.broadcastAndSend(entity, packet);
    }

    public void broadcast(Entity entity, Packet<?> packet) {
        this.chunkMap.broadcast(entity, packet);
    }

    public void setViewDistance(int i2) {
        this.chunkMap.setServerViewDistance(i2);
    }

    public void setSimulationDistance(int i2) {
        this.distanceManager.updateSimulationDistance(i2);
    }

    @Override
    public void setSpawnSettings(boolean flag, boolean flag1) {
        this.spawnEnemies = flag;
        this.spawnFriendlies = flag1;
    }

    public String getChunkDebugData(ChunkCoordIntPair chunkcoordintpair) {
        return this.chunkMap.getChunkDebugData(chunkcoordintpair);
    }

    public WorldPersistentData getDataStorage() {
        return this.dataStorage;
    }

    public VillagePlace getPoiManager() {
        return this.chunkMap.getPoiManager();
    }

    public ChunkScanAccess chunkScanner() {
        return this.chunkMap.chunkScanner();
    }

    @Nullable
    @VisibleForDebug
    public SpawnerCreature.d getLastSpawnState() {
        return this.lastSpawnState;
    }

    public void removeTicketsOnClosing() {
        this.distanceManager.removeTicketsOnClosing();
    }

    private final class b
    extends IAsyncTaskHandler<Runnable> {
        b(World world) {
            super("Chunk source main thread executor for " + String.valueOf(world.dimension().location()));
        }

        @Override
        public void managedBlock(BooleanSupplier booleansupplier) {
            super.managedBlock(() -> MinecraftServer.throwIfFatalException() && booleansupplier.getAsBoolean());
        }

        @Override
        protected Runnable wrapRunnable(Runnable runnable) {
            return runnable;
        }

        @Override
        protected boolean shouldRun(Runnable runnable) {
            return true;
        }

        @Override
        protected boolean scheduleExecutables() {
            return true;
        }

        @Override
        protected Thread getRunningThread() {
            return ChunkProviderServer.this.mainThread;
        }

        @Override
        protected void doRunTask(Runnable runnable) {
            ChunkProviderServer.this.level.getProfiler().incrementCounter("runTask");
            super.doRunTask(runnable);
        }

        @Override
        public boolean pollTask() {
            try {
                if (ChunkProviderServer.this.runDistanceManagerUpdates()) {
                    boolean bl = true;
                    return bl;
                }
                ChunkProviderServer.this.lightEngine.tryScheduleUpdate();
                boolean bl = super.pollTask();
                return bl;
            }
            finally {
                ChunkProviderServer.this.chunkMap.callbackExecutor.run();
            }
        }
    }

    private record a(Chunk chunk, PlayerChunk holder) {
    }
}

