/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.level;

import com.google.common.collect.Lists;
import com.mojang.datafixers.util.Pair;
import com.mojang.logging.LogUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundBundlePacket;
import net.minecraft.network.protocol.game.ClientboundProjectilePowerPacket;
import net.minecraft.network.protocol.game.PacketListenerPlayOut;
import net.minecraft.network.protocol.game.PacketPlayOutAttachEntity;
import net.minecraft.network.protocol.game.PacketPlayOutEntity;
import net.minecraft.network.protocol.game.PacketPlayOutEntityDestroy;
import net.minecraft.network.protocol.game.PacketPlayOutEntityEquipment;
import net.minecraft.network.protocol.game.PacketPlayOutEntityHeadRotation;
import net.minecraft.network.protocol.game.PacketPlayOutEntityMetadata;
import net.minecraft.network.protocol.game.PacketPlayOutEntityTeleport;
import net.minecraft.network.protocol.game.PacketPlayOutEntityVelocity;
import net.minecraft.network.protocol.game.PacketPlayOutMount;
import net.minecraft.network.protocol.game.PacketPlayOutUpdateAttributes;
import net.minecraft.network.protocol.game.VecDeltaCodec;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.server.network.ServerPlayerConnection;
import net.minecraft.util.MathHelper;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EnumItemSlot;
import net.minecraft.world.entity.Leashable;
import net.minecraft.world.entity.ai.attributes.AttributeModifiable;
import net.minecraft.world.entity.decoration.EntityItemFrame;
import net.minecraft.world.entity.projectile.EntityArrow;
import net.minecraft.world.entity.projectile.EntityFireball;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemWorldMap;
import net.minecraft.world.level.World;
import net.minecraft.world.level.saveddata.maps.MapId;
import net.minecraft.world.level.saveddata.maps.WorldMap;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.player.PlayerVelocityEvent;
import org.bukkit.util.Vector;
import org.slf4j.Logger;

public class EntityTrackerEntry {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final int TOLERANCE_LEVEL_ROTATION = 1;
    private static final double TOLERANCE_LEVEL_POSITION = 7.62939453125E-6;
    public static final int FORCED_POS_UPDATE_PERIOD = 60;
    private static final int FORCED_TELEPORT_PERIOD = 400;
    private final WorldServer level;
    private final Entity entity;
    private final int updateInterval;
    private final boolean trackDelta;
    private final Consumer<Packet<?>> broadcast;
    private final VecDeltaCodec positionCodec = new VecDeltaCodec();
    private int lastSentYRot;
    private int lastSentXRot;
    private int lastSentYHeadRot;
    private Vec3D lastSentMovement;
    private int tickCount;
    private int teleportDelay;
    private List<Entity> lastPassengers = Collections.emptyList();
    private boolean wasRiding;
    private boolean wasOnGround;
    @Nullable
    private List<DataWatcher.c<?>> trackedDataValues;
    private final Set<ServerPlayerConnection> trackedPlayers;

    public EntityTrackerEntry(WorldServer worldserver, Entity entity, int i2, boolean flag, Consumer<Packet<?>> consumer, Set<ServerPlayerConnection> trackedPlayers) {
        this.trackedPlayers = trackedPlayers;
        this.level = worldserver;
        this.broadcast = consumer;
        this.entity = entity;
        this.updateInterval = i2;
        this.trackDelta = flag;
        this.positionCodec.setBase(entity.trackingPosition());
        this.lastSentMovement = entity.getDeltaMovement();
        this.lastSentYRot = MathHelper.floor(entity.getYRot() * 256.0f / 360.0f);
        this.lastSentXRot = MathHelper.floor(entity.getXRot() * 256.0f / 360.0f);
        this.lastSentYHeadRot = MathHelper.floor(entity.getYHeadRot() * 256.0f / 360.0f);
        this.wasOnGround = entity.onGround();
        this.trackedDataValues = entity.getEntityData().getNonDefaultValues();
    }

    public void sendChanges() {
        Entity entity2;
        List<Entity> list = this.entity.getPassengers();
        if (!list.equals(this.lastPassengers)) {
            this.broadcastAndSend(new PacketPlayOutMount(this.entity));
            EntityTrackerEntry.removedPassengers(list, this.lastPassengers).forEach(entity -> {
                if (entity instanceof EntityPlayer) {
                    EntityPlayer entityplayer = (EntityPlayer)entity;
                    entityplayer.connection.teleport(entityplayer.getX(), entityplayer.getY(), entityplayer.getZ(), entityplayer.getYRot(), entityplayer.getXRot());
                }
            });
            this.lastPassengers = list;
        }
        if ((entity2 = this.entity) instanceof EntityItemFrame) {
            MapId mapid;
            WorldMap worldmap;
            EntityItemFrame entityitemframe = (EntityItemFrame)entity2;
            ItemStack itemstack = entityitemframe.getItem();
            if (this.tickCount % 10 == 0 && itemstack.getItem() instanceof ItemWorldMap && (worldmap = ItemWorldMap.getSavedData(mapid = itemstack.get(DataComponents.MAP_ID), (World)this.level)) != null) {
                Iterator<ServerPlayerConnection> iterator = this.trackedPlayers.iterator();
                while (iterator.hasNext()) {
                    EntityPlayer entityplayer = iterator.next().getPlayer();
                    worldmap.tickCarriedBy(entityplayer, itemstack);
                    Packet<?> packet = worldmap.getUpdatePacket(mapid, entityplayer);
                    if (packet == null) continue;
                    entityplayer.connection.send(packet);
                }
            }
            this.sendDirtyEntityData();
        }
        if (this.tickCount % this.updateInterval == 0 || this.entity.hasImpulse || this.entity.getEntityData().isDirty()) {
            int i2;
            if (this.entity.isPassenger()) {
                boolean flag;
                i2 = MathHelper.floor(this.entity.getYRot() * 256.0f / 360.0f);
                j = MathHelper.floor(this.entity.getXRot() * 256.0f / 360.0f);
                boolean bl = flag = Math.abs(i2 - this.lastSentYRot) >= 1 || Math.abs(j - this.lastSentXRot) >= 1;
                if (flag) {
                    this.broadcast.accept(new PacketPlayOutEntity.PacketPlayOutEntityLook(this.entity.getId(), (byte)i2, (byte)j, this.entity.onGround()));
                    this.lastSentYRot = i2;
                    this.lastSentXRot = j;
                }
                this.positionCodec.setBase(this.entity.trackingPosition());
                this.sendDirtyEntityData();
                this.wasRiding = true;
            } else {
                Vec3D vec3d1;
                double d0;
                boolean flag6;
                ++this.teleportDelay;
                i2 = MathHelper.floor(this.entity.getYRot() * 256.0f / 360.0f);
                j = MathHelper.floor(this.entity.getXRot() * 256.0f / 360.0f);
                Vec3D vec3d = this.entity.trackingPosition();
                boolean flag1 = this.positionCodec.delta(vec3d).lengthSqr() >= 7.62939453125E-6;
                Packet<PacketListenerPlayOut> packet1 = null;
                boolean flag2 = flag1 || this.tickCount % 60 == 0;
                boolean flag3 = Math.abs(i2 - this.lastSentYRot) >= 1 || Math.abs(j - this.lastSentXRot) >= 1;
                boolean flag4 = false;
                boolean flag5 = false;
                long k2 = this.positionCodec.encodeX(vec3d);
                long l2 = this.positionCodec.encodeY(vec3d);
                long i1 = this.positionCodec.encodeZ(vec3d);
                boolean bl = flag6 = k2 < -32768L || k2 > 32767L || l2 < -32768L || l2 > 32767L || i1 < -32768L || i1 > 32767L;
                if (!flag6 && this.teleportDelay <= 400 && !this.wasRiding && this.wasOnGround == this.entity.onGround()) {
                    if (!(flag2 && flag3 || this.entity instanceof EntityArrow)) {
                        if (flag2) {
                            packet1 = new PacketPlayOutEntity.PacketPlayOutRelEntityMove(this.entity.getId(), (short)k2, (short)l2, (short)i1, this.entity.onGround());
                            flag4 = true;
                        } else if (flag3) {
                            packet1 = new PacketPlayOutEntity.PacketPlayOutEntityLook(this.entity.getId(), (byte)i2, (byte)j, this.entity.onGround());
                            flag5 = true;
                        }
                    } else {
                        packet1 = new PacketPlayOutEntity.PacketPlayOutRelEntityMoveLook(this.entity.getId(), (short)k2, (short)l2, (short)i1, (byte)i2, (byte)j, this.entity.onGround());
                        flag4 = true;
                        flag5 = true;
                    }
                } else {
                    this.wasOnGround = this.entity.onGround();
                    this.teleportDelay = 0;
                    packet1 = new PacketPlayOutEntityTeleport(this.entity);
                    flag4 = true;
                    flag5 = true;
                }
                if ((this.trackDelta || this.entity.hasImpulse || this.entity instanceof EntityLiving && ((EntityLiving)this.entity).isFallFlying()) && this.tickCount > 0 && ((d0 = (vec3d1 = this.entity.getDeltaMovement()).distanceToSqr(this.lastSentMovement)) > 1.0E-7 || d0 > 0.0 && vec3d1.lengthSqr() == 0.0)) {
                    this.lastSentMovement = vec3d1;
                    Entity entity1 = this.entity;
                    if (entity1 instanceof EntityFireball) {
                        EntityFireball entityfireball = (EntityFireball)entity1;
                        this.broadcast.accept(new ClientboundBundlePacket((Iterable<Packet<? super PacketListenerPlayOut>>)List.of(new PacketPlayOutEntityVelocity(this.entity.getId(), this.lastSentMovement), new ClientboundProjectilePowerPacket(entityfireball.getId(), entityfireball.accelerationPower))));
                    } else {
                        this.broadcast.accept(new PacketPlayOutEntityVelocity(this.entity.getId(), this.lastSentMovement));
                    }
                }
                if (packet1 != null) {
                    this.broadcast.accept(packet1);
                }
                this.sendDirtyEntityData();
                if (flag4) {
                    this.positionCodec.setBase(vec3d);
                }
                if (flag5) {
                    this.lastSentYRot = i2;
                    this.lastSentXRot = j;
                }
                this.wasRiding = false;
            }
            i2 = MathHelper.floor(this.entity.getYHeadRot() * 256.0f / 360.0f);
            if (Math.abs(i2 - this.lastSentYHeadRot) >= 1) {
                this.broadcast.accept(new PacketPlayOutEntityHeadRotation(this.entity, (byte)i2));
                this.lastSentYHeadRot = i2;
            }
            this.entity.hasImpulse = false;
        }
        ++this.tickCount;
        if (this.entity.hurtMarked) {
            boolean cancelled = false;
            if (this.entity instanceof EntityPlayer) {
                Player player = (Player)this.entity.getBukkitEntity();
                Vector velocity = player.getVelocity();
                PlayerVelocityEvent event = new PlayerVelocityEvent(player, velocity.clone());
                this.entity.level().getCraftServer().getPluginManager().callEvent((Event)event);
                if (event.isCancelled()) {
                    cancelled = true;
                } else if (!velocity.equals((Object)event.getVelocity())) {
                    player.setVelocity(event.getVelocity());
                }
            }
            if (cancelled) {
                return;
            }
            this.entity.hurtMarked = false;
            this.broadcastAndSend(new PacketPlayOutEntityVelocity(this.entity));
        }
    }

    private static Stream<Entity> removedPassengers(List<Entity> list, List<Entity> list1) {
        return list1.stream().filter(entity -> !list.contains(entity));
    }

    public void removePairing(EntityPlayer entityplayer) {
        this.entity.stopSeenByPlayer(entityplayer);
        entityplayer.connection.send(new PacketPlayOutEntityDestroy(this.entity.getId()));
    }

    public void addPairing(EntityPlayer entityplayer) {
        ArrayList<Packet<? super PacketListenerPlayOut>> list = new ArrayList<Packet<? super PacketListenerPlayOut>>();
        Objects.requireNonNull(list);
        this.sendPairingData(entityplayer, list::add);
        entityplayer.connection.send(new ClientboundBundlePacket((Iterable<Packet<? super PacketListenerPlayOut>>)list));
        this.entity.startSeenByPlayer(entityplayer);
    }

    public void sendPairingData(EntityPlayer entityplayer, Consumer<Packet<PacketListenerPlayOut>> consumer) {
        Leashable leashable;
        Entity entity;
        if (this.entity.isRemoved()) {
            return;
        }
        Packet<PacketListenerPlayOut> packet = this.entity.getAddEntityPacket(this);
        consumer.accept(packet);
        if (this.trackedDataValues != null) {
            consumer.accept(new PacketPlayOutEntityMetadata(this.entity.getId(), this.trackedDataValues));
        }
        boolean flag = this.trackDelta;
        if (this.entity instanceof EntityLiving) {
            Collection<AttributeModifiable> collection = ((EntityLiving)this.entity).getAttributes().getSyncableAttributes();
            if (this.entity.getId() == entityplayer.getId()) {
                ((EntityPlayer)this.entity).getBukkitEntity().injectScaledMaxHealth(collection, false);
            }
            if (!collection.isEmpty()) {
                consumer.accept(new PacketPlayOutUpdateAttributes(this.entity.getId(), collection));
            }
            if (((EntityLiving)this.entity).isFallFlying()) {
                flag = true;
            }
        }
        if (flag && !(this.entity instanceof EntityLiving)) {
            consumer.accept(new PacketPlayOutEntityVelocity(this.entity.getId(), this.lastSentMovement));
        }
        if (this.entity instanceof EntityLiving) {
            ArrayList list = Lists.newArrayList();
            for (EnumItemSlot enumitemslot : EnumItemSlot.values()) {
                ItemStack itemstack = ((EntityLiving)this.entity).getItemBySlot(enumitemslot);
                if (itemstack.isEmpty()) continue;
                list.add(Pair.of((Object)enumitemslot, (Object)itemstack.copy()));
            }
            if (!list.isEmpty()) {
                consumer.accept(new PacketPlayOutEntityEquipment(this.entity.getId(), list));
            }
            ((EntityLiving)this.entity).detectEquipmentUpdatesPublic();
        }
        if (!this.entity.getPassengers().isEmpty()) {
            consumer.accept(new PacketPlayOutMount(this.entity));
        }
        if (this.entity.isPassenger()) {
            consumer.accept(new PacketPlayOutMount(this.entity.getVehicle()));
        }
        if ((entity = this.entity) instanceof Leashable && (leashable = (Leashable)((Object)entity)).isLeashed()) {
            consumer.accept(new PacketPlayOutAttachEntity(this.entity, leashable.getLeashHolder()));
        }
    }

    public Vec3D getPositionBase() {
        return this.positionCodec.getBase();
    }

    public Vec3D getLastSentMovement() {
        return this.lastSentMovement;
    }

    public float getLastSentXRot() {
        return (float)(this.lastSentXRot * 360) / 256.0f;
    }

    public float getLastSentYRot() {
        return (float)(this.lastSentYRot * 360) / 256.0f;
    }

    public float getLastSentYHeadRot() {
        return (float)(this.lastSentYHeadRot * 360) / 256.0f;
    }

    private void sendDirtyEntityData() {
        DataWatcher datawatcher = this.entity.getEntityData();
        List<DataWatcher.c<?>> list = datawatcher.packDirty();
        if (list != null) {
            this.trackedDataValues = datawatcher.getNonDefaultValues();
            this.broadcastAndSend(new PacketPlayOutEntityMetadata(this.entity.getId(), list));
        }
        if (this.entity instanceof EntityLiving) {
            Set<AttributeModifiable> set = ((EntityLiving)this.entity).getAttributes().getAttributesToSync();
            if (!set.isEmpty()) {
                if (this.entity instanceof EntityPlayer) {
                    ((EntityPlayer)this.entity).getBukkitEntity().injectScaledMaxHealth(set, false);
                }
                this.broadcastAndSend(new PacketPlayOutUpdateAttributes(this.entity.getId(), set));
            }
            set.clear();
        }
    }

    private void broadcastAndSend(Packet<?> packet) {
        this.broadcast.accept(packet);
        if (this.entity instanceof EntityPlayer) {
            ((EntityPlayer)this.entity).connection.send(packet);
        }
    }
}

