/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.level;

import it.unimi.dsi.fastutil.shorts.ShortOpenHashSet;
import it.unimi.dsi.fastutil.shorts.ShortSet;
import java.util.BitSet;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.IntConsumer;
import java.util.function.IntSupplier;
import javax.annotation.Nullable;
import net.minecraft.SystemUtils;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.SectionPosition;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.PacketListenerPlayOut;
import net.minecraft.network.protocol.game.PacketPlayOutBlockChange;
import net.minecraft.network.protocol.game.PacketPlayOutLightUpdate;
import net.minecraft.network.protocol.game.PacketPlayOutMultiBlockChange;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ChunkLevel;
import net.minecraft.server.level.ChunkResult;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.FullChunkStatus;
import net.minecraft.server.level.GenerationChunkHolder;
import net.minecraft.server.level.PlayerChunkMap;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.EnumSkyBlock;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.chunk.Chunk;
import net.minecraft.world.level.chunk.ChunkSection;
import net.minecraft.world.level.chunk.IChunkAccess;
import net.minecraft.world.level.chunk.status.ChunkStatus;
import net.minecraft.world.level.lighting.LevelLightEngine;

public class PlayerChunk
extends GenerationChunkHolder {
    public static final ChunkResult<Chunk> UNLOADED_LEVEL_CHUNK = ChunkResult.error("Unloaded level chunk");
    private static final CompletableFuture<ChunkResult<Chunk>> UNLOADED_LEVEL_CHUNK_FUTURE = CompletableFuture.completedFuture(UNLOADED_LEVEL_CHUNK);
    private final LevelHeightAccessor levelHeightAccessor;
    private volatile CompletableFuture<ChunkResult<Chunk>> fullChunkFuture = UNLOADED_LEVEL_CHUNK_FUTURE;
    private volatile CompletableFuture<ChunkResult<Chunk>> tickingChunkFuture = UNLOADED_LEVEL_CHUNK_FUTURE;
    private volatile CompletableFuture<ChunkResult<Chunk>> entityTickingChunkFuture = UNLOADED_LEVEL_CHUNK_FUTURE;
    public int oldTicketLevel;
    private int ticketLevel;
    private int queueLevel;
    private boolean hasChangedSections;
    private final ShortSet[] changedBlocksPerSection;
    private final BitSet blockChangedLightSectionFilter = new BitSet();
    private final BitSet skyChangedLightSectionFilter = new BitSet();
    private final LevelLightEngine lightEngine;
    private final a onLevelChange;
    public final b playerProvider;
    private boolean wasAccessibleSinceLastSave;
    private CompletableFuture<?> pendingFullStateConfirmation = CompletableFuture.completedFuture(null);
    private CompletableFuture<?> sendSync = CompletableFuture.completedFuture(null);
    private CompletableFuture<?> saveSync = CompletableFuture.completedFuture(null);

    public PlayerChunk(ChunkCoordIntPair chunkcoordintpair, int i2, LevelHeightAccessor levelheightaccessor, LevelLightEngine levellightengine, a playerchunk_a, b playerchunk_b) {
        super(chunkcoordintpair);
        this.levelHeightAccessor = levelheightaccessor;
        this.lightEngine = levellightengine;
        this.onLevelChange = playerchunk_a;
        this.playerProvider = playerchunk_b;
        this.ticketLevel = this.oldTicketLevel = ChunkLevel.MAX_LEVEL + 1;
        this.queueLevel = this.oldTicketLevel;
        this.setTicketLevel(i2);
        this.changedBlocksPerSection = new ShortSet[levelheightaccessor.getSectionsCount()];
    }

    public Chunk getFullChunkNow() {
        if (!ChunkLevel.fullStatus(this.oldTicketLevel).isOrAfter(FullChunkStatus.FULL)) {
            return null;
        }
        return this.getFullChunkNowUnchecked();
    }

    public Chunk getFullChunkNowUnchecked() {
        return (Chunk)this.getChunkIfPresentUnchecked(ChunkStatus.FULL);
    }

    public CompletableFuture<ChunkResult<Chunk>> getTickingChunkFuture() {
        return this.tickingChunkFuture;
    }

    public CompletableFuture<ChunkResult<Chunk>> getEntityTickingChunkFuture() {
        return this.entityTickingChunkFuture;
    }

    public CompletableFuture<ChunkResult<Chunk>> getFullChunkFuture() {
        return this.fullChunkFuture;
    }

    @Nullable
    public Chunk getTickingChunk() {
        return this.getTickingChunkFuture().getNow(UNLOADED_LEVEL_CHUNK).orElse(null);
    }

    @Nullable
    public Chunk getChunkToSend() {
        return !this.sendSync.isDone() ? null : this.getTickingChunk();
    }

    public CompletableFuture<?> getSendSyncFuture() {
        return this.sendSync;
    }

    public void addSendDependency(CompletableFuture<?> completablefuture) {
        this.sendSync = this.sendSync.isDone() ? completablefuture : this.sendSync.thenCombine(completablefuture, (object, object1) -> null);
    }

    public CompletableFuture<?> getSaveSyncFuture() {
        return this.saveSync;
    }

    public boolean isReadyForSaving() {
        return this.getGenerationRefCount() == 0 && this.saveSync.isDone();
    }

    private void addSaveDependency(CompletableFuture<?> completablefuture) {
        this.saveSync = this.saveSync.isDone() ? completablefuture : this.saveSync.thenCombine(completablefuture, (object, object1) -> null);
    }

    public void blockChanged(BlockPosition blockposition) {
        Chunk chunk = this.getTickingChunk();
        if (chunk != null) {
            int i2 = this.levelHeightAccessor.getSectionIndex(blockposition.getY());
            if (i2 < 0 || i2 >= this.changedBlocksPerSection.length) {
                return;
            }
            if (this.changedBlocksPerSection[i2] == null) {
                this.hasChangedSections = true;
                this.changedBlocksPerSection[i2] = new ShortOpenHashSet();
            }
            this.changedBlocksPerSection[i2].add(SectionPosition.sectionRelativePos(blockposition));
        }
    }

    public void sectionLightChanged(EnumSkyBlock enumskyblock, int i2) {
        IChunkAccess ichunkaccess = this.getChunkIfPresent(ChunkStatus.INITIALIZE_LIGHT);
        if (ichunkaccess != null) {
            ichunkaccess.setUnsaved(true);
            Chunk chunk = this.getTickingChunk();
            if (chunk != null) {
                int j2 = this.lightEngine.getMinLightSection();
                int k2 = this.lightEngine.getMaxLightSection();
                if (i2 >= j2 && i2 <= k2) {
                    int l2 = i2 - j2;
                    if (enumskyblock == EnumSkyBlock.SKY) {
                        this.skyChangedLightSectionFilter.set(l2);
                    } else {
                        this.blockChangedLightSectionFilter.set(l2);
                    }
                }
            }
        }
    }

    public void broadcastChanges(Chunk chunk) {
        if (this.hasChangedSections || !this.skyChangedLightSectionFilter.isEmpty() || !this.blockChangedLightSectionFilter.isEmpty()) {
            List<EntityPlayer> list;
            World world = chunk.getLevel();
            if (!this.skyChangedLightSectionFilter.isEmpty() || !this.blockChangedLightSectionFilter.isEmpty()) {
                list = this.playerProvider.getPlayers(this.pos, true);
                if (!list.isEmpty()) {
                    PacketPlayOutLightUpdate packetplayoutlightupdate = new PacketPlayOutLightUpdate(chunk.getPos(), this.lightEngine, this.skyChangedLightSectionFilter, this.blockChangedLightSectionFilter);
                    this.broadcast(list, packetplayoutlightupdate);
                }
                this.skyChangedLightSectionFilter.clear();
                this.blockChangedLightSectionFilter.clear();
            }
            if (this.hasChangedSections) {
                list = this.playerProvider.getPlayers(this.pos, false);
                for (int i2 = 0; i2 < this.changedBlocksPerSection.length; ++i2) {
                    ShortSet shortset = this.changedBlocksPerSection[i2];
                    if (shortset == null) continue;
                    this.changedBlocksPerSection[i2] = null;
                    if (list.isEmpty()) continue;
                    int j2 = this.levelHeightAccessor.getSectionYFromSectionIndex(i2);
                    SectionPosition sectionposition = SectionPosition.of(chunk.getPos(), j2);
                    if (shortset.size() == 1) {
                        BlockPosition blockposition = sectionposition.relativeToBlockPos(shortset.iterator().nextShort());
                        IBlockData iblockdata = world.getBlockState(blockposition);
                        this.broadcast(list, new PacketPlayOutBlockChange(blockposition, iblockdata));
                        this.broadcastBlockEntityIfNeeded(list, world, blockposition, iblockdata);
                        continue;
                    }
                    ChunkSection chunksection = chunk.getSection(i2);
                    PacketPlayOutMultiBlockChange packetplayoutmultiblockchange = new PacketPlayOutMultiBlockChange(sectionposition, shortset, chunksection);
                    this.broadcast(list, packetplayoutmultiblockchange);
                    List<EntityPlayer> finalList = list;
                    packetplayoutmultiblockchange.runUpdates((blockposition1, iblockdata1) -> this.broadcastBlockEntityIfNeeded(finalList, world, (BlockPosition)blockposition1, (IBlockData)iblockdata1));
                }
                this.hasChangedSections = false;
            }
        }
    }

    private void broadcastBlockEntityIfNeeded(List<EntityPlayer> list, World world, BlockPosition blockposition, IBlockData iblockdata) {
        if (iblockdata.hasBlockEntity()) {
            this.broadcastBlockEntity(list, world, blockposition);
        }
    }

    private void broadcastBlockEntity(List<EntityPlayer> list, World world, BlockPosition blockposition) {
        Packet<PacketListenerPlayOut> packet;
        TileEntity tileentity = world.getBlockEntity(blockposition);
        if (tileentity != null && (packet = tileentity.getUpdatePacket()) != null) {
            this.broadcast(list, packet);
        }
    }

    private void broadcast(List<EntityPlayer> list, Packet<?> packet) {
        list.forEach(entityplayer -> entityplayer.connection.send(packet));
    }

    @Override
    public int getTicketLevel() {
        return this.ticketLevel;
    }

    @Override
    public int getQueueLevel() {
        return this.queueLevel;
    }

    private void setQueueLevel(int i2) {
        this.queueLevel = i2;
    }

    public void setTicketLevel(int i2) {
        this.ticketLevel = i2;
    }

    private void scheduleFullChunkPromotion(PlayerChunkMap playerchunkmap, CompletableFuture<ChunkResult<Chunk>> completablefuture, Executor executor, FullChunkStatus fullchunkstatus) {
        this.pendingFullStateConfirmation.cancel(false);
        CompletableFuture completablefuture1 = new CompletableFuture();
        completablefuture1.thenRunAsync(() -> playerchunkmap.onFullChunkStatusChange(this.pos, fullchunkstatus), executor);
        this.pendingFullStateConfirmation = completablefuture1;
        completablefuture.thenAccept(chunkresult -> chunkresult.ifSuccess(chunk -> completablefuture1.complete(null)));
    }

    private void demoteFullChunk(PlayerChunkMap playerchunkmap, FullChunkStatus fullchunkstatus) {
        this.pendingFullStateConfirmation.cancel(false);
        playerchunkmap.onFullChunkStatusChange(this.pos, fullchunkstatus);
    }

    protected void callEventIfUnloading(PlayerChunkMap playerchunkmap) {
        FullChunkStatus oldFullChunkStatus = ChunkLevel.fullStatus(this.oldTicketLevel);
        FullChunkStatus newFullChunkStatus = ChunkLevel.fullStatus(this.ticketLevel);
        boolean oldIsFull = oldFullChunkStatus.isOrAfter(FullChunkStatus.FULL);
        boolean newIsFull = newFullChunkStatus.isOrAfter(FullChunkStatus.FULL);
        if (oldIsFull && !newIsFull) {
            ((CompletableFuture)this.getFullChunkFuture().thenAccept(either -> {
                Chunk chunk = either.orElse(null);
                if (chunk != null) {
                    playerchunkmap.callbackExecutor.execute(() -> {
                        chunk.setUnsaved(true);
                        chunk.unloadCallback();
                    });
                }
            })).exceptionally(throwable -> {
                MinecraftServer.LOGGER.error("Failed to schedule unload callback for chunk " + String.valueOf(this.pos), throwable);
                return null;
            });
            playerchunkmap.callbackExecutor.run();
        }
    }

    protected void updateFutures(PlayerChunkMap playerchunkmap, Executor executor) {
        FullChunkStatus fullchunkstatus = ChunkLevel.fullStatus(this.oldTicketLevel);
        FullChunkStatus fullchunkstatus1 = ChunkLevel.fullStatus(this.ticketLevel);
        boolean flag = fullchunkstatus.isOrAfter(FullChunkStatus.FULL);
        boolean flag1 = fullchunkstatus1.isOrAfter(FullChunkStatus.FULL);
        this.wasAccessibleSinceLastSave |= flag1;
        if (!flag && flag1) {
            this.fullChunkFuture = playerchunkmap.prepareAccessibleChunk(this);
            this.scheduleFullChunkPromotion(playerchunkmap, this.fullChunkFuture, executor, FullChunkStatus.FULL);
            this.addSaveDependency(this.fullChunkFuture);
        }
        if (flag && !flag1) {
            this.fullChunkFuture.complete(UNLOADED_LEVEL_CHUNK);
            this.fullChunkFuture = UNLOADED_LEVEL_CHUNK_FUTURE;
        }
        boolean flag2 = fullchunkstatus.isOrAfter(FullChunkStatus.BLOCK_TICKING);
        boolean flag3 = fullchunkstatus1.isOrAfter(FullChunkStatus.BLOCK_TICKING);
        if (!flag2 && flag3) {
            this.tickingChunkFuture = playerchunkmap.prepareTickingChunk(this);
            this.scheduleFullChunkPromotion(playerchunkmap, this.tickingChunkFuture, executor, FullChunkStatus.BLOCK_TICKING);
            this.addSaveDependency(this.tickingChunkFuture);
        }
        if (flag2 && !flag3) {
            this.tickingChunkFuture.complete(UNLOADED_LEVEL_CHUNK);
            this.tickingChunkFuture = UNLOADED_LEVEL_CHUNK_FUTURE;
        }
        boolean flag4 = fullchunkstatus.isOrAfter(FullChunkStatus.ENTITY_TICKING);
        boolean flag5 = fullchunkstatus1.isOrAfter(FullChunkStatus.ENTITY_TICKING);
        if (!flag4 && flag5) {
            if (this.entityTickingChunkFuture != UNLOADED_LEVEL_CHUNK_FUTURE) {
                throw SystemUtils.pauseInIde(new IllegalStateException());
            }
            this.entityTickingChunkFuture = playerchunkmap.prepareEntityTickingChunk(this);
            this.scheduleFullChunkPromotion(playerchunkmap, this.entityTickingChunkFuture, executor, FullChunkStatus.ENTITY_TICKING);
            this.addSaveDependency(this.entityTickingChunkFuture);
        }
        if (flag4 && !flag5) {
            this.entityTickingChunkFuture.complete(UNLOADED_LEVEL_CHUNK);
            this.entityTickingChunkFuture = UNLOADED_LEVEL_CHUNK_FUTURE;
        }
        if (!fullchunkstatus1.isOrAfter(fullchunkstatus)) {
            this.demoteFullChunk(playerchunkmap, fullchunkstatus1);
        }
        this.onLevelChange.onLevelChange(this.pos, this::getQueueLevel, this.ticketLevel, this::setQueueLevel);
        this.oldTicketLevel = this.ticketLevel;
        if (!fullchunkstatus.isOrAfter(FullChunkStatus.FULL) && fullchunkstatus1.isOrAfter(FullChunkStatus.FULL)) {
            ((CompletableFuture)this.getFullChunkFuture().thenAccept(either -> {
                Chunk chunk = either.orElse(null);
                if (chunk != null) {
                    playerchunkmap.callbackExecutor.execute(() -> chunk.loadCallback());
                }
            })).exceptionally(throwable -> {
                MinecraftServer.LOGGER.error("Failed to schedule load callback for chunk " + String.valueOf(this.pos), throwable);
                return null;
            });
            playerchunkmap.callbackExecutor.run();
        }
    }

    public boolean wasAccessibleSinceLastSave() {
        return this.wasAccessibleSinceLastSave;
    }

    public void refreshAccessibility() {
        this.wasAccessibleSinceLastSave = ChunkLevel.fullStatus(this.ticketLevel).isOrAfter(FullChunkStatus.FULL);
    }

    @FunctionalInterface
    public static interface a {
        public void onLevelChange(ChunkCoordIntPair var1, IntSupplier var2, int var3, IntConsumer var4);
    }

    public static interface b {
        public List<EntityPlayer> getPlayers(ChunkCoordIntPair var1, boolean var2);
    }
}

