/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.level;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Queues;
import com.google.common.collect.Sets;
import com.mojang.datafixers.DataFixer;
import com.mojang.logging.LogUtils;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.longs.Long2ByteMap;
import it.unimi.dsi.fastutil.longs.Long2ByteOpenHashMap;
import it.unimi.dsi.fastutil.longs.Long2LongMap;
import it.unimi.dsi.fastutil.longs.Long2LongOpenHashMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectLinkedOpenHashMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.LongIterator;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import it.unimi.dsi.fastutil.longs.LongSet;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import java.io.IOException;
import java.io.Writer;
import java.nio.file.Path;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BooleanSupplier;
import java.util.function.Consumer;
import java.util.function.IntFunction;
import java.util.function.IntSupplier;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.CrashReport;
import net.minecraft.CrashReportSystemDetails;
import net.minecraft.ReportedException;
import net.minecraft.SystemUtils;
import net.minecraft.core.IRegistryCustom;
import net.minecraft.core.SectionPosition;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NbtException;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundChunksBiomesPacket;
import net.minecraft.network.protocol.game.PacketPlayOutViewCentre;
import net.minecraft.server.level.ChunkGenerationTask;
import net.minecraft.server.level.ChunkLevel;
import net.minecraft.server.level.ChunkMapDistance;
import net.minecraft.server.level.ChunkResult;
import net.minecraft.server.level.ChunkTaskQueue;
import net.minecraft.server.level.ChunkTaskQueueSorter;
import net.minecraft.server.level.ChunkTrackingView;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.EntityTrackerEntry;
import net.minecraft.server.level.FullChunkStatus;
import net.minecraft.server.level.GeneratingChunkMap;
import net.minecraft.server.level.GenerationChunkHolder;
import net.minecraft.server.level.LightEngineThreaded;
import net.minecraft.server.level.PlayerChunk;
import net.minecraft.server.level.PlayerMap;
import net.minecraft.server.level.TickingTracker;
import net.minecraft.server.level.WorldServer;
import net.minecraft.server.level.progress.WorldLoadListener;
import net.minecraft.server.network.ServerPlayerConnection;
import net.minecraft.util.CSVWriter;
import net.minecraft.util.MathHelper;
import net.minecraft.util.StaticCache2D;
import net.minecraft.util.profiling.GameProfilerFiller;
import net.minecraft.util.thread.IAsyncTaskHandler;
import net.minecraft.util.thread.Mailbox;
import net.minecraft.util.thread.ThreadedMailbox;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.ai.village.poi.VillagePlace;
import net.minecraft.world.entity.boss.EntityComplexPart;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.chunk.Chunk;
import net.minecraft.world.level.chunk.ChunkConverter;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.chunk.ChunkGeneratorStructureState;
import net.minecraft.world.level.chunk.IChunkAccess;
import net.minecraft.world.level.chunk.ILightAccess;
import net.minecraft.world.level.chunk.ProtoChunk;
import net.minecraft.world.level.chunk.ProtoChunkExtension;
import net.minecraft.world.level.chunk.status.ChunkStatus;
import net.minecraft.world.level.chunk.status.ChunkStep;
import net.minecraft.world.level.chunk.status.ChunkType;
import net.minecraft.world.level.chunk.status.WorldGenContext;
import net.minecraft.world.level.chunk.storage.ChunkRegionLoader;
import net.minecraft.world.level.chunk.storage.IChunkLoader;
import net.minecraft.world.level.chunk.storage.RegionStorageInfo;
import net.minecraft.world.level.entity.ChunkStatusUpdateListener;
import net.minecraft.world.level.levelgen.ChunkGeneratorAbstract;
import net.minecraft.world.level.levelgen.GeneratorSettingBase;
import net.minecraft.world.level.levelgen.RandomState;
import net.minecraft.world.level.levelgen.structure.StructureStart;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplateManager;
import net.minecraft.world.level.storage.Convertable;
import net.minecraft.world.level.storage.WorldPersistentData;
import net.minecraft.world.phys.Vec3D;
import org.apache.commons.lang3.mutable.MutableBoolean;
import org.bukkit.craftbukkit.v1_21_R1.generator.CustomChunkGenerator;
import org.slf4j.Logger;
import org.spigotmc.AsyncCatcher;
import org.spigotmc.TrackingRange;

public class PlayerChunkMap
extends IChunkLoader
implements PlayerChunk.b,
GeneratingChunkMap {
    private static final ChunkResult<List<IChunkAccess>> UNLOADED_CHUNK_LIST_RESULT = ChunkResult.error("Unloaded chunks found in range");
    private static final CompletableFuture<ChunkResult<List<IChunkAccess>>> UNLOADED_CHUNK_LIST_FUTURE = CompletableFuture.completedFuture(UNLOADED_CHUNK_LIST_RESULT);
    private static final byte CHUNK_TYPE_REPLACEABLE = -1;
    private static final byte CHUNK_TYPE_UNKNOWN = 0;
    private static final byte CHUNK_TYPE_FULL = 1;
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final int CHUNK_SAVED_PER_TICK = 200;
    private static final int CHUNK_SAVED_EAGERLY_PER_TICK = 20;
    private static final int EAGER_CHUNK_SAVE_COOLDOWN_IN_MILLIS = 10000;
    public static final int MIN_VIEW_DISTANCE = 2;
    public static final int MAX_VIEW_DISTANCE = 32;
    public static final int FORCED_TICKET_LEVEL = ChunkLevel.byStatus(FullChunkStatus.ENTITY_TICKING);
    public final Long2ObjectLinkedOpenHashMap<PlayerChunk> updatingChunkMap = new Long2ObjectLinkedOpenHashMap();
    public volatile Long2ObjectLinkedOpenHashMap<PlayerChunk> visibleChunkMap;
    private final Long2ObjectLinkedOpenHashMap<PlayerChunk> pendingUnloads;
    private final List<ChunkGenerationTask> pendingGenerationTasks;
    public final WorldServer level;
    private final LightEngineThreaded lightEngine;
    private final IAsyncTaskHandler<Runnable> mainThreadExecutor;
    private final RandomState randomState;
    private final ChunkGeneratorStructureState chunkGeneratorState;
    private final Supplier<WorldPersistentData> overworldDataStorage;
    private final VillagePlace poiManager;
    public final LongSet toDrop;
    private boolean modified;
    private final ChunkTaskQueueSorter queueSorter;
    private final Mailbox<ChunkTaskQueueSorter.a<Runnable>> worldgenMailbox;
    private final Mailbox<ChunkTaskQueueSorter.a<Runnable>> mainThreadMailbox;
    public final WorldLoadListener progressListener;
    private final ChunkStatusUpdateListener chunkStatusListener;
    public final a distanceManager;
    private final AtomicInteger tickingGenerated;
    private final String storageName;
    private final PlayerMap playerMap;
    public final Int2ObjectMap<EntityTracker> entityMap;
    private final Long2ByteMap chunkTypeCache;
    private final Long2LongMap chunkSaveCooldowns;
    private final Queue<Runnable> unloadQueue;
    public int serverViewDistance;
    private final WorldGenContext worldGenContext;
    public final CallbackExecutor callbackExecutor = new CallbackExecutor();

    public PlayerChunkMap(WorldServer worldserver, Convertable.ConversionSession convertable_conversionsession, DataFixer datafixer, StructureTemplateManager structuretemplatemanager, Executor executor, IAsyncTaskHandler<Runnable> iasynctaskhandler, ILightAccess ilightaccess, ChunkGenerator chunkgenerator, WorldLoadListener worldloadlistener, ChunkStatusUpdateListener chunkstatusupdatelistener, Supplier<WorldPersistentData> supplier, int i2, boolean flag) {
        super(new RegionStorageInfo(convertable_conversionsession.getLevelId(), worldserver.dimension(), "chunk"), convertable_conversionsession.getDimensionPath(worldserver.dimension()).resolve("region"), datafixer, flag);
        this.visibleChunkMap = this.updatingChunkMap.clone();
        this.pendingUnloads = new Long2ObjectLinkedOpenHashMap();
        this.pendingGenerationTasks = new ArrayList<ChunkGenerationTask>();
        this.toDrop = new LongOpenHashSet();
        this.tickingGenerated = new AtomicInteger();
        this.playerMap = new PlayerMap();
        this.entityMap = new Int2ObjectOpenHashMap();
        this.chunkTypeCache = new Long2ByteOpenHashMap();
        this.chunkSaveCooldowns = new Long2LongOpenHashMap();
        this.unloadQueue = Queues.newConcurrentLinkedQueue();
        Path path = convertable_conversionsession.getDimensionPath(worldserver.dimension());
        this.storageName = path.getFileName().toString();
        this.level = worldserver;
        IRegistryCustom iregistrycustom = worldserver.registryAccess();
        long j2 = worldserver.getSeed();
        ChunkGenerator randomGenerator = chunkgenerator;
        if (randomGenerator instanceof CustomChunkGenerator) {
            CustomChunkGenerator customChunkGenerator = (CustomChunkGenerator)randomGenerator;
            randomGenerator = customChunkGenerator.getDelegate();
        }
        if (randomGenerator instanceof ChunkGeneratorAbstract) {
            ChunkGeneratorAbstract chunkgeneratorabstract = (ChunkGeneratorAbstract)randomGenerator;
            this.randomState = RandomState.create(chunkgeneratorabstract.generatorSettings().value(), iregistrycustom.lookupOrThrow(Registries.NOISE), j2);
        } else {
            this.randomState = RandomState.create(GeneratorSettingBase.dummy(), iregistrycustom.lookupOrThrow(Registries.NOISE), j2);
        }
        this.chunkGeneratorState = chunkgenerator.createState(iregistrycustom.lookupOrThrow(Registries.STRUCTURE_SET), this.randomState, j2, worldserver.spigotConfig);
        this.mainThreadExecutor = iasynctaskhandler;
        ThreadedMailbox<Runnable> threadedmailbox = ThreadedMailbox.create(executor, "worldgen");
        Objects.requireNonNull(iasynctaskhandler);
        Mailbox<Runnable> mailbox = Mailbox.of("main", iasynctaskhandler::tell);
        this.progressListener = worldloadlistener;
        this.chunkStatusListener = chunkstatusupdatelistener;
        ThreadedMailbox<Runnable> threadedmailbox1 = ThreadedMailbox.create(executor, "light");
        this.queueSorter = new ChunkTaskQueueSorter((List<Mailbox<?>>)ImmutableList.of(threadedmailbox, mailbox, threadedmailbox1), executor, Integer.MAX_VALUE);
        this.worldgenMailbox = this.queueSorter.getProcessor(threadedmailbox, false);
        this.mainThreadMailbox = this.queueSorter.getProcessor(mailbox, false);
        this.lightEngine = new LightEngineThreaded(ilightaccess, this, this.level.dimensionType().hasSkyLight(), threadedmailbox1, this.queueSorter.getProcessor(threadedmailbox1, false));
        this.distanceManager = new a(executor, iasynctaskhandler);
        this.overworldDataStorage = supplier;
        this.poiManager = new VillagePlace(new RegionStorageInfo(convertable_conversionsession.getLevelId(), worldserver.dimension(), "poi"), path.resolve("poi"), datafixer, flag, iregistrycustom, worldserver.getServer(), worldserver);
        this.setServerViewDistance(i2);
        this.worldGenContext = new WorldGenContext(worldserver, chunkgenerator, structuretemplatemanager, this.lightEngine, this.mainThreadMailbox);
    }

    protected ChunkGenerator generator() {
        return this.worldGenContext.generator();
    }

    protected ChunkGeneratorStructureState generatorState() {
        return this.chunkGeneratorState;
    }

    protected RandomState randomState() {
        return this.randomState;
    }

    private static double euclideanDistanceSquared(ChunkCoordIntPair chunkcoordintpair, Entity entity) {
        double d0 = SectionPosition.sectionToBlockCoord(chunkcoordintpair.x, 8);
        double d1 = SectionPosition.sectionToBlockCoord(chunkcoordintpair.z, 8);
        double d2 = d0 - entity.getX();
        double d3 = d1 - entity.getZ();
        return d2 * d2 + d3 * d3;
    }

    boolean isChunkTracked(EntityPlayer entityplayer, int i2, int j2) {
        return entityplayer.getChunkTrackingView().contains(i2, j2) && !entityplayer.connection.chunkSender.isPending(ChunkCoordIntPair.asLong(i2, j2));
    }

    private boolean isChunkOnTrackedBorder(EntityPlayer entityplayer, int i2, int j2) {
        if (!this.isChunkTracked(entityplayer, i2, j2)) {
            return false;
        }
        for (int k2 = -1; k2 <= 1; ++k2) {
            for (int l2 = -1; l2 <= 1; ++l2) {
                if (k2 == 0 && l2 == 0 || this.isChunkTracked(entityplayer, i2 + k2, j2 + l2)) continue;
                return true;
            }
        }
        return false;
    }

    protected LightEngineThreaded getLightEngine() {
        return this.lightEngine;
    }

    @Nullable
    protected PlayerChunk getUpdatingChunkIfPresent(long i2) {
        return (PlayerChunk)this.updatingChunkMap.get(i2);
    }

    @Nullable
    protected PlayerChunk getVisibleChunkIfPresent(long i2) {
        return (PlayerChunk)this.visibleChunkMap.get(i2);
    }

    protected IntSupplier getChunkQueueLevel(long i2) {
        return () -> {
            PlayerChunk playerchunk = this.getVisibleChunkIfPresent(i2);
            return playerchunk == null ? ChunkTaskQueue.PRIORITY_LEVEL_COUNT - 1 : Math.min(playerchunk.getQueueLevel(), ChunkTaskQueue.PRIORITY_LEVEL_COUNT - 1);
        };
    }

    public String getChunkDebugData(ChunkCoordIntPair chunkcoordintpair) {
        PlayerChunk playerchunk = this.getVisibleChunkIfPresent(chunkcoordintpair.toLong());
        if (playerchunk == null) {
            return "null";
        }
        String s2 = playerchunk.getTicketLevel() + "\n";
        ChunkStatus chunkstatus = playerchunk.getLatestStatus();
        IChunkAccess ichunkaccess = playerchunk.getLatestChunk();
        if (chunkstatus != null) {
            s2 = s2 + "St: \u00a7" + chunkstatus.getIndex() + String.valueOf(chunkstatus) + "\u00a7r\n";
        }
        if (ichunkaccess != null) {
            s2 = s2 + "Ch: \u00a7" + ichunkaccess.getPersistedStatus().getIndex() + String.valueOf(ichunkaccess.getPersistedStatus()) + "\u00a7r\n";
        }
        FullChunkStatus fullchunkstatus = playerchunk.getFullStatus();
        s2 = s2 + String.valueOf('\u00a7') + fullchunkstatus.ordinal() + String.valueOf((Object)fullchunkstatus);
        return s2 + "\u00a7r";
    }

    private CompletableFuture<ChunkResult<List<IChunkAccess>>> getChunkRangeFuture(PlayerChunk playerchunk, int i2, IntFunction<ChunkStatus> intfunction) {
        if (i2 == 0) {
            ChunkStatus chunkstatus = intfunction.apply(0);
            return playerchunk.scheduleChunkGenerationTask(chunkstatus, this).thenApply(chunkresult -> chunkresult.map(List::of));
        }
        ArrayList<CompletableFuture<ChunkResult<IChunkAccess>>> list = new ArrayList<CompletableFuture<ChunkResult<IChunkAccess>>>();
        ChunkCoordIntPair chunkcoordintpair = playerchunk.getPos();
        for (int j2 = -i2; j2 <= i2; ++j2) {
            for (int k2 = -i2; k2 <= i2; ++k2) {
                int l2 = Math.max(Math.abs(k2), Math.abs(j2));
                long i1 = ChunkCoordIntPair.asLong(chunkcoordintpair.x + k2, chunkcoordintpair.z + j2);
                PlayerChunk playerchunk1 = this.getUpdatingChunkIfPresent(i1);
                if (playerchunk1 == null) {
                    return UNLOADED_CHUNK_LIST_FUTURE;
                }
                ChunkStatus chunkstatus1 = intfunction.apply(l2);
                list.add(playerchunk1.scheduleChunkGenerationTask(chunkstatus1, this));
            }
        }
        return SystemUtils.sequence(list).thenApply(list1 -> {
            ArrayList list2 = Lists.newArrayList();
            for (ChunkResult chunkresult : list1) {
                if (chunkresult == null) {
                    throw this.debugFuturesAndCreateReportedException(new IllegalStateException("At least one of the chunk futures were null"), "n/a");
                }
                IChunkAccess ichunkaccess = chunkresult.orElse(null);
                if (ichunkaccess == null) {
                    return UNLOADED_CHUNK_LIST_RESULT;
                }
                list2.add(ichunkaccess);
            }
            return ChunkResult.of(list2);
        });
    }

    public ReportedException debugFuturesAndCreateReportedException(IllegalStateException illegalstateexception, String s2) {
        StringBuilder stringbuilder = new StringBuilder();
        Consumer<PlayerChunk> consumer = playerchunk -> playerchunk.getAllFutures().forEach(pair -> {
            ChunkStatus chunkstatus = (ChunkStatus)pair.getFirst();
            CompletableFuture completablefuture = (CompletableFuture)pair.getSecond();
            if (completablefuture != null && completablefuture.isDone() && completablefuture.join() == null) {
                stringbuilder.append(playerchunk.getPos()).append(" - status: ").append(chunkstatus).append(" future: ").append(completablefuture).append(System.lineSeparator());
            }
        });
        stringbuilder.append("Updating:").append(System.lineSeparator());
        this.updatingChunkMap.values().forEach(consumer);
        stringbuilder.append("Visible:").append(System.lineSeparator());
        this.visibleChunkMap.values().forEach(consumer);
        CrashReport crashreport = CrashReport.forThrowable(illegalstateexception, "Chunk loading");
        CrashReportSystemDetails crashreportsystemdetails = crashreport.addCategory("Chunk loading");
        crashreportsystemdetails.setDetail("Details", s2);
        crashreportsystemdetails.setDetail("Futures", stringbuilder);
        return new ReportedException(crashreport);
    }

    public CompletableFuture<ChunkResult<Chunk>> prepareEntityTickingChunk(PlayerChunk playerchunk) {
        return this.getChunkRangeFuture(playerchunk, 2, i2 -> ChunkStatus.FULL).thenApplyAsync(chunkresult -> chunkresult.map(list -> (Chunk)list.get(list.size() / 2)), (Executor)this.mainThreadExecutor);
    }

    @Nullable
    PlayerChunk updateChunkScheduling(long i2, int j2, @Nullable PlayerChunk playerchunk, int k2) {
        if (!ChunkLevel.isLoaded(k2) && !ChunkLevel.isLoaded(j2)) {
            return playerchunk;
        }
        if (playerchunk != null) {
            playerchunk.setTicketLevel(j2);
        }
        if (playerchunk != null) {
            if (!ChunkLevel.isLoaded(j2)) {
                this.toDrop.add(i2);
            } else {
                this.toDrop.remove(i2);
            }
        }
        if (ChunkLevel.isLoaded(j2) && playerchunk == null) {
            playerchunk = (PlayerChunk)this.pendingUnloads.remove(i2);
            if (playerchunk != null) {
                playerchunk.setTicketLevel(j2);
            } else {
                playerchunk = new PlayerChunk(new ChunkCoordIntPair(i2), j2, this.level, this.lightEngine, this.queueSorter, this);
            }
            this.updatingChunkMap.put(i2, (Object)playerchunk);
            this.modified = true;
        }
        return playerchunk;
    }

    @Override
    public void close() throws IOException {
        try {
            this.queueSorter.close();
            this.poiManager.close();
        }
        finally {
            super.close();
        }
    }

    protected void saveAllChunks(boolean flag) {
        if (flag) {
            List<PlayerChunk> list = this.visibleChunkMap.values().stream().filter(PlayerChunk::wasAccessibleSinceLastSave).peek(PlayerChunk::refreshAccessibility).toList();
            MutableBoolean mutableboolean = new MutableBoolean();
            do {
                mutableboolean.setFalse();
                list.stream().map(playerchunk -> {
                    IAsyncTaskHandler<Runnable> iasynctaskhandler = this.mainThreadExecutor;
                    Objects.requireNonNull(playerchunk);
                    iasynctaskhandler.managedBlock(playerchunk::isReadyForSaving);
                    return playerchunk.getLatestChunk();
                }).filter(ichunkaccess -> ichunkaccess instanceof ProtoChunkExtension || ichunkaccess instanceof Chunk).filter(this::save).forEach(ichunkaccess -> mutableboolean.setTrue());
            } while (mutableboolean.isTrue());
            this.processUnloads(() -> true);
            this.flushWorker();
        } else {
            this.visibleChunkMap.values().forEach(this::saveChunkIfNeeded);
        }
    }

    protected void tick(BooleanSupplier booleansupplier) {
        GameProfilerFiller gameprofilerfiller = this.level.getProfiler();
        gameprofilerfiller.push("poi");
        this.poiManager.tick(booleansupplier);
        gameprofilerfiller.popPush("chunk_unload");
        if (!this.level.noSave()) {
            this.processUnloads(booleansupplier);
        }
        gameprofilerfiller.pop();
    }

    public boolean hasWork() {
        return this.lightEngine.hasLightWork() || !this.pendingUnloads.isEmpty() || !this.updatingChunkMap.isEmpty() || this.poiManager.hasWork() || !this.toDrop.isEmpty() || !this.unloadQueue.isEmpty() || this.queueSorter.hasWork() || this.distanceManager.hasTickets();
    }

    private void processUnloads(BooleanSupplier booleansupplier) {
        Runnable runnable;
        LongIterator longiterator = this.toDrop.iterator();
        int i2 = 0;
        while (longiterator.hasNext() && (booleansupplier.getAsBoolean() || i2 < 200 || this.toDrop.size() > 2000)) {
            long j2 = longiterator.nextLong();
            PlayerChunk playerchunk = (PlayerChunk)this.updatingChunkMap.get(j2);
            if (playerchunk != null) {
                if (playerchunk.getGenerationRefCount() != 0) continue;
                this.updatingChunkMap.remove(j2);
                this.pendingUnloads.put(j2, (Object)playerchunk);
                this.modified = true;
                ++i2;
                this.scheduleUnload(j2, playerchunk);
            }
            longiterator.remove();
        }
        for (int k2 = Math.max(0, this.unloadQueue.size() - 2000); (booleansupplier.getAsBoolean() || k2 > 0) && (runnable = this.unloadQueue.poll()) != null; --k2) {
            runnable.run();
        }
        int l2 = 0;
        ObjectIterator objectiterator = this.visibleChunkMap.values().iterator();
        while (l2 < 20 && booleansupplier.getAsBoolean() && objectiterator.hasNext()) {
            if (!this.saveChunkIfNeeded((PlayerChunk)objectiterator.next())) continue;
            ++l2;
        }
    }

    private void scheduleUnload(long i2, PlayerChunk playerchunk) {
        CompletableFuture<?> completablefuture = playerchunk.getSaveSyncFuture();
        Runnable runnable = () -> {
            if (!playerchunk.isReadyForSaving()) {
                this.scheduleUnload(i2, playerchunk);
            } else {
                IChunkAccess ichunkaccess = playerchunk.getLatestChunk();
                if (this.pendingUnloads.remove(i2, (Object)playerchunk) && ichunkaccess != null) {
                    Chunk chunk;
                    if (ichunkaccess instanceof Chunk) {
                        chunk = (Chunk)ichunkaccess;
                        chunk.setLoaded(false);
                    }
                    this.save(ichunkaccess);
                    if (ichunkaccess instanceof Chunk) {
                        chunk = (Chunk)ichunkaccess;
                        this.level.unload(chunk);
                    }
                    this.lightEngine.updateChunkStatus(ichunkaccess.getPos());
                    this.lightEngine.tryScheduleUpdate();
                    this.progressListener.onStatusChange(ichunkaccess.getPos(), null);
                    this.chunkSaveCooldowns.remove(ichunkaccess.getPos().toLong());
                }
            }
        };
        Queue<Runnable> queue = this.unloadQueue;
        Objects.requireNonNull(this.unloadQueue);
        ((CompletableFuture)completablefuture.thenRunAsync(runnable, queue::add)).whenComplete((ovoid, throwable) -> {
            if (throwable != null) {
                LOGGER.error("Failed to save chunk {}", (Object)playerchunk.getPos(), throwable);
            }
        });
    }

    protected boolean promoteChunkMap() {
        if (!this.modified) {
            return false;
        }
        this.visibleChunkMap = this.updatingChunkMap.clone();
        this.modified = false;
        return true;
    }

    private CompletableFuture<IChunkAccess> scheduleChunkLoad(ChunkCoordIntPair chunkcoordintpair) {
        return ((CompletableFuture)((CompletableFuture)this.readChunk(chunkcoordintpair).thenApply(optional -> optional.filter(nbttagcompound -> {
            boolean flag = PlayerChunkMap.isChunkDataValid(nbttagcompound);
            if (!flag) {
                LOGGER.error("Chunk file at {} is missing level data, skipping", (Object)chunkcoordintpair);
            }
            return flag;
        }))).thenApplyAsync(optional -> {
            this.level.getProfiler().incrementCounter("chunkLoad");
            if (optional.isPresent()) {
                ProtoChunk protochunk = ChunkRegionLoader.read(this.level, this.poiManager, this.storageInfo(), chunkcoordintpair, (NBTTagCompound)optional.get());
                this.markPosition(chunkcoordintpair, protochunk.getPersistedStatus().getChunkType());
                return protochunk;
            }
            return this.createEmptyChunk(chunkcoordintpair);
        }, (Executor)this.mainThreadExecutor)).exceptionallyAsync(throwable -> this.handleChunkLoadFailure((Throwable)throwable, chunkcoordintpair), (Executor)this.mainThreadExecutor);
    }

    private static boolean isChunkDataValid(NBTTagCompound nbttagcompound) {
        return nbttagcompound.contains("Status", 8);
    }

    private IChunkAccess handleChunkLoadFailure(Throwable throwable, ChunkCoordIntPair chunkcoordintpair) {
        boolean flag1;
        Throwable throwable1;
        if (throwable instanceof CompletionException) {
            CompletionException completionexception = (CompletionException)throwable;
            throwable1 = completionexception.getCause();
        } else {
            throwable1 = throwable;
        }
        Throwable throwable2 = throwable1;
        if (throwable2 instanceof ReportedException) {
            ReportedException reportedexception = (ReportedException)throwable2;
            throwable1 = reportedexception.getCause();
        } else {
            throwable1 = throwable2;
        }
        Throwable throwable3 = throwable1;
        boolean flag = throwable3 instanceof Error;
        boolean bl = flag1 = throwable3 instanceof IOException || throwable3 instanceof NbtException;
        if (!flag) {
            if (!flag1) {
                // empty if block
            }
            this.level.getServer().reportChunkLoadFailure(throwable3, this.storageInfo(), chunkcoordintpair);
            return this.createEmptyChunk(chunkcoordintpair);
        }
        CrashReport crashreport = CrashReport.forThrowable(throwable, "Exception loading chunk");
        CrashReportSystemDetails crashreportsystemdetails = crashreport.addCategory("Chunk being loaded");
        crashreportsystemdetails.setDetail("pos", chunkcoordintpair);
        this.markPositionReplaceable(chunkcoordintpair);
        throw new ReportedException(crashreport);
    }

    private IChunkAccess createEmptyChunk(ChunkCoordIntPair chunkcoordintpair) {
        this.markPositionReplaceable(chunkcoordintpair);
        return new ProtoChunk(chunkcoordintpair, ChunkConverter.EMPTY, this.level, this.level.registryAccess().registryOrThrow(Registries.BIOME), null);
    }

    private void markPositionReplaceable(ChunkCoordIntPair chunkcoordintpair) {
        this.chunkTypeCache.put(chunkcoordintpair.toLong(), (byte)-1);
    }

    private byte markPosition(ChunkCoordIntPair chunkcoordintpair, ChunkType chunktype) {
        return this.chunkTypeCache.put(chunkcoordintpair.toLong(), (byte)(chunktype == ChunkType.PROTOCHUNK ? -1 : 1));
    }

    @Override
    public GenerationChunkHolder acquireGeneration(long i2) {
        PlayerChunk playerchunk = (PlayerChunk)this.updatingChunkMap.get(i2);
        playerchunk.increaseGenerationRefCount();
        return playerchunk;
    }

    @Override
    public void releaseGeneration(GenerationChunkHolder generationchunkholder) {
        generationchunkholder.decreaseGenerationRefCount();
    }

    @Override
    public CompletableFuture<IChunkAccess> applyStep(GenerationChunkHolder generationchunkholder, ChunkStep chunkstep, StaticCache2D<GenerationChunkHolder> staticcache2d) {
        ChunkCoordIntPair chunkcoordintpair = generationchunkholder.getPos();
        if (chunkstep.targetStatus() == ChunkStatus.EMPTY) {
            return this.scheduleChunkLoad(chunkcoordintpair);
        }
        try {
            GenerationChunkHolder generationchunkholder1 = staticcache2d.get(chunkcoordintpair.x, chunkcoordintpair.z);
            IChunkAccess ichunkaccess = generationchunkholder1.getChunkIfPresentUnchecked(chunkstep.targetStatus().getParent());
            if (ichunkaccess == null) {
                throw new IllegalStateException("Parent chunk missing");
            }
            CompletableFuture<IChunkAccess> completablefuture = chunkstep.apply(this.worldGenContext, staticcache2d, ichunkaccess);
            this.progressListener.onStatusChange(chunkcoordintpair, chunkstep.targetStatus());
            return completablefuture;
        }
        catch (Exception exception) {
            exception.getStackTrace();
            CrashReport crashreport = CrashReport.forThrowable(exception, "Exception generating new chunk");
            CrashReportSystemDetails crashreportsystemdetails = crashreport.addCategory("Chunk to be generated");
            crashreportsystemdetails.setDetail("Status being generated", () -> chunkstep.targetStatus().getName());
            crashreportsystemdetails.setDetail("Location", String.format(Locale.ROOT, "%d,%d", chunkcoordintpair.x, chunkcoordintpair.z));
            crashreportsystemdetails.setDetail("Position hash", ChunkCoordIntPair.asLong(chunkcoordintpair.x, chunkcoordintpair.z));
            crashreportsystemdetails.setDetail("Generator", this.generator());
            this.mainThreadExecutor.execute(() -> {
                throw new ReportedException(crashreport);
            });
            throw new ReportedException(crashreport);
        }
    }

    @Override
    public ChunkGenerationTask scheduleGenerationTask(ChunkStatus chunkstatus, ChunkCoordIntPair chunkcoordintpair) {
        ChunkGenerationTask chunkgenerationtask = ChunkGenerationTask.create(this, chunkstatus, chunkcoordintpair);
        this.pendingGenerationTasks.add(chunkgenerationtask);
        return chunkgenerationtask;
    }

    private void runGenerationTask(ChunkGenerationTask chunkgenerationtask) {
        this.worldgenMailbox.tell(ChunkTaskQueueSorter.message(chunkgenerationtask.getCenter(), () -> {
            CompletableFuture<?> completablefuture = chunkgenerationtask.runUntilWait();
            if (completablefuture != null) {
                completablefuture.thenRun(() -> this.runGenerationTask(chunkgenerationtask));
            }
        }));
    }

    @Override
    public void runGenerationTasks() {
        this.pendingGenerationTasks.forEach(this::runGenerationTask);
        this.pendingGenerationTasks.clear();
    }

    public CompletableFuture<ChunkResult<Chunk>> prepareTickingChunk(PlayerChunk playerchunk) {
        CompletableFuture<ChunkResult<List<IChunkAccess>>> completablefuture = this.getChunkRangeFuture(playerchunk, 1, i2 -> ChunkStatus.FULL);
        CompletionStage completablefuture1 = ((CompletableFuture)completablefuture.thenApplyAsync(chunkresult -> chunkresult.map(list -> (Chunk)list.get(list.size() / 2)), runnable -> this.mainThreadMailbox.tell(ChunkTaskQueueSorter.message((GenerationChunkHolder)playerchunk, runnable)))).thenApplyAsync(chunkresult -> chunkresult.ifSuccess(chunk -> {
            chunk.postProcessGeneration();
            this.level.startTickingChunk((Chunk)chunk);
            CompletableFuture<?> completablefuture2 = playerchunk.getSendSyncFuture();
            if (completablefuture2.isDone()) {
                this.onChunkReadyToSend((Chunk)chunk);
            } else {
                completablefuture2.thenAcceptAsync(object -> this.onChunkReadyToSend((Chunk)chunk), (Executor)this.mainThreadExecutor);
            }
        }), (Executor)this.mainThreadExecutor);
        ((CompletableFuture)completablefuture1).handle((chunkresult, throwable) -> {
            this.tickingGenerated.getAndIncrement();
            return null;
        });
        return completablefuture1;
    }

    private void onChunkReadyToSend(Chunk chunk) {
        ChunkCoordIntPair chunkcoordintpair = chunk.getPos();
        for (EntityPlayer entityplayer : this.playerMap.getAllPlayers()) {
            if (!entityplayer.getChunkTrackingView().contains(chunkcoordintpair)) continue;
            PlayerChunkMap.markChunkPendingToSend(entityplayer, chunk);
        }
    }

    public CompletableFuture<ChunkResult<Chunk>> prepareAccessibleChunk(PlayerChunk playerchunk) {
        return this.getChunkRangeFuture(playerchunk, 1, ChunkLevel::getStatusAroundFullChunk).thenApplyAsync(chunkresult -> chunkresult.map(list -> (Chunk)list.get(list.size() / 2)), runnable -> this.mainThreadMailbox.tell(ChunkTaskQueueSorter.message((GenerationChunkHolder)playerchunk, runnable)));
    }

    public int getTickingGenerated() {
        return this.tickingGenerated.get();
    }

    private boolean saveChunkIfNeeded(PlayerChunk playerchunk) {
        if (playerchunk.wasAccessibleSinceLastSave() && playerchunk.isReadyForSaving()) {
            IChunkAccess ichunkaccess = playerchunk.getLatestChunk();
            if (!(ichunkaccess instanceof ProtoChunkExtension) && !(ichunkaccess instanceof Chunk)) {
                return false;
            }
            long i2 = ichunkaccess.getPos().toLong();
            long j2 = this.chunkSaveCooldowns.getOrDefault(i2, -1L);
            long k2 = System.currentTimeMillis();
            if (k2 < j2) {
                return false;
            }
            boolean flag = this.save(ichunkaccess);
            playerchunk.refreshAccessibility();
            if (flag) {
                this.chunkSaveCooldowns.put(i2, k2 + 10000L);
            }
            return flag;
        }
        return false;
    }

    public boolean save(IChunkAccess ichunkaccess) {
        this.poiManager.flush(ichunkaccess.getPos());
        if (!ichunkaccess.isUnsaved()) {
            return false;
        }
        ichunkaccess.setUnsaved(false);
        ChunkCoordIntPair chunkcoordintpair = ichunkaccess.getPos();
        try {
            ChunkStatus chunkstatus = ichunkaccess.getPersistedStatus();
            if (chunkstatus.getChunkType() != ChunkType.LEVELCHUNK) {
                if (this.isExistingChunkFull(chunkcoordintpair)) {
                    return false;
                }
                if (chunkstatus == ChunkStatus.EMPTY && ichunkaccess.getAllStarts().values().stream().noneMatch(StructureStart::isValid)) {
                    return false;
                }
            }
            this.level.getProfiler().incrementCounter("chunkSave");
            NBTTagCompound nbttagcompound = ChunkRegionLoader.write(this.level, ichunkaccess);
            this.write(chunkcoordintpair, nbttagcompound).exceptionally(throwable -> {
                this.level.getServer().reportChunkSaveFailure((Throwable)throwable, this.storageInfo(), chunkcoordintpair);
                return null;
            });
            this.markPosition(chunkcoordintpair, chunkstatus.getChunkType());
            return true;
        }
        catch (Exception exception) {
            this.level.getServer().reportChunkSaveFailure(exception, this.storageInfo(), chunkcoordintpair);
            return false;
        }
    }

    private boolean isExistingChunkFull(ChunkCoordIntPair chunkcoordintpair) {
        NBTTagCompound nbttagcompound;
        byte b0 = this.chunkTypeCache.get(chunkcoordintpair.toLong());
        if (b0 != 0) {
            return b0 == 1;
        }
        try {
            nbttagcompound = this.readChunk(chunkcoordintpair).join().orElse(null);
            if (nbttagcompound == null) {
                this.markPositionReplaceable(chunkcoordintpair);
                return false;
            }
        }
        catch (Exception exception) {
            LOGGER.error("Failed to read chunk {}", (Object)chunkcoordintpair, (Object)exception);
            this.markPositionReplaceable(chunkcoordintpair);
            return false;
        }
        ChunkType chunktype = ChunkRegionLoader.getChunkTypeFromTag(nbttagcompound);
        return this.markPosition(chunkcoordintpair, chunktype) == 1;
    }

    protected void setServerViewDistance(int i2) {
        int j2 = MathHelper.clamp(i2, 2, 32);
        if (j2 != this.serverViewDistance) {
            this.serverViewDistance = j2;
            this.distanceManager.updatePlayerTickets(this.serverViewDistance);
            for (EntityPlayer entityplayer : this.playerMap.getAllPlayers()) {
                this.updateChunkTracking(entityplayer);
            }
        }
    }

    int getPlayerViewDistance(EntityPlayer entityplayer) {
        return MathHelper.clamp(entityplayer.requestedViewDistance(), 2, this.serverViewDistance);
    }

    private void markChunkPendingToSend(EntityPlayer entityplayer, ChunkCoordIntPair chunkcoordintpair) {
        Chunk chunk = this.getChunkToSend(chunkcoordintpair.toLong());
        if (chunk != null) {
            PlayerChunkMap.markChunkPendingToSend(entityplayer, chunk);
        }
    }

    private static void markChunkPendingToSend(EntityPlayer entityplayer, Chunk chunk) {
        entityplayer.connection.chunkSender.markChunkPendingToSend(chunk);
    }

    private static void dropChunk(EntityPlayer entityplayer, ChunkCoordIntPair chunkcoordintpair) {
        entityplayer.connection.chunkSender.dropChunk(entityplayer, chunkcoordintpair);
    }

    @Nullable
    public Chunk getChunkToSend(long i2) {
        PlayerChunk playerchunk = this.getVisibleChunkIfPresent(i2);
        return playerchunk == null ? null : playerchunk.getChunkToSend();
    }

    public int size() {
        return this.visibleChunkMap.size();
    }

    public ChunkMapDistance getDistanceManager() {
        return this.distanceManager;
    }

    protected Iterable<PlayerChunk> getChunks() {
        return Iterables.unmodifiableIterable((Iterable)this.visibleChunkMap.values());
    }

    void dumpChunks(Writer writer) throws IOException {
        CSVWriter csvwriter = CSVWriter.builder().addColumn("x").addColumn("z").addColumn("level").addColumn("in_memory").addColumn("status").addColumn("full_status").addColumn("accessible_ready").addColumn("ticking_ready").addColumn("entity_ticking_ready").addColumn("ticket").addColumn("spawning").addColumn("block_entity_count").addColumn("ticking_ticket").addColumn("ticking_level").addColumn("block_ticks").addColumn("fluid_ticks").build(writer);
        TickingTracker tickingtracker = this.distanceManager.tickingTracker();
        for (Long2ObjectMap.Entry entry : this.visibleChunkMap.long2ObjectEntrySet()) {
            long i2 = entry.getLongKey();
            ChunkCoordIntPair chunkcoordintpair = new ChunkCoordIntPair(i2);
            PlayerChunk playerchunk = (PlayerChunk)entry.getValue();
            Optional<IChunkAccess> optional = Optional.ofNullable(playerchunk.getLatestChunk());
            Optional<Object> optional1 = optional.flatMap(ichunkaccess -> ichunkaccess instanceof Chunk ? Optional.of((Chunk)ichunkaccess) : Optional.empty());
            csvwriter.writeRow(chunkcoordintpair.x, chunkcoordintpair.z, playerchunk.getTicketLevel(), optional.isPresent(), optional.map(IChunkAccess::getPersistedStatus).orElse(null), optional1.map(Chunk::getFullStatus).orElse(null), PlayerChunkMap.printFuture(playerchunk.getFullChunkFuture()), PlayerChunkMap.printFuture(playerchunk.getTickingChunkFuture()), PlayerChunkMap.printFuture(playerchunk.getEntityTickingChunkFuture()), this.distanceManager.getTicketDebugString(i2), this.anyPlayerCloseEnoughForSpawning(chunkcoordintpair), optional1.map(chunk -> chunk.getBlockEntities().size()).orElse(0), tickingtracker.getTicketDebugString(i2), tickingtracker.getLevel(i2), optional1.map(chunk -> chunk.getBlockTicks().count()).orElse(0), optional1.map(chunk -> chunk.getFluidTicks().count()).orElse(0));
        }
    }

    private static String printFuture(CompletableFuture<ChunkResult<Chunk>> completablefuture) {
        try {
            ChunkResult chunkresult = completablefuture.getNow(null);
            return chunkresult != null ? (chunkresult.isSuccess() ? "done" : "unloaded") : "not completed";
        }
        catch (CompletionException completionexception) {
            return "failed " + completionexception.getCause().getMessage();
        }
        catch (CancellationException cancellationexception) {
            return "cancelled";
        }
    }

    private CompletableFuture<Optional<NBTTagCompound>> readChunk(ChunkCoordIntPair chunkcoordintpair) {
        return this.read(chunkcoordintpair).thenApplyAsync(optional -> optional.map(nbttagcompound -> this.upgradeChunkTag((NBTTagCompound)nbttagcompound, chunkcoordintpair)), (Executor)SystemUtils.backgroundExecutor());
    }

    private NBTTagCompound upgradeChunkTag(NBTTagCompound nbttagcompound, ChunkCoordIntPair chunkcoordintpair) {
        return this.upgradeChunkTag(this.level.getTypeKey(), this.overworldDataStorage, nbttagcompound, this.generator().getTypeNameForDataFixer(), chunkcoordintpair, this.level);
    }

    boolean anyPlayerCloseEnoughForSpawning(ChunkCoordIntPair chunkcoordintpair) {
        return this.anyPlayerCloseEnoughForSpawning(chunkcoordintpair, false);
    }

    boolean anyPlayerCloseEnoughForSpawning(ChunkCoordIntPair chunkcoordintpair, boolean reducedRange) {
        EntityPlayer entityplayer;
        double blockRange;
        int chunkRange = this.level.spigotConfig.mobSpawnRange;
        chunkRange = chunkRange > this.level.spigotConfig.viewDistance ? (int)this.level.spigotConfig.viewDistance : chunkRange;
        chunkRange = chunkRange > 8 ? 8 : (int)chunkRange;
        double d2 = blockRange = reducedRange ? Math.pow(chunkRange << 4, 2.0) : 16384.0;
        if (!this.distanceManager.hasPlayersNearby(chunkcoordintpair.toLong())) {
            return false;
        }
        Iterator<EntityPlayer> iterator = this.playerMap.getAllPlayers().iterator();
        do {
            if (iterator.hasNext()) continue;
            return false;
        } while (!this.playerIsCloseEnoughForSpawning(entityplayer = iterator.next(), chunkcoordintpair, blockRange));
        return true;
    }

    public List<EntityPlayer> getPlayersCloseForSpawning(ChunkCoordIntPair chunkcoordintpair) {
        long i2 = chunkcoordintpair.toLong();
        if (!this.distanceManager.hasPlayersNearby(i2)) {
            return List.of();
        }
        ImmutableList.Builder builder = ImmutableList.builder();
        for (EntityPlayer entityplayer : this.playerMap.getAllPlayers()) {
            if (!this.playerIsCloseEnoughForSpawning(entityplayer, chunkcoordintpair, 16384.0)) continue;
            builder.add((Object)entityplayer);
        }
        return builder.build();
    }

    private boolean playerIsCloseEnoughForSpawning(EntityPlayer entityplayer, ChunkCoordIntPair chunkcoordintpair, double range) {
        if (entityplayer.isSpectator()) {
            return false;
        }
        double d0 = PlayerChunkMap.euclideanDistanceSquared(chunkcoordintpair, entityplayer);
        return d0 < range;
    }

    private boolean skipPlayer(EntityPlayer entityplayer) {
        return entityplayer.isSpectator() && !this.level.getGameRules().getBoolean(GameRules.RULE_SPECTATORSGENERATECHUNKS);
    }

    void updatePlayerStatus(EntityPlayer entityplayer, boolean flag) {
        boolean flag1 = this.skipPlayer(entityplayer);
        boolean flag2 = this.playerMap.ignoredOrUnknown(entityplayer);
        if (flag) {
            this.playerMap.addPlayer(entityplayer, flag1);
            this.updatePlayerPos(entityplayer);
            if (!flag1) {
                this.distanceManager.addPlayer(SectionPosition.of(entityplayer), entityplayer);
            }
            entityplayer.setChunkTrackingView(ChunkTrackingView.EMPTY);
            this.updateChunkTracking(entityplayer);
        } else {
            SectionPosition sectionposition = entityplayer.getLastSectionPos();
            this.playerMap.removePlayer(entityplayer);
            if (!flag2) {
                this.distanceManager.removePlayer(sectionposition, entityplayer);
            }
            this.applyChunkTrackingView(entityplayer, ChunkTrackingView.EMPTY);
        }
    }

    private void updatePlayerPos(EntityPlayer entityplayer) {
        SectionPosition sectionposition = SectionPosition.of(entityplayer);
        entityplayer.setLastSectionPos(sectionposition);
    }

    public void move(EntityPlayer entityplayer) {
        boolean flag2;
        for (EntityTracker playerchunkmap_entitytracker : this.entityMap.values()) {
            if (playerchunkmap_entitytracker.entity == entityplayer) {
                playerchunkmap_entitytracker.updatePlayers(this.level.players());
                continue;
            }
            playerchunkmap_entitytracker.updatePlayer(entityplayer);
        }
        SectionPosition sectionposition = entityplayer.getLastSectionPos();
        SectionPosition sectionposition1 = SectionPosition.of(entityplayer);
        boolean flag = this.playerMap.ignored(entityplayer);
        boolean flag1 = this.skipPlayer(entityplayer);
        boolean bl = flag2 = sectionposition.asLong() != sectionposition1.asLong();
        if (flag2 || flag != flag1) {
            this.updatePlayerPos(entityplayer);
            if (!flag) {
                this.distanceManager.removePlayer(sectionposition, entityplayer);
            }
            if (!flag1) {
                this.distanceManager.addPlayer(sectionposition1, entityplayer);
            }
            if (!flag && flag1) {
                this.playerMap.ignorePlayer(entityplayer);
            }
            if (flag && !flag1) {
                this.playerMap.unIgnorePlayer(entityplayer);
            }
            this.updateChunkTracking(entityplayer);
        }
    }

    private void updateChunkTracking(EntityPlayer entityplayer) {
        ChunkTrackingView.a chunktrackingview_a;
        ChunkCoordIntPair chunkcoordintpair = entityplayer.chunkPosition();
        int i2 = this.getPlayerViewDistance(entityplayer);
        ChunkTrackingView chunktrackingview = entityplayer.getChunkTrackingView();
        if (chunktrackingview instanceof ChunkTrackingView.a && (chunktrackingview_a = (ChunkTrackingView.a)chunktrackingview).center().equals(chunkcoordintpair) && chunktrackingview_a.viewDistance() == i2) {
            return;
        }
        this.applyChunkTrackingView(entityplayer, ChunkTrackingView.of(chunkcoordintpair, i2));
    }

    private void applyChunkTrackingView(EntityPlayer entityplayer, ChunkTrackingView chunktrackingview) {
        if (entityplayer.level() == this.level) {
            ChunkTrackingView chunktrackingview1 = entityplayer.getChunkTrackingView();
            if (chunktrackingview instanceof ChunkTrackingView.a) {
                ChunkTrackingView.a chunktrackingview_a1;
                ChunkTrackingView.a chunktrackingview_a = (ChunkTrackingView.a)chunktrackingview;
                if (!(chunktrackingview1 instanceof ChunkTrackingView.a) || !(chunktrackingview_a1 = (ChunkTrackingView.a)chunktrackingview1).center().equals(chunktrackingview_a.center())) {
                    entityplayer.connection.send(new PacketPlayOutViewCentre(chunktrackingview_a.center().x, chunktrackingview_a.center().z));
                }
            }
            ChunkTrackingView.difference(chunktrackingview1, chunktrackingview, chunkcoordintpair -> this.markChunkPendingToSend(entityplayer, (ChunkCoordIntPair)chunkcoordintpair), chunkcoordintpair -> PlayerChunkMap.dropChunk(entityplayer, chunkcoordintpair));
            entityplayer.setChunkTrackingView(chunktrackingview);
        }
    }

    @Override
    public List<EntityPlayer> getPlayers(ChunkCoordIntPair chunkcoordintpair, boolean flag) {
        Set<EntityPlayer> set = this.playerMap.getAllPlayers();
        ImmutableList.Builder builder = ImmutableList.builder();
        for (EntityPlayer entityplayer : set) {
            if ((!flag || !this.isChunkOnTrackedBorder(entityplayer, chunkcoordintpair.x, chunkcoordintpair.z)) && (flag || !this.isChunkTracked(entityplayer, chunkcoordintpair.x, chunkcoordintpair.z))) continue;
            builder.add((Object)entityplayer);
        }
        return builder.build();
    }

    protected void addEntity(Entity entity) {
        AsyncCatcher.catchOp("entity track");
        if (!(entity instanceof EntityComplexPart)) {
            EntityTypes<?> entitytypes = entity.getType();
            int i2 = entitytypes.clientTrackingRange() * 16;
            if ((i2 = TrackingRange.getEntityTrackingRange(entity, i2)) != 0) {
                int j2 = entitytypes.updateInterval();
                if (this.entityMap.containsKey(entity.getId())) {
                    throw SystemUtils.pauseInIde(new IllegalStateException("Entity is already tracked!"));
                }
                EntityTracker playerchunkmap_entitytracker = new EntityTracker(entity, i2, j2, entitytypes.trackDeltas());
                this.entityMap.put(entity.getId(), (Object)playerchunkmap_entitytracker);
                playerchunkmap_entitytracker.updatePlayers(this.level.players());
                if (entity instanceof EntityPlayer) {
                    EntityPlayer entityplayer = (EntityPlayer)entity;
                    this.updatePlayerStatus(entityplayer, true);
                    for (EntityTracker playerchunkmap_entitytracker1 : this.entityMap.values()) {
                        if (playerchunkmap_entitytracker1.entity == entityplayer) continue;
                        playerchunkmap_entitytracker1.updatePlayer(entityplayer);
                    }
                }
            }
        }
    }

    protected void removeEntity(Entity entity) {
        EntityTracker playerchunkmap_entitytracker1;
        AsyncCatcher.catchOp("entity untrack");
        if (entity instanceof EntityPlayer) {
            EntityPlayer entityplayer = (EntityPlayer)entity;
            this.updatePlayerStatus(entityplayer, false);
            for (EntityTracker playerchunkmap_entitytracker : this.entityMap.values()) {
                playerchunkmap_entitytracker.removePlayer(entityplayer);
            }
        }
        if ((playerchunkmap_entitytracker1 = (EntityTracker)this.entityMap.remove(entity.getId())) != null) {
            playerchunkmap_entitytracker1.broadcastRemoved();
        }
    }

    protected void tick() {
        for (EntityPlayer entityplayer : this.playerMap.getAllPlayers()) {
            this.updateChunkTracking(entityplayer);
        }
        ArrayList list = Lists.newArrayList();
        List<EntityPlayer> list1 = this.level.players();
        for (EntityTracker playerchunkmap_entitytracker : this.entityMap.values()) {
            boolean flag;
            SectionPosition sectionposition = playerchunkmap_entitytracker.lastSectionPos;
            SectionPosition sectionposition1 = SectionPosition.of(playerchunkmap_entitytracker.entity);
            boolean bl = flag = !Objects.equals(sectionposition, sectionposition1);
            if (flag) {
                playerchunkmap_entitytracker.updatePlayers(list1);
                Entity entity = playerchunkmap_entitytracker.entity;
                if (entity instanceof EntityPlayer) {
                    list.add((EntityPlayer)entity);
                }
                playerchunkmap_entitytracker.lastSectionPos = sectionposition1;
            }
            if (!flag && !this.distanceManager.inEntityTickingRange(sectionposition1.chunk().toLong())) continue;
            playerchunkmap_entitytracker.serverEntity.sendChanges();
        }
        if (!list.isEmpty()) {
            for (EntityTracker playerchunkmap_entitytracker : this.entityMap.values()) {
                playerchunkmap_entitytracker.updatePlayers(list);
            }
        }
    }

    public void broadcast(Entity entity, Packet<?> packet) {
        EntityTracker playerchunkmap_entitytracker = (EntityTracker)this.entityMap.get(entity.getId());
        if (playerchunkmap_entitytracker != null) {
            playerchunkmap_entitytracker.broadcast(packet);
        }
    }

    protected void broadcastAndSend(Entity entity, Packet<?> packet) {
        EntityTracker playerchunkmap_entitytracker = (EntityTracker)this.entityMap.get(entity.getId());
        if (playerchunkmap_entitytracker != null) {
            playerchunkmap_entitytracker.broadcastAndSend(packet);
        }
    }

    public void resendBiomesForChunks(List<IChunkAccess> list) {
        HashMap<EntityPlayer, List> map = new HashMap<EntityPlayer, List>();
        for (IChunkAccess ichunkaccess : list) {
            Chunk chunk1;
            ChunkCoordIntPair chunkcoordintpair = ichunkaccess.getPos();
            Chunk chunk = ichunkaccess instanceof Chunk ? (chunk1 = (Chunk)ichunkaccess) : this.level.getChunk(chunkcoordintpair.x, chunkcoordintpair.z);
            for (EntityPlayer entityplayer : this.getPlayers(chunkcoordintpair, false)) {
                map.computeIfAbsent(entityplayer, entityplayer1 -> new ArrayList()).add(chunk);
            }
        }
        map.forEach((entityplayer1, list1) -> entityplayer1.connection.send(ClientboundChunksBiomesPacket.forChunks(list1)));
    }

    protected VillagePlace getPoiManager() {
        return this.poiManager;
    }

    public String getStorageName() {
        return this.storageName;
    }

    void onFullChunkStatusChange(ChunkCoordIntPair chunkcoordintpair, FullChunkStatus fullchunkstatus) {
        this.chunkStatusListener.onChunkStatusChange(chunkcoordintpair, fullchunkstatus);
    }

    public void waitForLightBeforeSending(ChunkCoordIntPair chunkcoordintpair, int i2) {
        int j2 = i2 + 1;
        ChunkCoordIntPair.rangeClosed(chunkcoordintpair, j2).forEach(chunkcoordintpair1 -> {
            PlayerChunk playerchunk = this.getVisibleChunkIfPresent(chunkcoordintpair1.toLong());
            if (playerchunk != null) {
                playerchunk.addSendDependency(this.lightEngine.waitForPendingTasks(chunkcoordintpair1.x, chunkcoordintpair1.z));
            }
        });
    }

    public static final class CallbackExecutor
    implements Executor,
    Runnable {
        private final Queue<Runnable> queue = new ArrayDeque<Runnable>();

        @Override
        public void execute(Runnable runnable) {
            this.queue.add(runnable);
        }

        @Override
        public void run() {
            Runnable task;
            while ((task = this.queue.poll()) != null) {
                task.run();
            }
        }
    }

    private class a
    extends ChunkMapDistance {
        protected a(Executor executor, Executor executor1) {
            super(executor, executor1);
        }

        @Override
        protected boolean isChunkToRemove(long i2) {
            return PlayerChunkMap.this.toDrop.contains(i2);
        }

        @Override
        @Nullable
        protected PlayerChunk getChunk(long i2) {
            return PlayerChunkMap.this.getUpdatingChunkIfPresent(i2);
        }

        @Override
        @Nullable
        protected PlayerChunk updateChunkScheduling(long i2, int j2, @Nullable PlayerChunk playerchunk, int k2) {
            return PlayerChunkMap.this.updateChunkScheduling(i2, j2, playerchunk, k2);
        }
    }

    public class EntityTracker {
        public final EntityTrackerEntry serverEntity;
        final Entity entity;
        private final int range;
        SectionPosition lastSectionPos;
        public final Set<ServerPlayerConnection> seenBy = Sets.newIdentityHashSet();

        public EntityTracker(Entity entity, int i2, int j2, boolean flag) {
            this.serverEntity = new EntityTrackerEntry(PlayerChunkMap.this.level, entity, j2, flag, this::broadcast, this.seenBy);
            this.entity = entity;
            this.range = i2;
            this.lastSectionPos = SectionPosition.of(entity);
        }

        public boolean equals(Object object) {
            return object instanceof EntityTracker ? ((EntityTracker)object).entity.getId() == this.entity.getId() : false;
        }

        public int hashCode() {
            return this.entity.getId();
        }

        public void broadcast(Packet<?> packet) {
            for (ServerPlayerConnection serverplayerconnection : this.seenBy) {
                serverplayerconnection.send(packet);
            }
        }

        public void broadcastAndSend(Packet<?> packet) {
            this.broadcast(packet);
            if (this.entity instanceof EntityPlayer) {
                ((EntityPlayer)this.entity).connection.send(packet);
            }
        }

        public void broadcastRemoved() {
            for (ServerPlayerConnection serverplayerconnection : this.seenBy) {
                this.serverEntity.removePairing(serverplayerconnection.getPlayer());
            }
        }

        public void removePlayer(EntityPlayer entityplayer) {
            AsyncCatcher.catchOp("player tracker clear");
            if (this.seenBy.remove(entityplayer.connection)) {
                this.serverEntity.removePairing(entityplayer);
            }
        }

        public void updatePlayer(EntityPlayer entityplayer) {
            AsyncCatcher.catchOp("player tracker update");
            if (entityplayer != this.entity) {
                boolean flag;
                Vec3D vec3d = entityplayer.position().subtract(this.entity.position());
                int i2 = PlayerChunkMap.this.getPlayerViewDistance(entityplayer);
                double d1 = vec3d.x * vec3d.x + vec3d.z * vec3d.z;
                double d0 = Math.min(this.getEffectiveRange(), i2 * 16);
                double d2 = d0 * d0;
                boolean bl = flag = d1 <= d2 && this.entity.broadcastToPlayer(entityplayer) && PlayerChunkMap.this.isChunkTracked(entityplayer, this.entity.chunkPosition().x, this.entity.chunkPosition().z);
                if (!entityplayer.getBukkitEntity().canSee(this.entity.getBukkitEntity())) {
                    flag = false;
                }
                if (flag) {
                    if (this.seenBy.add(entityplayer.connection)) {
                        this.serverEntity.addPairing(entityplayer);
                    }
                } else if (this.seenBy.remove(entityplayer.connection)) {
                    this.serverEntity.removePairing(entityplayer);
                }
            }
        }

        private int scaledRange(int i2) {
            return PlayerChunkMap.this.level.getServer().getScaledTrackingDistance(i2);
        }

        private int getEffectiveRange() {
            int i2 = this.range;
            for (Entity entity : this.entity.getIndirectPassengers()) {
                int j2 = entity.getType().clientTrackingRange() * 16;
                if (j2 <= i2) continue;
                i2 = j2;
            }
            return this.scaledRange(i2);
        }

        public void updatePlayers(List<EntityPlayer> list) {
            for (EntityPlayer entityplayer : list) {
                this.updatePlayer(entityplayer);
            }
        }
    }
}

