/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.level;

import com.mojang.logging.LogUtils;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriterionTriggers;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundPlayerInfoUpdatePacket;
import net.minecraft.network.protocol.game.PacketPlayInBlockDig;
import net.minecraft.network.protocol.game.PacketPlayOutBlockChange;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.ITileInventory;
import net.minecraft.world.InteractionResultWrapper;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.EnumItemSlot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemBisected;
import net.minecraft.world.item.ItemDebugStick;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.ItemActionContext;
import net.minecraft.world.item.enchantment.EnchantmentManager;
import net.minecraft.world.level.EnumGamemode;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockCake;
import net.minecraft.world.level.block.BlockDoor;
import net.minecraft.world.level.block.BlockTrapdoor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.GameMasterBlock;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockPropertyDoubleBlockHalf;
import net.minecraft.world.phys.MovingObjectPositionBlock;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.GameMode;
import org.bukkit.block.BlockState;
import org.bukkit.craftbukkit.v1_21_R1.block.CraftBlock;
import org.bukkit.craftbukkit.v1_21_R1.event.CraftEventFactory;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.block.Action;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.BlockDamageEvent;
import org.bukkit.event.player.PlayerGameModeChangeEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.slf4j.Logger;

public class PlayerInteractManager {
    private static final Logger LOGGER = LogUtils.getLogger();
    protected WorldServer level;
    protected final EntityPlayer player;
    private EnumGamemode gameModeForPlayer = EnumGamemode.DEFAULT_MODE;
    @Nullable
    private EnumGamemode previousGameModeForPlayer;
    private boolean isDestroyingBlock;
    private int destroyProgressStart;
    private BlockPosition destroyPos = BlockPosition.ZERO;
    private int gameTicks;
    private boolean hasDelayedDestroy;
    private BlockPosition delayedDestroyPos = BlockPosition.ZERO;
    private int delayedTickStart;
    private int lastSentState = -1;
    public boolean interactResult = false;
    public boolean firedInteract = false;
    public BlockPosition interactPosition;
    public EnumHand interactHand;
    public ItemStack interactItemStack;

    public PlayerInteractManager(EntityPlayer entityplayer) {
        this.player = entityplayer;
        this.level = entityplayer.serverLevel();
    }

    public boolean changeGameModeForPlayer(EnumGamemode enumgamemode) {
        if (enumgamemode == this.gameModeForPlayer) {
            return false;
        }
        PlayerGameModeChangeEvent event = new PlayerGameModeChangeEvent((Player)this.player.getBukkitEntity(), GameMode.getByValue((int)enumgamemode.getId()));
        this.level.getCraftServer().getPluginManager().callEvent((Event)event);
        if (event.isCancelled()) {
            return false;
        }
        this.setGameModeForPlayer(enumgamemode, this.previousGameModeForPlayer);
        this.player.onUpdateAbilities();
        this.player.server.getPlayerList().broadcastAll((Packet)new ClientboundPlayerInfoUpdatePacket(ClientboundPlayerInfoUpdatePacket.a.UPDATE_GAME_MODE, this.player), this.player);
        this.level.updateSleepingPlayerList();
        if (enumgamemode == EnumGamemode.CREATIVE) {
            this.player.resetCurrentImpulseContext();
        }
        return true;
    }

    protected void setGameModeForPlayer(EnumGamemode enumgamemode, @Nullable EnumGamemode enumgamemode1) {
        this.previousGameModeForPlayer = enumgamemode1;
        this.gameModeForPlayer = enumgamemode;
        enumgamemode.updatePlayerAbilities(this.player.getAbilities());
    }

    public EnumGamemode getGameModeForPlayer() {
        return this.gameModeForPlayer;
    }

    @Nullable
    public EnumGamemode getPreviousGameModeForPlayer() {
        return this.previousGameModeForPlayer;
    }

    public boolean isSurvival() {
        return this.gameModeForPlayer.isSurvival();
    }

    public boolean isCreative() {
        return this.gameModeForPlayer.isCreative();
    }

    public void tick() {
        this.gameTicks = MinecraftServer.currentTick;
        if (this.hasDelayedDestroy) {
            IBlockData iblockdata = this.level.getBlockState(this.delayedDestroyPos);
            if (iblockdata.isAir()) {
                this.hasDelayedDestroy = false;
            } else {
                float f2 = this.incrementDestroyProgress(iblockdata, this.delayedDestroyPos, this.delayedTickStart);
                if (f2 >= 1.0f) {
                    this.hasDelayedDestroy = false;
                    this.destroyBlock(this.delayedDestroyPos);
                }
            }
        } else if (this.isDestroyingBlock) {
            IBlockData iblockdata = this.level.getBlockState(this.destroyPos);
            if (iblockdata.isAir()) {
                this.level.destroyBlockProgress(this.player.getId(), this.destroyPos, -1);
                this.lastSentState = -1;
                this.isDestroyingBlock = false;
            } else {
                this.incrementDestroyProgress(iblockdata, this.destroyPos, this.destroyProgressStart);
            }
        }
    }

    private float incrementDestroyProgress(IBlockData iblockdata, BlockPosition blockposition, int i2) {
        int j2 = this.gameTicks - i2;
        float f2 = iblockdata.getDestroyProgress(this.player, this.player.level(), blockposition) * (float)(j2 + 1);
        int k2 = (int)(f2 * 10.0f);
        if (k2 != this.lastSentState) {
            this.level.destroyBlockProgress(this.player.getId(), blockposition, k2);
            this.lastSentState = k2;
        }
        return f2;
    }

    private void debugLogging(BlockPosition blockposition, boolean flag, int i2, String s2) {
    }

    public void handleBlockBreakAction(BlockPosition blockposition, PacketPlayInBlockDig.EnumPlayerDigType packetplayinblockdig_enumplayerdigtype, EnumDirection enumdirection, int i2, int j2) {
        if (!this.player.canInteractWithBlock(blockposition, 1.0)) {
            this.debugLogging(blockposition, false, j2, "too far");
        } else if (blockposition.getY() >= i2) {
            this.player.connection.send(new PacketPlayOutBlockChange(blockposition, this.level.getBlockState(blockposition)));
            this.debugLogging(blockposition, false, j2, "too high");
        } else if (packetplayinblockdig_enumplayerdigtype == PacketPlayInBlockDig.EnumPlayerDigType.START_DESTROY_BLOCK) {
            if (!this.level.mayInteract(this.player, blockposition)) {
                CraftEventFactory.callPlayerInteractEvent(this.player, Action.LEFT_CLICK_BLOCK, blockposition, enumdirection, this.player.getInventory().getSelected(), EnumHand.MAIN_HAND);
                this.player.connection.send(new PacketPlayOutBlockChange(blockposition, this.level.getBlockState(blockposition)));
                this.debugLogging(blockposition, false, j2, "may not interact");
                TileEntity tileentity = this.level.getBlockEntity(blockposition);
                if (tileentity != null) {
                    this.player.connection.send(tileentity.getUpdatePacket());
                }
                return;
            }
            PlayerInteractEvent event = CraftEventFactory.callPlayerInteractEvent(this.player, Action.LEFT_CLICK_BLOCK, blockposition, enumdirection, this.player.getInventory().getSelected(), EnumHand.MAIN_HAND);
            if (event.isCancelled()) {
                this.player.connection.send(new PacketPlayOutBlockChange(this.level, blockposition));
                TileEntity tileentity = this.level.getBlockEntity(blockposition);
                if (tileentity != null) {
                    this.player.connection.send(tileentity.getUpdatePacket());
                }
                return;
            }
            if (this.isCreative()) {
                this.destroyAndAck(blockposition, j2, "creative destroy");
                return;
            }
            if (this.player.getMainHandItem().is(Items.DEBUG_STICK) && ((ItemDebugStick)Items.DEBUG_STICK).handleInteraction(this.player, this.level.getBlockState(blockposition), this.level, blockposition, false, this.player.getMainHandItem())) {
                this.player.connection.send(new PacketPlayOutBlockChange(this.level, blockposition));
                return;
            }
            if (this.player.blockActionRestricted(this.level, blockposition, this.gameModeForPlayer)) {
                this.player.connection.send(new PacketPlayOutBlockChange(blockposition, this.level.getBlockState(blockposition)));
                this.debugLogging(blockposition, false, j2, "block action restricted");
                return;
            }
            this.destroyProgressStart = this.gameTicks;
            float f2 = 1.0f;
            IBlockData iblockdata = this.level.getBlockState(blockposition);
            if (event.useInteractedBlock() == Event.Result.DENY) {
                IBlockData data = this.level.getBlockState(blockposition);
                if (data.getBlock() instanceof BlockDoor) {
                    boolean bottom = data.getValue(BlockDoor.HALF) == BlockPropertyDoubleBlockHalf.LOWER;
                    this.player.connection.send(new PacketPlayOutBlockChange(this.level, blockposition));
                    this.player.connection.send(new PacketPlayOutBlockChange(this.level, bottom ? blockposition.above() : blockposition.below()));
                } else if (data.getBlock() instanceof BlockTrapdoor) {
                    this.player.connection.send(new PacketPlayOutBlockChange(this.level, blockposition));
                }
            } else if (!iblockdata.isAir()) {
                EnchantmentManager.onHitBlock(this.level, this.player.getMainHandItem(), this.player, this.player, EnumItemSlot.MAINHAND, Vec3D.atCenterOf(blockposition), iblockdata, item -> this.player.onEquippedItemBroken((Item)item, EnumItemSlot.MAINHAND));
                iblockdata.attack(this.level, blockposition, this.player);
                f2 = iblockdata.getDestroyProgress(this.player, this.player.level(), blockposition);
            }
            if (event.useItemInHand() == Event.Result.DENY) {
                if (f2 > 1.0f) {
                    this.player.connection.send(new PacketPlayOutBlockChange(this.level, blockposition));
                }
                return;
            }
            BlockDamageEvent blockEvent = CraftEventFactory.callBlockDamageEvent(this.player, blockposition, this.player.getInventory().getSelected(), f2 >= 1.0f);
            if (blockEvent.isCancelled()) {
                this.player.connection.send(new PacketPlayOutBlockChange(this.level, blockposition));
                return;
            }
            if (blockEvent.getInstaBreak()) {
                f2 = 2.0f;
            }
            if (!iblockdata.isAir() && f2 >= 1.0f) {
                this.destroyAndAck(blockposition, j2, "insta mine");
            } else {
                if (this.isDestroyingBlock) {
                    this.player.connection.send(new PacketPlayOutBlockChange(this.destroyPos, this.level.getBlockState(this.destroyPos)));
                    this.debugLogging(blockposition, false, j2, "abort destroying since another started (client insta mine, server disagreed)");
                }
                this.isDestroyingBlock = true;
                this.destroyPos = blockposition.immutable();
                int k2 = (int)(f2 * 10.0f);
                this.level.destroyBlockProgress(this.player.getId(), blockposition, k2);
                this.debugLogging(blockposition, true, j2, "actual start of destroying");
                this.lastSentState = k2;
            }
        } else if (packetplayinblockdig_enumplayerdigtype == PacketPlayInBlockDig.EnumPlayerDigType.STOP_DESTROY_BLOCK) {
            if (blockposition.equals(this.destroyPos)) {
                int l2 = this.gameTicks - this.destroyProgressStart;
                IBlockData iblockdata = this.level.getBlockState(blockposition);
                if (!iblockdata.isAir()) {
                    float f1 = iblockdata.getDestroyProgress(this.player, this.player.level(), blockposition) * (float)(l2 + 1);
                    if (f1 >= 0.7f) {
                        this.isDestroyingBlock = false;
                        this.level.destroyBlockProgress(this.player.getId(), blockposition, -1);
                        this.destroyAndAck(blockposition, j2, "destroyed");
                        return;
                    }
                    if (!this.hasDelayedDestroy) {
                        this.isDestroyingBlock = false;
                        this.hasDelayedDestroy = true;
                        this.delayedDestroyPos = blockposition;
                        this.delayedTickStart = this.destroyProgressStart;
                    }
                }
            }
            this.debugLogging(blockposition, true, j2, "stopped destroying");
        } else if (packetplayinblockdig_enumplayerdigtype == PacketPlayInBlockDig.EnumPlayerDigType.ABORT_DESTROY_BLOCK) {
            this.isDestroyingBlock = false;
            if (!Objects.equals(this.destroyPos, blockposition)) {
                LOGGER.debug("Mismatch in destroy block pos: {} {}", (Object)this.destroyPos, (Object)blockposition);
                this.level.destroyBlockProgress(this.player.getId(), this.destroyPos, -1);
                this.debugLogging(blockposition, true, j2, "aborted mismatched destroying");
            }
            this.level.destroyBlockProgress(this.player.getId(), blockposition, -1);
            this.debugLogging(blockposition, true, j2, "aborted destroying");
            CraftEventFactory.callBlockDamageAbortEvent(this.player, blockposition, this.player.getInventory().getSelected());
        }
    }

    public void destroyAndAck(BlockPosition blockposition, int i2, String s2) {
        if (this.destroyBlock(blockposition)) {
            this.debugLogging(blockposition, true, i2, s2);
        } else {
            this.player.connection.send(new PacketPlayOutBlockChange(blockposition, this.level.getBlockState(blockposition)));
            this.debugLogging(blockposition, false, i2, s2);
        }
    }

    public boolean destroyBlock(BlockPosition blockposition) {
        IBlockData iblockdata = this.level.getBlockState(blockposition);
        CraftBlock bblock = CraftBlock.at(this.level, blockposition);
        BlockBreakEvent event = null;
        if (this.player instanceof EntityPlayer) {
            boolean isSwordNoBreak;
            boolean bl = isSwordNoBreak = !this.player.getMainHandItem().getItem().canAttackBlock(iblockdata, this.level, blockposition, this.player);
            if (this.level.getBlockEntity(blockposition) == null && !isSwordNoBreak) {
                PacketPlayOutBlockChange packet = new PacketPlayOutBlockChange(blockposition, Blocks.AIR.defaultBlockState());
                this.player.connection.send(packet);
            }
            event = new BlockBreakEvent((org.bukkit.block.Block)bblock, (Player)this.player.getBukkitEntity());
            event.setCancelled(isSwordNoBreak);
            IBlockData nmsData = this.level.getBlockState(blockposition);
            Block nmsBlock = nmsData.getBlock();
            ItemStack itemstack = this.player.getItemBySlot(EnumItemSlot.MAINHAND);
            if (nmsBlock != null && !event.isCancelled() && !this.isCreative() && this.player.hasCorrectToolForDrops(nmsBlock.defaultBlockState())) {
                event.setExpToDrop(nmsBlock.getExpDrop(nmsData, this.level, blockposition, itemstack, true));
            }
            this.level.getCraftServer().getPluginManager().callEvent((Event)event);
            if (event.isCancelled()) {
                if (isSwordNoBreak) {
                    return false;
                }
                this.player.connection.send(new PacketPlayOutBlockChange(this.level, blockposition));
                for (EnumDirection dir : EnumDirection.values()) {
                    this.player.connection.send(new PacketPlayOutBlockChange(this.level, blockposition.relative(dir)));
                }
                TileEntity tileentity = this.level.getBlockEntity(blockposition);
                if (tileentity != null) {
                    this.player.connection.send(tileentity.getUpdatePacket());
                }
                return false;
            }
        }
        if ((iblockdata = this.level.getBlockState(blockposition)).isAir()) {
            return false;
        }
        TileEntity tileentity = this.level.getBlockEntity(blockposition);
        Block block = iblockdata.getBlock();
        if (block instanceof GameMasterBlock && !this.player.canUseGameMasterBlocks()) {
            this.level.sendBlockUpdated(blockposition, iblockdata, iblockdata, 3);
            return false;
        }
        if (this.player.blockActionRestricted(this.level, blockposition, this.gameModeForPlayer)) {
            return false;
        }
        BlockState state = bblock.getState();
        this.level.captureDrops = new ArrayList();
        IBlockData iblockdata1 = block.playerWillDestroy(this.level, blockposition, iblockdata, this.player);
        boolean flag = this.level.removeBlock(blockposition, false);
        if (flag) {
            block.destroy(this.level, blockposition, iblockdata1);
        }
        if (!this.isCreative()) {
            ItemStack itemstack = this.player.getMainHandItem();
            ItemStack itemstack1 = itemstack.copy();
            boolean flag1 = this.player.hasCorrectToolForDrops(iblockdata1);
            itemstack.mineBlock(this.level, iblockdata1, blockposition, this.player);
            if (flag && flag1 && event.isDropItems()) {
                block.playerDestroy(this.level, this.player, blockposition, iblockdata1, tileentity, itemstack1);
            }
        }
        if (event.isDropItems()) {
            CraftEventFactory.handleBlockDropItemEvent(bblock, state, this.player, this.level.captureDrops);
        }
        this.level.captureDrops = null;
        if (flag && event != null) {
            iblockdata.getBlock().popExperience(this.level, blockposition, event.getExpToDrop());
        }
        return true;
    }

    public EnumInteractionResult useItem(EntityPlayer entityplayer, World world, ItemStack itemstack, EnumHand enumhand) {
        if (this.gameModeForPlayer == EnumGamemode.SPECTATOR) {
            return EnumInteractionResult.PASS;
        }
        if (entityplayer.getCooldowns().isOnCooldown(itemstack.getItem())) {
            return EnumInteractionResult.PASS;
        }
        int i2 = itemstack.getCount();
        int j2 = itemstack.getDamageValue();
        InteractionResultWrapper<ItemStack> interactionresultwrapper = itemstack.use(world, entityplayer, enumhand);
        ItemStack itemstack1 = interactionresultwrapper.getObject();
        if (itemstack1 == itemstack && itemstack1.getCount() == i2 && itemstack1.getUseDuration(entityplayer) <= 0 && itemstack1.getDamageValue() == j2) {
            return interactionresultwrapper.getResult();
        }
        if (interactionresultwrapper.getResult() == EnumInteractionResult.FAIL && itemstack1.getUseDuration(entityplayer) > 0 && !entityplayer.isUsingItem()) {
            return interactionresultwrapper.getResult();
        }
        if (itemstack != itemstack1) {
            entityplayer.setItemInHand(enumhand, itemstack1);
        }
        if (itemstack1.isEmpty()) {
            entityplayer.setItemInHand(enumhand, ItemStack.EMPTY);
        }
        if (!entityplayer.isUsingItem()) {
            entityplayer.inventoryMenu.sendAllDataToRemote();
        }
        return interactionresultwrapper.getResult();
    }

    public EnumInteractionResult useItemOn(EntityPlayer entityplayer, World world, ItemStack itemstack, EnumHand enumhand, MovingObjectPositionBlock movingobjectpositionblock) {
        EnumInteractionResult enuminteractionresult;
        BlockPosition blockposition = movingobjectpositionblock.getBlockPos();
        IBlockData iblockdata = world.getBlockState(blockposition);
        boolean cancelledBlock = false;
        if (!iblockdata.getBlock().isEnabled(world.enabledFeatures())) {
            return EnumInteractionResult.FAIL;
        }
        if (this.gameModeForPlayer == EnumGamemode.SPECTATOR) {
            ITileInventory itileinventory = iblockdata.getMenuProvider(world, blockposition);
            boolean bl = cancelledBlock = !(itileinventory instanceof ITileInventory);
        }
        if (entityplayer.getCooldowns().isOnCooldown(itemstack.getItem())) {
            cancelledBlock = true;
        }
        PlayerInteractEvent event = CraftEventFactory.callPlayerInteractEvent(entityplayer, Action.RIGHT_CLICK_BLOCK, blockposition, movingobjectpositionblock.getDirection(), itemstack, cancelledBlock, enumhand, movingobjectpositionblock.getLocation());
        this.firedInteract = true;
        this.interactResult = event.useItemInHand() == Event.Result.DENY;
        this.interactPosition = blockposition.immutable();
        this.interactHand = enumhand;
        this.interactItemStack = itemstack.copy();
        if (event.useInteractedBlock() == Event.Result.DENY) {
            if (iblockdata.getBlock() instanceof BlockDoor) {
                boolean bottom = iblockdata.getValue(BlockDoor.HALF) == BlockPropertyDoubleBlockHalf.LOWER;
                entityplayer.connection.send(new PacketPlayOutBlockChange(world, bottom ? blockposition.above() : blockposition.below()));
            } else if (iblockdata.getBlock() instanceof BlockCake) {
                entityplayer.getBukkitEntity().sendHealthUpdate();
            } else if (this.interactItemStack.getItem() instanceof ItemBisected) {
                entityplayer.connection.send(new PacketPlayOutBlockChange(world, blockposition.relative(movingobjectpositionblock.getDirection()).above()));
                entityplayer.connection.send(new PacketPlayOutBlockChange(world, blockposition.above()));
            }
            entityplayer.getBukkitEntity().updateInventory();
            return event.useItemInHand() != Event.Result.ALLOW ? EnumInteractionResult.SUCCESS : EnumInteractionResult.PASS;
        }
        if (this.gameModeForPlayer == EnumGamemode.SPECTATOR) {
            ITileInventory itileinventory = iblockdata.getMenuProvider(world, blockposition);
            if (itileinventory != null) {
                entityplayer.openMenu(itileinventory);
                return EnumInteractionResult.SUCCESS;
            }
            return EnumInteractionResult.PASS;
        }
        boolean flag = !entityplayer.getMainHandItem().isEmpty() || !entityplayer.getOffhandItem().isEmpty();
        boolean flag1 = entityplayer.isSecondaryUseActive() && flag;
        ItemStack itemstack1 = itemstack.copy();
        if (!flag1) {
            ItemInteractionResult iteminteractionresult = iblockdata.useItemOn(entityplayer.getItemInHand(enumhand), world, entityplayer, enumhand, movingobjectpositionblock);
            if (iteminteractionresult.consumesAction()) {
                CriterionTriggers.ITEM_USED_ON_BLOCK.trigger(entityplayer, blockposition, itemstack1);
                return iteminteractionresult.result();
            }
            if (iteminteractionresult == ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION && enumhand == EnumHand.MAIN_HAND && (enuminteractionresult = iblockdata.useWithoutItem(world, entityplayer, movingobjectpositionblock)).consumesAction()) {
                CriterionTriggers.DEFAULT_BLOCK_USE.trigger(entityplayer, blockposition);
                return enuminteractionresult;
            }
        }
        if (!itemstack.isEmpty() && !this.interactResult) {
            ItemActionContext itemactioncontext = new ItemActionContext(entityplayer, enumhand, movingobjectpositionblock);
            if (this.isCreative()) {
                int i2 = itemstack.getCount();
                enuminteractionresult = itemstack.useOn(itemactioncontext);
                itemstack.setCount(i2);
            } else {
                enuminteractionresult = itemstack.useOn(itemactioncontext);
            }
            if (enuminteractionresult.consumesAction()) {
                CriterionTriggers.ITEM_USED_ON_BLOCK.trigger(entityplayer, blockposition, itemstack1);
            }
            return enuminteractionresult;
        }
        return EnumInteractionResult.PASS;
    }

    public void setLevel(WorldServer worldserver) {
        this.level = worldserver;
    }
}

