/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.level;

import java.util.Comparator;
import net.minecraft.core.BaseBlockPosition;
import net.minecraft.core.BlockPosition;
import net.minecraft.util.Unit;
import net.minecraft.world.level.ChunkCoordIntPair;
import org.bukkit.plugin.Plugin;

public class TicketType<T> {
    private final String name;
    private final Comparator<T> comparator;
    public long timeout;
    public static final TicketType<Unit> START = TicketType.create("start", (unit, unit1) -> 0);
    public static final TicketType<Unit> DRAGON = TicketType.create("dragon", (unit, unit1) -> 0);
    public static final TicketType<ChunkCoordIntPair> PLAYER = TicketType.create("player", Comparator.comparingLong(ChunkCoordIntPair::toLong));
    public static final TicketType<ChunkCoordIntPair> FORCED = TicketType.create("forced", Comparator.comparingLong(ChunkCoordIntPair::toLong));
    public static final TicketType<BlockPosition> PORTAL = TicketType.create("portal", BaseBlockPosition::compareTo, 300);
    public static final TicketType<Integer> POST_TELEPORT = TicketType.create("post_teleport", Integer::compareTo, 5);
    public static final TicketType<ChunkCoordIntPair> UNKNOWN = TicketType.create("unknown", Comparator.comparingLong(ChunkCoordIntPair::toLong), 1);
    public static final TicketType<Unit> PLUGIN = TicketType.create("plugin", (a2, b2) -> 0);
    public static final TicketType<Plugin> PLUGIN_TICKET = TicketType.create("plugin_ticket", (plugin1, plugin2) -> plugin1.getClass().getName().compareTo(plugin2.getClass().getName()));

    public static <T> TicketType<T> create(String s2, Comparator<T> comparator) {
        return new TicketType<T>(s2, comparator, 0L);
    }

    public static <T> TicketType<T> create(String s2, Comparator<T> comparator, int i2) {
        return new TicketType<T>(s2, comparator, i2);
    }

    protected TicketType(String s2, Comparator<T> comparator, long i2) {
        this.name = s2;
        this.comparator = comparator;
        this.timeout = i2;
    }

    public String toString() {
        return this.name;
    }

    public Comparator<T> getComparator() {
        return this.comparator;
    }

    public long timeout() {
        return this.timeout;
    }
}

