/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.level;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Lists;
import com.google.common.collect.Streams;
import com.mojang.datafixers.DataFixer;
import com.mojang.datafixers.util.Pair;
import com.mojang.logging.LogUtils;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.longs.LongSet;
import it.unimi.dsi.fastutil.longs.LongSets;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectLinkedOpenHashSet;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.Executor;
import java.util.function.BooleanSupplier;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.CrashReport;
import net.minecraft.CrashReportSystemDetails;
import net.minecraft.ReportType;
import net.minecraft.SystemUtils;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.SectionPosition;
import net.minecraft.core.particles.ParticleParam;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.chat.IChatMutableComponent;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundDamageEventPacket;
import net.minecraft.network.protocol.game.PacketDebug;
import net.minecraft.network.protocol.game.PacketPlayOutBlockAction;
import net.minecraft.network.protocol.game.PacketPlayOutBlockBreakAnimation;
import net.minecraft.network.protocol.game.PacketPlayOutEntitySound;
import net.minecraft.network.protocol.game.PacketPlayOutEntityStatus;
import net.minecraft.network.protocol.game.PacketPlayOutExplosion;
import net.minecraft.network.protocol.game.PacketPlayOutNamedSoundEffect;
import net.minecraft.network.protocol.game.PacketPlayOutSpawnPosition;
import net.minecraft.network.protocol.game.PacketPlayOutWorldEvent;
import net.minecraft.network.protocol.game.PacketPlayOutWorldParticles;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.ScoreboardServer;
import net.minecraft.server.level.ChunkProviderServer;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.PlayerChunkMap;
import net.minecraft.server.level.TicketType;
import net.minecraft.server.level.progress.WorldLoadListener;
import net.minecraft.server.players.SleepStatus;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.tags.TagKey;
import net.minecraft.util.AbortableIterationConsumer;
import net.minecraft.util.CSVWriter;
import net.minecraft.util.IProgressUpdate;
import net.minecraft.util.MathHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.util.Unit;
import net.minecraft.util.datafix.DataFixTypes;
import net.minecraft.util.profiling.GameProfilerFiller;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.DifficultyDamageScaler;
import net.minecraft.world.IInventory;
import net.minecraft.world.RandomSequences;
import net.minecraft.world.TickRateManager;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLightning;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumCreatureType;
import net.minecraft.world.entity.ReputationHandler;
import net.minecraft.world.entity.ai.navigation.NavigationAbstract;
import net.minecraft.world.entity.ai.village.ReputationEvent;
import net.minecraft.world.entity.ai.village.poi.PoiTypes;
import net.minecraft.world.entity.ai.village.poi.VillagePlace;
import net.minecraft.world.entity.ai.village.poi.VillagePlaceType;
import net.minecraft.world.entity.animal.EntityAnimal;
import net.minecraft.world.entity.animal.EntityWaterAnimal;
import net.minecraft.world.entity.animal.horse.EntityHorseSkeleton;
import net.minecraft.world.entity.boss.EntityComplexPart;
import net.minecraft.world.entity.boss.enderdragon.EntityEnderDragon;
import net.minecraft.world.entity.npc.NPC;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.raid.PersistentRaid;
import net.minecraft.world.entity.raid.Raid;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraft.world.item.alchemy.PotionBrewer;
import net.minecraft.world.item.crafting.CraftingManager;
import net.minecraft.world.level.BlockActionData;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.ExplosionDamageCalculator;
import net.minecraft.world.level.ForcedChunk;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.GeneratorAccessSeed;
import net.minecraft.world.level.MobSpawner;
import net.minecraft.world.level.SpawnerCreature;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.World;
import net.minecraft.world.level.biome.BiomeBase;
import net.minecraft.world.level.biome.WorldChunkManager;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockSnow;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.TickingBlockEntity;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.chunk.Chunk;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.chunk.ChunkSection;
import net.minecraft.world.level.chunk.IChunkAccess;
import net.minecraft.world.level.chunk.storage.EntityStorage;
import net.minecraft.world.level.chunk.storage.RegionStorageInfo;
import net.minecraft.world.level.chunk.storage.SimpleRegionStorage;
import net.minecraft.world.level.dimension.BuiltinDimensionTypes;
import net.minecraft.world.level.dimension.WorldDimension;
import net.minecraft.world.level.dimension.end.EnderDragonBattle;
import net.minecraft.world.level.entity.EntityTickList;
import net.minecraft.world.level.entity.EntityTypeTest;
import net.minecraft.world.level.entity.LevelCallback;
import net.minecraft.world.level.entity.LevelEntityGetter;
import net.minecraft.world.level.entity.PersistentEntitySectionManager;
import net.minecraft.world.level.gameevent.DynamicGameEventListener;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.gameevent.GameEventDispatcher;
import net.minecraft.world.level.levelgen.ChunkGeneratorAbstract;
import net.minecraft.world.level.levelgen.ChunkProviderFlat;
import net.minecraft.world.level.levelgen.HeightMap;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureBoundingBox;
import net.minecraft.world.level.levelgen.structure.StructureCheck;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplateManager;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidType;
import net.minecraft.world.level.pathfinder.PathTypeCache;
import net.minecraft.world.level.portal.PortalTravelAgent;
import net.minecraft.world.level.saveddata.PersistentBase;
import net.minecraft.world.level.saveddata.maps.MapId;
import net.minecraft.world.level.saveddata.maps.PersistentIdCounts;
import net.minecraft.world.level.saveddata.maps.WorldMap;
import net.minecraft.world.level.storage.Convertable;
import net.minecraft.world.level.storage.WorldDataServer;
import net.minecraft.world.level.storage.WorldPersistentData;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.Vec3D;
import net.minecraft.world.phys.shapes.OperatorBoolean;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.phys.shapes.VoxelShapes;
import net.minecraft.world.ticks.TickListServer;
import org.bukkit.Bukkit;
import org.bukkit.WeatherType;
import org.bukkit.World;
import org.bukkit.craftbukkit.v1_21_R1.event.CraftEventFactory;
import org.bukkit.craftbukkit.v1_21_R1.generator.CustomChunkGenerator;
import org.bukkit.craftbukkit.v1_21_R1.generator.CustomWorldChunkManager;
import org.bukkit.craftbukkit.v1_21_R1.util.WorldUUID;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.LightningStrike;
import org.bukkit.event.Event;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.event.server.MapInitializeEvent;
import org.bukkit.event.weather.LightningStrikeEvent;
import org.bukkit.event.world.TimeSkipEvent;
import org.bukkit.event.world.WorldSaveEvent;
import org.bukkit.generator.BiomeProvider;
import org.bukkit.generator.WorldInfo;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.map.MapView;
import org.slf4j.Logger;
import org.spigotmc.ActivationRange;
import org.spigotmc.AsyncCatcher;

public class WorldServer
extends net.minecraft.world.level.World
implements GeneratorAccessSeed {
    public static final BlockPosition END_SPAWN_POINT = new BlockPosition(100, 50, 0);
    public static final IntProvider RAIN_DELAY = UniformInt.of(12000, 180000);
    public static final IntProvider RAIN_DURATION = UniformInt.of(12000, 24000);
    private static final IntProvider THUNDER_DELAY = UniformInt.of(12000, 180000);
    public static final IntProvider THUNDER_DURATION = UniformInt.of(3600, 15600);
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final int EMPTY_TIME_NO_TICK = 300;
    private static final int MAX_SCHEDULED_TICKS_PER_TICK = 65536;
    final List<EntityPlayer> players;
    private final ChunkProviderServer chunkSource;
    private final MinecraftServer server;
    public final WorldDataServer serverLevelData;
    private int lastSpawnChunkRadius;
    final EntityTickList entityTickList;
    public final PersistentEntitySectionManager<Entity> entityManager;
    private final GameEventDispatcher gameEventDispatcher;
    public boolean noSave;
    private final SleepStatus sleepStatus;
    private int emptyTime;
    private final PortalTravelAgent portalForcer;
    private final TickListServer<Block> blockTicks;
    private final TickListServer<FluidType> fluidTicks;
    private final PathTypeCache pathTypesByPosCache;
    final Set<EntityInsentient> navigatingMobs;
    volatile boolean isUpdatingNavigations;
    protected final PersistentRaid raids;
    private final ObjectLinkedOpenHashSet<BlockActionData> blockEvents;
    private final List<BlockActionData> blockEventsToReschedule;
    private boolean handlingTick;
    private final List<MobSpawner> customSpawners;
    @Nullable
    private EnderDragonBattle dragonFight;
    final Int2ObjectMap<EntityComplexPart> dragonParts;
    private final StructureManager structureManager;
    private final StructureCheck structureCheck;
    private final boolean tickTime;
    private final RandomSequences randomSequences;
    public final Convertable.ConversionSession convertable;
    public final UUID uuid;

    public Chunk getChunkIfLoaded(int x2, int z2) {
        return this.chunkSource.getChunk(x2, z2, false);
    }

    @Override
    public ResourceKey<WorldDimension> getTypeKey() {
        return this.convertable.dimensionType;
    }

    public WorldServer(MinecraftServer minecraftserver, Executor executor, Convertable.ConversionSession convertable_conversionsession, WorldDataServer iworlddataserver, ResourceKey<net.minecraft.world.level.World> resourcekey, WorldDimension worlddimension, WorldLoadListener worldloadlistener, boolean flag, long i2, List<MobSpawner> list, boolean flag1, @Nullable RandomSequences randomsequences, World.Environment env, org.bukkit.generator.ChunkGenerator gen, BiomeProvider biomeProvider) {
        super(iworlddataserver, resourcekey, minecraftserver.registryAccess(), worlddimension.type(), minecraftserver::getProfiler, false, flag, i2, minecraftserver.getMaxChainedNeighborUpdates(), gen, biomeProvider, env);
        this.pvpMode = minecraftserver.isPvpAllowed();
        this.convertable = convertable_conversionsession;
        this.uuid = WorldUUID.getUUID(convertable_conversionsession.levelDirectory.path().toFile());
        this.players = Lists.newArrayList();
        this.entityTickList = new EntityTickList();
        this.blockTicks = new TickListServer(this::isPositionTickingWithEntitiesLoaded, this.getProfilerSupplier());
        this.fluidTicks = new TickListServer(this::isPositionTickingWithEntitiesLoaded, this.getProfilerSupplier());
        this.pathTypesByPosCache = new PathTypeCache();
        this.navigatingMobs = new ObjectOpenHashSet();
        this.blockEvents = new ObjectLinkedOpenHashSet();
        this.blockEventsToReschedule = new ArrayList<BlockActionData>(64);
        this.dragonParts = new Int2ObjectOpenHashMap();
        this.tickTime = flag1;
        this.server = minecraftserver;
        this.customSpawners = list;
        this.serverLevelData = iworlddataserver;
        ChunkGenerator chunkgenerator = worlddimension.generator();
        this.serverLevelData.setWorld(this);
        if (biomeProvider != null) {
            CustomWorldChunkManager worldChunkManager = new CustomWorldChunkManager((WorldInfo)this.getWorld(), biomeProvider, this.server.registryAccess().registryOrThrow(Registries.BIOME));
            if (chunkgenerator instanceof ChunkGeneratorAbstract) {
                ChunkGeneratorAbstract cga = (ChunkGeneratorAbstract)chunkgenerator;
                chunkgenerator = new ChunkGeneratorAbstract((WorldChunkManager)worldChunkManager, cga.settings);
            } else if (chunkgenerator instanceof ChunkProviderFlat) {
                ChunkProviderFlat cpf = (ChunkProviderFlat)chunkgenerator;
                chunkgenerator = new ChunkProviderFlat(cpf.settings(), worldChunkManager);
            }
        }
        if (gen != null) {
            chunkgenerator = new CustomChunkGenerator(this, chunkgenerator, gen);
        }
        boolean flag2 = minecraftserver.forceSynchronousWrites();
        DataFixer datafixer = minecraftserver.getFixerUpper();
        EntityStorage entitypersistentstorage = new EntityStorage(new SimpleRegionStorage(new RegionStorageInfo(convertable_conversionsession.getLevelId(), resourcekey, "entities"), convertable_conversionsession.getDimensionPath(resourcekey).resolve("entities"), datafixer, flag2, DataFixTypes.ENTITY_CHUNK), this, minecraftserver);
        this.entityManager = new PersistentEntitySectionManager<Entity>(Entity.class, new a(), entitypersistentstorage);
        StructureTemplateManager structuretemplatemanager = minecraftserver.getStructureManager();
        int j2 = this.spigotConfig.viewDistance;
        int k2 = this.spigotConfig.simulationDistance;
        PersistentEntitySectionManager<Entity> persistententitysectionmanager = this.entityManager;
        Objects.requireNonNull(this.entityManager);
        this.chunkSource = new ChunkProviderServer(this, convertable_conversionsession, datafixer, structuretemplatemanager, executor, chunkgenerator, j2, k2, flag2, worldloadlistener, persistententitysectionmanager::updateChunkStatus, () -> minecraftserver.overworld().getDataStorage());
        this.chunkSource.getGeneratorState().ensureStructuresGenerated();
        this.portalForcer = new PortalTravelAgent(this);
        this.updateSkyBrightness();
        this.prepareWeather();
        this.getWorldBorder().setAbsoluteMaxSize(minecraftserver.getAbsoluteMaxWorldSize());
        this.raids = this.getDataStorage().computeIfAbsent(PersistentRaid.factory(this), PersistentRaid.getFileId(this.dimensionTypeRegistration()));
        if (!minecraftserver.isSingleplayer()) {
            iworlddataserver.setGameType(minecraftserver.getDefaultGameType());
        }
        long l2 = minecraftserver.getWorldData().worldGenOptions().seed();
        this.structureCheck = new StructureCheck(this.chunkSource.chunkScanner(), this.registryAccess(), minecraftserver.getStructureManager(), resourcekey, chunkgenerator, this.chunkSource.randomState(), this, chunkgenerator.getBiomeSource(), l2, datafixer);
        this.structureManager = new StructureManager(this, this.serverLevelData.worldGenOptions(), this.structureCheck);
        this.dragonFight = this.dimension() == net.minecraft.world.level.World.END && this.dimensionTypeRegistration().is(BuiltinDimensionTypes.END) || env == World.Environment.THE_END ? new EnderDragonBattle(this, this.serverLevelData.worldGenOptions().seed(), this.serverLevelData.endDragonFightData()) : null;
        this.sleepStatus = new SleepStatus();
        this.gameEventDispatcher = new GameEventDispatcher(this);
        this.randomSequences = Objects.requireNonNullElseGet(randomsequences, () -> this.getDataStorage().computeIfAbsent(RandomSequences.factory(l2), "random_sequences"));
        this.getCraftServer().addWorld(this.getWorld());
    }

    @Deprecated
    @VisibleForTesting
    public void setDragonFight(@Nullable EnderDragonBattle enderdragonbattle) {
        this.dragonFight = enderdragonbattle;
    }

    public void setWeatherParameters(int i2, int j2, boolean flag, boolean flag1) {
        this.serverLevelData.setClearWeatherTime(i2);
        this.serverLevelData.setRainTime(j2);
        this.serverLevelData.setThunderTime(j2);
        this.serverLevelData.setRaining(flag);
        this.serverLevelData.setThundering(flag1);
    }

    @Override
    public Holder<BiomeBase> getUncachedNoiseBiome(int i2, int j2, int k2) {
        return this.getChunkSource().getGenerator().getBiomeSource().getNoiseBiome(i2, j2, k2, this.getChunkSource().randomState().sampler());
    }

    public StructureManager structureManager() {
        return this.structureManager;
    }

    public void tick(BooleanSupplier booleansupplier) {
        long j2;
        int i2;
        GameProfilerFiller gameprofilerfiller = this.getProfiler();
        this.handlingTick = true;
        TickRateManager tickratemanager = this.tickRateManager();
        boolean flag = tickratemanager.runsNormally();
        if (flag) {
            gameprofilerfiller.push("world border");
            this.getWorldBorder().tick();
            gameprofilerfiller.popPush("weather");
            this.advanceWeatherCycle();
        }
        if (this.sleepStatus.areEnoughSleeping(i2 = this.getGameRules().getInt(GameRules.RULE_PLAYERS_SLEEPING_PERCENTAGE)) && this.sleepStatus.areEnoughDeepSleeping(i2, this.players)) {
            j2 = this.levelData.getDayTime() + 24000L;
            TimeSkipEvent event = new TimeSkipEvent((World)this.getWorld(), TimeSkipEvent.SkipReason.NIGHT_SKIP, j2 - j2 % 24000L - this.getDayTime());
            if (this.getGameRules().getBoolean(GameRules.RULE_DAYLIGHT)) {
                this.getCraftServer().getPluginManager().callEvent((Event)event);
                if (!event.isCancelled()) {
                    this.setDayTime(this.getDayTime() + event.getSkipAmount());
                }
            }
            if (!event.isCancelled()) {
                this.wakeUpAllPlayers();
            }
            if (this.getGameRules().getBoolean(GameRules.RULE_WEATHER_CYCLE) && this.isRaining()) {
                this.resetWeatherCycle();
            }
        }
        this.updateSkyBrightness();
        if (flag) {
            this.tickTime();
        }
        gameprofilerfiller.popPush("tickPending");
        this.timings.doTickPending.startTiming();
        if (!this.isDebug() && flag) {
            j2 = this.getGameTime();
            gameprofilerfiller.push("blockTicks");
            this.blockTicks.tick(j2, 65536, this::tickBlock);
            gameprofilerfiller.popPush("fluidTicks");
            this.fluidTicks.tick(j2, 65536, this::tickFluid);
            gameprofilerfiller.pop();
        }
        this.timings.doTickPending.stopTiming();
        gameprofilerfiller.popPush("raid");
        if (flag) {
            this.raids.tick();
        }
        gameprofilerfiller.popPush("chunkSource");
        this.getChunkSource().tick(booleansupplier, true);
        gameprofilerfiller.popPush("blockEvents");
        if (flag) {
            this.timings.doSounds.startTiming();
            this.runBlockEvents();
            this.timings.doSounds.stopTiming();
        }
        this.handlingTick = false;
        gameprofilerfiller.pop();
        boolean flag1 = true;
        if (flag1) {
            this.resetEmptyTime();
        }
        if (flag1 || this.emptyTime++ < 300) {
            gameprofilerfiller.push("entities");
            this.timings.tickEntities.startTiming();
            if (this.dragonFight != null && flag) {
                gameprofilerfiller.push("dragonFight");
                this.dragonFight.tick();
                gameprofilerfiller.pop();
            }
            ActivationRange.activateEntities(this);
            this.timings.entityTick.startTiming();
            this.entityTickList.forEach(entity -> {
                if (!entity.isRemoved() && !tickratemanager.isEntityFrozen((Entity)entity)) {
                    gameprofilerfiller.push("checkDespawn");
                    entity.checkDespawn();
                    gameprofilerfiller.pop();
                    if (this.chunkSource.chunkMap.getDistanceManager().inEntityTickingRange(entity.chunkPosition().toLong())) {
                        Entity entity1 = entity.getVehicle();
                        if (entity1 != null) {
                            if (!entity1.isRemoved() && entity1.hasPassenger((Entity)entity)) {
                                return;
                            }
                            entity.stopRiding();
                        }
                        gameprofilerfiller.push("tick");
                        this.guardEntityTick(this::tickNonPassenger, entity);
                        gameprofilerfiller.pop();
                    }
                }
            });
            this.timings.entityTick.stopTiming();
            this.timings.tickEntities.stopTiming();
            gameprofilerfiller.pop();
            this.tickBlockEntities();
        }
        gameprofilerfiller.push("entityManagement");
        this.entityManager.tick();
        gameprofilerfiller.pop();
    }

    @Override
    public boolean shouldTickBlocksAt(long i2) {
        return this.chunkSource.chunkMap.getDistanceManager().inBlockTickingRange(i2);
    }

    protected void tickTime() {
        if (this.tickTime) {
            long i2 = this.levelData.getGameTime() + 1L;
            this.serverLevelData.setGameTime(i2);
            this.serverLevelData.getScheduledEvents().tick(this.server, i2);
            if (this.levelData.getGameRules().getBoolean(GameRules.RULE_DAYLIGHT)) {
                this.setDayTime(this.levelData.getDayTime() + 1L);
            }
        }
    }

    public void setDayTime(long i2) {
        this.serverLevelData.setDayTime(i2);
    }

    public void tickCustomSpawners(boolean flag, boolean flag1) {
        for (MobSpawner mobspawner : this.customSpawners) {
            mobspawner.tick(this, flag, flag1);
        }
    }

    private boolean shouldDiscardEntity(Entity entity) {
        return !this.server.isSpawningAnimals() && (entity instanceof EntityAnimal || entity instanceof EntityWaterAnimal) ? true : !this.server.areNpcsEnabled() && entity instanceof NPC;
    }

    private void wakeUpAllPlayers() {
        this.sleepStatus.removeAllSleepers();
        this.players.stream().filter(EntityLiving::isSleeping).collect(Collectors.toList()).forEach(entityplayer -> entityplayer.stopSleepInBed(false, false));
    }

    public void tickChunk(Chunk chunk, int i2) {
        BlockPosition blockposition;
        ChunkCoordIntPair chunkcoordintpair = chunk.getPos();
        boolean flag = this.isRaining();
        int j2 = chunkcoordintpair.getMinBlockX();
        int k2 = chunkcoordintpair.getMinBlockZ();
        GameProfilerFiller gameprofilerfiller = this.getProfiler();
        gameprofilerfiller.push("thunder");
        if (flag && this.isThundering() && this.spigotConfig.thunderChance > 0 && this.random.nextInt(this.spigotConfig.thunderChance) == 0 && this.isRainingAt(blockposition = this.findLightningTargetAround(this.getBlockRandomPos(j2, 0, k2, 15)))) {
            EntityLightning entitylightning;
            EntityHorseSkeleton entityhorseskeleton;
            boolean flag1;
            DifficultyDamageScaler difficultydamagescaler = this.getCurrentDifficultyAt(blockposition);
            boolean bl = flag1 = this.getGameRules().getBoolean(GameRules.RULE_DOMOBSPAWNING) && this.random.nextDouble() < (double)difficultydamagescaler.getEffectiveDifficulty() * 0.01 && !this.getBlockState(blockposition.below()).is(Blocks.LIGHTNING_ROD);
            if (flag1 && (entityhorseskeleton = EntityTypes.SKELETON_HORSE.create(this)) != null) {
                entityhorseskeleton.setTrap(true);
                entityhorseskeleton.setAge(0);
                entityhorseskeleton.setPos(blockposition.getX(), blockposition.getY(), blockposition.getZ());
                this.addFreshEntity(entityhorseskeleton, CreatureSpawnEvent.SpawnReason.LIGHTNING);
            }
            if ((entitylightning = EntityTypes.LIGHTNING_BOLT.create(this)) != null) {
                entitylightning.moveTo(Vec3D.atBottomCenterOf(blockposition));
                entitylightning.setVisualOnly(flag1);
                this.strikeLightning(entitylightning, LightningStrikeEvent.Cause.WEATHER);
            }
        }
        gameprofilerfiller.popPush("iceandsnow");
        for (int l2 = 0; l2 < i2; ++l2) {
            if (this.random.nextInt(48) != 0) continue;
            this.tickPrecipitation(this.getBlockRandomPos(j2, 0, k2, 15));
        }
        gameprofilerfiller.popPush("tickBlocks");
        if (i2 > 0) {
            ChunkSection[] achunksection = chunk.getSections();
            for (int i1 = 0; i1 < achunksection.length; ++i1) {
                ChunkSection chunksection = achunksection[i1];
                if (!chunksection.isRandomlyTicking()) continue;
                int j1 = chunk.getSectionYFromSectionIndex(i1);
                int k1 = SectionPosition.sectionToBlockCoord(j1);
                for (int l1 = 0; l1 < i2; ++l1) {
                    Fluid fluid;
                    BlockPosition blockposition1 = this.getBlockRandomPos(j2, k1, k2, 15);
                    gameprofilerfiller.push("randomTick");
                    IBlockData iblockdata = chunksection.getBlockState(blockposition1.getX() - j2, blockposition1.getY() - k1, blockposition1.getZ() - k2);
                    if (iblockdata.isRandomlyTicking()) {
                        iblockdata.randomTick(this, blockposition1, this.random);
                    }
                    if ((fluid = iblockdata.getFluidState()).isRandomlyTicking()) {
                        fluid.randomTick(this, blockposition1, this.random);
                    }
                    gameprofilerfiller.pop();
                }
            }
        }
        gameprofilerfiller.pop();
    }

    @VisibleForTesting
    public void tickPrecipitation(BlockPosition blockposition) {
        BlockPosition blockposition1 = this.getHeightmapPos(HeightMap.Type.MOTION_BLOCKING, blockposition);
        BlockPosition blockposition2 = blockposition1.below();
        BiomeBase biomebase = this.getBiome(blockposition1).value();
        if (biomebase.shouldFreeze(this, blockposition2)) {
            CraftEventFactory.handleBlockFormEvent((net.minecraft.world.level.World)this, blockposition2, Blocks.ICE.defaultBlockState(), null);
        }
        if (this.isRaining()) {
            BiomeBase.Precipitation biomebase_precipitation;
            int i2 = this.getGameRules().getInt(GameRules.RULE_SNOW_ACCUMULATION_HEIGHT);
            if (i2 > 0 && biomebase.shouldSnow(this, blockposition1)) {
                IBlockData iblockdata = this.getBlockState(blockposition1);
                if (iblockdata.is(Blocks.SNOW)) {
                    int j2 = iblockdata.getValue(BlockSnow.LAYERS);
                    if (j2 < Math.min(i2, 8)) {
                        IBlockData iblockdata1 = (IBlockData)iblockdata.setValue(BlockSnow.LAYERS, j2 + 1);
                        Block.pushEntitiesUp(iblockdata, iblockdata1, this, blockposition1);
                        CraftEventFactory.handleBlockFormEvent((net.minecraft.world.level.World)this, blockposition1, iblockdata1, null);
                    }
                } else {
                    CraftEventFactory.handleBlockFormEvent((net.minecraft.world.level.World)this, blockposition1, Blocks.SNOW.defaultBlockState(), null);
                }
            }
            if ((biomebase_precipitation = biomebase.getPrecipitationAt(blockposition2)) != BiomeBase.Precipitation.NONE) {
                IBlockData iblockdata2 = this.getBlockState(blockposition2);
                iblockdata2.getBlock().handlePrecipitation(iblockdata2, this, blockposition2, biomebase_precipitation);
            }
        }
    }

    private Optional<BlockPosition> findLightningRod(BlockPosition blockposition) {
        Optional<BlockPosition> optional = this.getPoiManager().findClosest(holder -> holder.is(PoiTypes.LIGHTNING_ROD), blockposition1 -> blockposition1.getY() == this.getHeight(HeightMap.Type.WORLD_SURFACE, blockposition1.getX(), blockposition1.getZ()) - 1, blockposition, 128, VillagePlace.Occupancy.ANY);
        return optional.map(blockposition1 -> blockposition1.above(1));
    }

    protected BlockPosition findLightningTargetAround(BlockPosition blockposition) {
        BlockPosition blockposition1 = this.getHeightmapPos(HeightMap.Type.MOTION_BLOCKING, blockposition);
        Optional<BlockPosition> optional = this.findLightningRod(blockposition1);
        if (optional.isPresent()) {
            return optional.get();
        }
        AxisAlignedBB axisalignedbb = AxisAlignedBB.encapsulatingFullBlocks(blockposition1, new BlockPosition(blockposition1.atY(this.getMaxBuildHeight()))).inflate(3.0);
        List<EntityLiving> list = this.getEntitiesOfClass(EntityLiving.class, axisalignedbb, entityliving -> entityliving != null && entityliving.isAlive() && this.canSeeSky(entityliving.blockPosition()));
        if (!list.isEmpty()) {
            return list.get(this.random.nextInt(list.size())).blockPosition();
        }
        if (blockposition1.getY() == this.getMinBuildHeight() - 1) {
            blockposition1 = blockposition1.above(2);
        }
        return blockposition1;
    }

    public boolean isHandlingTick() {
        return this.handlingTick;
    }

    public boolean canSleepThroughNights() {
        return this.getGameRules().getInt(GameRules.RULE_PLAYERS_SLEEPING_PERCENTAGE) <= 100;
    }

    private void announceSleepStatus() {
        if (this.canSleepThroughNights() && (!this.getServer().isSingleplayer() || this.getServer().isPublished())) {
            int i2 = this.getGameRules().getInt(GameRules.RULE_PLAYERS_SLEEPING_PERCENTAGE);
            IChatMutableComponent ichatmutablecomponent = this.sleepStatus.areEnoughSleeping(i2) ? IChatBaseComponent.translatable("sleep.skipping_night") : IChatBaseComponent.translatable("sleep.players_sleeping", this.sleepStatus.amountSleeping(), this.sleepStatus.sleepersNeeded(i2));
            for (EntityPlayer entityplayer : this.players) {
                entityplayer.displayClientMessage(ichatmutablecomponent, true);
            }
        }
    }

    public void updateSleepingPlayerList() {
        if (!this.players.isEmpty() && this.sleepStatus.update(this.players)) {
            this.announceSleepStatus();
        }
    }

    @Override
    public ScoreboardServer getScoreboard() {
        return this.server.getScoreboard();
    }

    private void advanceWeatherCycle() {
        int idx;
        boolean flag = this.isRaining();
        if (this.dimensionType().hasSkyLight()) {
            if (this.getGameRules().getBoolean(GameRules.RULE_WEATHER_CYCLE)) {
                int i2 = this.serverLevelData.getClearWeatherTime();
                int j2 = this.serverLevelData.getThunderTime();
                int k2 = this.serverLevelData.getRainTime();
                boolean flag1 = this.levelData.isThundering();
                boolean flag2 = this.levelData.isRaining();
                if (i2 > 0) {
                    --i2;
                    j2 = flag1 ? 0 : 1;
                    k2 = flag2 ? 0 : 1;
                    flag1 = false;
                    flag2 = false;
                } else {
                    if (j2 > 0) {
                        if (--j2 == 0) {
                            flag1 = !flag1;
                        }
                    } else {
                        j2 = flag1 ? THUNDER_DURATION.sample(this.random) : THUNDER_DELAY.sample(this.random);
                    }
                    if (k2 > 0) {
                        if (--k2 == 0) {
                            flag2 = !flag2;
                        }
                    } else {
                        k2 = flag2 ? RAIN_DURATION.sample(this.random) : RAIN_DELAY.sample(this.random);
                    }
                }
                this.serverLevelData.setThunderTime(j2);
                this.serverLevelData.setRainTime(k2);
                this.serverLevelData.setClearWeatherTime(i2);
                this.serverLevelData.setThundering(flag1);
                this.serverLevelData.setRaining(flag2);
            }
            this.oThunderLevel = this.thunderLevel;
            this.thunderLevel = this.levelData.isThundering() ? (this.thunderLevel += 0.01f) : (this.thunderLevel -= 0.01f);
            this.thunderLevel = MathHelper.clamp(this.thunderLevel, 0.0f, 1.0f);
            this.oRainLevel = this.rainLevel;
            this.rainLevel = this.levelData.isRaining() ? (this.rainLevel += 0.01f) : (this.rainLevel -= 0.01f);
            this.rainLevel = MathHelper.clamp(this.rainLevel, 0.0f, 1.0f);
        }
        for (idx = 0; idx < this.players.size(); ++idx) {
            if (this.players.get(idx).level() != this) continue;
            this.players.get(idx).tickWeather();
        }
        if (flag != this.isRaining()) {
            for (idx = 0; idx < this.players.size(); ++idx) {
                if (this.players.get(idx).level() != this) continue;
                this.players.get(idx).setPlayerWeather(!flag ? WeatherType.DOWNFALL : WeatherType.CLEAR, false);
            }
        }
        for (idx = 0; idx < this.players.size(); ++idx) {
            if (this.players.get(idx).level() != this) continue;
            this.players.get(idx).updateWeather(this.oRainLevel, this.rainLevel, this.oThunderLevel, this.thunderLevel);
        }
    }

    @VisibleForTesting
    public void resetWeatherCycle() {
        this.serverLevelData.setRaining(false);
        if (!this.serverLevelData.isRaining()) {
            this.serverLevelData.setRainTime(0);
        }
        this.serverLevelData.setThundering(false);
        if (!this.serverLevelData.isThundering()) {
            this.serverLevelData.setThunderTime(0);
        }
    }

    public void resetEmptyTime() {
        this.emptyTime = 0;
    }

    private void tickFluid(BlockPosition blockposition, FluidType fluidtype) {
        Fluid fluid = this.getFluidState(blockposition);
        if (fluid.is(fluidtype)) {
            fluid.tick(this, blockposition);
        }
    }

    private void tickBlock(BlockPosition blockposition, Block block) {
        IBlockData iblockdata = this.getBlockState(blockposition);
        if (iblockdata.is(block)) {
            iblockdata.tick(this, blockposition, this.random);
        }
    }

    public void tickNonPassenger(Entity entity) {
        if (!ActivationRange.checkIfActive(entity)) {
            ++entity.tickCount;
            entity.inactiveTick();
            return;
        }
        entity.tickTimer.startTiming();
        entity.setOldPosAndRot();
        GameProfilerFiller gameprofilerfiller = this.getProfiler();
        ++entity.tickCount;
        this.getProfiler().push(() -> BuiltInRegistries.ENTITY_TYPE.getKey(entity.getType()).toString());
        gameprofilerfiller.incrementCounter("tickNonPassenger");
        entity.tick();
        entity.postTick();
        this.getProfiler().pop();
        for (Entity entity1 : entity.getPassengers()) {
            this.tickPassenger(entity, entity1);
        }
        entity.tickTimer.stopTiming();
    }

    private void tickPassenger(Entity entity, Entity entity1) {
        if (!entity1.isRemoved() && entity1.getVehicle() == entity) {
            if (entity1 instanceof EntityHuman || this.entityTickList.contains(entity1)) {
                entity1.setOldPosAndRot();
                ++entity1.tickCount;
                GameProfilerFiller gameprofilerfiller = this.getProfiler();
                gameprofilerfiller.push(() -> BuiltInRegistries.ENTITY_TYPE.getKey(entity1.getType()).toString());
                gameprofilerfiller.incrementCounter("tickPassenger");
                entity1.rideTick();
                entity1.postTick();
                gameprofilerfiller.pop();
                for (Entity entity2 : entity1.getPassengers()) {
                    this.tickPassenger(entity1, entity2);
                }
            }
        } else {
            entity1.stopRiding();
        }
    }

    @Override
    public boolean mayInteract(EntityHuman entityhuman, BlockPosition blockposition) {
        return !this.server.isUnderSpawnProtection(this, blockposition, entityhuman) && this.getWorldBorder().isWithinBounds(blockposition);
    }

    public void save(@Nullable IProgressUpdate iprogressupdate, boolean flag, boolean flag1) {
        ChunkProviderServer chunkproviderserver = this.getChunkSource();
        if (!flag1) {
            Bukkit.getPluginManager().callEvent((Event)new WorldSaveEvent((World)this.getWorld()));
            if (iprogressupdate != null) {
                iprogressupdate.progressStartNoAbort(IChatBaseComponent.translatable("menu.savingLevel"));
            }
            this.saveLevelData();
            if (iprogressupdate != null) {
                iprogressupdate.progressStage(IChatBaseComponent.translatable("menu.savingChunks"));
            }
            chunkproviderserver.save(flag);
            if (flag) {
                this.entityManager.saveAll();
            } else {
                this.entityManager.autoSave();
            }
        }
        WorldServer worldserver1 = this;
        this.serverLevelData.setWorldBorder(worldserver1.getWorldBorder().createSettings());
        this.serverLevelData.setCustomBossEvents(this.server.getCustomBossEvents().save(this.registryAccess()));
        this.convertable.saveDataTag(this.server.registryAccess(), this.serverLevelData, this.server.getPlayerList().getSingleplayerData());
    }

    private void saveLevelData() {
        if (this.dragonFight != null) {
            this.serverLevelData.setEndDragonFightData(this.dragonFight.saveData());
        }
        this.getChunkSource().getDataStorage().save();
    }

    public <T extends Entity> List<? extends T> getEntities(EntityTypeTest<Entity, T> entitytypetest, Predicate<? super T> predicate) {
        ArrayList list = Lists.newArrayList();
        this.getEntities(entitytypetest, predicate, list);
        return list;
    }

    public <T extends Entity> void getEntities(EntityTypeTest<Entity, T> entitytypetest, Predicate<? super T> predicate, List<? super T> list) {
        this.getEntities(entitytypetest, predicate, list, Integer.MAX_VALUE);
    }

    public <T extends Entity> void getEntities(EntityTypeTest<Entity, T> entitytypetest, Predicate<? super T> predicate, List<? super T> list, int i2) {
        this.getEntities().get(entitytypetest, entity -> {
            if (predicate.test(entity)) {
                list.add((Object)entity);
                if (list.size() >= i2) {
                    return AbortableIterationConsumer.a.ABORT;
                }
            }
            return AbortableIterationConsumer.a.CONTINUE;
        });
    }

    public List<? extends EntityEnderDragon> getDragons() {
        return this.getEntities(EntityTypes.ENDER_DRAGON, EntityLiving::isAlive);
    }

    public List<EntityPlayer> getPlayers(Predicate<? super EntityPlayer> predicate) {
        return this.getPlayers(predicate, Integer.MAX_VALUE);
    }

    public List<EntityPlayer> getPlayers(Predicate<? super EntityPlayer> predicate, int i2) {
        ArrayList list = Lists.newArrayList();
        for (EntityPlayer entityplayer : this.players) {
            if (!predicate.test(entityplayer)) continue;
            list.add(entityplayer);
            if (list.size() < i2) continue;
            return list;
        }
        return list;
    }

    @Nullable
    public EntityPlayer getRandomPlayer() {
        List<EntityPlayer> list = this.getPlayers(EntityLiving::isAlive);
        return list.isEmpty() ? null : list.get(this.random.nextInt(list.size()));
    }

    @Override
    public boolean addFreshEntity(Entity entity) {
        return this.addFreshEntity(entity, CreatureSpawnEvent.SpawnReason.DEFAULT);
    }

    @Override
    public boolean addFreshEntity(Entity entity, CreatureSpawnEvent.SpawnReason reason) {
        return this.addEntity(entity, reason);
    }

    public boolean addWithUUID(Entity entity) {
        return this.addWithUUID(entity, CreatureSpawnEvent.SpawnReason.DEFAULT);
    }

    public boolean addWithUUID(Entity entity, CreatureSpawnEvent.SpawnReason reason) {
        return this.addEntity(entity, reason);
    }

    public void addDuringTeleport(Entity entity) {
        this.addDuringTeleport(entity, null);
    }

    public void addDuringTeleport(Entity entity, CreatureSpawnEvent.SpawnReason reason) {
        if (entity instanceof EntityPlayer) {
            EntityPlayer entityplayer = (EntityPlayer)entity;
            this.addPlayer(entityplayer);
        } else {
            this.addEntity(entity, reason);
        }
    }

    public void addNewPlayer(EntityPlayer entityplayer) {
        this.addPlayer(entityplayer);
    }

    public void addRespawnedPlayer(EntityPlayer entityplayer) {
        this.addPlayer(entityplayer);
    }

    private void addPlayer(EntityPlayer entityplayer) {
        Entity entity = this.getEntities().get(entityplayer.getUUID());
        if (entity != null) {
            LOGGER.warn("Force-added player with duplicate UUID {}", (Object)entityplayer.getUUID());
            entity.unRide();
            this.removePlayerImmediately((EntityPlayer)entity, Entity.RemovalReason.DISCARDED);
        }
        this.entityManager.addNewEntity(entityplayer);
    }

    private boolean addEntity(Entity entity, CreatureSpawnEvent.SpawnReason spawnReason) {
        AsyncCatcher.catchOp("entity add");
        if (entity.isRemoved()) {
            return false;
        }
        if (spawnReason != null && !CraftEventFactory.doEntityAddEventCalling(this, entity, spawnReason)) {
            return false;
        }
        return this.entityManager.addNewEntity(entity);
    }

    public boolean tryAddFreshEntityWithPassengers(Entity entity) {
        return this.tryAddFreshEntityWithPassengers(entity, CreatureSpawnEvent.SpawnReason.DEFAULT);
    }

    public boolean tryAddFreshEntityWithPassengers(Entity entity, CreatureSpawnEvent.SpawnReason reason) {
        Stream<UUID> stream = entity.getSelfAndPassengers().map(Entity::getUUID);
        PersistentEntitySectionManager<Entity> persistententitysectionmanager = this.entityManager;
        Objects.requireNonNull(this.entityManager);
        if (stream.anyMatch(persistententitysectionmanager::isLoaded)) {
            return false;
        }
        this.addFreshEntityWithPassengers(entity, reason);
        return true;
    }

    public void unload(Chunk chunk) {
        for (TileEntity tileentity : chunk.getBlockEntities().values()) {
            if (!(tileentity instanceof IInventory)) continue;
            for (HumanEntity h2 : Lists.newArrayList(((IInventory)((Object)tileentity)).getViewers())) {
                h2.closeInventory();
            }
        }
        chunk.clearAllBlockEntities();
        chunk.unregisterTickContainerFromLevel(this);
    }

    public void removePlayerImmediately(EntityPlayer entityplayer, Entity.RemovalReason entity_removalreason) {
        entityplayer.remove(entity_removalreason, null);
    }

    public boolean strikeLightning(Entity entitylightning) {
        return this.strikeLightning(entitylightning, LightningStrikeEvent.Cause.UNKNOWN);
    }

    public boolean strikeLightning(Entity entitylightning, LightningStrikeEvent.Cause cause) {
        LightningStrikeEvent lightning = CraftEventFactory.callLightningStrikeEvent((LightningStrike)entitylightning.getBukkitEntity(), cause);
        if (lightning.isCancelled()) {
            return false;
        }
        return this.addFreshEntity(entitylightning);
    }

    @Override
    public void destroyBlockProgress(int i2, BlockPosition blockposition, int j2) {
        Iterator<EntityPlayer> iterator = this.server.getPlayerList().getPlayers().iterator();
        EntityHuman entityhuman = null;
        Entity entity = this.getEntity(i2);
        if (entity instanceof EntityHuman) {
            entityhuman = (EntityHuman)entity;
        }
        while (iterator.hasNext()) {
            EntityPlayer entityplayer = iterator.next();
            if (entityplayer == null || entityplayer.level() != this || entityplayer.getId() == i2) continue;
            double d0 = (double)blockposition.getX() - entityplayer.getX();
            double d1 = (double)blockposition.getY() - entityplayer.getY();
            double d2 = (double)blockposition.getZ() - entityplayer.getZ();
            if (entityhuman != null && !entityplayer.getBukkitEntity().canSee(entityhuman.getBukkitEntity()) || !(d0 * d0 + d1 * d1 + d2 * d2 < 1024.0)) continue;
            entityplayer.connection.send(new PacketPlayOutBlockBreakAnimation(i2, blockposition, j2));
        }
    }

    @Override
    public void playSeededSound(@Nullable EntityHuman entityhuman, double d0, double d1, double d2, Holder<SoundEffect> holder, SoundCategory soundcategory, float f2, float f1, long i2) {
        this.server.getPlayerList().broadcast(entityhuman, d0, d1, d2, holder.value().getRange(f2), this.dimension(), new PacketPlayOutNamedSoundEffect(holder, soundcategory, d0, d1, d2, f2, f1, i2));
    }

    @Override
    public void playSeededSound(@Nullable EntityHuman entityhuman, Entity entity, Holder<SoundEffect> holder, SoundCategory soundcategory, float f2, float f1, long i2) {
        this.server.getPlayerList().broadcast(entityhuman, entity.getX(), entity.getY(), entity.getZ(), holder.value().getRange(f2), this.dimension(), new PacketPlayOutEntitySound(holder, soundcategory, entity, f2, f1, i2));
    }

    @Override
    public void globalLevelEvent(int i2, BlockPosition blockposition, int j2) {
        if (this.getGameRules().getBoolean(GameRules.RULE_GLOBAL_SOUND_EVENTS)) {
            this.server.getPlayerList().broadcastAll(new PacketPlayOutWorldEvent(i2, blockposition, j2, true));
        } else {
            this.levelEvent(null, i2, blockposition, j2);
        }
    }

    @Override
    public void levelEvent(@Nullable EntityHuman entityhuman, int i2, BlockPosition blockposition, int j2) {
        this.server.getPlayerList().broadcast(entityhuman, blockposition.getX(), blockposition.getY(), blockposition.getZ(), 64.0, this.dimension(), new PacketPlayOutWorldEvent(i2, blockposition, j2, false));
    }

    public int getLogicalHeight() {
        return this.dimensionType().logicalHeight();
    }

    @Override
    public void gameEvent(Holder<GameEvent> holder, Vec3D vec3d, GameEvent.a gameevent_a) {
        this.gameEventDispatcher.post(holder, vec3d, gameevent_a);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void sendBlockUpdated(BlockPosition blockposition, IBlockData iblockdata, IBlockData iblockdata1, int i2) {
        if (this.isUpdatingNavigations) {
            String s2 = "recursive call to sendBlockUpdated";
            SystemUtils.logAndPauseIfInIde("recursive call to sendBlockUpdated", new IllegalStateException("recursive call to sendBlockUpdated"));
        }
        this.getChunkSource().blockChanged(blockposition);
        this.pathTypesByPosCache.invalidate(blockposition);
        VoxelShape voxelshape = iblockdata.getCollisionShape(this, blockposition);
        VoxelShape voxelshape1 = iblockdata1.getCollisionShape(this, blockposition);
        if (VoxelShapes.joinIsNotEmpty(voxelshape, voxelshape1, OperatorBoolean.NOT_SAME)) {
            ObjectArrayList list = new ObjectArrayList();
            Iterator<EntityInsentient> iterator = this.navigatingMobs.iterator();
            while (iterator.hasNext()) {
                EntityInsentient entityinsentient;
                try {
                    entityinsentient = iterator.next();
                }
                catch (ConcurrentModificationException ex) {
                    this.sendBlockUpdated(blockposition, iblockdata, iblockdata1, i2);
                    return;
                }
                NavigationAbstract navigationabstract = entityinsentient.getNavigation();
                if (!navigationabstract.shouldRecomputePath(blockposition)) continue;
                list.add(navigationabstract);
            }
            try {
                this.isUpdatingNavigations = true;
                for (NavigationAbstract navigationabstract1 : list) {
                    navigationabstract1.recomputePath();
                }
            }
            finally {
                this.isUpdatingNavigations = false;
            }
        }
    }

    @Override
    public void updateNeighborsAt(BlockPosition blockposition, Block block) {
        this.neighborUpdater.updateNeighborsAtExceptFromFacing(blockposition, block, null);
    }

    @Override
    public void updateNeighborsAtExceptFromFacing(BlockPosition blockposition, Block block, EnumDirection enumdirection) {
        this.neighborUpdater.updateNeighborsAtExceptFromFacing(blockposition, block, enumdirection);
    }

    @Override
    public void neighborChanged(BlockPosition blockposition, Block block, BlockPosition blockposition1) {
        this.neighborUpdater.neighborChanged(blockposition, block, blockposition1);
    }

    @Override
    public void neighborChanged(IBlockData iblockdata, BlockPosition blockposition, Block block, BlockPosition blockposition1, boolean flag) {
        this.neighborUpdater.neighborChanged(iblockdata, blockposition, block, blockposition1, flag);
    }

    @Override
    public void broadcastEntityEvent(Entity entity, byte b0) {
        this.getChunkSource().broadcastAndSend(entity, new PacketPlayOutEntityStatus(entity, b0));
    }

    @Override
    public void broadcastDamageEvent(Entity entity, DamageSource damagesource) {
        this.getChunkSource().broadcastAndSend(entity, new ClientboundDamageEventPacket(entity, damagesource));
    }

    @Override
    public ChunkProviderServer getChunkSource() {
        return this.chunkSource;
    }

    @Override
    public Explosion explode(@Nullable Entity entity, @Nullable DamageSource damagesource, @Nullable ExplosionDamageCalculator explosiondamagecalculator, double d0, double d1, double d2, float f2, boolean flag, World.a world_a, ParticleParam particleparam, ParticleParam particleparam1, Holder<SoundEffect> holder) {
        Explosion explosion = this.explode(entity, damagesource, explosiondamagecalculator, d0, d1, d2, f2, flag, world_a, false, particleparam, particleparam1, holder);
        if (explosion.wasCanceled) {
            return explosion;
        }
        if (!explosion.interactsWithBlocks()) {
            explosion.clearToBlow();
        }
        for (EntityPlayer entityplayer : this.players) {
            if (!(entityplayer.distanceToSqr(d0, d1, d2) < 4096.0)) continue;
            entityplayer.connection.send(new PacketPlayOutExplosion(d0, d1, d2, f2, explosion.getToBlow(), explosion.getHitPlayers().get(entityplayer), explosion.getBlockInteraction(), explosion.getSmallExplosionParticles(), explosion.getLargeExplosionParticles(), explosion.getExplosionSound()));
        }
        return explosion;
    }

    @Override
    public void blockEvent(BlockPosition blockposition, Block block, int i2, int j2) {
        this.blockEvents.add((Object)new BlockActionData(blockposition, block, i2, j2));
    }

    private void runBlockEvents() {
        this.blockEventsToReschedule.clear();
        while (!this.blockEvents.isEmpty()) {
            BlockActionData blockactiondata = (BlockActionData)this.blockEvents.removeFirst();
            if (this.shouldTickBlocksAt(blockactiondata.pos())) {
                if (!this.doBlockEvent(blockactiondata)) continue;
                this.server.getPlayerList().broadcast(null, blockactiondata.pos().getX(), blockactiondata.pos().getY(), blockactiondata.pos().getZ(), 64.0, this.dimension(), new PacketPlayOutBlockAction(blockactiondata.pos(), blockactiondata.block(), blockactiondata.paramA(), blockactiondata.paramB()));
                continue;
            }
            this.blockEventsToReschedule.add(blockactiondata);
        }
        this.blockEvents.addAll(this.blockEventsToReschedule);
    }

    private boolean doBlockEvent(BlockActionData blockactiondata) {
        IBlockData iblockdata = this.getBlockState(blockactiondata.pos());
        return iblockdata.is(blockactiondata.block()) ? iblockdata.triggerEvent(this, blockactiondata.pos(), blockactiondata.paramA(), blockactiondata.paramB()) : false;
    }

    public TickListServer<Block> getBlockTicks() {
        return this.blockTicks;
    }

    public TickListServer<FluidType> getFluidTicks() {
        return this.fluidTicks;
    }

    @Override
    @Nonnull
    public MinecraftServer getServer() {
        return this.server;
    }

    public PortalTravelAgent getPortalForcer() {
        return this.portalForcer;
    }

    public StructureTemplateManager getStructureManager() {
        return this.server.getStructureManager();
    }

    public <T extends ParticleParam> int sendParticles(T t0, double d0, double d1, double d2, int i2, double d3, double d4, double d5, double d6) {
        return this.sendParticles(null, t0, d0, d1, d2, i2, d3, d4, d5, d6, false);
    }

    public <T extends ParticleParam> int sendParticles(EntityPlayer sender, T t0, double d0, double d1, double d2, int i2, double d3, double d4, double d5, double d6, boolean force) {
        PacketPlayOutWorldParticles packetplayoutworldparticles = new PacketPlayOutWorldParticles(t0, force, d0, d1, d2, (float)d3, (float)d4, (float)d5, (float)d6, i2);
        int j2 = 0;
        for (int k2 = 0; k2 < this.players.size(); ++k2) {
            EntityPlayer entityplayer = this.players.get(k2);
            if (sender != null && !entityplayer.getBukkitEntity().canSee(sender.getBukkitEntity()) || !this.sendParticles(entityplayer, force, d0, d1, d2, packetplayoutworldparticles)) continue;
            ++j2;
        }
        return j2;
    }

    public <T extends ParticleParam> boolean sendParticles(EntityPlayer entityplayer, T t0, boolean flag, double d0, double d1, double d2, int i2, double d3, double d4, double d5, double d6) {
        PacketPlayOutWorldParticles packet = new PacketPlayOutWorldParticles(t0, flag, d0, d1, d2, (float)d3, (float)d4, (float)d5, (float)d6, i2);
        return this.sendParticles(entityplayer, flag, d0, d1, d2, packet);
    }

    private boolean sendParticles(EntityPlayer entityplayer, boolean flag, double d0, double d1, double d2, Packet<?> packet) {
        if (entityplayer.level() != this) {
            return false;
        }
        BlockPosition blockposition = entityplayer.blockPosition();
        if (blockposition.closerToCenterThan(new Vec3D(d0, d1, d2), flag ? 512.0 : 32.0)) {
            entityplayer.connection.send(packet);
            return true;
        }
        return false;
    }

    @Override
    @Nullable
    public Entity getEntity(int i2) {
        return this.getEntities().get(i2);
    }

    @Deprecated
    @Nullable
    public Entity getEntityOrPart(int i2) {
        Entity entity = this.getEntities().get(i2);
        return entity != null ? entity : (Entity)this.dragonParts.get(i2);
    }

    @Nullable
    public Entity getEntity(UUID uuid) {
        return this.getEntities().get(uuid);
    }

    @Nullable
    public BlockPosition findNearestMapStructure(TagKey<Structure> tagkey, BlockPosition blockposition, int i2, boolean flag) {
        if (!this.serverLevelData.worldGenOptions().generateStructures()) {
            return null;
        }
        Optional<HolderSet.Named<Structure>> optional = this.registryAccess().registryOrThrow(Registries.STRUCTURE).getTag(tagkey);
        if (optional.isEmpty()) {
            return null;
        }
        Pair<BlockPosition, Holder<Structure>> pair = this.getChunkSource().getGenerator().findNearestMapStructure(this, (HolderSet<Structure>)optional.get(), blockposition, i2, flag);
        return pair != null ? (BlockPosition)pair.getFirst() : null;
    }

    @Nullable
    public Pair<BlockPosition, Holder<BiomeBase>> findClosestBiome3d(Predicate<Holder<BiomeBase>> predicate, BlockPosition blockposition, int i2, int j2, int k2) {
        return this.getChunkSource().getGenerator().getBiomeSource().findClosestBiome3d(blockposition, i2, j2, k2, predicate, this.getChunkSource().randomState().sampler(), this);
    }

    @Override
    public CraftingManager getRecipeManager() {
        return this.server.getRecipeManager();
    }

    @Override
    public TickRateManager tickRateManager() {
        return this.server.tickRateManager();
    }

    @Override
    public boolean noSave() {
        return this.noSave;
    }

    public WorldPersistentData getDataStorage() {
        return this.getChunkSource().getDataStorage();
    }

    @Override
    @Nullable
    public WorldMap getMapData(MapId mapid) {
        WorldMap worldmap = this.getServer().overworld().getDataStorage().get(WorldMap.factory(), mapid.key());
        if (worldmap != null) {
            worldmap.id = mapid;
        }
        return worldmap;
    }

    @Override
    public void setMapData(MapId mapid, WorldMap worldmap) {
        worldmap.id = mapid;
        MapInitializeEvent event = new MapInitializeEvent((MapView)worldmap.mapView);
        Bukkit.getServer().getPluginManager().callEvent((Event)event);
        this.getServer().overworld().getDataStorage().set(mapid.key(), worldmap);
    }

    @Override
    public MapId getFreeMapId() {
        return this.getServer().overworld().getDataStorage().computeIfAbsent(PersistentIdCounts.factory(), "idcounts").getFreeAuxValueForMap();
    }

    public void setDefaultSpawnPos(BlockPosition blockposition, float f2) {
        int i2;
        BlockPosition blockposition1 = this.levelData.getSpawnPos();
        float f1 = this.levelData.getSpawnAngle();
        if (!blockposition1.equals(blockposition) || f1 != f2) {
            this.levelData.setSpawn(blockposition, f2);
            this.getServer().getPlayerList().broadcastAll(new PacketPlayOutSpawnPosition(blockposition, f2));
        }
        if (this.lastSpawnChunkRadius > 1) {
            this.getChunkSource().removeRegionTicket(TicketType.START, new ChunkCoordIntPair(blockposition1), this.lastSpawnChunkRadius, Unit.INSTANCE);
        }
        if ((i2 = this.getGameRules().getInt(GameRules.RULE_SPAWN_CHUNK_RADIUS) + 1) > 1) {
            this.getChunkSource().addRegionTicket(TicketType.START, new ChunkCoordIntPair(blockposition), i2, Unit.INSTANCE);
        }
        this.lastSpawnChunkRadius = i2;
    }

    public LongSet getForcedChunks() {
        ForcedChunk forcedchunk = this.getDataStorage().get(ForcedChunk.factory(), "chunks");
        return forcedchunk != null ? LongSets.unmodifiable((LongSet)forcedchunk.getChunks()) : LongSets.EMPTY_SET;
    }

    public boolean setChunkForced(int i2, int j2, boolean flag) {
        boolean flag1;
        ForcedChunk forcedchunk = this.getDataStorage().computeIfAbsent(ForcedChunk.factory(), "chunks");
        ChunkCoordIntPair chunkcoordintpair = new ChunkCoordIntPair(i2, j2);
        long k2 = chunkcoordintpair.toLong();
        if (flag) {
            flag1 = forcedchunk.getChunks().add(k2);
            if (flag1) {
                this.getChunk(i2, j2);
            }
        } else {
            flag1 = forcedchunk.getChunks().remove(k2);
        }
        forcedchunk.setDirty(flag1);
        if (flag1) {
            this.getChunkSource().updateChunkForced(chunkcoordintpair, flag);
        }
        return flag1;
    }

    public List<EntityPlayer> players() {
        return this.players;
    }

    @Override
    public void onBlockStateChange(BlockPosition blockposition, IBlockData iblockdata, IBlockData iblockdata1) {
        Optional<Holder<VillagePlaceType>> optional1;
        Optional<Holder<VillagePlaceType>> optional = PoiTypes.forState(iblockdata);
        if (!Objects.equals(optional, optional1 = PoiTypes.forState(iblockdata1))) {
            BlockPosition blockposition1 = blockposition.immutable();
            optional.ifPresent(holder -> this.getServer().execute(() -> {
                this.getPoiManager().remove(blockposition1);
                PacketDebug.sendPoiRemovedPacket(this, blockposition1);
            }));
            optional1.ifPresent(holder -> this.getServer().execute(() -> {
                this.getPoiManager().add(blockposition1, (Holder<VillagePlaceType>)holder);
                PacketDebug.sendPoiAddedPacket(this, blockposition1);
            }));
        }
    }

    public VillagePlace getPoiManager() {
        return this.getChunkSource().getPoiManager();
    }

    public boolean isVillage(BlockPosition blockposition) {
        return this.isCloseToVillage(blockposition, 1);
    }

    public boolean isVillage(SectionPosition sectionposition) {
        return this.isVillage(sectionposition.center());
    }

    public boolean isCloseToVillage(BlockPosition blockposition, int i2) {
        return i2 > 6 ? false : this.sectionsToVillage(SectionPosition.of(blockposition)) <= i2;
    }

    public int sectionsToVillage(SectionPosition sectionposition) {
        return this.getPoiManager().sectionsToVillage(sectionposition);
    }

    public PersistentRaid getRaids() {
        return this.raids;
    }

    @Nullable
    public Raid getRaidAt(BlockPosition blockposition) {
        return this.raids.getNearbyRaid(blockposition, 9216);
    }

    public boolean isRaided(BlockPosition blockposition) {
        return this.getRaidAt(blockposition) != null;
    }

    public void onReputationEvent(ReputationEvent reputationevent, Entity entity, ReputationHandler reputationhandler) {
        reputationhandler.onReputationEventFrom(reputationevent, entity);
    }

    public void saveDebugReport(Path path) throws IOException {
        PlayerChunkMap playerchunkmap = this.getChunkSource().chunkMap;
        try (BufferedWriter bufferedwriter = Files.newBufferedWriter(path.resolve("stats.txt"), new OpenOption[0]);){
            bufferedwriter.write(String.format(Locale.ROOT, "spawning_chunks: %d\n", playerchunkmap.getDistanceManager().getNaturalSpawnChunkCount()));
            SpawnerCreature.d spawnercreature_d = this.getChunkSource().getLastSpawnState();
            if (spawnercreature_d != null) {
                for (Object2IntMap.Entry entry : spawnercreature_d.getMobCategoryCounts().object2IntEntrySet()) {
                    bufferedwriter.write(String.format(Locale.ROOT, "spawn_count.%s: %d\n", ((EnumCreatureType)entry.getKey()).getName(), entry.getIntValue()));
                }
            }
            bufferedwriter.write(String.format(Locale.ROOT, "entities: %s\n", this.entityManager.gatherStats()));
            bufferedwriter.write(String.format(Locale.ROOT, "block_entity_tickers: %d\n", this.blockEntityTickers.size()));
            bufferedwriter.write(String.format(Locale.ROOT, "block_ticks: %d\n", ((TickListServer)this.getBlockTicks()).count()));
            bufferedwriter.write(String.format(Locale.ROOT, "fluid_ticks: %d\n", ((TickListServer)this.getFluidTicks()).count()));
            bufferedwriter.write("distance_manager: " + playerchunkmap.getDistanceManager().getDebugStatus() + "\n");
            bufferedwriter.write(String.format(Locale.ROOT, "pending_tasks: %d\n", this.getChunkSource().getPendingTasksCount()));
        }
        CrashReport crashreport = new CrashReport("Level dump", new Exception("dummy"));
        this.fillReportDetails(crashreport);
        try (BufferedWriter bufferedwriter1 = Files.newBufferedWriter(path.resolve("example_crash.txt"), new OpenOption[0]);){
            bufferedwriter1.write(crashreport.getFriendlyReport(ReportType.TEST));
        }
        Path path1 = path.resolve("chunks.csv");
        try (BufferedWriter bufferedwriter2 = Files.newBufferedWriter(path1, new OpenOption[0]);){
            playerchunkmap.dumpChunks(bufferedwriter2);
        }
        Path path2 = path.resolve("entity_chunks.csv");
        try (BufferedWriter bufferedwriter3 = Files.newBufferedWriter(path2, new OpenOption[0]);){
            this.entityManager.dumpSections(bufferedwriter3);
        }
        Path path3 = path.resolve("entities.csv");
        try (BufferedWriter bufferedwriter4 = Files.newBufferedWriter(path3, new OpenOption[0]);){
            WorldServer.dumpEntities(bufferedwriter4, this.getEntities().getAll());
        }
        Path path4 = path.resolve("block_entities.csv");
        try (BufferedWriter bufferedwriter5 = Files.newBufferedWriter(path4, new OpenOption[0]);){
            this.dumpBlockEntityTickers(bufferedwriter5);
        }
    }

    private static void dumpEntities(Writer writer, Iterable<Entity> iterable) throws IOException {
        CSVWriter csvwriter = CSVWriter.builder().addColumn("x").addColumn("y").addColumn("z").addColumn("uuid").addColumn("type").addColumn("alive").addColumn("display_name").addColumn("custom_name").build(writer);
        for (Entity entity : iterable) {
            IChatBaseComponent ichatbasecomponent = entity.getCustomName();
            IChatBaseComponent ichatbasecomponent1 = entity.getDisplayName();
            csvwriter.writeRow(entity.getX(), entity.getY(), entity.getZ(), entity.getUUID(), BuiltInRegistries.ENTITY_TYPE.getKey(entity.getType()), entity.isAlive(), ichatbasecomponent1.getString(), ichatbasecomponent != null ? ichatbasecomponent.getString() : null);
        }
    }

    private void dumpBlockEntityTickers(Writer writer) throws IOException {
        CSVWriter csvwriter = CSVWriter.builder().addColumn("x").addColumn("y").addColumn("z").addColumn("type").build(writer);
        for (TickingBlockEntity tickingblockentity : this.blockEntityTickers) {
            BlockPosition blockposition = tickingblockentity.getPos();
            csvwriter.writeRow(blockposition.getX(), blockposition.getY(), blockposition.getZ(), tickingblockentity.getType());
        }
    }

    @VisibleForTesting
    public void clearBlockEvents(StructureBoundingBox structureboundingbox) {
        this.blockEvents.removeIf(blockactiondata -> structureboundingbox.isInside(blockactiondata.pos()));
    }

    @Override
    public void blockUpdated(BlockPosition blockposition, Block block) {
        if (!this.isDebug()) {
            if (this.populating) {
                return;
            }
            this.updateNeighborsAt(blockposition, block);
        }
    }

    @Override
    public float getShade(EnumDirection enumdirection, boolean flag) {
        return 1.0f;
    }

    public Iterable<Entity> getAllEntities() {
        return this.getEntities().getAll();
    }

    public String toString() {
        return "ServerLevel[" + this.serverLevelData.getLevelName() + "]";
    }

    public boolean isFlat() {
        return this.serverLevelData.isFlatWorld();
    }

    @Override
    public long getSeed() {
        return this.serverLevelData.worldGenOptions().seed();
    }

    @Nullable
    public EnderDragonBattle getDragonFight() {
        return this.dragonFight;
    }

    @Override
    public WorldServer getLevel() {
        return this;
    }

    @VisibleForTesting
    public String getWatchdogStats() {
        return String.format(Locale.ROOT, "players: %s, entities: %s [%s], block_entities: %d [%s], block_ticks: %d, fluid_ticks: %d, chunk_source: %s", this.players.size(), this.entityManager.gatherStats(), WorldServer.getTypeCount(this.entityManager.getEntityGetter().getAll(), entity -> BuiltInRegistries.ENTITY_TYPE.getKey(entity.getType()).toString()), this.blockEntityTickers.size(), WorldServer.getTypeCount(this.blockEntityTickers, TickingBlockEntity::getType), ((TickListServer)this.getBlockTicks()).count(), ((TickListServer)this.getFluidTicks()).count(), this.gatherChunkSourceStats());
    }

    private static <T> String getTypeCount(Iterable<T> iterable, Function<T, String> function) {
        try {
            Object2IntOpenHashMap object2intopenhashmap = new Object2IntOpenHashMap();
            for (T t0 : iterable) {
                String s2 = function.apply(t0);
                object2intopenhashmap.addTo((Object)s2, 1);
            }
            return object2intopenhashmap.object2IntEntrySet().stream().sorted(Comparator.comparing(Object2IntMap.Entry::getIntValue).reversed()).limit(5L).map(entry -> {
                String s1 = (String)entry.getKey();
                return s1 + ":" + entry.getIntValue();
            }).collect(Collectors.joining(","));
        }
        catch (Exception exception) {
            return "";
        }
    }

    @Override
    public LevelEntityGetter<Entity> getEntities() {
        AsyncCatcher.catchOp("Chunk getEntities call");
        return this.entityManager.getEntityGetter();
    }

    public void addLegacyChunkEntities(Stream<Entity> stream) {
        this.entityManager.addLegacyChunkEntities(stream);
    }

    public void addWorldGenChunkEntities(Stream<Entity> stream) {
        this.entityManager.addWorldGenChunkEntities(stream);
    }

    public void startTickingChunk(Chunk chunk) {
        chunk.unpackTicks(this.getLevelData().getGameTime());
    }

    public void onStructureStartsAvailable(IChunkAccess ichunkaccess) {
        this.server.execute(() -> this.structureCheck.onStructureLoad(ichunkaccess.getPos(), ichunkaccess.getAllStarts()));
    }

    public PathTypeCache getPathTypeCache() {
        return this.pathTypesByPosCache;
    }

    @Override
    public void close() throws IOException {
        super.close();
        this.entityManager.close();
    }

    @Override
    public String gatherChunkSourceStats() {
        String s2 = this.chunkSource.gatherStats();
        return "Chunks[S] W: " + s2 + " E: " + this.entityManager.gatherStats();
    }

    public boolean areEntitiesLoaded(long i2) {
        return this.entityManager.areEntitiesLoaded(i2);
    }

    private boolean isPositionTickingWithEntitiesLoaded(long i2) {
        return this.areEntitiesLoaded(i2) && this.chunkSource.isPositionTicking(i2);
    }

    public boolean isPositionEntityTicking(BlockPosition blockposition) {
        return this.entityManager.canPositionTick(blockposition) && this.chunkSource.chunkMap.getDistanceManager().inEntityTickingRange(ChunkCoordIntPair.asLong(blockposition));
    }

    public boolean isNaturalSpawningAllowed(BlockPosition blockposition) {
        return this.entityManager.canPositionTick(blockposition);
    }

    public boolean isNaturalSpawningAllowed(ChunkCoordIntPair chunkcoordintpair) {
        return this.entityManager.canPositionTick(chunkcoordintpair);
    }

    @Override
    public FeatureFlagSet enabledFeatures() {
        return this.server.getWorldData().enabledFeatures();
    }

    @Override
    public PotionBrewer potionBrewing() {
        return this.server.potionBrewing();
    }

    public RandomSource getRandomSequence(MinecraftKey minecraftkey) {
        return this.randomSequences.get(minecraftkey);
    }

    public RandomSequences getRandomSequences() {
        return this.randomSequences;
    }

    @Override
    public CrashReportSystemDetails fillReportDetails(CrashReport crashreport) {
        CrashReportSystemDetails crashreportsystemdetails = super.fillReportDetails(crashreport);
        crashreportsystemdetails.setDetail("Loaded entity count", () -> String.valueOf(this.entityManager.count()));
        return crashreportsystemdetails;
    }

    private final class a
    implements LevelCallback<Entity> {
        a() {
        }

        @Override
        public void onCreated(Entity entity) {
        }

        @Override
        public void onDestroyed(Entity entity) {
            WorldServer.this.getScoreboard().entityRemoved(entity);
        }

        @Override
        public void onTickingStart(Entity entity) {
            WorldServer.this.entityTickList.add(entity);
        }

        @Override
        public void onTickingEnd(Entity entity) {
            WorldServer.this.entityTickList.remove(entity);
        }

        @Override
        public void onTrackingStart(Entity entity) {
            AsyncCatcher.catchOp("entity register");
            WorldServer.this.getChunkSource().addEntity(entity);
            if (entity instanceof EntityPlayer) {
                EntityPlayer entityplayer = (EntityPlayer)entity;
                WorldServer.this.players.add(entityplayer);
                WorldServer.this.updateSleepingPlayerList();
            }
            if (entity instanceof EntityInsentient) {
                EntityInsentient entityinsentient = (EntityInsentient)entity;
                if (WorldServer.this.isUpdatingNavigations) {
                    String s2 = "onTrackingStart called during navigation iteration";
                    SystemUtils.logAndPauseIfInIde("onTrackingStart called during navigation iteration", new IllegalStateException("onTrackingStart called during navigation iteration"));
                }
                WorldServer.this.navigatingMobs.add(entityinsentient);
            }
            if (entity instanceof EntityEnderDragon) {
                EntityEnderDragon entityenderdragon = (EntityEnderDragon)entity;
                for (EntityComplexPart entitycomplexpart : entityenderdragon.getSubEntities()) {
                    WorldServer.this.dragonParts.put(entitycomplexpart.getId(), (Object)entitycomplexpart);
                }
            }
            entity.updateDynamicGameEventListener(DynamicGameEventListener::add);
            entity.inWorld = true;
            entity.valid = true;
        }

        @Override
        public void onTrackingEnd(Entity entity) {
            AsyncCatcher.catchOp("entity unregister");
            if (entity instanceof EntityHuman) {
                Streams.stream(WorldServer.this.getServer().getAllLevels()).map(WorldServer::getDataStorage).forEach(worldData -> {
                    for (PersistentBase o2 : worldData.cache.values()) {
                        if (!(o2 instanceof WorldMap)) continue;
                        WorldMap map = (WorldMap)o2;
                        map.carriedByPlayers.remove((EntityHuman)entity);
                        Iterator<WorldMap.WorldMapHumanTracker> iter = map.carriedBy.iterator();
                        while (iter.hasNext()) {
                            if (iter.next().player != entity) continue;
                            iter.remove();
                        }
                    }
                });
            }
            if (entity.getBukkitEntity() instanceof InventoryHolder && (!(entity instanceof EntityPlayer) || entity.getRemovalReason() != Entity.RemovalReason.KILLED)) {
                for (HumanEntity h2 : Lists.newArrayList((Iterable)((InventoryHolder)entity.getBukkitEntity()).getInventory().getViewers())) {
                    h2.closeInventory();
                }
            }
            WorldServer.this.getChunkSource().removeEntity(entity);
            if (entity instanceof EntityPlayer) {
                EntityPlayer entityplayer = (EntityPlayer)entity;
                WorldServer.this.players.remove(entityplayer);
                WorldServer.this.updateSleepingPlayerList();
            }
            if (entity instanceof EntityInsentient) {
                EntityInsentient entityinsentient = (EntityInsentient)entity;
                if (WorldServer.this.isUpdatingNavigations) {
                    String s2 = "onTrackingStart called during navigation iteration";
                    SystemUtils.logAndPauseIfInIde("onTrackingStart called during navigation iteration", new IllegalStateException("onTrackingStart called during navigation iteration"));
                }
                WorldServer.this.navigatingMobs.remove(entityinsentient);
            }
            if (entity instanceof EntityEnderDragon) {
                EntityEnderDragon entityenderdragon = (EntityEnderDragon)entity;
                for (EntityComplexPart entitycomplexpart : entityenderdragon.getSubEntities()) {
                    WorldServer.this.dragonParts.remove(entitycomplexpart.getId());
                }
            }
            entity.updateDynamicGameEventListener(DynamicGameEventListener::remove);
            entity.valid = false;
            if (!(entity instanceof EntityPlayer)) {
                for (EntityPlayer player : WorldServer.this.players) {
                    player.getBukkitEntity().onEntityRemove(entity);
                }
            }
        }

        @Override
        public void onSectionChange(Entity entity) {
            entity.updateDynamicGameEventListener(DynamicGameEventListener::move);
        }
    }
}

