/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.network;

import com.google.gson.Gson;
import com.mojang.authlib.properties.Property;
import com.mojang.util.UndashedUuid;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.regex.Pattern;
import net.minecraft.SharedConstants;
import net.minecraft.network.DisconnectionDetails;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.chat.IChatMutableComponent;
import net.minecraft.network.protocol.handshake.PacketHandshakingInListener;
import net.minecraft.network.protocol.handshake.PacketHandshakingInSetProtocol;
import net.minecraft.network.protocol.login.LoginProtocols;
import net.minecraft.network.protocol.login.PacketLoginOutDisconnect;
import net.minecraft.network.protocol.status.ServerPing;
import net.minecraft.network.protocol.status.StatusProtocols;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.network.LoginListener;
import net.minecraft.server.network.PacketStatusListener;
import org.apache.logging.log4j.LogManager;
import org.spigotmc.SpigotConfig;

public class HandshakeListener
implements PacketHandshakingInListener {
    private static final Gson gson = new Gson();
    static final Pattern HOST_PATTERN = Pattern.compile("[0-9a-f\\.:]{0,45}");
    static final Pattern PROP_PATTERN = Pattern.compile("\\w{0,16}");
    private static final HashMap<InetAddress, Long> throttleTracker = new HashMap();
    private static int throttleCounter = 0;
    private static final IChatBaseComponent IGNORE_STATUS_REASON = IChatBaseComponent.translatable("disconnect.ignoring_status_request");
    private final MinecraftServer server;
    private final NetworkManager connection;

    public HandshakeListener(MinecraftServer minecraftserver, NetworkManager networkmanager) {
        this.server = minecraftserver;
        this.connection = networkmanager;
    }

    @Override
    public void handleIntention(PacketHandshakingInSetProtocol packethandshakinginsetprotocol) {
        this.connection.hostname = packethandshakinginsetprotocol.hostName() + ":" + packethandshakinginsetprotocol.port();
        switch (packethandshakinginsetprotocol.intention()) {
            case LOGIN: {
                this.beginLogin(packethandshakinginsetprotocol, false);
                break;
            }
            case STATUS: {
                ServerPing serverping = this.server.getStatus();
                this.connection.setupOutboundProtocol(StatusProtocols.CLIENTBOUND);
                if (this.server.repliesToStatus() && serverping != null) {
                    this.connection.setupInboundProtocol(StatusProtocols.SERVERBOUND, new PacketStatusListener(serverping, this.connection));
                    break;
                }
                this.connection.disconnect(IGNORE_STATUS_REASON);
                break;
            }
            case TRANSFER: {
                if (!this.server.acceptsTransfers()) {
                    this.connection.setupOutboundProtocol(LoginProtocols.CLIENTBOUND);
                    IChatMutableComponent ichatmutablecomponent = IChatBaseComponent.translatable("multiplayer.disconnect.transfers_disabled");
                    this.connection.send(new PacketLoginOutDisconnect(ichatmutablecomponent));
                    this.connection.disconnect(ichatmutablecomponent);
                    break;
                }
                this.beginLogin(packethandshakinginsetprotocol, true);
                break;
            }
            default: {
                throw new UnsupportedOperationException("Invalid intention " + String.valueOf((Object)packethandshakinginsetprotocol.intention()));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void beginLogin(PacketHandshakingInSetProtocol packethandshakinginsetprotocol, boolean flag) {
        this.connection.setupOutboundProtocol(LoginProtocols.CLIENTBOUND);
        try {
            long currentTime = System.currentTimeMillis();
            long connectionThrottle = this.server.server.getConnectionThrottle();
            InetAddress address = ((InetSocketAddress)this.connection.getRemoteAddress()).getAddress();
            HashMap<InetAddress, Long> hashMap = throttleTracker;
            synchronized (hashMap) {
                if (throttleTracker.containsKey(address) && !"127.0.0.1".equals(address.getHostAddress()) && currentTime - throttleTracker.get(address) < connectionThrottle) {
                    throttleTracker.put(address, currentTime);
                    IChatMutableComponent chatmessage = IChatBaseComponent.literal("Connection throttled! Please wait before reconnecting.");
                    this.connection.send(new PacketLoginOutDisconnect(chatmessage));
                    this.connection.disconnect(chatmessage);
                    return;
                }
                throttleTracker.put(address, currentTime);
                if (++throttleCounter > 200) {
                    throttleCounter = 0;
                    Iterator<Map.Entry<InetAddress, Long>> iter = throttleTracker.entrySet().iterator();
                    while (iter.hasNext()) {
                        Map.Entry<InetAddress, Long> entry = iter.next();
                        if (entry.getValue() <= connectionThrottle) continue;
                        iter.remove();
                    }
                }
            }
        }
        catch (Throwable t2) {
            LogManager.getLogger().debug("Failed to check connection throttle", t2);
        }
        if (packethandshakinginsetprotocol.protocolVersion() != SharedConstants.getCurrentVersion().getProtocolVersion()) {
            IChatMutableComponent ichatmutablecomponent = packethandshakinginsetprotocol.protocolVersion() < SharedConstants.getCurrentVersion().getProtocolVersion() ? IChatBaseComponent.literal(MessageFormat.format(SpigotConfig.outdatedClientMessage.replaceAll("'", "''"), SharedConstants.getCurrentVersion().getName())) : IChatBaseComponent.literal(MessageFormat.format(SpigotConfig.outdatedServerMessage.replaceAll("'", "''"), SharedConstants.getCurrentVersion().getName()));
            this.connection.send(new PacketLoginOutDisconnect(ichatmutablecomponent));
            this.connection.disconnect(ichatmutablecomponent);
        } else {
            this.connection.setupInboundProtocol(LoginProtocols.SERVERBOUND, new LoginListener(this.server, this.connection, flag));
            String[] split = packethandshakinginsetprotocol.hostName().split("\u0000");
            if (SpigotConfig.bungee) {
                if (split.length != 3 && split.length != 4 || !HOST_PATTERN.matcher(split[1]).matches()) {
                    IChatMutableComponent chatmessage = IChatBaseComponent.literal("If you wish to use IP forwarding, please enable it in your BungeeCord config as well!");
                    this.connection.send(new PacketLoginOutDisconnect(chatmessage));
                    this.connection.disconnect(chatmessage);
                    return;
                }
                this.connection.hostname = split[0];
                this.connection.address = new InetSocketAddress(split[1], ((InetSocketAddress)this.connection.getRemoteAddress()).getPort());
                this.connection.spoofedUUID = UndashedUuid.fromStringLenient((String)split[2]);
                if (split.length == 4) {
                    this.connection.spoofedProfile = (Property[])gson.fromJson(split[3], Property[].class);
                }
            } else if ((split.length == 3 || split.length == 4) && HOST_PATTERN.matcher(split[1]).matches()) {
                IChatMutableComponent chatmessage = IChatBaseComponent.literal("Unknown data in login hostname, did you forget to enable BungeeCord in spigot.yml?");
                this.connection.send(new PacketLoginOutDisconnect(chatmessage));
                this.connection.disconnect(chatmessage);
                return;
            }
        }
    }

    @Override
    public void onDisconnect(DisconnectionDetails disconnectiondetails) {
    }

    @Override
    public boolean isAcceptingMessages() {
        return this.connection.isConnected();
    }
}

