/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.network;

import com.google.common.primitives.Ints;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.exceptions.AuthenticationUnavailableException;
import com.mojang.authlib.properties.Property;
import com.mojang.authlib.yggdrasil.ProfileResult;
import com.mojang.logging.LogUtils;
import java.math.BigInteger;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.security.PrivateKey;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import javax.annotation.Nullable;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import net.minecraft.CrashReport;
import net.minecraft.CrashReportSystemDetails;
import net.minecraft.DefaultUncaughtExceptionHandler;
import net.minecraft.core.UUIDUtil;
import net.minecraft.network.DisconnectionDetails;
import net.minecraft.network.EnumProtocol;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.PacketSendListener;
import net.minecraft.network.TickablePacketListener;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.PlayerConnectionUtils;
import net.minecraft.network.protocol.configuration.ConfigurationProtocols;
import net.minecraft.network.protocol.cookie.ServerboundCookieResponsePacket;
import net.minecraft.network.protocol.login.PacketLoginInEncryptionBegin;
import net.minecraft.network.protocol.login.PacketLoginInListener;
import net.minecraft.network.protocol.login.PacketLoginInStart;
import net.minecraft.network.protocol.login.PacketLoginOutDisconnect;
import net.minecraft.network.protocol.login.PacketLoginOutEncryptionBegin;
import net.minecraft.network.protocol.login.PacketLoginOutSetCompression;
import net.minecraft.network.protocol.login.PacketLoginOutSuccess;
import net.minecraft.network.protocol.login.ServerboundCustomQueryAnswerPacket;
import net.minecraft.network.protocol.login.ServerboundLoginAcknowledgedPacket;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.network.CommonListenerCookie;
import net.minecraft.server.network.HandshakeListener;
import net.minecraft.server.network.ServerCommonPacketListenerImpl;
import net.minecraft.server.network.ServerConfigurationPacketListenerImpl;
import net.minecraft.server.players.PlayerList;
import net.minecraft.util.CryptographyException;
import net.minecraft.util.MinecraftEncryption;
import net.minecraft.util.RandomSource;
import net.minecraft.util.UtilColor;
import org.apache.commons.lang3.Validate;
import org.bukkit.craftbukkit.v1_21_R1.CraftServer;
import org.bukkit.craftbukkit.v1_21_R1.entity.CraftPlayer;
import org.bukkit.craftbukkit.v1_21_R1.util.Waitable;
import org.bukkit.event.Event;
import org.bukkit.event.player.AsyncPlayerPreLoginEvent;
import org.bukkit.event.player.PlayerPreLoginEvent;
import org.slf4j.Logger;

public class LoginListener
implements PacketLoginInListener,
TickablePacketListener,
CraftPlayer.TransferCookieConnection {
    private static final AtomicInteger UNIQUE_THREAD_ID = new AtomicInteger(0);
    static final Logger LOGGER = LogUtils.getLogger();
    private static final int MAX_TICKS_BEFORE_LOGIN = 600;
    private final byte[] challenge;
    final MinecraftServer server;
    public final NetworkManager connection;
    private volatile EnumProtocolState state = EnumProtocolState.HELLO;
    private int tick;
    @Nullable
    String requestedUsername;
    @Nullable
    private GameProfile authenticatedProfile;
    private final String serverId;
    private final boolean transferred;
    private EntityPlayer player;

    @Override
    public boolean isTransferred() {
        return this.transferred;
    }

    @Override
    public EnumProtocol getProtocol() {
        return EnumProtocol.LOGIN;
    }

    @Override
    public void sendPacket(Packet<?> packet) {
        this.connection.send(packet);
    }

    @Override
    public void kickPlayer(IChatBaseComponent reason) {
        this.disconnect(reason);
    }

    public LoginListener(MinecraftServer minecraftserver, NetworkManager networkmanager, boolean flag) {
        this.serverId = "";
        this.server = minecraftserver;
        this.connection = networkmanager;
        this.challenge = Ints.toByteArray((int)RandomSource.create().nextInt());
        this.transferred = flag;
    }

    @Override
    public void tick() {
        if (this.state == EnumProtocolState.VERIFYING) {
            this.verifyLoginAndFinishConnectionSetup(Objects.requireNonNull(this.authenticatedProfile));
        }
        if (this.state == EnumProtocolState.WAITING_FOR_COOKIES && !this.player.getBukkitEntity().isAwaitingCookies()) {
            this.postCookies(this.authenticatedProfile);
        }
        if (this.state == EnumProtocolState.WAITING_FOR_DUPE_DISCONNECT && !this.isPlayerAlreadyInWorld(Objects.requireNonNull(this.authenticatedProfile))) {
            this.finishLoginAndWaitForClient(this.authenticatedProfile);
        }
        if (this.tick++ == 600) {
            this.disconnect(IChatBaseComponent.translatable("multiplayer.disconnect.slow_login"));
        }
    }

    @Deprecated
    public void disconnect(String s2) {
        this.disconnect(IChatBaseComponent.literal(s2));
    }

    @Override
    public boolean isAcceptingMessages() {
        return this.connection.isConnected();
    }

    public void disconnect(IChatBaseComponent ichatbasecomponent) {
        try {
            LOGGER.info("Disconnecting {}: {}", (Object)this.getUserName(), (Object)ichatbasecomponent.getString());
            this.connection.send(new PacketLoginOutDisconnect(ichatbasecomponent));
            this.connection.disconnect(ichatbasecomponent);
        }
        catch (Exception exception) {
            LOGGER.error("Error whilst disconnecting player", (Throwable)exception);
        }
    }

    private boolean isPlayerAlreadyInWorld(GameProfile gameprofile) {
        return this.server.getPlayerList().getPlayer(gameprofile.getId()) != null;
    }

    @Override
    public void onDisconnect(DisconnectionDetails disconnectiondetails) {
        LOGGER.info("{} lost connection: {}", (Object)this.getUserName(), (Object)disconnectiondetails.reason().getString());
    }

    public String getUserName() {
        String s2 = this.connection.getLoggableAddress(this.server.logIPs());
        return this.requestedUsername != null ? this.requestedUsername + " (" + s2 + ")" : s2;
    }

    @Override
    public void handleHello(PacketLoginInStart packetlogininstart) {
        Validate.validState((this.state == EnumProtocolState.HELLO ? 1 : 0) != 0, (String)"Unexpected hello packet", (Object[])new Object[0]);
        Validate.validState((boolean)UtilColor.isValidPlayerName(packetlogininstart.name()), (String)"Invalid characters in username", (Object[])new Object[0]);
        this.requestedUsername = packetlogininstart.name();
        GameProfile gameprofile = this.server.getSingleplayerProfile();
        if (gameprofile != null && this.requestedUsername.equalsIgnoreCase(gameprofile.getName())) {
            this.startClientVerification(gameprofile);
        } else if (this.server.usesAuthentication() && !this.connection.isMemoryConnection()) {
            this.state = EnumProtocolState.KEY;
            this.connection.send(new PacketLoginOutEncryptionBegin("", this.server.getKeyPair().getPublic().getEncoded(), this.challenge, true));
        } else {
            Thread thread = new Thread("User Authenticator #" + UNIQUE_THREAD_ID.incrementAndGet()){

                @Override
                public void run() {
                    try {
                        GameProfile gameprofile = LoginListener.this.createOfflineProfile(LoginListener.this.requestedUsername);
                        LoginListener.this.callPlayerPreLoginEvents(gameprofile);
                        LOGGER.info("UUID of player {} is {}", (Object)gameprofile.getName(), (Object)gameprofile.getId());
                        LoginListener.this.startClientVerification(gameprofile);
                    }
                    catch (Exception ex) {
                        LoginListener.this.disconnect("Failed to verify username!");
                        LoginListener.this.server.server.getLogger().log(Level.WARNING, "Exception verifying " + LoginListener.this.requestedUsername, ex);
                    }
                }
            };
            thread.setUncaughtExceptionHandler(new DefaultUncaughtExceptionHandler(LOGGER));
            thread.start();
        }
    }

    void startClientVerification(GameProfile gameprofile) {
        this.authenticatedProfile = gameprofile;
        this.state = EnumProtocolState.VERIFYING;
    }

    private void verifyLoginAndFinishConnectionSetup(GameProfile gameprofile) {
        PlayerList playerlist = this.server.getPlayerList();
        this.player = playerlist.canPlayerLogin(this, gameprofile);
        if (this.player != null) {
            if (this.player.getBukkitEntity().isAwaitingCookies()) {
                this.state = EnumProtocolState.WAITING_FOR_COOKIES;
            } else {
                this.postCookies(gameprofile);
            }
        }
    }

    private void postCookies(GameProfile gameprofile) {
        PlayerList playerlist = this.server.getPlayerList();
        if (this.player != null) {
            boolean flag;
            if (this.server.getCompressionThreshold() >= 0 && !this.connection.isMemoryConnection()) {
                this.connection.send(new PacketLoginOutSetCompression(this.server.getCompressionThreshold()), PacketSendListener.thenRun(() -> this.connection.setupCompression(this.server.getCompressionThreshold(), true)));
            }
            if (flag = playerlist.disconnectAllPlayersWithProfile(gameprofile, this.player)) {
                this.state = EnumProtocolState.WAITING_FOR_DUPE_DISCONNECT;
            } else {
                this.finishLoginAndWaitForClient(gameprofile);
            }
        }
    }

    private void finishLoginAndWaitForClient(GameProfile gameprofile) {
        this.state = EnumProtocolState.PROTOCOL_SWITCHING;
        this.connection.send(new PacketLoginOutSuccess(gameprofile, true));
    }

    @Override
    public void handleKey(PacketLoginInEncryptionBegin packetlogininencryptionbegin) {
        String s2;
        Validate.validState((this.state == EnumProtocolState.KEY ? 1 : 0) != 0, (String)"Unexpected key packet", (Object[])new Object[0]);
        try {
            PrivateKey privatekey = this.server.getKeyPair().getPrivate();
            if (!packetlogininencryptionbegin.isChallengeValid(this.challenge, privatekey)) {
                throw new IllegalStateException("Protocol error");
            }
            SecretKey secretkey = packetlogininencryptionbegin.getSecretKey(privatekey);
            Cipher cipher = MinecraftEncryption.getCipher(2, secretkey);
            Cipher cipher1 = MinecraftEncryption.getCipher(1, secretkey);
            s2 = new BigInteger(MinecraftEncryption.digestData("", this.server.getKeyPair().getPublic(), secretkey)).toString(16);
            this.state = EnumProtocolState.AUTHENTICATING;
            this.connection.setEncryptionKey(cipher, cipher1);
        }
        catch (CryptographyException cryptographyexception) {
            throw new IllegalStateException("Protocol error", cryptographyexception);
        }
        Thread thread = new Thread("User Authenticator #" + UNIQUE_THREAD_ID.incrementAndGet()){

            @Override
            public void run() {
                String s1 = Objects.requireNonNull(LoginListener.this.requestedUsername, "Player name not initialized");
                try {
                    ProfileResult profileresult = LoginListener.this.server.getSessionService().hasJoinedServer(s1, s2, this.getAddress());
                    if (profileresult != null) {
                        GameProfile gameprofile = profileresult.profile();
                        if (!LoginListener.this.connection.isConnected()) {
                            return;
                        }
                        LoginListener.this.callPlayerPreLoginEvents(gameprofile);
                        LOGGER.info("UUID of player {} is {}", (Object)gameprofile.getName(), (Object)gameprofile.getId());
                        LoginListener.this.startClientVerification(gameprofile);
                    } else if (LoginListener.this.server.isSingleplayer()) {
                        LOGGER.warn("Failed to verify username but will let them in anyway!");
                        LoginListener.this.startClientVerification(LoginListener.this.createOfflineProfile(s1));
                    } else {
                        LoginListener.this.disconnect(IChatBaseComponent.translatable("multiplayer.disconnect.unverified_username"));
                        LOGGER.error("Username '{}' tried to join with an invalid session", (Object)s1);
                    }
                }
                catch (AuthenticationUnavailableException authenticationunavailableexception) {
                    if (LoginListener.this.server.isSingleplayer()) {
                        LOGGER.warn("Authentication servers are down but will let them in anyway!");
                        LoginListener.this.startClientVerification(LoginListener.this.createOfflineProfile(s1));
                    } else {
                        LoginListener.this.disconnect(IChatBaseComponent.translatable("multiplayer.disconnect.authservers_down"));
                        LOGGER.error("Couldn't verify username because servers are unavailable");
                    }
                }
                catch (Exception exception) {
                    LoginListener.this.disconnect("Failed to verify username!");
                    LoginListener.this.server.server.getLogger().log(Level.WARNING, "Exception verifying " + s1, exception);
                }
            }

            @Nullable
            private InetAddress getAddress() {
                SocketAddress socketaddress = LoginListener.this.connection.getRemoteAddress();
                return LoginListener.this.server.getPreventProxyConnections() && socketaddress instanceof InetSocketAddress ? ((InetSocketAddress)socketaddress).getAddress() : null;
            }
        };
        thread.setUncaughtExceptionHandler(new DefaultUncaughtExceptionHandler(LOGGER));
        thread.start();
    }

    private void callPlayerPreLoginEvents(GameProfile gameprofile) throws Exception {
        String playerName = gameprofile.getName();
        InetAddress address = ((InetSocketAddress)this.connection.getRemoteAddress()).getAddress();
        UUID uniqueId = gameprofile.getId();
        final CraftServer server = this.server.server;
        AsyncPlayerPreLoginEvent asyncEvent = new AsyncPlayerPreLoginEvent(playerName, address, uniqueId, this.transferred);
        server.getPluginManager().callEvent((Event)asyncEvent);
        if (PlayerPreLoginEvent.getHandlerList().getRegisteredListeners().length != 0) {
            final PlayerPreLoginEvent event = new PlayerPreLoginEvent(playerName, address, uniqueId);
            if (asyncEvent.getResult() != PlayerPreLoginEvent.Result.ALLOWED) {
                event.disallow(asyncEvent.getResult(), asyncEvent.getKickMessage());
            }
            Waitable<PlayerPreLoginEvent.Result> waitable = new Waitable<PlayerPreLoginEvent.Result>(this){

                @Override
                protected PlayerPreLoginEvent.Result evaluate() {
                    server.getPluginManager().callEvent((Event)event);
                    return event.getResult();
                }
            };
            this.server.processQueue.add(waitable);
            if (waitable.get() != PlayerPreLoginEvent.Result.ALLOWED) {
                this.disconnect(event.getKickMessage());
                return;
            }
        } else if (asyncEvent.getLoginResult() != AsyncPlayerPreLoginEvent.Result.ALLOWED) {
            this.disconnect(asyncEvent.getKickMessage());
            return;
        }
    }

    @Override
    public void handleCustomQueryPacket(ServerboundCustomQueryAnswerPacket serverboundcustomqueryanswerpacket) {
        this.disconnect(ServerCommonPacketListenerImpl.DISCONNECT_UNEXPECTED_QUERY);
    }

    @Override
    public void handleLoginAcknowledgement(ServerboundLoginAcknowledgedPacket serverboundloginacknowledgedpacket) {
        PlayerConnectionUtils.ensureRunningOnSameThread(serverboundloginacknowledgedpacket, this, this.server);
        Validate.validState((this.state == EnumProtocolState.PROTOCOL_SWITCHING ? 1 : 0) != 0, (String)"Unexpected login acknowledgement packet", (Object[])new Object[0]);
        this.connection.setupOutboundProtocol(ConfigurationProtocols.CLIENTBOUND);
        CommonListenerCookie commonlistenercookie = CommonListenerCookie.createInitial(Objects.requireNonNull(this.authenticatedProfile), this.transferred);
        ServerConfigurationPacketListenerImpl serverconfigurationpacketlistenerimpl = new ServerConfigurationPacketListenerImpl(this.server, this.connection, commonlistenercookie, this.player);
        this.connection.setupInboundProtocol(ConfigurationProtocols.SERVERBOUND, serverconfigurationpacketlistenerimpl);
        serverconfigurationpacketlistenerimpl.startConfiguration();
        this.state = EnumProtocolState.ACCEPTED;
    }

    @Override
    public void fillListenerSpecificCrashDetails(CrashReport crashreport, CrashReportSystemDetails crashreportsystemdetails) {
        crashreportsystemdetails.setDetail("Login phase", () -> this.state.toString());
    }

    @Override
    public void handleCookieResponse(ServerboundCookieResponsePacket serverboundcookieresponsepacket) {
        PlayerConnectionUtils.ensureRunningOnSameThread(serverboundcookieresponsepacket, this, this.server);
        if (this.player != null && this.player.getBukkitEntity().handleCookieResponse(serverboundcookieresponsepacket)) {
            return;
        }
        this.disconnect(ServerCommonPacketListenerImpl.DISCONNECT_UNEXPECTED_QUERY);
    }

    protected GameProfile createOfflineProfile(String s2) {
        UUID uuid = this.connection.spoofedUUID != null ? this.connection.spoofedUUID : UUIDUtil.createOfflinePlayerUUID(s2);
        GameProfile gameProfile = new GameProfile(uuid, s2);
        if (this.connection.spoofedProfile != null) {
            for (Property property : this.connection.spoofedProfile) {
                if (!HandshakeListener.PROP_PATTERN.matcher(property.name()).matches()) continue;
                gameProfile.getProperties().put((Object)property.name(), (Object)property);
            }
        }
        return gameProfile;
    }

    private static enum EnumProtocolState {
        HELLO,
        KEY,
        AUTHENTICATING,
        NEGOTIATING,
        VERIFYING,
        WAITING_FOR_COOKIES,
        WAITING_FOR_DUPE_DISCONNECT,
        PROTOCOL_SWITCHING,
        ACCEPTED;

    }
}

