/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.network;

import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Optional;
import net.minecraft.SharedConstants;
import net.minecraft.network.DisconnectionDetails;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.protocol.ping.ClientboundPongResponsePacket;
import net.minecraft.network.protocol.ping.ServerboundPingRequestPacket;
import net.minecraft.network.protocol.status.PacketStatusInListener;
import net.minecraft.network.protocol.status.PacketStatusInStart;
import net.minecraft.network.protocol.status.PacketStatusOutServerInfo;
import net.minecraft.network.protocol.status.ServerPing;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.EntityPlayer;
import org.bukkit.craftbukkit.v1_21_R1.CraftServer;
import org.bukkit.craftbukkit.v1_21_R1.util.CraftChatMessage;
import org.bukkit.craftbukkit.v1_21_R1.util.CraftIconCache;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.server.ServerListPingEvent;
import org.bukkit.util.CachedServerIcon;
import org.spigotmc.SpigotConfig;

public class PacketStatusListener
implements PacketStatusInListener {
    private static final IChatBaseComponent DISCONNECT_REASON = IChatBaseComponent.translatable("multiplayer.status.request_handled");
    private final ServerPing status;
    private final NetworkManager connection;
    private boolean hasRequestedStatus;

    public PacketStatusListener(ServerPing serverping, NetworkManager networkmanager) {
        this.status = serverping;
        this.connection = networkmanager;
    }

    @Override
    public void onDisconnect(DisconnectionDetails disconnectiondetails) {
    }

    @Override
    public boolean isAcceptingMessages() {
        return this.connection.isConnected();
    }

    @Override
    public void handleStatusRequest(PacketStatusInStart packetstatusinstart) {
        if (this.hasRequestedStatus) {
            this.connection.disconnect(DISCONNECT_REASON);
        } else {
            this.hasRequestedStatus = true;
            final MinecraftServer server = MinecraftServer.getServer();
            final Object[] players = server.getPlayerList().players.toArray();
            class ServerListPingEvent
            extends org.bukkit.event.server.ServerListPingEvent {
                CraftIconCache icon;

                ServerListPingEvent() {
                    super(this$0.connection.hostname, ((InetSocketAddress)this$0.connection.getRemoteAddress()).getAddress(), minecraftServer.getMotd(), minecraftServer.getPlayerList().getMaxPlayers());
                    this.icon = server.server.getServerIcon();
                }

                public void setServerIcon(CachedServerIcon icon) {
                    if (!(icon instanceof CraftIconCache)) {
                        throw new IllegalArgumentException(String.valueOf(icon) + " was not created by " + String.valueOf(CraftServer.class));
                    }
                    this.icon = (CraftIconCache)icon;
                }

                public Iterator<Player> iterator() throws UnsupportedOperationException {
                    return new Iterator<Player>(){
                        int i;
                        int ret = Integer.MIN_VALUE;
                        EntityPlayer player;

                        @Override
                        public boolean hasNext() {
                            if (this.player != null) {
                                return true;
                            }
                            Object[] currentPlayers = players;
                            int length = currentPlayers.length;
                            for (int i2 = this.i; i2 < length; ++i2) {
                                EntityPlayer player = (EntityPlayer)currentPlayers[i2];
                                if (player == null) continue;
                                this.i = i2 + 1;
                                this.player = player;
                                return true;
                            }
                            return false;
                        }

                        @Override
                        public Player next() {
                            if (!this.hasNext()) {
                                throw new NoSuchElementException();
                            }
                            EntityPlayer player = this.player;
                            this.player = null;
                            this.ret = this.i - 1;
                            return player.getBukkitEntity();
                        }

                        @Override
                        public void remove() {
                            Object[] currentPlayers = players;
                            int i2 = this.ret;
                            if (i2 < 0 || currentPlayers[i2] == null) {
                                throw new IllegalStateException();
                            }
                            currentPlayers[i2] = null;
                        }
                    };
                }
            }
            ServerListPingEvent event = new ServerListPingEvent();
            server.server.getPluginManager().callEvent((Event)event);
            List<Object> profiles = new ArrayList(players.length);
            for (Object player : players) {
                if (player == null) continue;
                EntityPlayer entityPlayer = (EntityPlayer)player;
                if (entityPlayer.allowsListing()) {
                    profiles.add(entityPlayer.getGameProfile());
                    continue;
                }
                profiles.add(MinecraftServer.ANONYMOUS_PLAYER_PROFILE);
            }
            if (!server.hidesOnlinePlayers() && !profiles.isEmpty()) {
                Collections.shuffle(profiles);
                profiles = profiles.subList(0, Math.min(profiles.size(), SpigotConfig.playerSample));
            }
            ServerPing.ServerPingPlayerSample playerSample = new ServerPing.ServerPingPlayerSample(event.getMaxPlayers(), event.getNumPlayers(), server.hidesOnlinePlayers() ? Collections.emptyList() : profiles);
            ServerPing ping = new ServerPing(CraftChatMessage.fromString(event.getMotd(), true)[0], Optional.of(playerSample), Optional.of(new ServerPing.ServerData(server.getServerModName() + " " + server.getServerVersion(), SharedConstants.getCurrentVersion().getProtocolVersion())), event.icon.value != null ? Optional.of(new ServerPing.a(event.icon.value)) : Optional.empty(), server.enforceSecureProfile());
            this.connection.send(new PacketStatusOutServerInfo(ping));
        }
    }

    @Override
    public void handlePingRequest(ServerboundPingRequestPacket serverboundpingrequestpacket) {
        this.connection.send(new ClientboundPongResponsePacket(serverboundpingrequestpacket.getTime()));
        this.connection.disconnect(DISCONNECT_REASON);
    }
}

