/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.network;

import com.google.common.collect.Lists;
import com.google.common.primitives.Floats;
import com.mojang.authlib.GameProfile;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.ParseResults;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.datafixers.util.Pair;
import com.mojang.logging.LogUtils;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMaps;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.net.SocketAddress;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.logging.Level;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.EnumChatFormat;
import net.minecraft.SystemUtils;
import net.minecraft.advancements.AdvancementHolder;
import net.minecraft.advancements.CriterionTriggers;
import net.minecraft.commands.CommandListenerWrapper;
import net.minecraft.commands.CommandSigningContext;
import net.minecraft.commands.arguments.ArgumentSignatures;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.DisconnectionDetails;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.TickablePacketListener;
import net.minecraft.network.chat.ChatMessageType;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.chat.IChatMutableComponent;
import net.minecraft.network.chat.LastSeenMessages;
import net.minecraft.network.chat.LastSeenMessagesValidator;
import net.minecraft.network.chat.MessageSignature;
import net.minecraft.network.chat.MessageSignatureCache;
import net.minecraft.network.chat.OutgoingChatMessage;
import net.minecraft.network.chat.PlayerChatMessage;
import net.minecraft.network.chat.RemoteChatSession;
import net.minecraft.network.chat.SignableCommand;
import net.minecraft.network.chat.SignedMessageBody;
import net.minecraft.network.chat.SignedMessageChain;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.PlayerConnectionUtils;
import net.minecraft.network.protocol.common.ServerboundClientInformationPacket;
import net.minecraft.network.protocol.configuration.ConfigurationProtocols;
import net.minecraft.network.protocol.game.ClientboundBlockChangedAckPacket;
import net.minecraft.network.protocol.game.ClientboundDisguisedChatPacket;
import net.minecraft.network.protocol.game.ClientboundPlayerChatPacket;
import net.minecraft.network.protocol.game.ClientboundPlayerInfoUpdatePacket;
import net.minecraft.network.protocol.game.ClientboundStartConfigurationPacket;
import net.minecraft.network.protocol.game.ClientboundSystemChatPacket;
import net.minecraft.network.protocol.game.PacketListenerPlayIn;
import net.minecraft.network.protocol.game.PacketPlayInAbilities;
import net.minecraft.network.protocol.game.PacketPlayInAdvancements;
import net.minecraft.network.protocol.game.PacketPlayInArmAnimation;
import net.minecraft.network.protocol.game.PacketPlayInAutoRecipe;
import net.minecraft.network.protocol.game.PacketPlayInBEdit;
import net.minecraft.network.protocol.game.PacketPlayInBeacon;
import net.minecraft.network.protocol.game.PacketPlayInBlockDig;
import net.minecraft.network.protocol.game.PacketPlayInBlockPlace;
import net.minecraft.network.protocol.game.PacketPlayInBoatMove;
import net.minecraft.network.protocol.game.PacketPlayInChat;
import net.minecraft.network.protocol.game.PacketPlayInClientCommand;
import net.minecraft.network.protocol.game.PacketPlayInCloseWindow;
import net.minecraft.network.protocol.game.PacketPlayInDifficultyChange;
import net.minecraft.network.protocol.game.PacketPlayInDifficultyLock;
import net.minecraft.network.protocol.game.PacketPlayInEnchantItem;
import net.minecraft.network.protocol.game.PacketPlayInEntityAction;
import net.minecraft.network.protocol.game.PacketPlayInEntityNBTQuery;
import net.minecraft.network.protocol.game.PacketPlayInFlying;
import net.minecraft.network.protocol.game.PacketPlayInHeldItemSlot;
import net.minecraft.network.protocol.game.PacketPlayInItemName;
import net.minecraft.network.protocol.game.PacketPlayInJigsawGenerate;
import net.minecraft.network.protocol.game.PacketPlayInPickItem;
import net.minecraft.network.protocol.game.PacketPlayInRecipeDisplayed;
import net.minecraft.network.protocol.game.PacketPlayInRecipeSettings;
import net.minecraft.network.protocol.game.PacketPlayInSetCommandBlock;
import net.minecraft.network.protocol.game.PacketPlayInSetCommandMinecart;
import net.minecraft.network.protocol.game.PacketPlayInSetCreativeSlot;
import net.minecraft.network.protocol.game.PacketPlayInSetJigsaw;
import net.minecraft.network.protocol.game.PacketPlayInSpectate;
import net.minecraft.network.protocol.game.PacketPlayInSteerVehicle;
import net.minecraft.network.protocol.game.PacketPlayInStruct;
import net.minecraft.network.protocol.game.PacketPlayInTabComplete;
import net.minecraft.network.protocol.game.PacketPlayInTeleportAccept;
import net.minecraft.network.protocol.game.PacketPlayInTileNBTQuery;
import net.minecraft.network.protocol.game.PacketPlayInTrSel;
import net.minecraft.network.protocol.game.PacketPlayInUpdateSign;
import net.minecraft.network.protocol.game.PacketPlayInUseEntity;
import net.minecraft.network.protocol.game.PacketPlayInUseItem;
import net.minecraft.network.protocol.game.PacketPlayInVehicleMove;
import net.minecraft.network.protocol.game.PacketPlayInWindowClick;
import net.minecraft.network.protocol.game.PacketPlayOutAttachEntity;
import net.minecraft.network.protocol.game.PacketPlayOutBlockChange;
import net.minecraft.network.protocol.game.PacketPlayOutEntityEquipment;
import net.minecraft.network.protocol.game.PacketPlayOutHeldItemSlot;
import net.minecraft.network.protocol.game.PacketPlayOutNBTQuery;
import net.minecraft.network.protocol.game.PacketPlayOutPosition;
import net.minecraft.network.protocol.game.PacketPlayOutSetSlot;
import net.minecraft.network.protocol.game.PacketPlayOutTabComplete;
import net.minecraft.network.protocol.game.PacketPlayOutVehicleMove;
import net.minecraft.network.protocol.game.ServerboundChatAckPacket;
import net.minecraft.network.protocol.game.ServerboundChatCommandPacket;
import net.minecraft.network.protocol.game.ServerboundChatCommandSignedPacket;
import net.minecraft.network.protocol.game.ServerboundChatSessionUpdatePacket;
import net.minecraft.network.protocol.game.ServerboundChunkBatchReceivedPacket;
import net.minecraft.network.protocol.game.ServerboundConfigurationAcknowledgedPacket;
import net.minecraft.network.protocol.game.ServerboundContainerSlotStateChangedPacket;
import net.minecraft.network.protocol.game.ServerboundDebugSampleSubscriptionPacket;
import net.minecraft.network.protocol.ping.ClientboundPongResponsePacket;
import net.minecraft.network.protocol.ping.ServerboundPingRequestPacket;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.server.network.CommonListenerCookie;
import net.minecraft.server.network.Filterable;
import net.minecraft.server.network.FilteredText;
import net.minecraft.server.network.ITextFilter;
import net.minecraft.server.network.PlayerChunkSender;
import net.minecraft.server.network.ServerCommonPacketListenerImpl;
import net.minecraft.server.network.ServerConfigurationPacketListenerImpl;
import net.minecraft.server.network.ServerPlayerConnection;
import net.minecraft.stats.RecipeBookServer;
import net.minecraft.util.FutureChain;
import net.minecraft.util.MathHelper;
import net.minecraft.util.SignatureValidator;
import net.minecraft.util.UtilColor;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.IInventory;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityExperienceOrb;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EnumItemSlot;
import net.minecraft.world.entity.EnumMoveType;
import net.minecraft.world.entity.HasCustomInventoryScreen;
import net.minecraft.world.entity.IJumpable;
import net.minecraft.world.entity.RelativeMovement;
import net.minecraft.world.entity.animal.Bucketable;
import net.minecraft.world.entity.animal.allay.Allay;
import net.minecraft.world.entity.item.EntityItem;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.player.EnumChatVisibility;
import net.minecraft.world.entity.player.PlayerInventory;
import net.minecraft.world.entity.player.ProfilePublicKey;
import net.minecraft.world.entity.projectile.EntityArrow;
import net.minecraft.world.entity.vehicle.EntityBoat;
import net.minecraft.world.inventory.Container;
import net.minecraft.world.inventory.ContainerAnvil;
import net.minecraft.world.inventory.ContainerBeacon;
import net.minecraft.world.inventory.ContainerMerchant;
import net.minecraft.world.inventory.ContainerRecipeBook;
import net.minecraft.world.inventory.CrafterMenu;
import net.minecraft.world.inventory.InventoryClickType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemBlock;
import net.minecraft.world.item.ItemBucket;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.item.component.WritableBookContent;
import net.minecraft.world.item.component.WrittenBookContent;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.level.CommandBlockListenerAbstract;
import net.minecraft.world.level.EnumGamemode;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.RayTrace;
import net.minecraft.world.level.block.BlockCommand;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.CrafterBlockEntity;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.entity.TileEntityCommand;
import net.minecraft.world.level.block.entity.TileEntityJigsaw;
import net.minecraft.world.level.block.entity.TileEntitySign;
import net.minecraft.world.level.block.entity.TileEntityStructure;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.MovingObjectPosition;
import net.minecraft.world.phys.MovingObjectPositionBlock;
import net.minecraft.world.phys.Vec3D;
import net.minecraft.world.phys.shapes.OperatorBoolean;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.phys.shapes.VoxelShapes;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.FluidCollisionMode;
import org.bukkit.Keyed;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.command.CommandException;
import org.bukkit.command.CommandSender;
import org.bukkit.craftbukkit.v1_21_R1.SpigotTimings;
import org.bukkit.craftbukkit.v1_21_R1.entity.CraftEntity;
import org.bukkit.craftbukkit.v1_21_R1.entity.CraftPlayer;
import org.bukkit.craftbukkit.v1_21_R1.event.CraftEventFactory;
import org.bukkit.craftbukkit.v1_21_R1.inventory.CraftInventoryView;
import org.bukkit.craftbukkit.v1_21_R1.inventory.CraftItemStack;
import org.bukkit.craftbukkit.v1_21_R1.inventory.CraftItemType;
import org.bukkit.craftbukkit.v1_21_R1.util.CraftChatMessage;
import org.bukkit.craftbukkit.v1_21_R1.util.CraftNamespacedKey;
import org.bukkit.craftbukkit.v1_21_R1.util.LazyPlayerSet;
import org.bukkit.craftbukkit.v1_21_R1.util.Waitable;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.block.Action;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.event.inventory.CraftItemEvent;
import org.bukkit.event.inventory.InventoryAction;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCreativeEvent;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.event.inventory.SmithItemEvent;
import org.bukkit.event.inventory.TradeSelectEvent;
import org.bukkit.event.player.AsyncPlayerChatEvent;
import org.bukkit.event.player.PlayerAnimationEvent;
import org.bukkit.event.player.PlayerAnimationType;
import org.bukkit.event.player.PlayerChatEvent;
import org.bukkit.event.player.PlayerCommandPreprocessEvent;
import org.bukkit.event.player.PlayerInteractAtEntityEvent;
import org.bukkit.event.player.PlayerInteractEntityEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerItemHeldEvent;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.event.player.PlayerRecipeBookClickEvent;
import org.bukkit.event.player.PlayerRespawnEvent;
import org.bukkit.event.player.PlayerSwapHandItemsEvent;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.bukkit.event.player.PlayerToggleFlightEvent;
import org.bukkit.event.player.PlayerToggleSneakEvent;
import org.bukkit.event.player.PlayerToggleSprintEvent;
import org.bukkit.inventory.CraftingInventory;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryView;
import org.bukkit.inventory.Recipe;
import org.bukkit.inventory.SmithingInventory;
import org.bukkit.util.RayTraceResult;
import org.bukkit.util.Vector;
import org.slf4j.Logger;
import org.spigotmc.SpigotConfig;

public class PlayerConnection
extends ServerCommonPacketListenerImpl
implements PacketListenerPlayIn,
ServerPlayerConnection,
TickablePacketListener {
    static final Logger LOGGER = LogUtils.getLogger();
    private static final int NO_BLOCK_UPDATES_TO_ACK = -1;
    private static final int TRACKED_MESSAGE_DISCONNECT_THRESHOLD = 4096;
    private static final int MAXIMUM_FLYING_TICKS = 80;
    private static final IChatBaseComponent CHAT_VALIDATION_FAILED = IChatBaseComponent.translatable("multiplayer.disconnect.chat_validation_failed");
    private static final IChatBaseComponent INVALID_COMMAND_SIGNATURE = IChatBaseComponent.translatable("chat.disabled.invalid_command_signature").withStyle(EnumChatFormat.RED);
    private static final int MAX_COMMAND_SUGGESTIONS = 1000;
    public EntityPlayer player;
    public final PlayerChunkSender chunkSender;
    private int tickCount;
    private int ackBlockChangesUpTo = -1;
    private final AtomicInteger chatSpamTickCount = new AtomicInteger();
    private int dropSpamTickCount;
    private double firstGoodX;
    private double firstGoodY;
    private double firstGoodZ;
    private double lastGoodX;
    private double lastGoodY;
    private double lastGoodZ;
    @Nullable
    private net.minecraft.world.entity.Entity lastVehicle;
    private double vehicleFirstGoodX;
    private double vehicleFirstGoodY;
    private double vehicleFirstGoodZ;
    private double vehicleLastGoodX;
    private double vehicleLastGoodY;
    private double vehicleLastGoodZ;
    @Nullable
    private Vec3D awaitingPositionFromClient;
    private int awaitingTeleport;
    private int awaitingTeleportTime;
    private boolean clientIsFloating;
    private int aboveGroundTickCount;
    private boolean clientVehicleIsFloating;
    private int aboveGroundVehicleTickCount;
    private int receivedMovePacketCount;
    private int knownMovePacketCount;
    @Nullable
    private RemoteChatSession chatSession;
    private SignedMessageChain.b signedMessageDecoder;
    private final LastSeenMessagesValidator lastSeenMessages = new LastSeenMessagesValidator(20);
    private final MessageSignatureCache messageSignatureCache = MessageSignatureCache.createDefault();
    private final FutureChain chatMessageChain;
    private boolean waitingForSwitchToConfig;
    private int lastTick = MinecraftServer.currentTick;
    private int allowedPlayerTicks = 1;
    private int lastDropTick = MinecraftServer.currentTick;
    private int lastBookTick = MinecraftServer.currentTick;
    private int dropCount = 0;
    private boolean hasMoved = false;
    private double lastPosX = Double.MAX_VALUE;
    private double lastPosY = Double.MAX_VALUE;
    private double lastPosZ = Double.MAX_VALUE;
    private float lastPitch = Float.MAX_VALUE;
    private float lastYaw = Float.MAX_VALUE;
    private boolean justTeleported = false;
    private int limitedPackets;
    private long lastLimitedPacket = -1L;

    public PlayerConnection(MinecraftServer minecraftserver, NetworkManager networkmanager, EntityPlayer entityplayer, CommonListenerCookie commonlistenercookie) {
        super(minecraftserver, networkmanager, commonlistenercookie, entityplayer);
        this.chunkSender = new PlayerChunkSender(networkmanager.isMemoryConnection());
        this.player = entityplayer;
        entityplayer.connection = this;
        entityplayer.getTextFilter().join();
        UUID uuid = entityplayer.getUUID();
        Objects.requireNonNull(minecraftserver);
        this.signedMessageDecoder = SignedMessageChain.b.unsigned(uuid, minecraftserver::enforceSecureProfile);
        this.chatMessageChain = new FutureChain(minecraftserver.chatExecutor);
    }

    @Override
    public void tick() {
        int spam;
        SpigotTimings.playerConnectionTimer.startTiming();
        if (this.ackBlockChangesUpTo > -1) {
            this.send(new ClientboundBlockChangedAckPacket(this.ackBlockChangesUpTo));
            this.ackBlockChangesUpTo = -1;
        }
        this.resetPosition();
        this.player.xo = this.player.getX();
        this.player.yo = this.player.getY();
        this.player.zo = this.player.getZ();
        this.player.doTick();
        this.player.absMoveTo(this.firstGoodX, this.firstGoodY, this.firstGoodZ, this.player.getYRot(), this.player.getXRot());
        ++this.tickCount;
        this.knownMovePacketCount = this.receivedMovePacketCount;
        if (this.clientIsFloating && !this.player.isSleeping() && !this.player.isPassenger() && !this.player.isDeadOrDying()) {
            if (++this.aboveGroundTickCount > this.getMaximumFlyingTicks(this.player)) {
                LOGGER.warn("{} was kicked for floating too long!", (Object)this.player.getName().getString());
                this.disconnect(IChatBaseComponent.translatable("multiplayer.disconnect.flying"));
                return;
            }
        } else {
            this.clientIsFloating = false;
            this.aboveGroundTickCount = 0;
        }
        this.lastVehicle = this.player.getRootVehicle();
        if (this.lastVehicle != this.player && this.lastVehicle.getControllingPassenger() == this.player) {
            this.vehicleFirstGoodX = this.lastVehicle.getX();
            this.vehicleFirstGoodY = this.lastVehicle.getY();
            this.vehicleFirstGoodZ = this.lastVehicle.getZ();
            this.vehicleLastGoodX = this.lastVehicle.getX();
            this.vehicleLastGoodY = this.lastVehicle.getY();
            this.vehicleLastGoodZ = this.lastVehicle.getZ();
            if (this.clientVehicleIsFloating && this.lastVehicle.getControllingPassenger() == this.player) {
                if (++this.aboveGroundVehicleTickCount > this.getMaximumFlyingTicks(this.lastVehicle)) {
                    LOGGER.warn("{} was kicked for floating a vehicle too long!", (Object)this.player.getName().getString());
                    this.disconnect(IChatBaseComponent.translatable("multiplayer.disconnect.flying"));
                    return;
                }
            } else {
                this.clientVehicleIsFloating = false;
                this.aboveGroundVehicleTickCount = 0;
            }
        } else {
            this.lastVehicle = null;
            this.clientVehicleIsFloating = false;
            this.aboveGroundVehicleTickCount = 0;
        }
        this.keepConnectionAlive();
        while ((spam = this.chatSpamTickCount.get()) > 0 && !this.chatSpamTickCount.compareAndSet(spam, spam - 1)) {
        }
        if (this.dropSpamTickCount > 0) {
            --this.dropSpamTickCount;
        }
        if (this.player.getLastActionTime() > 0L && this.server.getPlayerIdleTimeout() > 0 && SystemUtils.getMillis() - this.player.getLastActionTime() > (long)this.server.getPlayerIdleTimeout() * 1000L * 60L) {
            this.player.resetLastActionTime();
            this.disconnect(IChatBaseComponent.translatable("multiplayer.disconnect.idling"));
        }
        SpigotTimings.playerConnectionTimer.stopTiming();
    }

    private int getMaximumFlyingTicks(net.minecraft.world.entity.Entity entity) {
        double d0 = entity.getGravity();
        if (d0 < (double)1.0E-5f) {
            return Integer.MAX_VALUE;
        }
        double d1 = 0.08 / d0;
        return MathHelper.ceil(80.0 * Math.max(d1, 1.0));
    }

    public void resetPosition() {
        this.firstGoodX = this.player.getX();
        this.firstGoodY = this.player.getY();
        this.firstGoodZ = this.player.getZ();
        this.lastGoodX = this.player.getX();
        this.lastGoodY = this.player.getY();
        this.lastGoodZ = this.player.getZ();
    }

    @Override
    public boolean isAcceptingMessages() {
        return this.connection.isConnected() && !this.waitingForSwitchToConfig;
    }

    @Override
    public boolean shouldHandleMessage(Packet<?> packet) {
        return super.shouldHandleMessage(packet) ? true : this.waitingForSwitchToConfig && this.connection.isConnected() && packet instanceof ServerboundConfigurationAcknowledgedPacket;
    }

    @Override
    protected GameProfile playerProfile() {
        return this.player.getGameProfile();
    }

    private <T, R> CompletableFuture<R> filterTextPacket(T t0, BiFunction<ITextFilter, T, CompletableFuture<R>> bifunction) {
        return bifunction.apply(this.player.getTextFilter(), (ITextFilter)t0).thenApply(object -> {
            if (!this.isAcceptingMessages()) {
                LOGGER.debug("Ignoring packet due to disconnection");
                throw new CancellationException("disconnected");
            }
            return object;
        });
    }

    private CompletableFuture<FilteredText> filterTextPacket(String s2) {
        return this.filterTextPacket(s2, ITextFilter::processStreamMessage);
    }

    private CompletableFuture<List<FilteredText>> filterTextPacket(List<String> list) {
        return this.filterTextPacket(list, ITextFilter::processMessageBundle);
    }

    @Override
    public void handlePlayerInput(PacketPlayInSteerVehicle packetplayinsteervehicle) {
        PlayerConnectionUtils.ensureRunningOnSameThread(packetplayinsteervehicle, this, this.player.serverLevel());
        this.player.setPlayerInput(packetplayinsteervehicle.getXxa(), packetplayinsteervehicle.getZza(), packetplayinsteervehicle.isJumping(), packetplayinsteervehicle.isShiftKeyDown());
    }

    private static boolean containsInvalidValues(double d0, double d1, double d2, float f2, float f1) {
        return Double.isNaN(d0) || Double.isNaN(d1) || Double.isNaN(d2) || !Floats.isFinite((float)f1) || !Floats.isFinite((float)f2);
    }

    private static double clampHorizontal(double d0) {
        return MathHelper.clamp(d0, -3.0E7, 3.0E7);
    }

    private static double clampVertical(double d0) {
        return MathHelper.clamp(d0, -2.0E7, 2.0E7);
    }

    @Override
    public void handleMoveVehicle(PacketPlayInVehicleMove packetplayinvehiclemove) {
        net.minecraft.world.entity.Entity entity;
        PlayerConnectionUtils.ensureRunningOnSameThread(packetplayinvehiclemove, this, this.player.serverLevel());
        if (PlayerConnection.containsInvalidValues(packetplayinvehiclemove.getX(), packetplayinvehiclemove.getY(), packetplayinvehiclemove.getZ(), packetplayinvehiclemove.getYRot(), packetplayinvehiclemove.getXRot())) {
            this.disconnect(IChatBaseComponent.translatable("multiplayer.disconnect.invalid_vehicle_movement"));
        } else if (!this.updateAwaitingTeleport() && (entity = this.player.getRootVehicle()) != this.player && entity.getControllingPassenger() == this.player && entity == this.lastVehicle) {
            EntityLiving entityliving;
            WorldServer worldserver = this.player.serverLevel();
            double prevX = this.player.getX();
            double prevY = this.player.getY();
            double prevZ = this.player.getZ();
            float prevYaw = this.player.getYRot();
            float prevPitch = this.player.getXRot();
            double d0 = entity.getX();
            double d1 = entity.getY();
            double d2 = entity.getZ();
            double d3 = PlayerConnection.clampHorizontal(packetplayinvehiclemove.getX());
            double d4 = PlayerConnection.clampVertical(packetplayinvehiclemove.getY());
            double d5 = PlayerConnection.clampHorizontal(packetplayinvehiclemove.getZ());
            float f2 = MathHelper.wrapDegrees(packetplayinvehiclemove.getYRot());
            float f1 = MathHelper.wrapDegrees(packetplayinvehiclemove.getXRot());
            double d6 = d3 - this.vehicleFirstGoodX;
            double d7 = d4 - this.vehicleFirstGoodY;
            double d8 = d5 - this.vehicleFirstGoodZ;
            double d9 = entity.getDeltaMovement().lengthSqr();
            double d10 = d6 * d6 + d7 * d7 + d8 * d8;
            this.allowedPlayerTicks = (int)((long)this.allowedPlayerTicks + (System.currentTimeMillis() / 50L - (long)this.lastTick));
            this.allowedPlayerTicks = Math.max(this.allowedPlayerTicks, 1);
            this.lastTick = (int)(System.currentTimeMillis() / 50L);
            ++this.receivedMovePacketCount;
            int i2 = this.receivedMovePacketCount - this.knownMovePacketCount;
            if (i2 > Math.max(this.allowedPlayerTicks, 5)) {
                LOGGER.debug(this.player.getScoreboardName() + " is sending move packets too frequently (" + i2 + " packets since last tick)");
                i2 = 1;
            }
            this.allowedPlayerTicks = d10 > 0.0 ? --this.allowedPlayerTicks : 20;
            double speed = this.player.getAbilities().flying ? (double)(this.player.getAbilities().flyingSpeed * 20.0f) : (double)(this.player.getAbilities().walkingSpeed * 10.0f);
            speed *= 2.0;
            if (d10 - d9 > Math.max(100.0, Math.pow(SpigotConfig.movedTooQuicklyMultiplier * (double)i2 * speed, 2.0)) && !this.isSingleplayerOwner()) {
                LOGGER.warn("{} (vehicle of {}) moved too quickly! {},{},{}", new Object[]{entity.getName().getString(), this.player.getName().getString(), d6, d7, d8});
                this.send(new PacketPlayOutVehicleMove(entity));
                return;
            }
            boolean flag = worldserver.noCollision(entity, entity.getBoundingBox().deflate(0.0625));
            d6 = d3 - this.vehicleLastGoodX;
            d7 = d4 - this.vehicleLastGoodY - 1.0E-6;
            d8 = d5 - this.vehicleLastGoodZ;
            boolean flag1 = entity.verticalCollisionBelow;
            if (entity instanceof EntityLiving && (entityliving = (EntityLiving)entity).onClimbable()) {
                entityliving.resetFallDistance();
            }
            entity.move(EnumMoveType.PLAYER, new Vec3D(d6, d7, d8));
            double d11 = d7;
            d6 = d3 - entity.getX();
            d7 = d4 - entity.getY();
            if (d7 > -0.5 || d7 < 0.5) {
                d7 = 0.0;
            }
            d8 = d5 - entity.getZ();
            d10 = d6 * d6 + d7 * d7 + d8 * d8;
            boolean flag2 = false;
            if (d10 > SpigotConfig.movedWronglyThreshold) {
                flag2 = true;
                LOGGER.warn("{} (vehicle of {}) moved wrongly! {}", new Object[]{entity.getName().getString(), this.player.getName().getString(), Math.sqrt(d10)});
            }
            entity.absMoveTo(d3, d4, d5, f2, f1);
            this.player.absMoveTo(d3, d4, d5, this.player.getYRot(), this.player.getXRot());
            boolean flag3 = worldserver.noCollision(entity, entity.getBoundingBox().deflate(0.0625));
            if (flag && (flag2 || !flag3)) {
                entity.absMoveTo(d0, d1, d2, f2, f1);
                this.player.absMoveTo(d0, d1, d2, this.player.getYRot(), this.player.getXRot());
                this.send(new PacketPlayOutVehicleMove(entity));
                return;
            }
            CraftPlayer player = this.getCraftPlayer();
            if (!this.hasMoved) {
                this.lastPosX = prevX;
                this.lastPosY = prevY;
                this.lastPosZ = prevZ;
                this.lastYaw = prevYaw;
                this.lastPitch = prevPitch;
                this.hasMoved = true;
            }
            Location from = new Location(player.getWorld(), this.lastPosX, this.lastPosY, this.lastPosZ, this.lastYaw, this.lastPitch);
            Location to = player.getLocation().clone();
            to.setX(packetplayinvehiclemove.getX());
            to.setY(packetplayinvehiclemove.getY());
            to.setZ(packetplayinvehiclemove.getZ());
            to.setYaw(packetplayinvehiclemove.getYRot());
            to.setPitch(packetplayinvehiclemove.getXRot());
            double delta = Math.pow(this.lastPosX - to.getX(), 2.0) + Math.pow(this.lastPosY - to.getY(), 2.0) + Math.pow(this.lastPosZ - to.getZ(), 2.0);
            float deltaAngle = Math.abs(this.lastYaw - to.getYaw()) + Math.abs(this.lastPitch - to.getPitch());
            if ((delta > 0.00390625 || deltaAngle > 10.0f) && !this.player.isImmobile()) {
                this.lastPosX = to.getX();
                this.lastPosY = to.getY();
                this.lastPosZ = to.getZ();
                this.lastYaw = to.getYaw();
                this.lastPitch = to.getPitch();
                Location oldTo = to.clone();
                PlayerMoveEvent event = new PlayerMoveEvent((Player)player, from, to);
                this.cserver.getPluginManager().callEvent((Event)event);
                if (event.isCancelled()) {
                    this.teleport(from);
                    return;
                }
                if (!oldTo.equals((Object)event.getTo()) && !event.isCancelled()) {
                    this.player.getBukkitEntity().teleport(event.getTo(), PlayerTeleportEvent.TeleportCause.PLUGIN);
                    return;
                }
                if (!from.equals((Object)this.getCraftPlayer().getLocation()) && this.justTeleported) {
                    this.justTeleported = false;
                    return;
                }
            }
            this.player.serverLevel().getChunkSource().move(this.player);
            Vec3D vec3d = new Vec3D(entity.getX() - d0, entity.getY() - d1, entity.getZ() - d2);
            this.player.setKnownMovement(vec3d);
            this.player.checkMovementStatistics(vec3d.x, vec3d.y, vec3d.z);
            this.clientVehicleIsFloating = d11 >= -0.03125 && !flag1 && !this.server.isFlightAllowed() && !entity.isNoGravity() && this.noBlocksAround(entity);
            this.vehicleLastGoodX = entity.getX();
            this.vehicleLastGoodY = entity.getY();
            this.vehicleLastGoodZ = entity.getZ();
        }
    }

    private boolean noBlocksAround(net.minecraft.world.entity.Entity entity) {
        return entity.level().getBlockStates(entity.getBoundingBox().inflate(0.0625).expandTowards(0.0, -0.55, 0.0)).allMatch(BlockBase.BlockData::isAir);
    }

    @Override
    public void handleAcceptTeleportPacket(PacketPlayInTeleportAccept packetplayinteleportaccept) {
        PlayerConnectionUtils.ensureRunningOnSameThread(packetplayinteleportaccept, this, this.player.serverLevel());
        if (packetplayinteleportaccept.getId() == this.awaitingTeleport) {
            if (this.awaitingPositionFromClient == null) {
                this.disconnect(IChatBaseComponent.translatable("multiplayer.disconnect.invalid_player_movement"));
                return;
            }
            this.player.absMoveTo(this.awaitingPositionFromClient.x, this.awaitingPositionFromClient.y, this.awaitingPositionFromClient.z, this.player.getYRot(), this.player.getXRot());
            this.lastGoodX = this.awaitingPositionFromClient.x;
            this.lastGoodY = this.awaitingPositionFromClient.y;
            this.lastGoodZ = this.awaitingPositionFromClient.z;
            if (this.player.isChangingDimension()) {
                this.player.hasChangedDimension();
            }
            this.awaitingPositionFromClient = null;
            this.player.serverLevel().getChunkSource().move(this.player);
        }
    }

    @Override
    public void handleRecipeBookSeenRecipePacket(PacketPlayInRecipeDisplayed packetplayinrecipedisplayed) {
        PlayerConnectionUtils.ensureRunningOnSameThread(packetplayinrecipedisplayed, this, this.player.serverLevel());
        Optional<RecipeHolder<?>> optional = this.server.getRecipeManager().byKey(packetplayinrecipedisplayed.getRecipe());
        RecipeBookServer recipebookserver = this.player.getRecipeBook();
        Objects.requireNonNull(recipebookserver);
        optional.ifPresent(recipebookserver::removeHighlight);
    }

    @Override
    public void handleRecipeBookChangeSettingsPacket(PacketPlayInRecipeSettings packetplayinrecipesettings) {
        PlayerConnectionUtils.ensureRunningOnSameThread(packetplayinrecipesettings, this, this.player.serverLevel());
        CraftEventFactory.callRecipeBookSettingsEvent(this.player, packetplayinrecipesettings.getBookType(), packetplayinrecipesettings.isOpen(), packetplayinrecipesettings.isFiltering());
        this.player.getRecipeBook().setBookSetting(packetplayinrecipesettings.getBookType(), packetplayinrecipesettings.isOpen(), packetplayinrecipesettings.isFiltering());
    }

    @Override
    public void handleSeenAdvancements(PacketPlayInAdvancements packetplayinadvancements) {
        PlayerConnectionUtils.ensureRunningOnSameThread(packetplayinadvancements, this, this.player.serverLevel());
        if (packetplayinadvancements.getAction() == PacketPlayInAdvancements.Status.OPENED_TAB) {
            MinecraftKey minecraftkey = Objects.requireNonNull(packetplayinadvancements.getTab());
            AdvancementHolder advancementholder = this.server.getAdvancements().get(minecraftkey);
            if (advancementholder != null) {
                this.player.getAdvancements().setSelectedTab(advancementholder);
            }
        }
    }

    @Override
    public void handleCustomCommandSuggestions(PacketPlayInTabComplete packetplayintabcomplete) {
        PlayerConnectionUtils.ensureRunningOnSameThread(packetplayintabcomplete, this, this.player.serverLevel());
        if (this.chatSpamTickCount.addAndGet(1) > 500 && !this.server.getPlayerList().isOp(this.player.getGameProfile())) {
            this.disconnect(IChatBaseComponent.translatable("disconnect.spam"));
            return;
        }
        StringReader stringreader = new StringReader(packetplayintabcomplete.getCommand());
        if (stringreader.canRead() && stringreader.peek() == '/') {
            stringreader.skip();
        }
        ParseResults<CommandListenerWrapper> parseresults = this.server.getCommands().getDispatcher().parse(stringreader, this.player.createCommandSourceStack());
        this.server.getCommands().getDispatcher().getCompletionSuggestions(parseresults).thenAccept(suggestions -> {
            if (suggestions.isEmpty()) {
                return;
            }
            Suggestions suggestions1 = suggestions.getList().size() <= 1000 ? suggestions : new Suggestions(suggestions.getRange(), suggestions.getList().subList(0, 1000));
            this.send(new PacketPlayOutTabComplete(packetplayintabcomplete.getId(), suggestions1));
        });
    }

    @Override
    public void handleSetCommandBlock(PacketPlayInSetCommandBlock packetplayinsetcommandblock) {
        PlayerConnectionUtils.ensureRunningOnSameThread(packetplayinsetcommandblock, this, this.player.serverLevel());
        if (!this.server.isCommandBlockEnabled()) {
            this.player.sendSystemMessage(IChatBaseComponent.translatable("advMode.notEnabled"));
        } else if (!this.player.canUseGameMasterBlocks()) {
            this.player.sendSystemMessage(IChatBaseComponent.translatable("advMode.notAllowed"));
        } else {
            CommandBlockListenerAbstract commandblocklistenerabstract = null;
            TileEntityCommand tileentitycommand = null;
            BlockPosition blockposition = packetplayinsetcommandblock.getPos();
            TileEntity tileentity = this.player.level().getBlockEntity(blockposition);
            if (tileentity instanceof TileEntityCommand) {
                tileentitycommand = (TileEntityCommand)tileentity;
                commandblocklistenerabstract = tileentitycommand.getCommandBlock();
            }
            String s2 = packetplayinsetcommandblock.getCommand();
            boolean flag = packetplayinsetcommandblock.isTrackOutput();
            if (commandblocklistenerabstract != null) {
                TileEntityCommand.Type tileentitycommand_type = tileentitycommand.getMode();
                IBlockData iblockdata = this.player.level().getBlockState(blockposition);
                EnumDirection enumdirection = iblockdata.getValue(BlockCommand.FACING);
                IBlockData iblockdata2 = switch (packetplayinsetcommandblock.getMode()) {
                    case TileEntityCommand.Type.SEQUENCE -> Blocks.CHAIN_COMMAND_BLOCK.defaultBlockState();
                    case TileEntityCommand.Type.AUTO -> Blocks.REPEATING_COMMAND_BLOCK.defaultBlockState();
                    default -> Blocks.COMMAND_BLOCK.defaultBlockState();
                };
                IBlockData iblockdata3 = (IBlockData)((IBlockData)iblockdata2.setValue(BlockCommand.FACING, enumdirection)).setValue(BlockCommand.CONDITIONAL, packetplayinsetcommandblock.isConditional());
                if (iblockdata3 != iblockdata) {
                    this.player.level().setBlock(blockposition, iblockdata3, 2);
                    tileentity.setBlockState(iblockdata3);
                    this.player.level().getChunkAt(blockposition).setBlockEntity(tileentity);
                }
                commandblocklistenerabstract.setCommand(s2);
                commandblocklistenerabstract.setTrackOutput(flag);
                if (!flag) {
                    commandblocklistenerabstract.setLastOutput(null);
                }
                tileentitycommand.setAutomatic(packetplayinsetcommandblock.isAutomatic());
                if (tileentitycommand_type != packetplayinsetcommandblock.getMode()) {
                    tileentitycommand.onModeSwitch();
                }
                commandblocklistenerabstract.onUpdated();
                if (!UtilColor.isNullOrEmpty(s2)) {
                    this.player.sendSystemMessage(IChatBaseComponent.translatable("advMode.setCommand.success", s2));
                }
            }
        }
    }

    @Override
    public void handleSetCommandMinecart(PacketPlayInSetCommandMinecart packetplayinsetcommandminecart) {
        PlayerConnectionUtils.ensureRunningOnSameThread(packetplayinsetcommandminecart, this, this.player.serverLevel());
        if (!this.server.isCommandBlockEnabled()) {
            this.player.sendSystemMessage(IChatBaseComponent.translatable("advMode.notEnabled"));
        } else if (!this.player.canUseGameMasterBlocks()) {
            this.player.sendSystemMessage(IChatBaseComponent.translatable("advMode.notAllowed"));
        } else {
            CommandBlockListenerAbstract commandblocklistenerabstract = packetplayinsetcommandminecart.getCommandBlock(this.player.level());
            if (commandblocklistenerabstract != null) {
                commandblocklistenerabstract.setCommand(packetplayinsetcommandminecart.getCommand());
                commandblocklistenerabstract.setTrackOutput(packetplayinsetcommandminecart.isTrackOutput());
                if (!packetplayinsetcommandminecart.isTrackOutput()) {
                    commandblocklistenerabstract.setLastOutput(null);
                }
                commandblocklistenerabstract.onUpdated();
                this.player.sendSystemMessage(IChatBaseComponent.translatable("advMode.setCommand.success", packetplayinsetcommandminecart.getCommand()));
            }
        }
    }

    @Override
    public void handlePickItem(PacketPlayInPickItem packetplayinpickitem) {
        PlayerConnectionUtils.ensureRunningOnSameThread(packetplayinpickitem, this, this.player.serverLevel());
        this.player.getInventory().pickSlot(packetplayinpickitem.getSlot());
        this.player.connection.send(new PacketPlayOutSetSlot(-2, 0, this.player.getInventory().selected, this.player.getInventory().getItem(this.player.getInventory().selected)));
        this.player.connection.send(new PacketPlayOutSetSlot(-2, 0, packetplayinpickitem.getSlot(), this.player.getInventory().getItem(packetplayinpickitem.getSlot())));
        this.player.connection.send(new PacketPlayOutHeldItemSlot(this.player.getInventory().selected));
    }

    @Override
    public void handleRenameItem(PacketPlayInItemName packetplayinitemname) {
        PlayerConnectionUtils.ensureRunningOnSameThread(packetplayinitemname, this, this.player.serverLevel());
        Container container = this.player.containerMenu;
        if (container instanceof ContainerAnvil) {
            ContainerAnvil containeranvil = (ContainerAnvil)container;
            if (!containeranvil.stillValid(this.player)) {
                LOGGER.debug("Player {} interacted with invalid menu {}", (Object)this.player, (Object)containeranvil);
                return;
            }
            containeranvil.setItemName(packetplayinitemname.getName());
        }
    }

    @Override
    public void handleSetBeaconPacket(PacketPlayInBeacon packetplayinbeacon) {
        PlayerConnectionUtils.ensureRunningOnSameThread(packetplayinbeacon, this, this.player.serverLevel());
        Container container = this.player.containerMenu;
        if (container instanceof ContainerBeacon) {
            ContainerBeacon containerbeacon = (ContainerBeacon)container;
            if (!this.player.containerMenu.stillValid(this.player)) {
                LOGGER.debug("Player {} interacted with invalid menu {}", (Object)this.player, (Object)this.player.containerMenu);
                return;
            }
            containerbeacon.updateEffects(packetplayinbeacon.primary(), packetplayinbeacon.secondary());
        }
    }

    @Override
    public void handleSetStructureBlock(PacketPlayInStruct packetplayinstruct) {
        PlayerConnectionUtils.ensureRunningOnSameThread(packetplayinstruct, this, this.player.serverLevel());
        if (this.player.canUseGameMasterBlocks()) {
            BlockPosition blockposition = packetplayinstruct.getPos();
            IBlockData iblockdata = this.player.level().getBlockState(blockposition);
            TileEntity tileentity = this.player.level().getBlockEntity(blockposition);
            if (tileentity instanceof TileEntityStructure) {
                TileEntityStructure tileentitystructure = (TileEntityStructure)tileentity;
                tileentitystructure.setMode(packetplayinstruct.getMode());
                tileentitystructure.setStructureName(packetplayinstruct.getName());
                tileentitystructure.setStructurePos(packetplayinstruct.getOffset());
                tileentitystructure.setStructureSize(packetplayinstruct.getSize());
                tileentitystructure.setMirror(packetplayinstruct.getMirror());
                tileentitystructure.setRotation(packetplayinstruct.getRotation());
                tileentitystructure.setMetaData(packetplayinstruct.getData());
                tileentitystructure.setIgnoreEntities(packetplayinstruct.isIgnoreEntities());
                tileentitystructure.setShowAir(packetplayinstruct.isShowAir());
                tileentitystructure.setShowBoundingBox(packetplayinstruct.isShowBoundingBox());
                tileentitystructure.setIntegrity(packetplayinstruct.getIntegrity());
                tileentitystructure.setSeed(packetplayinstruct.getSeed());
                if (tileentitystructure.hasStructureName()) {
                    String s2 = tileentitystructure.getStructureName();
                    if (packetplayinstruct.getUpdateType() == TileEntityStructure.UpdateType.SAVE_AREA) {
                        if (tileentitystructure.saveStructure()) {
                            this.player.displayClientMessage(IChatBaseComponent.translatable("structure_block.save_success", s2), false);
                        } else {
                            this.player.displayClientMessage(IChatBaseComponent.translatable("structure_block.save_failure", s2), false);
                        }
                    } else if (packetplayinstruct.getUpdateType() == TileEntityStructure.UpdateType.LOAD_AREA) {
                        if (!tileentitystructure.isStructureLoadable()) {
                            this.player.displayClientMessage(IChatBaseComponent.translatable("structure_block.load_not_found", s2), false);
                        } else if (tileentitystructure.placeStructureIfSameSize(this.player.serverLevel())) {
                            this.player.displayClientMessage(IChatBaseComponent.translatable("structure_block.load_success", s2), false);
                        } else {
                            this.player.displayClientMessage(IChatBaseComponent.translatable("structure_block.load_prepare", s2), false);
                        }
                    } else if (packetplayinstruct.getUpdateType() == TileEntityStructure.UpdateType.SCAN_AREA) {
                        if (tileentitystructure.detectSize()) {
                            this.player.displayClientMessage(IChatBaseComponent.translatable("structure_block.size_success", s2), false);
                        } else {
                            this.player.displayClientMessage(IChatBaseComponent.translatable("structure_block.size_failure"), false);
                        }
                    }
                } else {
                    this.player.displayClientMessage(IChatBaseComponent.translatable("structure_block.invalid_structure_name", packetplayinstruct.getName()), false);
                }
                tileentitystructure.setChanged();
                this.player.level().sendBlockUpdated(blockposition, iblockdata, iblockdata, 3);
            }
        }
    }

    @Override
    public void handleSetJigsawBlock(PacketPlayInSetJigsaw packetplayinsetjigsaw) {
        PlayerConnectionUtils.ensureRunningOnSameThread(packetplayinsetjigsaw, this, this.player.serverLevel());
        if (this.player.canUseGameMasterBlocks()) {
            BlockPosition blockposition = packetplayinsetjigsaw.getPos();
            IBlockData iblockdata = this.player.level().getBlockState(blockposition);
            TileEntity tileentity = this.player.level().getBlockEntity(blockposition);
            if (tileentity instanceof TileEntityJigsaw) {
                TileEntityJigsaw tileentityjigsaw = (TileEntityJigsaw)tileentity;
                tileentityjigsaw.setName(packetplayinsetjigsaw.getName());
                tileentityjigsaw.setTarget(packetplayinsetjigsaw.getTarget());
                tileentityjigsaw.setPool(ResourceKey.create(Registries.TEMPLATE_POOL, packetplayinsetjigsaw.getPool()));
                tileentityjigsaw.setFinalState(packetplayinsetjigsaw.getFinalState());
                tileentityjigsaw.setJoint(packetplayinsetjigsaw.getJoint());
                tileentityjigsaw.setPlacementPriority(packetplayinsetjigsaw.getPlacementPriority());
                tileentityjigsaw.setSelectionPriority(packetplayinsetjigsaw.getSelectionPriority());
                tileentityjigsaw.setChanged();
                this.player.level().sendBlockUpdated(blockposition, iblockdata, iblockdata, 3);
            }
        }
    }

    @Override
    public void handleJigsawGenerate(PacketPlayInJigsawGenerate packetplayinjigsawgenerate) {
        PlayerConnectionUtils.ensureRunningOnSameThread(packetplayinjigsawgenerate, this, this.player.serverLevel());
        if (this.player.canUseGameMasterBlocks()) {
            BlockPosition blockposition = packetplayinjigsawgenerate.getPos();
            TileEntity tileentity = this.player.level().getBlockEntity(blockposition);
            if (tileentity instanceof TileEntityJigsaw) {
                TileEntityJigsaw tileentityjigsaw = (TileEntityJigsaw)tileentity;
                tileentityjigsaw.generate(this.player.serverLevel(), packetplayinjigsawgenerate.levels(), packetplayinjigsawgenerate.keepJigsaws());
            }
        }
    }

    @Override
    public void handleSelectTrade(PacketPlayInTrSel packetplayintrsel) {
        PlayerConnectionUtils.ensureRunningOnSameThread(packetplayintrsel, this, this.player.serverLevel());
        int i2 = packetplayintrsel.getItem();
        Container container = this.player.containerMenu;
        if (container instanceof ContainerMerchant) {
            ContainerMerchant containermerchant = (ContainerMerchant)container;
            TradeSelectEvent tradeSelectEvent = CraftEventFactory.callTradeSelectEvent(this.player, i2, containermerchant);
            if (tradeSelectEvent.isCancelled()) {
                this.player.getBukkitEntity().updateInventory();
                return;
            }
            if (!containermerchant.stillValid(this.player)) {
                LOGGER.debug("Player {} interacted with invalid menu {}", (Object)this.player, (Object)containermerchant);
                return;
            }
            containermerchant.setSelectionHint(i2);
            containermerchant.tryMoveItems(i2);
        }
    }

    @Override
    public void handleEditBook(PacketPlayInBEdit packetplayinbedit) {
        if (this.lastBookTick + 20 > MinecraftServer.currentTick) {
            this.disconnect(IChatBaseComponent.literal("Book edited too quickly!"));
            return;
        }
        this.lastBookTick = MinecraftServer.currentTick;
        int i2 = packetplayinbedit.slot();
        if (PlayerInventory.isHotbarSlot(i2) || i2 == 40) {
            ArrayList list = Lists.newArrayList();
            Optional<String> optional = packetplayinbedit.title();
            Objects.requireNonNull(list);
            optional.ifPresent(list::add);
            Stream stream = packetplayinbedit.pages().stream().limit(100L);
            Objects.requireNonNull(list);
            stream.forEach(list::add);
            Consumer<List> consumer = optional.isPresent() ? list1 -> this.signBook((FilteredText)list1.get(0), list1.subList(1, list1.size()), i2) : list1 -> this.updateBookContents((List<FilteredText>)list1, i2);
            this.filterTextPacket(list).thenAcceptAsync(consumer, (Executor)this.server);
        }
    }

    private void updateBookContents(List<FilteredText> list, int i2) {
        ItemStack handItem = this.player.getInventory().getItem(i2);
        ItemStack itemstack = handItem.copy();
        if (itemstack.is(Items.WRITABLE_BOOK)) {
            List<Filterable<String>> list1 = list.stream().map(this::filterableFromOutgoing).toList();
            itemstack.set(DataComponents.WRITABLE_BOOK_CONTENT, new WritableBookContent(list1));
            CraftEventFactory.handleEditBookEvent(this.player, i2, handItem, itemstack);
        }
    }

    private void signBook(FilteredText filteredtext, List<FilteredText> list, int i2) {
        ItemStack itemstack = this.player.getInventory().getItem(i2);
        if (itemstack.is(Items.WRITABLE_BOOK)) {
            ItemStack itemstack1 = itemstack.transmuteCopy(Items.WRITTEN_BOOK);
            itemstack1.remove(DataComponents.WRITABLE_BOOK_CONTENT);
            List<Filterable<IChatBaseComponent>> list1 = list.stream().map(filteredtext1 -> this.filterableFromOutgoing((FilteredText)filteredtext1).map(IChatBaseComponent::literal)).toList();
            itemstack1.set(DataComponents.WRITTEN_BOOK_CONTENT, new WrittenBookContent(this.filterableFromOutgoing(filteredtext), this.player.getName().getString(), 0, list1, true));
            CraftEventFactory.handleEditBookEvent(this.player, i2, itemstack, itemstack1);
            this.player.getInventory().setItem(i2, itemstack);
        }
    }

    private Filterable<String> filterableFromOutgoing(FilteredText filteredtext) {
        return this.player.isTextFilteringEnabled() ? Filterable.passThrough(filteredtext.filteredOrEmpty()) : Filterable.from(filteredtext);
    }

    @Override
    public void handleEntityTagQuery(PacketPlayInEntityNBTQuery packetplayinentitynbtquery) {
        net.minecraft.world.entity.Entity entity;
        PlayerConnectionUtils.ensureRunningOnSameThread(packetplayinentitynbtquery, this, this.player.serverLevel());
        if (this.player.hasPermissions(2) && (entity = this.player.level().getEntity(packetplayinentitynbtquery.getEntityId())) != null) {
            NBTTagCompound nbttagcompound = entity.saveWithoutId(new NBTTagCompound());
            this.player.connection.send(new PacketPlayOutNBTQuery(packetplayinentitynbtquery.getTransactionId(), nbttagcompound));
        }
    }

    @Override
    public void handleContainerSlotStateChanged(ServerboundContainerSlotStateChangedPacket serverboundcontainerslotstatechangedpacket) {
        CrafterMenu craftermenu;
        IInventory iinventory;
        Container container;
        PlayerConnectionUtils.ensureRunningOnSameThread(serverboundcontainerslotstatechangedpacket, this, this.player.serverLevel());
        if (!this.player.isSpectator() && serverboundcontainerslotstatechangedpacket.containerId() == this.player.containerMenu.containerId && (container = this.player.containerMenu) instanceof CrafterMenu && (iinventory = (craftermenu = (CrafterMenu)container).getContainer()) instanceof CrafterBlockEntity) {
            CrafterBlockEntity crafterblockentity = (CrafterBlockEntity)iinventory;
            crafterblockentity.setSlotState(serverboundcontainerslotstatechangedpacket.slotId(), serverboundcontainerslotstatechangedpacket.newState());
        }
    }

    @Override
    public void handleBlockEntityTagQuery(PacketPlayInTileNBTQuery packetplayintilenbtquery) {
        PlayerConnectionUtils.ensureRunningOnSameThread(packetplayintilenbtquery, this, this.player.serverLevel());
        if (this.player.hasPermissions(2)) {
            TileEntity tileentity = this.player.level().getBlockEntity(packetplayintilenbtquery.getPos());
            NBTTagCompound nbttagcompound = tileentity != null ? tileentity.saveWithoutMetadata(this.player.registryAccess()) : null;
            this.player.connection.send(new PacketPlayOutNBTQuery(packetplayintilenbtquery.getTransactionId(), nbttagcompound));
        }
    }

    @Override
    public void handleMovePlayer(PacketPlayInFlying packetplayinflying) {
        PlayerConnectionUtils.ensureRunningOnSameThread(packetplayinflying, this, this.player.serverLevel());
        if (PlayerConnection.containsInvalidValues(packetplayinflying.getX(0.0), packetplayinflying.getY(0.0), packetplayinflying.getZ(0.0), packetplayinflying.getYRot(0.0f), packetplayinflying.getXRot(0.0f))) {
            this.disconnect(IChatBaseComponent.translatable("multiplayer.disconnect.invalid_player_movement"));
        } else {
            WorldServer worldserver = this.player.serverLevel();
            if (!this.player.wonGame && !this.player.isImmobile()) {
                if (this.tickCount == 0) {
                    this.resetPosition();
                }
                if (!this.updateAwaitingTeleport()) {
                    double d0 = PlayerConnection.clampHorizontal(packetplayinflying.getX(this.player.getX()));
                    double d1 = PlayerConnection.clampVertical(packetplayinflying.getY(this.player.getY()));
                    double d2 = PlayerConnection.clampHorizontal(packetplayinflying.getZ(this.player.getZ()));
                    float f2 = MathHelper.wrapDegrees(packetplayinflying.getYRot(this.player.getYRot()));
                    float f1 = MathHelper.wrapDegrees(packetplayinflying.getXRot(this.player.getXRot()));
                    if (this.player.isPassenger()) {
                        this.player.absMoveTo(this.player.getX(), this.player.getY(), this.player.getZ(), f2, f1);
                        this.player.serverLevel().getChunkSource().move(this.player);
                        this.allowedPlayerTicks = 20;
                    } else {
                        double prevX = this.player.getX();
                        double prevY = this.player.getY();
                        double prevZ = this.player.getZ();
                        float prevYaw = this.player.getYRot();
                        float prevPitch = this.player.getXRot();
                        double d3 = this.player.getX();
                        double d4 = this.player.getY();
                        double d5 = this.player.getZ();
                        double d6 = d0 - this.firstGoodX;
                        double d7 = d1 - this.firstGoodY;
                        double d8 = d2 - this.firstGoodZ;
                        double d9 = this.player.getDeltaMovement().lengthSqr();
                        double d10 = d6 * d6 + d7 * d7 + d8 * d8;
                        if (this.player.isSleeping()) {
                            if (d10 > 1.0) {
                                this.teleport(this.player.getX(), this.player.getY(), this.player.getZ(), f2, f1);
                            }
                        } else {
                            boolean flag1;
                            boolean flag = this.player.isFallFlying();
                            if (worldserver.tickRateManager().runsNormally()) {
                                ++this.receivedMovePacketCount;
                                int i2 = this.receivedMovePacketCount - this.knownMovePacketCount;
                                this.allowedPlayerTicks = (int)((long)this.allowedPlayerTicks + (System.currentTimeMillis() / 50L - (long)this.lastTick));
                                this.allowedPlayerTicks = Math.max(this.allowedPlayerTicks, 1);
                                this.lastTick = (int)(System.currentTimeMillis() / 50L);
                                if (i2 > Math.max(this.allowedPlayerTicks, 5)) {
                                    LOGGER.debug("{} is sending move packets too frequently ({} packets since last tick)", (Object)this.player.getName().getString(), (Object)i2);
                                    i2 = 1;
                                }
                                this.allowedPlayerTicks = packetplayinflying.hasRot || d10 > 0.0 ? --this.allowedPlayerTicks : 20;
                                double speed = this.player.getAbilities().flying ? (double)(this.player.getAbilities().flyingSpeed * 20.0f) : (double)(this.player.getAbilities().walkingSpeed * 10.0f);
                                if (!(this.player.isChangingDimension() || this.player.level().getGameRules().getBoolean(GameRules.RULE_DISABLE_ELYTRA_MOVEMENT_CHECK) && flag)) {
                                    float f22;
                                    float f3 = f22 = flag ? 300.0f : 100.0f;
                                    if (d10 - d9 > Math.max((double)f22, Math.pow(SpigotConfig.movedTooQuicklyMultiplier * (double)i2 * speed, 2.0)) && !this.isSingleplayerOwner()) {
                                        LOGGER.warn("{} moved too quickly! {},{},{}", new Object[]{this.player.getName().getString(), d6, d7, d8});
                                        this.teleport(this.player.getX(), this.player.getY(), this.player.getZ(), this.player.getYRot(), this.player.getXRot());
                                        return;
                                    }
                                }
                            }
                            AxisAlignedBB axisalignedbb = this.player.getBoundingBox();
                            d6 = d0 - this.lastGoodX;
                            d7 = d1 - this.lastGoodY;
                            d8 = d2 - this.lastGoodZ;
                            boolean bl = flag1 = d7 > 0.0;
                            if (this.player.onGround() && !packetplayinflying.isOnGround() && flag1) {
                                this.player.jumpFromGround();
                            }
                            boolean flag2 = this.player.verticalCollisionBelow;
                            this.player.move(EnumMoveType.PLAYER, new Vec3D(d6, d7, d8));
                            this.player.onGround = packetplayinflying.isOnGround();
                            double d11 = d7;
                            d6 = d0 - this.player.getX();
                            d7 = d1 - this.player.getY();
                            if (d7 > -0.5 || d7 < 0.5) {
                                d7 = 0.0;
                            }
                            d8 = d2 - this.player.getZ();
                            d10 = d6 * d6 + d7 * d7 + d8 * d8;
                            boolean flag3 = false;
                            if (!this.player.isChangingDimension() && d10 > SpigotConfig.movedWronglyThreshold && !this.player.isSleeping() && !this.player.gameMode.isCreative() && this.player.gameMode.getGameModeForPlayer() != EnumGamemode.SPECTATOR) {
                                flag3 = true;
                                LOGGER.warn("{} moved wrongly!", (Object)this.player.getName().getString());
                            }
                            if (!this.player.noPhysics && !this.player.isSleeping() && (flag3 && worldserver.noCollision(this.player, axisalignedbb) || this.isPlayerCollidingWithAnythingNew(worldserver, axisalignedbb, d0, d1, d2))) {
                                this.internalTeleport(d3, d4, d5, f2, f1, Collections.emptySet());
                                this.player.doCheckFallDamage(this.player.getX() - d3, this.player.getY() - d4, this.player.getZ() - d5, packetplayinflying.isOnGround());
                            } else {
                                this.player.absMoveTo(prevX, prevY, prevZ, prevYaw, prevPitch);
                                CraftPlayer player = this.getCraftPlayer();
                                if (!this.hasMoved) {
                                    this.lastPosX = prevX;
                                    this.lastPosY = prevY;
                                    this.lastPosZ = prevZ;
                                    this.lastYaw = prevYaw;
                                    this.lastPitch = prevPitch;
                                    this.hasMoved = true;
                                }
                                Location from = new Location(player.getWorld(), this.lastPosX, this.lastPosY, this.lastPosZ, this.lastYaw, this.lastPitch);
                                Location to = player.getLocation().clone();
                                if (packetplayinflying.hasPos) {
                                    to.setX(packetplayinflying.x);
                                    to.setY(packetplayinflying.y);
                                    to.setZ(packetplayinflying.z);
                                }
                                if (packetplayinflying.hasRot) {
                                    to.setYaw(packetplayinflying.yRot);
                                    to.setPitch(packetplayinflying.xRot);
                                }
                                double delta = Math.pow(this.lastPosX - to.getX(), 2.0) + Math.pow(this.lastPosY - to.getY(), 2.0) + Math.pow(this.lastPosZ - to.getZ(), 2.0);
                                float deltaAngle = Math.abs(this.lastYaw - to.getYaw()) + Math.abs(this.lastPitch - to.getPitch());
                                if ((delta > 0.00390625 || deltaAngle > 10.0f) && !this.player.isImmobile()) {
                                    this.lastPosX = to.getX();
                                    this.lastPosY = to.getY();
                                    this.lastPosZ = to.getZ();
                                    this.lastYaw = to.getYaw();
                                    this.lastPitch = to.getPitch();
                                    Location oldTo = to.clone();
                                    PlayerMoveEvent event = new PlayerMoveEvent((Player)player, from, to);
                                    this.cserver.getPluginManager().callEvent((Event)event);
                                    if (event.isCancelled()) {
                                        this.teleport(from);
                                        return;
                                    }
                                    if (!oldTo.equals((Object)event.getTo()) && !event.isCancelled()) {
                                        this.player.getBukkitEntity().teleport(event.getTo(), PlayerTeleportEvent.TeleportCause.PLUGIN);
                                        return;
                                    }
                                    if (!from.equals((Object)this.getCraftPlayer().getLocation()) && this.justTeleported) {
                                        this.justTeleported = false;
                                        return;
                                    }
                                }
                                this.player.absMoveTo(d0, d1, d2, f2, f1);
                                boolean flag4 = this.player.isAutoSpinAttack();
                                this.clientIsFloating = d11 >= -0.03125 && !flag2 && this.player.gameMode.getGameModeForPlayer() != EnumGamemode.SPECTATOR && !this.server.isFlightAllowed() && !this.player.getAbilities().mayfly && !this.player.hasEffect(MobEffects.LEVITATION) && !flag && !flag4 && this.noBlocksAround(this.player);
                                this.player.serverLevel().getChunkSource().move(this.player);
                                Vec3D vec3d = new Vec3D(this.player.getX() - d3, this.player.getY() - d4, this.player.getZ() - d5);
                                this.player.setOnGroundWithMovement(packetplayinflying.isOnGround(), vec3d);
                                this.player.doCheckFallDamage(this.player.getX() - d3, this.player.getY() - d4, this.player.getZ() - d5, packetplayinflying.isOnGround());
                                this.player.setKnownMovement(vec3d);
                                if (flag1) {
                                    this.player.resetFallDistance();
                                }
                                if (packetplayinflying.isOnGround() || this.player.hasLandedInLiquid() || this.player.onClimbable() || this.player.isSpectator() || flag || flag4) {
                                    this.player.tryResetCurrentImpulseContext();
                                }
                                this.player.checkMovementStatistics(this.player.getX() - d3, this.player.getY() - d4, this.player.getZ() - d5);
                                this.lastGoodX = this.player.getX();
                                this.lastGoodY = this.player.getY();
                                this.lastGoodZ = this.player.getZ();
                            }
                        }
                    }
                }
            }
        }
    }

    private boolean updateAwaitingTeleport() {
        if (this.awaitingPositionFromClient != null) {
            if (this.tickCount - this.awaitingTeleportTime > 20) {
                this.awaitingTeleportTime = this.tickCount;
                this.teleport(this.awaitingPositionFromClient.x, this.awaitingPositionFromClient.y, this.awaitingPositionFromClient.z, this.player.getYRot(), this.player.getXRot());
            }
            this.allowedPlayerTicks = 20;
            return true;
        }
        this.awaitingTeleportTime = this.tickCount;
        return false;
    }

    private boolean isPlayerCollidingWithAnythingNew(IWorldReader iworldreader, AxisAlignedBB axisalignedbb, double d0, double d1, double d2) {
        VoxelShape voxelshape1;
        AxisAlignedBB axisalignedbb1 = this.player.getBoundingBox().move(d0 - this.player.getX(), d1 - this.player.getY(), d2 - this.player.getZ());
        Iterable<VoxelShape> iterable = iworldreader.getCollisions(this.player, axisalignedbb1.deflate(1.0E-5f));
        VoxelShape voxelshape = VoxelShapes.create(axisalignedbb.deflate(1.0E-5f));
        Iterator<VoxelShape> iterator = iterable.iterator();
        do {
            if (iterator.hasNext()) continue;
            return false;
        } while (VoxelShapes.joinIsNotEmpty(voxelshape1 = iterator.next(), voxelshape, OperatorBoolean.AND));
        return true;
    }

    public void teleport(double d0, double d1, double d2, float f2, float f1) {
        this.teleport(d0, d1, d2, f2, f1, PlayerTeleportEvent.TeleportCause.UNKNOWN);
    }

    public boolean teleport(double d0, double d1, double d2, float f2, float f1, PlayerTeleportEvent.TeleportCause cause) {
        return this.teleport(d0, d1, d2, f2, f1, Collections.emptySet(), cause);
    }

    public void teleport(double d0, double d1, double d2, float f2, float f1, Set<RelativeMovement> set) {
        this.teleport(d0, d1, d2, f2, f1, set, PlayerTeleportEvent.TeleportCause.UNKNOWN);
    }

    public boolean teleport(double d0, double d1, double d2, float f2, float f1, Set<RelativeMovement> set, PlayerTeleportEvent.TeleportCause cause) {
        CraftPlayer player = this.getCraftPlayer();
        Location from = player.getLocation();
        double x2 = d0;
        double y2 = d1;
        double z2 = d2;
        float yaw = f2;
        float pitch = f1;
        Location to = new Location(this.getCraftPlayer().getWorld(), x2, y2, z2, yaw, pitch);
        if (from.equals((Object)to)) {
            this.internalTeleport(d0, d1, d2, f2, f1, set);
            return true;
        }
        PlayerTeleportEvent event = new PlayerTeleportEvent((Player)player, from.clone(), to.clone(), cause);
        this.cserver.getPluginManager().callEvent((Event)event);
        if (event.isCancelled() || !to.equals((Object)event.getTo())) {
            set = Collections.emptySet();
            to = event.isCancelled() ? event.getFrom() : event.getTo();
            d0 = to.getX();
            d1 = to.getY();
            d2 = to.getZ();
            f2 = to.getYaw();
            f1 = to.getPitch();
        }
        this.internalTeleport(d0, d1, d2, f2, f1, set);
        return !event.isCancelled();
    }

    public void teleport(Location dest) {
        this.internalTeleport(dest.getX(), dest.getY(), dest.getZ(), dest.getYaw(), dest.getPitch(), Collections.emptySet());
    }

    private void internalTeleport(double d0, double d1, double d2, float f2, float f1, Set<RelativeMovement> set) {
        if (Float.isNaN(f2)) {
            f2 = 0.0f;
        }
        if (Float.isNaN(f1)) {
            f1 = 0.0f;
        }
        this.justTeleported = true;
        double d3 = set.contains((Object)RelativeMovement.X) ? this.player.getX() : 0.0;
        double d4 = set.contains((Object)RelativeMovement.Y) ? this.player.getY() : 0.0;
        double d5 = set.contains((Object)RelativeMovement.Z) ? this.player.getZ() : 0.0;
        float f22 = set.contains((Object)RelativeMovement.Y_ROT) ? this.player.getYRot() : 0.0f;
        float f3 = set.contains((Object)RelativeMovement.X_ROT) ? this.player.getXRot() : 0.0f;
        this.awaitingPositionFromClient = new Vec3D(d0, d1, d2);
        if (++this.awaitingTeleport == Integer.MAX_VALUE) {
            this.awaitingTeleport = 0;
        }
        this.lastPosX = this.awaitingPositionFromClient.x;
        this.lastPosY = this.awaitingPositionFromClient.y;
        this.lastPosZ = this.awaitingPositionFromClient.z;
        this.lastYaw = f2;
        this.lastPitch = f1;
        this.awaitingTeleportTime = this.tickCount;
        this.player.absMoveTo(d0, d1, d2, f2, f1);
        this.player.connection.send(new PacketPlayOutPosition(d0 - d3, d1 - d4, d2 - d5, f2 - f22, f1 - f3, set, this.awaitingTeleport));
    }

    @Override
    public void handlePlayerAction(PacketPlayInBlockDig packetplayinblockdig) {
        PlayerConnectionUtils.ensureRunningOnSameThread(packetplayinblockdig, this, this.player.serverLevel());
        if (this.player.isImmobile()) {
            return;
        }
        BlockPosition blockposition = packetplayinblockdig.getPos();
        this.player.resetLastActionTime();
        PacketPlayInBlockDig.EnumPlayerDigType packetplayinblockdig_enumplayerdigtype = packetplayinblockdig.getAction();
        switch (packetplayinblockdig_enumplayerdigtype) {
            case SWAP_ITEM_WITH_OFFHAND: {
                if (!this.player.isSpectator()) {
                    ItemStack itemstack = this.player.getItemInHand(EnumHand.OFF_HAND);
                    CraftItemStack mainHand = CraftItemStack.asCraftMirror(itemstack);
                    CraftItemStack offHand = CraftItemStack.asCraftMirror(this.player.getItemInHand(EnumHand.MAIN_HAND));
                    PlayerSwapHandItemsEvent swapItemsEvent = new PlayerSwapHandItemsEvent((Player)this.getCraftPlayer(), (org.bukkit.inventory.ItemStack)mainHand.clone(), (org.bukkit.inventory.ItemStack)offHand.clone());
                    this.cserver.getPluginManager().callEvent((Event)swapItemsEvent);
                    if (swapItemsEvent.isCancelled()) {
                        return;
                    }
                    if (swapItemsEvent.getOffHandItem().equals((Object)offHand)) {
                        this.player.setItemInHand(EnumHand.OFF_HAND, this.player.getItemInHand(EnumHand.MAIN_HAND));
                    } else {
                        this.player.setItemInHand(EnumHand.OFF_HAND, CraftItemStack.asNMSCopy(swapItemsEvent.getOffHandItem()));
                    }
                    if (swapItemsEvent.getMainHandItem().equals((Object)mainHand)) {
                        this.player.setItemInHand(EnumHand.MAIN_HAND, itemstack);
                    } else {
                        this.player.setItemInHand(EnumHand.MAIN_HAND, CraftItemStack.asNMSCopy(swapItemsEvent.getMainHandItem()));
                    }
                    this.player.stopUsingItem();
                }
                return;
            }
            case DROP_ITEM: {
                if (!this.player.isSpectator()) {
                    if (this.lastDropTick != MinecraftServer.currentTick) {
                        this.dropCount = 0;
                        this.lastDropTick = MinecraftServer.currentTick;
                    } else {
                        ++this.dropCount;
                        if (this.dropCount >= 20) {
                            LOGGER.warn(this.player.getScoreboardName() + " dropped their items too quickly!");
                            this.disconnect(IChatBaseComponent.literal("You dropped your items too quickly (Hacking?)"));
                            return;
                        }
                    }
                    this.player.drop(false);
                }
                return;
            }
            case DROP_ALL_ITEMS: {
                if (!this.player.isSpectator()) {
                    this.player.drop(true);
                }
                return;
            }
            case RELEASE_USE_ITEM: {
                this.player.releaseUsingItem();
                return;
            }
            case START_DESTROY_BLOCK: 
            case ABORT_DESTROY_BLOCK: 
            case STOP_DESTROY_BLOCK: {
                this.player.gameMode.handleBlockBreakAction(blockposition, packetplayinblockdig_enumplayerdigtype, packetplayinblockdig.getDirection(), this.player.level().getMaxBuildHeight(), packetplayinblockdig.getSequence());
                this.player.connection.ackBlockChangesUpTo(packetplayinblockdig.getSequence());
                return;
            }
        }
        throw new IllegalArgumentException("Invalid player action");
    }

    private static boolean wasBlockPlacementAttempt(EntityPlayer entityplayer, ItemStack itemstack) {
        if (itemstack.isEmpty()) {
            return false;
        }
        Item item = itemstack.getItem();
        return (item instanceof ItemBlock || item instanceof ItemBucket) && !entityplayer.getCooldowns().isOnCooldown(item);
    }

    private boolean checkLimit(long timestamp) {
        if (this.lastLimitedPacket != -1L && timestamp - this.lastLimitedPacket < 30L && this.limitedPackets++ >= 4) {
            return false;
        }
        if (this.lastLimitedPacket == -1L || timestamp - this.lastLimitedPacket >= 30L) {
            this.lastLimitedPacket = timestamp;
            this.limitedPackets = 0;
            return true;
        }
        return true;
    }

    @Override
    public void handleUseItemOn(PacketPlayInUseItem packetplayinuseitem) {
        PlayerConnectionUtils.ensureRunningOnSameThread(packetplayinuseitem, this, this.player.serverLevel());
        if (this.player.isImmobile()) {
            return;
        }
        if (!this.checkLimit(packetplayinuseitem.timestamp)) {
            return;
        }
        this.player.connection.ackBlockChangesUpTo(packetplayinuseitem.getSequence());
        WorldServer worldserver = this.player.serverLevel();
        EnumHand enumhand = packetplayinuseitem.getHand();
        ItemStack itemstack = this.player.getItemInHand(enumhand);
        if (itemstack.isItemEnabled(worldserver.enabledFeatures())) {
            MovingObjectPositionBlock movingobjectpositionblock = packetplayinuseitem.getHitResult();
            Vec3D vec3d = movingobjectpositionblock.getLocation();
            BlockPosition blockposition = movingobjectpositionblock.getBlockPos();
            if (this.player.canInteractWithBlock(blockposition, 1.0)) {
                Vec3D vec3d1 = vec3d.subtract(Vec3D.atCenterOf(blockposition));
                double d0 = 1.0000001;
                if (Math.abs(vec3d1.x()) < 1.0000001 && Math.abs(vec3d1.y()) < 1.0000001 && Math.abs(vec3d1.z()) < 1.0000001) {
                    EnumDirection enumdirection = movingobjectpositionblock.getDirection();
                    this.player.resetLastActionTime();
                    int i2 = this.player.level().getMaxBuildHeight();
                    if (blockposition.getY() < i2) {
                        if (this.awaitingPositionFromClient == null && worldserver.mayInteract(this.player, blockposition)) {
                            this.player.stopUsingItem();
                            EnumInteractionResult enuminteractionresult = this.player.gameMode.useItemOn(this.player, worldserver, itemstack, enumhand, movingobjectpositionblock);
                            if (enuminteractionresult.consumesAction()) {
                                CriterionTriggers.ANY_BLOCK_USE.trigger(this.player, movingobjectpositionblock.getBlockPos(), itemstack.copy());
                            }
                            if (enumdirection == EnumDirection.UP && !enuminteractionresult.consumesAction() && blockposition.getY() >= i2 - 1 && PlayerConnection.wasBlockPlacementAttempt(this.player, itemstack)) {
                                IChatMutableComponent ichatmutablecomponent = IChatBaseComponent.translatable("build.tooHigh", i2 - 1).withStyle(EnumChatFormat.RED);
                                this.player.sendSystemMessage(ichatmutablecomponent, true);
                            } else if (enuminteractionresult.shouldSwing()) {
                                this.player.swing(enumhand, true);
                            }
                        }
                    } else {
                        IChatMutableComponent ichatmutablecomponent1 = IChatBaseComponent.translatable("build.tooHigh", i2 - 1).withStyle(EnumChatFormat.RED);
                        this.player.sendSystemMessage(ichatmutablecomponent1, true);
                    }
                    this.player.connection.send(new PacketPlayOutBlockChange(worldserver, blockposition));
                    this.player.connection.send(new PacketPlayOutBlockChange(worldserver, blockposition.relative(enumdirection)));
                } else {
                    LOGGER.warn("Rejecting UseItemOnPacket from {}: Location {} too far away from hit block {}.", new Object[]{this.player.getGameProfile().getName(), vec3d, blockposition});
                }
            }
        }
    }

    @Override
    public void handleUseItem(PacketPlayInBlockPlace packetplayinblockplace) {
        PlayerConnectionUtils.ensureRunningOnSameThread(packetplayinblockplace, this, this.player.serverLevel());
        if (this.player.isImmobile()) {
            return;
        }
        if (!this.checkLimit(packetplayinblockplace.timestamp)) {
            return;
        }
        this.ackBlockChangesUpTo(packetplayinblockplace.getSequence());
        WorldServer worldserver = this.player.serverLevel();
        EnumHand enumhand = packetplayinblockplace.getHand();
        ItemStack itemstack = this.player.getItemInHand(enumhand);
        this.player.resetLastActionTime();
        if (!itemstack.isEmpty() && itemstack.isItemEnabled(worldserver.enabledFeatures())) {
            boolean cancelled;
            float f2 = MathHelper.wrapDegrees(packetplayinblockplace.getYRot());
            float f1 = MathHelper.wrapDegrees(packetplayinblockplace.getXRot());
            if (f1 != this.player.getXRot() || f2 != this.player.getYRot()) {
                this.player.absRotateTo(f2, f1);
            }
            double d0 = this.player.getX();
            double d1 = this.player.getY() + (double)this.player.getEyeHeight();
            double d2 = this.player.getZ();
            Vec3D vec3d = new Vec3D(d0, d1, d2);
            float f3 = MathHelper.cos(-f2 * ((float)Math.PI / 180) - (float)Math.PI);
            float f4 = MathHelper.sin(-f2 * ((float)Math.PI / 180) - (float)Math.PI);
            float f5 = -MathHelper.cos(-f1 * ((float)Math.PI / 180));
            float f6 = MathHelper.sin(-f1 * ((float)Math.PI / 180));
            float f7 = f4 * f5;
            float f8 = f3 * f5;
            double d3 = this.player.blockInteractionRange();
            Vec3D vec3d1 = vec3d.add((double)f7 * d3, (double)f6 * d3, (double)f8 * d3);
            MovingObjectPositionBlock movingobjectposition = this.player.level().clip(new RayTrace(vec3d, vec3d1, RayTrace.BlockCollisionOption.OUTLINE, RayTrace.FluidCollisionOption.NONE, this.player));
            if (movingobjectposition == null || ((MovingObjectPosition)movingobjectposition).getType() != MovingObjectPosition.EnumMovingObjectType.BLOCK) {
                PlayerInteractEvent event = CraftEventFactory.callPlayerInteractEvent(this.player, Action.RIGHT_CLICK_AIR, itemstack, enumhand);
                cancelled = event.useItemInHand() == Event.Result.DENY;
            } else {
                PlayerInteractEvent event;
                MovingObjectPositionBlock movingobjectpositionblock = movingobjectposition;
                cancelled = this.player.gameMode.firedInteract && this.player.gameMode.interactPosition.equals(movingobjectpositionblock.getBlockPos()) && this.player.gameMode.interactHand == enumhand && ItemStack.isSameItemSameComponents(this.player.gameMode.interactItemStack, itemstack) ? this.player.gameMode.interactResult : (event = CraftEventFactory.callPlayerInteractEvent(this.player, Action.RIGHT_CLICK_BLOCK, movingobjectpositionblock.getBlockPos(), movingobjectpositionblock.getDirection(), itemstack, true, enumhand, movingobjectpositionblock.getLocation())).useItemInHand() == Event.Result.DENY;
                this.player.gameMode.firedInteract = false;
            }
            if (cancelled) {
                this.player.getBukkitEntity().updateInventory();
                return;
            }
            itemstack = this.player.getItemInHand(enumhand);
            if (itemstack.isEmpty()) {
                return;
            }
            EnumInteractionResult enuminteractionresult = this.player.gameMode.useItem(this.player, worldserver, itemstack, enumhand);
            if (enuminteractionresult.shouldSwing()) {
                this.player.swing(enumhand, true);
            }
        }
    }

    @Override
    public void handleTeleportToEntityPacket(PacketPlayInSpectate packetplayinspectate) {
        PlayerConnectionUtils.ensureRunningOnSameThread(packetplayinspectate, this, this.player.serverLevel());
        if (this.player.isSpectator()) {
            for (WorldServer worldserver : this.server.getAllLevels()) {
                net.minecraft.world.entity.Entity entity = packetplayinspectate.getEntity(worldserver);
                if (entity == null) continue;
                this.player.teleportTo(worldserver, entity.getX(), entity.getY(), entity.getZ(), entity.getYRot(), entity.getXRot(), PlayerTeleportEvent.TeleportCause.SPECTATE);
                return;
            }
        }
    }

    @Override
    public void handlePaddleBoat(PacketPlayInBoatMove packetplayinboatmove) {
        PlayerConnectionUtils.ensureRunningOnSameThread(packetplayinboatmove, this, this.player.serverLevel());
        net.minecraft.world.entity.Entity entity = this.player.getControlledVehicle();
        if (entity instanceof EntityBoat) {
            EntityBoat entityboat = (EntityBoat)entity;
            entityboat.setPaddleState(packetplayinboatmove.getLeft(), packetplayinboatmove.getRight());
        }
    }

    @Override
    public void onDisconnect(DisconnectionDetails disconnectiondetails) {
        if (this.processedDisconnect) {
            return;
        }
        this.processedDisconnect = true;
        LOGGER.info("{} lost connection: {}", (Object)this.player.getName().getString(), (Object)disconnectiondetails.reason().getString());
        this.removePlayerFromWorld();
        super.onDisconnect(disconnectiondetails);
    }

    private void removePlayerFromWorld() {
        this.chatMessageChain.close();
        this.player.disconnect();
        String quitMessage = this.server.getPlayerList().remove(this.player);
        if (quitMessage != null && quitMessage.length() > 0) {
            this.server.getPlayerList().broadcastMessage(CraftChatMessage.fromString(quitMessage));
        }
        this.player.getTextFilter().leave();
    }

    public void ackBlockChangesUpTo(int i2) {
        if (i2 < 0) {
            throw new IllegalArgumentException("Expected packet sequence nr >= 0");
        }
        this.ackBlockChangesUpTo = Math.max(i2, this.ackBlockChangesUpTo);
    }

    @Override
    public void handleSetCarriedItem(PacketPlayInHeldItemSlot packetplayinhelditemslot) {
        PlayerConnectionUtils.ensureRunningOnSameThread(packetplayinhelditemslot, this, this.player.serverLevel());
        if (this.player.isImmobile()) {
            return;
        }
        if (packetplayinhelditemslot.getSlot() >= 0 && packetplayinhelditemslot.getSlot() < PlayerInventory.getSelectionSize()) {
            PlayerItemHeldEvent event = new PlayerItemHeldEvent((Player)this.getCraftPlayer(), this.player.getInventory().selected, packetplayinhelditemslot.getSlot());
            this.cserver.getPluginManager().callEvent((Event)event);
            if (event.isCancelled()) {
                this.send(new PacketPlayOutHeldItemSlot(this.player.getInventory().selected));
                this.player.resetLastActionTime();
                return;
            }
            if (this.player.getInventory().selected != packetplayinhelditemslot.getSlot() && this.player.getUsedItemHand() == EnumHand.MAIN_HAND) {
                this.player.stopUsingItem();
            }
            this.player.getInventory().selected = packetplayinhelditemslot.getSlot();
            this.player.resetLastActionTime();
        } else {
            LOGGER.warn("{} tried to set an invalid carried item", (Object)this.player.getName().getString());
            this.disconnect(IChatBaseComponent.literal("Invalid hotbar selection (Hacking?)"));
        }
    }

    @Override
    public void handleChat(PacketPlayInChat packetplayinchat) {
        if (this.server.isStopped()) {
            return;
        }
        Optional<LastSeenMessages> optional = this.unpackAndApplyLastSeen(packetplayinchat.lastSeenMessages());
        if (!optional.isEmpty()) {
            this.tryHandleChat(packetplayinchat.message(), () -> {
                PlayerChatMessage playerchatmessage;
                try {
                    playerchatmessage = this.getSignedMessage(packetplayinchat, (LastSeenMessages)optional.get());
                }
                catch (SignedMessageChain.a signedmessagechain_a) {
                    this.handleMessageDecodeFailure(signedmessagechain_a);
                    return;
                }
                CompletionStage completablefuture = this.filterTextPacket(playerchatmessage.signedContent()).thenApplyAsync(Function.identity(), (Executor)this.server.chatExecutor);
                IChatBaseComponent ichatbasecomponent = this.server.getChatDecorator().decorate(this.player, playerchatmessage.decoratedContent());
                this.chatMessageChain.append(completablefuture, filteredtext -> {
                    PlayerChatMessage playerchatmessage1 = playerchatmessage.withUnsignedContent(ichatbasecomponent).filter(filteredtext.mask());
                    this.broadcastChatMessage(playerchatmessage1);
                });
            }, false);
        }
    }

    @Override
    public void handleChatCommand(ServerboundChatCommandPacket serverboundchatcommandpacket) {
        this.tryHandleChat(serverboundchatcommandpacket.command(), () -> {
            if (this.player.hasDisconnected()) {
                return;
            }
            this.performUnsignedChatCommand(serverboundchatcommandpacket.command());
            this.detectRateSpam("/" + serverboundchatcommandpacket.command());
        }, true);
    }

    private void performUnsignedChatCommand(String s2) {
        String command = "/" + s2;
        LOGGER.info(this.player.getScoreboardName() + " issued server command: " + command);
        PlayerCommandPreprocessEvent event = new PlayerCommandPreprocessEvent((Player)this.getCraftPlayer(), command, (Set)new LazyPlayerSet(this.server));
        this.cserver.getPluginManager().callEvent((Event)event);
        if (event.isCancelled()) {
            return;
        }
        s2 = event.getMessage().substring(1);
        ParseResults<CommandListenerWrapper> parseresults = this.parseCommand(s2);
        if (this.server.enforceSecureProfile() && SignableCommand.hasSignableArguments(parseresults)) {
            LOGGER.error("Received unsigned command packet from {}, but the command requires signable arguments: {}", (Object)this.player.getGameProfile().getName(), (Object)s2);
            this.player.sendSystemMessage(INVALID_COMMAND_SIGNATURE);
        } else {
            this.server.getCommands().performCommand(parseresults, s2);
        }
    }

    @Override
    public void handleSignedChatCommand(ServerboundChatCommandSignedPacket serverboundchatcommandsignedpacket) {
        Optional<LastSeenMessages> optional = this.unpackAndApplyLastSeen(serverboundchatcommandsignedpacket.lastSeenMessages());
        if (!optional.isEmpty()) {
            this.tryHandleChat(serverboundchatcommandsignedpacket.command(), () -> {
                if (this.player.hasDisconnected()) {
                    return;
                }
                this.performSignedChatCommand(serverboundchatcommandsignedpacket, (LastSeenMessages)optional.get());
                this.detectRateSpam("/" + serverboundchatcommandsignedpacket.command());
            }, true);
        }
    }

    private void performSignedChatCommand(ServerboundChatCommandSignedPacket serverboundchatcommandsignedpacket, LastSeenMessages lastseenmessages) {
        Map<String, PlayerChatMessage> map;
        Object command = "/" + serverboundchatcommandsignedpacket.command();
        LOGGER.info(this.player.getScoreboardName() + " issued server command: " + (String)command);
        PlayerCommandPreprocessEvent event = new PlayerCommandPreprocessEvent((Player)this.getCraftPlayer(), (String)command, (Set)new LazyPlayerSet(this.server));
        this.cserver.getPluginManager().callEvent((Event)event);
        if (event.isCancelled()) {
            return;
        }
        command = event.getMessage().substring(1);
        ParseResults<CommandListenerWrapper> parseresults = this.parseCommand((String)command);
        try {
            map = serverboundchatcommandsignedpacket.command().equals(command) ? this.collectSignedArguments(serverboundchatcommandsignedpacket, SignableCommand.of(parseresults), lastseenmessages) : Collections.emptyMap();
        }
        catch (SignedMessageChain.a signedmessagechain_a) {
            this.handleMessageDecodeFailure(signedmessagechain_a);
            return;
        }
        CommandSigningContext.a commandsigningcontext_a = new CommandSigningContext.a(map);
        parseresults = net.minecraft.commands.CommandDispatcher.mapSource(parseresults, commandlistenerwrapper -> commandlistenerwrapper.withSigningContext(commandsigningcontext_a, this.chatMessageChain));
        this.server.getCommands().performCommand(parseresults, (String)command);
    }

    private void handleMessageDecodeFailure(SignedMessageChain.a signedmessagechain_a) {
        LOGGER.warn("Failed to update secure chat state for {}: '{}'", (Object)this.player.getGameProfile().getName(), (Object)signedmessagechain_a.getComponent().getString());
        this.player.sendSystemMessage(signedmessagechain_a.getComponent().copy().withStyle(EnumChatFormat.RED));
    }

    private <S> Map<String, PlayerChatMessage> collectSignedArguments(ServerboundChatCommandSignedPacket serverboundchatcommandsignedpacket, SignableCommand<S> signablecommand, LastSeenMessages lastseenmessages) throws SignedMessageChain.a {
        SignableCommand.a signablecommand_a1;
        List<ArgumentSignatures.a> list = serverboundchatcommandsignedpacket.argumentSignatures().entries();
        List<SignableCommand.a<S>> list1 = signablecommand.arguments();
        if (list.isEmpty()) {
            return this.collectUnsignedArguments(list1);
        }
        Object2ObjectOpenHashMap map = new Object2ObjectOpenHashMap();
        for (ArgumentSignatures.a argumentsignatures_a : list) {
            SignableCommand.a<S> signablecommand_a = signablecommand.getArgument(argumentsignatures_a.name());
            if (signablecommand_a == null) {
                this.signedMessageDecoder.setChainBroken();
                throw PlayerConnection.createSignedArgumentMismatchException(serverboundchatcommandsignedpacket.command(), list, list1);
            }
            SignedMessageBody signedmessagebody = new SignedMessageBody(signablecommand_a.value(), serverboundchatcommandsignedpacket.timeStamp(), serverboundchatcommandsignedpacket.salt(), lastseenmessages);
            map.put(signablecommand_a.name(), this.signedMessageDecoder.unpack(argumentsignatures_a.signature(), signedmessagebody));
        }
        Iterator<Record> iterator = list1.iterator();
        do {
            if (iterator.hasNext()) continue;
            return map;
        } while (map.containsKey((signablecommand_a1 = (SignableCommand.a)iterator.next()).name()));
        throw PlayerConnection.createSignedArgumentMismatchException(serverboundchatcommandsignedpacket.command(), list, list1);
    }

    private <S> Map<String, PlayerChatMessage> collectUnsignedArguments(List<SignableCommand.a<S>> list) throws SignedMessageChain.a {
        HashMap<String, PlayerChatMessage> map = new HashMap<String, PlayerChatMessage>();
        for (SignableCommand.a<S> signablecommand_a : list) {
            SignedMessageBody signedmessagebody = SignedMessageBody.unsigned(signablecommand_a.value());
            map.put(signablecommand_a.name(), this.signedMessageDecoder.unpack(null, signedmessagebody));
        }
        return map;
    }

    private static <S> SignedMessageChain.a createSignedArgumentMismatchException(String s2, List<ArgumentSignatures.a> list, List<SignableCommand.a<S>> list1) {
        String s1 = list.stream().map(ArgumentSignatures.a::name).collect(Collectors.joining(", "));
        String s22 = list1.stream().map(SignableCommand.a::name).collect(Collectors.joining(", "));
        LOGGER.error("Signed command mismatch between server and client ('{}'): got [{}] from client, but expected [{}]", new Object[]{s2, s1, s22});
        return new SignedMessageChain.a(INVALID_COMMAND_SIGNATURE);
    }

    private ParseResults<CommandListenerWrapper> parseCommand(String s2) {
        CommandDispatcher<CommandListenerWrapper> com_mojang_brigadier_commanddispatcher = this.server.getCommands().getDispatcher();
        return com_mojang_brigadier_commanddispatcher.parse(s2, this.player.createCommandSourceStack());
    }

    private void tryHandleChat(String s2, Runnable runnable, boolean sync) {
        if (PlayerConnection.isChatMessageIllegal(s2)) {
            this.disconnect(IChatBaseComponent.translatable("multiplayer.disconnect.illegal_characters"));
        } else if (this.player.isRemoved() || this.player.getChatVisibility() == EnumChatVisibility.HIDDEN) {
            this.send(new ClientboundSystemChatPacket(IChatBaseComponent.translatable("chat.disabled.options").withStyle(EnumChatFormat.RED), false));
        } else {
            this.player.resetLastActionTime();
            if (sync) {
                this.server.execute(runnable);
            } else {
                runnable.run();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Optional<LastSeenMessages> unpackAndApplyLastSeen(LastSeenMessages.b lastseenmessages_b) {
        LastSeenMessagesValidator lastseenmessagesvalidator = this.lastSeenMessages;
        LastSeenMessagesValidator lastSeenMessagesValidator = this.lastSeenMessages;
        synchronized (lastSeenMessagesValidator) {
            Optional<LastSeenMessages> optional = this.lastSeenMessages.applyUpdate(lastseenmessages_b);
            if (optional.isEmpty()) {
                LOGGER.warn("Failed to validate message acknowledgements from {}", (Object)this.player.getName().getString());
                this.disconnect(CHAT_VALIDATION_FAILED);
            }
            return optional;
        }
    }

    private static boolean isChatMessageIllegal(String s2) {
        for (int i2 = 0; i2 < s2.length(); ++i2) {
            if (UtilColor.isAllowedChatCharacter(s2.charAt(i2))) continue;
            return true;
        }
        return false;
    }

    public void chat(String s2, final PlayerChatMessage original, boolean async) {
        if (s2.isEmpty() || this.player.getChatVisibility() == EnumChatVisibility.HIDDEN) {
            return;
        }
        OutgoingChatMessage outgoing = OutgoingChatMessage.create(original);
        if (!async && s2.startsWith("/")) {
            this.handleCommand(s2);
        } else if (this.player.getChatVisibility() != EnumChatVisibility.SYSTEM) {
            CraftPlayer player = this.getCraftPlayer();
            AsyncPlayerChatEvent event = new AsyncPlayerChatEvent(async, (Player)player, s2, (Set)new LazyPlayerSet(this.server));
            final String originalFormat = event.getFormat();
            final String originalMessage = event.getMessage();
            this.cserver.getPluginManager().callEvent((Event)event);
            if (PlayerChatEvent.getHandlerList().getRegisteredListeners().length != 0) {
                final PlayerChatEvent queueEvent = new PlayerChatEvent((Player)player, event.getMessage(), event.getFormat(), event.getRecipients());
                queueEvent.setCancelled(event.isCancelled());
                Waitable waitable = new Waitable(){

                    protected Object evaluate() {
                        Bukkit.getPluginManager().callEvent((Event)queueEvent);
                        if (queueEvent.isCancelled()) {
                            return null;
                        }
                        String message = String.format(queueEvent.getFormat(), queueEvent.getPlayer().getDisplayName(), queueEvent.getMessage());
                        if (((LazyPlayerSet)queueEvent.getRecipients()).isLazy()) {
                            if (!SpigotConfig.bungee && originalFormat.equals(queueEvent.getFormat()) && originalMessage.equals(queueEvent.getMessage()) && queueEvent.getPlayer().getName().equalsIgnoreCase(queueEvent.getPlayer().getDisplayName())) {
                                PlayerConnection.this.server.getPlayerList().broadcastChatMessage(original, PlayerConnection.this.player, ChatMessageType.bind(ChatMessageType.CHAT, PlayerConnection.this.player));
                                return null;
                            }
                            for (EntityPlayer recipient : PlayerConnection.this.server.getPlayerList().players) {
                                recipient.getBukkitEntity().sendMessage(PlayerConnection.this.player.getUUID(), message);
                            }
                        } else {
                            for (Player player : queueEvent.getRecipients()) {
                                player.sendMessage(PlayerConnection.this.player.getUUID(), message);
                            }
                        }
                        PlayerConnection.this.server.console.sendMessage(message);
                        return null;
                    }
                };
                if (async) {
                    this.server.processQueue.add(waitable);
                } else {
                    waitable.run();
                }
                try {
                    waitable.get();
                }
                catch (InterruptedException e2) {
                    Thread.currentThread().interrupt();
                }
                catch (ExecutionException e3) {
                    throw new RuntimeException("Exception processing chat event", e3.getCause());
                }
            } else {
                if (event.isCancelled()) {
                    return;
                }
                s2 = String.format(event.getFormat(), event.getPlayer().getDisplayName(), event.getMessage());
                if (((LazyPlayerSet)event.getRecipients()).isLazy()) {
                    if (!SpigotConfig.bungee && originalFormat.equals(event.getFormat()) && originalMessage.equals(event.getMessage()) && event.getPlayer().getName().equalsIgnoreCase(event.getPlayer().getDisplayName())) {
                        this.server.getPlayerList().broadcastChatMessage(original, this.player, ChatMessageType.bind(ChatMessageType.CHAT, this.player));
                        return;
                    }
                    for (EntityPlayer recipient : this.server.getPlayerList().players) {
                        recipient.getBukkitEntity().sendMessage(this.player.getUUID(), s2);
                    }
                } else {
                    for (Player recipient : event.getRecipients()) {
                        recipient.sendMessage(this.player.getUUID(), s2);
                    }
                }
                this.server.console.sendMessage(s2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleCommand(String s2) {
        SpigotTimings.playerCommandTimer.startTiming();
        if (SpigotConfig.logCommands) {
            LOGGER.info(this.player.getScoreboardName() + " issued server command: " + s2);
        }
        CraftPlayer player = this.getCraftPlayer();
        PlayerCommandPreprocessEvent event = new PlayerCommandPreprocessEvent((Player)player, s2, (Set)new LazyPlayerSet(this.server));
        this.cserver.getPluginManager().callEvent((Event)event);
        if (event.isCancelled()) {
            SpigotTimings.playerCommandTimer.stopTiming();
            return;
        }
        try {
            if (this.cserver.dispatchCommand((CommandSender)event.getPlayer(), event.getMessage().substring(1))) {
                return;
            }
        }
        catch (CommandException ex) {
            player.sendMessage(String.valueOf(ChatColor.RED) + "An internal error occurred while attempting to perform this command");
            java.util.logging.Logger.getLogger(PlayerConnection.class.getName()).log(Level.SEVERE, null, ex);
            return;
        }
        finally {
            SpigotTimings.playerCommandTimer.stopTiming();
        }
    }

    private PlayerChatMessage getSignedMessage(PacketPlayInChat packetplayinchat, LastSeenMessages lastseenmessages) throws SignedMessageChain.a {
        SignedMessageBody signedmessagebody = new SignedMessageBody(packetplayinchat.message(), packetplayinchat.timeStamp(), packetplayinchat.salt(), lastseenmessages);
        return this.signedMessageDecoder.unpack(packetplayinchat.signature(), signedmessagebody);
    }

    private void broadcastChatMessage(PlayerChatMessage playerchatmessage) {
        String s2 = playerchatmessage.signedContent();
        if (s2.isEmpty()) {
            LOGGER.warn(this.player.getScoreboardName() + " tried to send an empty message");
        } else if (this.getCraftPlayer().isConversing()) {
            final String conversationInput = s2;
            this.server.processQueue.add(new Runnable(){

                @Override
                public void run() {
                    PlayerConnection.this.getCraftPlayer().acceptConversationInput(conversationInput);
                }
            });
        } else if (this.player.getChatVisibility() == EnumChatVisibility.SYSTEM) {
            this.send(new ClientboundSystemChatPacket(IChatBaseComponent.translatable("chat.cannotSend").withStyle(EnumChatFormat.RED), false));
        } else {
            this.chat(s2, playerchatmessage, true);
        }
        this.detectRateSpam(s2);
    }

    private void detectRateSpam(String s2) {
        boolean counted = true;
        for (String exclude : SpigotConfig.spamExclusions) {
            if (exclude == null || !s2.startsWith(exclude)) continue;
            counted = false;
            break;
        }
        if (this.chatSpamTickCount.addAndGet(20) > 200 && !this.server.getPlayerList().isOp(this.player.getGameProfile()) && !this.server.isSingleplayerOwner(this.player.getGameProfile())) {
            this.disconnect(IChatBaseComponent.translatable("disconnect.spam"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleChatAck(ServerboundChatAckPacket serverboundchatackpacket) {
        LastSeenMessagesValidator lastseenmessagesvalidator = this.lastSeenMessages;
        LastSeenMessagesValidator lastSeenMessagesValidator = this.lastSeenMessages;
        synchronized (lastSeenMessagesValidator) {
            if (!this.lastSeenMessages.applyOffset(serverboundchatackpacket.offset())) {
                LOGGER.warn("Failed to validate message acknowledgements from {}", (Object)this.player.getName().getString());
                this.disconnect(CHAT_VALIDATION_FAILED);
            }
        }
    }

    @Override
    public void handleAnimate(PacketPlayInArmAnimation packetplayinarmanimation) {
        PlayerConnectionUtils.ensureRunningOnSameThread(packetplayinarmanimation, this, this.player.serverLevel());
        if (this.player.isImmobile()) {
            return;
        }
        this.player.resetLastActionTime();
        float f1 = this.player.getXRot();
        float f2 = this.player.getYRot();
        double d0 = this.player.getX();
        double d1 = this.player.getY() + (double)this.player.getEyeHeight();
        double d2 = this.player.getZ();
        Location origin = new Location((World)this.player.level().getWorld(), d0, d1, d2, f2, f1);
        double d3 = Math.max(this.player.blockInteractionRange(), this.player.entityInteractionRange());
        RayTraceResult result = this.player.level().getWorld().rayTrace(origin, origin.getDirection(), d3, FluidCollisionMode.NEVER, false, 0.1, entity -> {
            net.minecraft.world.entity.Entity handle = ((CraftEntity)entity).getHandle();
            return entity != this.player.getBukkitEntity() && this.player.getBukkitEntity().canSee((Entity)entity) && !handle.isSpectator() && handle.isPickable() && !handle.isPassengerOfSameVehicle(this.player);
        });
        if (result == null) {
            CraftEventFactory.callPlayerInteractEvent(this.player, Action.LEFT_CLICK_AIR, this.player.getInventory().getSelected(), EnumHand.MAIN_HAND);
        }
        PlayerAnimationEvent event = new PlayerAnimationEvent((Player)this.getCraftPlayer(), packetplayinarmanimation.getHand() == EnumHand.MAIN_HAND ? PlayerAnimationType.ARM_SWING : PlayerAnimationType.OFF_ARM_SWING);
        this.cserver.getPluginManager().callEvent((Event)event);
        if (event.isCancelled()) {
            return;
        }
        this.player.swing(packetplayinarmanimation.getHand());
    }

    @Override
    public void handlePlayerCommand(PacketPlayInEntityAction packetplayinentityaction) {
        PlayerConnectionUtils.ensureRunningOnSameThread(packetplayinentityaction, this, this.player.serverLevel());
        if (this.player.isRemoved()) {
            return;
        }
        switch (packetplayinentityaction.getAction()) {
            case PRESS_SHIFT_KEY: 
            case RELEASE_SHIFT_KEY: {
                PlayerToggleSneakEvent event = new PlayerToggleSneakEvent((Player)this.getCraftPlayer(), packetplayinentityaction.getAction() == PacketPlayInEntityAction.EnumPlayerAction.PRESS_SHIFT_KEY);
                this.cserver.getPluginManager().callEvent((Event)event);
                if (!event.isCancelled()) break;
                return;
            }
            case START_SPRINTING: 
            case STOP_SPRINTING: {
                PlayerToggleSprintEvent e2 = new PlayerToggleSprintEvent((Player)this.getCraftPlayer(), packetplayinentityaction.getAction() == PacketPlayInEntityAction.EnumPlayerAction.START_SPRINTING);
                this.cserver.getPluginManager().callEvent((Event)e2);
                if (!e2.isCancelled()) break;
                return;
            }
        }
        this.player.resetLastActionTime();
        switch (packetplayinentityaction.getAction()) {
            case PRESS_SHIFT_KEY: {
                this.player.setShiftKeyDown(true);
                break;
            }
            case RELEASE_SHIFT_KEY: {
                this.player.setShiftKeyDown(false);
                break;
            }
            case START_SPRINTING: {
                this.player.setSprinting(true);
                break;
            }
            case STOP_SPRINTING: {
                this.player.setSprinting(false);
                break;
            }
            case STOP_SLEEPING: {
                if (!this.player.isSleeping()) break;
                this.player.stopSleepInBed(false, true);
                this.awaitingPositionFromClient = this.player.position();
                break;
            }
            case START_RIDING_JUMP: {
                net.minecraft.world.entity.Entity entity = this.player.getControlledVehicle();
                if (!(entity instanceof IJumpable)) break;
                IJumpable ijumpable = (IJumpable)((Object)entity);
                int i2 = packetplayinentityaction.getData();
                if (!ijumpable.canJump() || i2 <= 0) break;
                ijumpable.handleStartJump(i2);
                break;
            }
            case STOP_RIDING_JUMP: {
                net.minecraft.world.entity.Entity entity = this.player.getControlledVehicle();
                if (!(entity instanceof IJumpable)) break;
                IJumpable ijumpable = (IJumpable)((Object)entity);
                ijumpable.handleStopJump();
                break;
            }
            case OPEN_INVENTORY: {
                net.minecraft.world.entity.Entity entity = this.player.getVehicle();
                if (!(entity instanceof HasCustomInventoryScreen)) break;
                HasCustomInventoryScreen hascustominventoryscreen = (HasCustomInventoryScreen)((Object)entity);
                hascustominventoryscreen.openCustomInventoryScreen(this.player);
                break;
            }
            case START_FALL_FLYING: {
                if (this.player.tryToStartFallFlying()) break;
                this.player.stopFallFlying();
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid client command!");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPendingMessage(PlayerChatMessage playerchatmessage) {
        MessageSignature messagesignature = playerchatmessage.signature();
        if (messagesignature != null) {
            int i2;
            this.messageSignatureCache.push(playerchatmessage.signedBody(), playerchatmessage.signature());
            LastSeenMessagesValidator lastseenmessagesvalidator = this.lastSeenMessages;
            LastSeenMessagesValidator lastSeenMessagesValidator = this.lastSeenMessages;
            synchronized (lastSeenMessagesValidator) {
                this.lastSeenMessages.addPending(messagesignature);
                i2 = this.lastSeenMessages.trackedMessagesCount();
            }
            if (i2 > 4096) {
                this.disconnect(IChatBaseComponent.translatable("multiplayer.disconnect.too_many_pending_chats"));
            }
        }
    }

    public void sendPlayerChatMessage(PlayerChatMessage playerchatmessage, ChatMessageType.a chatmessagetype_a) {
        if (!this.getCraftPlayer().canSeePlayer(playerchatmessage.link().sender())) {
            this.sendDisguisedChatMessage(playerchatmessage.decoratedContent(), chatmessagetype_a);
            return;
        }
        this.send(new ClientboundPlayerChatPacket(playerchatmessage.link().sender(), playerchatmessage.link().index(), playerchatmessage.signature(), playerchatmessage.signedBody().pack(this.messageSignatureCache), playerchatmessage.unsignedContent(), playerchatmessage.filterMask(), chatmessagetype_a));
        this.addPendingMessage(playerchatmessage);
    }

    public void sendDisguisedChatMessage(IChatBaseComponent ichatbasecomponent, ChatMessageType.a chatmessagetype_a) {
        this.send(new ClientboundDisguisedChatPacket(ichatbasecomponent, chatmessagetype_a));
    }

    public SocketAddress getRemoteAddress() {
        return this.connection.getRemoteAddress();
    }

    public SocketAddress getRawAddress() {
        return this.connection.channel.remoteAddress();
    }

    public void switchToConfig() {
        this.waitingForSwitchToConfig = true;
        this.removePlayerFromWorld();
        this.send(ClientboundStartConfigurationPacket.INSTANCE);
        this.connection.setupOutboundProtocol(ConfigurationProtocols.CLIENTBOUND);
    }

    @Override
    public void handlePingRequest(ServerboundPingRequestPacket serverboundpingrequestpacket) {
        this.connection.send(new ClientboundPongResponsePacket(serverboundpingrequestpacket.getTime()));
    }

    @Override
    public void handleInteract(PacketPlayInUseEntity packetplayinuseentity) {
        PlayerConnectionUtils.ensureRunningOnSameThread(packetplayinuseentity, this, this.player.serverLevel());
        if (this.player.isImmobile()) {
            return;
        }
        final WorldServer worldserver = this.player.serverLevel();
        final net.minecraft.world.entity.Entity entity = packetplayinuseentity.getTarget(worldserver);
        if (entity == this.player && !this.player.isSpectator()) {
            this.disconnect(IChatBaseComponent.literal("Cannot interact with self!"));
            return;
        }
        this.player.resetLastActionTime();
        this.player.setShiftKeyDown(packetplayinuseentity.isUsingSecondaryAction());
        if (entity != null) {
            if (!worldserver.getWorldBorder().isWithinBounds(entity.blockPosition())) {
                return;
            }
            AxisAlignedBB axisalignedbb = entity.getBoundingBox();
            if (this.player.canInteractWithEntity(axisalignedbb, 1.0)) {
                packetplayinuseentity.dispatch(new PacketPlayInUseEntity.c(){

                    private void performInteraction(EnumHand enumhand, a playerconnection_a, PlayerInteractEntityEvent event) {
                        ItemStack itemstack = PlayerConnection.this.player.getItemInHand(enumhand);
                        if (itemstack.isItemEnabled(worldserver.enabledFeatures())) {
                            ItemStack itemstack1 = itemstack.copy();
                            ItemStack itemInHand = PlayerConnection.this.player.getItemInHand(enumhand);
                            boolean triggerLeashUpdate = itemInHand != null && itemInHand.getItem() == Items.LEAD && entity instanceof EntityInsentient;
                            Item origItem = PlayerConnection.this.player.getInventory().getSelected() == null ? null : PlayerConnection.this.player.getInventory().getSelected().getItem();
                            PlayerConnection.this.cserver.getPluginManager().callEvent((Event)event);
                            if (entity instanceof Bucketable && entity instanceof EntityLiving && origItem != null && origItem.asItem() == Items.WATER_BUCKET && (event.isCancelled() || PlayerConnection.this.player.getInventory().getSelected() == null || PlayerConnection.this.player.getInventory().getSelected().getItem() != origItem)) {
                                entity.getBukkitEntity().update(PlayerConnection.this.player);
                                PlayerConnection.this.player.containerMenu.sendAllDataToRemote();
                            }
                            if (triggerLeashUpdate && (event.isCancelled() || PlayerConnection.this.player.getInventory().getSelected() == null || PlayerConnection.this.player.getInventory().getSelected().getItem() != origItem)) {
                                PlayerConnection.this.send(new PacketPlayOutAttachEntity(entity, ((EntityInsentient)entity).getLeashHolder()));
                            }
                            if (event.isCancelled() || PlayerConnection.this.player.getInventory().getSelected() == null || PlayerConnection.this.player.getInventory().getSelected().getItem() != origItem) {
                                entity.refreshEntityData(PlayerConnection.this.player);
                                if (entity instanceof Allay) {
                                    PlayerConnection.this.send(new PacketPlayOutEntityEquipment(entity.getId(), Arrays.stream(EnumItemSlot.values()).map(slot -> Pair.of((Object)slot, (Object)((EntityLiving)entity).getItemBySlot((EnumItemSlot)slot).copy())).collect(Collectors.toList())));
                                    PlayerConnection.this.player.containerMenu.sendAllDataToRemote();
                                }
                            }
                            if (event.isCancelled()) {
                                return;
                            }
                            EnumInteractionResult enuminteractionresult = playerconnection_a.run(PlayerConnection.this.player, entity, enumhand);
                            if (!itemInHand.isEmpty() && itemInHand.getCount() <= -1) {
                                PlayerConnection.this.player.containerMenu.sendAllDataToRemote();
                            }
                            if (enuminteractionresult.consumesAction()) {
                                CriterionTriggers.PLAYER_INTERACTED_WITH_ENTITY.trigger(PlayerConnection.this.player, enuminteractionresult.indicateItemUse() ? itemstack1 : ItemStack.EMPTY, entity);
                                if (enuminteractionresult.shouldSwing()) {
                                    PlayerConnection.this.player.swing(enumhand, true);
                                }
                            }
                        }
                    }

                    @Override
                    public void onInteraction(EnumHand enumhand) {
                        this.performInteraction(enumhand, EntityHuman::interactOn, new PlayerInteractEntityEvent((Player)PlayerConnection.this.getCraftPlayer(), (Entity)entity.getBukkitEntity(), enumhand == EnumHand.OFF_HAND ? EquipmentSlot.OFF_HAND : EquipmentSlot.HAND));
                    }

                    @Override
                    public void onInteraction(EnumHand enumhand, Vec3D vec3d) {
                        this.performInteraction(enumhand, (entityplayer, entity1, enumhand1) -> entity1.interactAt(entityplayer, vec3d, enumhand1), (PlayerInteractEntityEvent)new PlayerInteractAtEntityEvent((Player)PlayerConnection.this.getCraftPlayer(), (Entity)entity.getBukkitEntity(), new Vector(vec3d.x, vec3d.y, vec3d.z), enumhand == EnumHand.OFF_HAND ? EquipmentSlot.OFF_HAND : EquipmentSlot.HAND));
                    }

                    @Override
                    public void onAttack() {
                        EntityArrow entityarrow;
                        if (!(entity instanceof EntityItem || entity instanceof EntityExperienceOrb || entity == PlayerConnection.this.player && !PlayerConnection.this.player.isSpectator() || entity instanceof EntityArrow && !(entityarrow = (EntityArrow)entity).isAttackable())) {
                            ItemStack itemstack = PlayerConnection.this.player.getItemInHand(EnumHand.MAIN_HAND);
                            if (!itemstack.isItemEnabled(worldserver.enabledFeatures())) {
                                return;
                            }
                            PlayerConnection.this.player.attack(entity);
                            if (!itemstack.isEmpty() && itemstack.getCount() <= -1) {
                                PlayerConnection.this.player.containerMenu.sendAllDataToRemote();
                            }
                            return;
                        }
                        PlayerConnection.this.disconnect(IChatBaseComponent.translatable("multiplayer.disconnect.invalid_entity_attacked"));
                        LOGGER.warn("Player {} tried to attack an invalid entity", (Object)PlayerConnection.this.player.getName().getString());
                    }
                });
            }
        }
    }

    @Override
    public void handleClientCommand(PacketPlayInClientCommand packetplayinclientcommand) {
        PlayerConnectionUtils.ensureRunningOnSameThread(packetplayinclientcommand, this, this.player.serverLevel());
        this.player.resetLastActionTime();
        PacketPlayInClientCommand.EnumClientCommand packetplayinclientcommand_enumclientcommand = packetplayinclientcommand.getAction();
        switch (packetplayinclientcommand_enumclientcommand) {
            case PERFORM_RESPAWN: {
                if (this.player.wonGame) {
                    this.player.wonGame = false;
                    this.player = this.server.getPlayerList().respawn(this.player, true, Entity.RemovalReason.CHANGED_DIMENSION, PlayerRespawnEvent.RespawnReason.END_PORTAL);
                    CriterionTriggers.CHANGED_DIMENSION.trigger(this.player, net.minecraft.world.level.World.END, net.minecraft.world.level.World.OVERWORLD);
                    break;
                }
                if (this.player.getHealth() > 0.0f) {
                    return;
                }
                this.player = this.server.getPlayerList().respawn(this.player, false, Entity.RemovalReason.KILLED, PlayerRespawnEvent.RespawnReason.DEATH);
                if (!this.server.isHardcore()) break;
                this.player.setGameMode(EnumGamemode.SPECTATOR);
                this.player.level().getGameRules().getRule(GameRules.RULE_SPECTATORSGENERATECHUNKS).set(false, this.player.serverLevel());
                break;
            }
            case REQUEST_STATS: {
                this.player.getStats().sendStats(this.player);
            }
        }
    }

    @Override
    public void handleContainerClose(PacketPlayInCloseWindow packetplayinclosewindow) {
        PlayerConnectionUtils.ensureRunningOnSameThread(packetplayinclosewindow, this, this.player.serverLevel());
        if (this.player.isImmobile()) {
            return;
        }
        CraftEventFactory.handleInventoryCloseEvent(this.player);
        this.player.doCloseContainer();
    }

    @Override
    public void handleContainerClick(PacketPlayInWindowClick packetplayinwindowclick) {
        PlayerConnectionUtils.ensureRunningOnSameThread(packetplayinwindowclick, this, this.player.serverLevel());
        if (this.player.isImmobile()) {
            return;
        }
        this.player.resetLastActionTime();
        if (this.player.containerMenu.containerId == packetplayinwindowclick.getContainerId() && this.player.containerMenu.stillValid(this.player)) {
            boolean cancelled = this.player.isSpectator();
            if (!this.player.containerMenu.stillValid(this.player)) {
                LOGGER.debug("Player {} interacted with invalid menu {}", (Object)this.player, (Object)this.player.containerMenu);
            } else {
                int i2 = packetplayinwindowclick.getSlotNum();
                if (!this.player.containerMenu.isValidSlotIndex(i2)) {
                    LOGGER.debug("Player {} clicked invalid slot index: {}, available slots: {}", new Object[]{this.player.getName(), i2, this.player.containerMenu.slots.size()});
                } else {
                    boolean flag = packetplayinwindowclick.getStateId() != this.player.containerMenu.getStateId();
                    this.player.containerMenu.suppressRemoteUpdates();
                    if (packetplayinwindowclick.getSlotNum() < -1 && packetplayinwindowclick.getSlotNum() != -999) {
                        return;
                    }
                    InventoryView inventory = this.player.containerMenu.getBukkitView();
                    InventoryType.SlotType type = inventory.getSlotType(packetplayinwindowclick.getSlotNum());
                    ClickType click = ClickType.UNKNOWN;
                    InventoryAction action = InventoryAction.UNKNOWN;
                    ItemStack itemstack = ItemStack.EMPTY;
                    switch (packetplayinwindowclick.getClickType()) {
                        case PICKUP: {
                            if (packetplayinwindowclick.getButtonNum() == 0) {
                                click = ClickType.LEFT;
                            } else if (packetplayinwindowclick.getButtonNum() == 1) {
                                click = ClickType.RIGHT;
                            }
                            if (packetplayinwindowclick.getButtonNum() != 0 && packetplayinwindowclick.getButtonNum() != 1) break;
                            action = InventoryAction.NOTHING;
                            if (packetplayinwindowclick.getSlotNum() == -999) {
                                if (this.player.containerMenu.getCarried().isEmpty()) break;
                                action = packetplayinwindowclick.getButtonNum() == 0 ? InventoryAction.DROP_ALL_CURSOR : InventoryAction.DROP_ONE_CURSOR;
                                break;
                            }
                            if (packetplayinwindowclick.getSlotNum() < 0) {
                                action = InventoryAction.NOTHING;
                                break;
                            }
                            Slot slot = this.player.containerMenu.getSlot(packetplayinwindowclick.getSlotNum());
                            if (slot == null) break;
                            ItemStack clickedItem = slot.getItem();
                            ItemStack cursor = this.player.containerMenu.getCarried();
                            if (clickedItem.isEmpty()) {
                                if (cursor.isEmpty()) break;
                                action = packetplayinwindowclick.getButtonNum() == 0 ? InventoryAction.PLACE_ALL : InventoryAction.PLACE_ONE;
                                break;
                            }
                            if (!slot.mayPickup(this.player)) break;
                            if (cursor.isEmpty()) {
                                action = packetplayinwindowclick.getButtonNum() == 0 ? InventoryAction.PICKUP_ALL : InventoryAction.PICKUP_HALF;
                                break;
                            }
                            if (slot.mayPlace(cursor)) {
                                if (ItemStack.isSameItemSameComponents(clickedItem, cursor)) {
                                    int toPlace = packetplayinwindowclick.getButtonNum() == 0 ? cursor.getCount() : 1;
                                    toPlace = Math.min(toPlace, clickedItem.getMaxStackSize() - clickedItem.getCount());
                                    if ((toPlace = Math.min(toPlace, slot.container.getMaxStackSize() - clickedItem.getCount())) == 1) {
                                        action = InventoryAction.PLACE_ONE;
                                        break;
                                    }
                                    if (toPlace == cursor.getCount()) {
                                        action = InventoryAction.PLACE_ALL;
                                        break;
                                    }
                                    if (toPlace < 0) {
                                        action = toPlace != -1 ? InventoryAction.PICKUP_SOME : InventoryAction.PICKUP_ONE;
                                        break;
                                    }
                                    if (toPlace == 0) break;
                                    action = InventoryAction.PLACE_SOME;
                                    break;
                                }
                                if (cursor.getCount() > slot.getMaxStackSize()) break;
                                action = InventoryAction.SWAP_WITH_CURSOR;
                                break;
                            }
                            if (!ItemStack.isSameItemSameComponents(cursor, clickedItem) || clickedItem.getCount() < 0 || clickedItem.getCount() + cursor.getCount() > cursor.getMaxStackSize()) break;
                            action = InventoryAction.PICKUP_ALL;
                            break;
                        }
                        case QUICK_MOVE: {
                            if (packetplayinwindowclick.getButtonNum() == 0) {
                                click = ClickType.SHIFT_LEFT;
                            } else if (packetplayinwindowclick.getButtonNum() == 1) {
                                click = ClickType.SHIFT_RIGHT;
                            }
                            if (packetplayinwindowclick.getButtonNum() != 0 && packetplayinwindowclick.getButtonNum() != 1) break;
                            if (packetplayinwindowclick.getSlotNum() < 0) {
                                action = InventoryAction.NOTHING;
                                break;
                            }
                            Slot slot = this.player.containerMenu.getSlot(packetplayinwindowclick.getSlotNum());
                            if (slot != null && slot.mayPickup(this.player) && slot.hasItem()) {
                                action = InventoryAction.MOVE_TO_OTHER_INVENTORY;
                                break;
                            }
                            action = InventoryAction.NOTHING;
                            break;
                        }
                        case SWAP: {
                            if ((packetplayinwindowclick.getButtonNum() < 0 || packetplayinwindowclick.getButtonNum() >= 9) && packetplayinwindowclick.getButtonNum() != 40) break;
                            click = packetplayinwindowclick.getButtonNum() == 40 ? ClickType.SWAP_OFFHAND : ClickType.NUMBER_KEY;
                            Slot clickedSlot = this.player.containerMenu.getSlot(packetplayinwindowclick.getSlotNum());
                            if (clickedSlot.mayPickup(this.player)) {
                                boolean canCleanSwap;
                                ItemStack hotbar = this.player.getInventory().getItem(packetplayinwindowclick.getButtonNum());
                                boolean bl = canCleanSwap = hotbar.isEmpty() || clickedSlot.container == this.player.getInventory() && clickedSlot.mayPlace(hotbar);
                                if (clickedSlot.hasItem()) {
                                    if (canCleanSwap) {
                                        action = InventoryAction.HOTBAR_SWAP;
                                        break;
                                    }
                                    action = InventoryAction.HOTBAR_MOVE_AND_READD;
                                    break;
                                }
                                if (!clickedSlot.hasItem() && !hotbar.isEmpty() && clickedSlot.mayPlace(hotbar)) {
                                    action = InventoryAction.HOTBAR_SWAP;
                                    break;
                                }
                                action = InventoryAction.NOTHING;
                                break;
                            }
                            action = InventoryAction.NOTHING;
                            break;
                        }
                        case CLONE: {
                            Slot slot;
                            if (packetplayinwindowclick.getButtonNum() == 2) {
                                click = ClickType.MIDDLE;
                                if (packetplayinwindowclick.getSlotNum() < 0) {
                                    action = InventoryAction.NOTHING;
                                    break;
                                }
                                slot = this.player.containerMenu.getSlot(packetplayinwindowclick.getSlotNum());
                                if (slot != null && slot.hasItem() && this.player.getAbilities().instabuild && this.player.containerMenu.getCarried().isEmpty()) {
                                    action = InventoryAction.CLONE_STACK;
                                    break;
                                }
                                action = InventoryAction.NOTHING;
                                break;
                            }
                            click = ClickType.UNKNOWN;
                            action = InventoryAction.UNKNOWN;
                            break;
                        }
                        case THROW: {
                            Slot slot;
                            if (packetplayinwindowclick.getSlotNum() >= 0) {
                                if (packetplayinwindowclick.getButtonNum() == 0) {
                                    click = ClickType.DROP;
                                    slot = this.player.containerMenu.getSlot(packetplayinwindowclick.getSlotNum());
                                    if (slot != null && slot.hasItem() && slot.mayPickup(this.player) && !slot.getItem().isEmpty() && slot.getItem().getItem() != Item.byBlock(Blocks.AIR)) {
                                        action = InventoryAction.DROP_ONE_SLOT;
                                        break;
                                    }
                                    action = InventoryAction.NOTHING;
                                    break;
                                }
                                if (packetplayinwindowclick.getButtonNum() != 1) break;
                                click = ClickType.CONTROL_DROP;
                                slot = this.player.containerMenu.getSlot(packetplayinwindowclick.getSlotNum());
                                if (slot != null && slot.hasItem() && slot.mayPickup(this.player) && !slot.getItem().isEmpty() && slot.getItem().getItem() != Item.byBlock(Blocks.AIR)) {
                                    action = InventoryAction.DROP_ALL_SLOT;
                                    break;
                                }
                                action = InventoryAction.NOTHING;
                                break;
                            }
                            click = ClickType.LEFT;
                            if (packetplayinwindowclick.getButtonNum() == 1) {
                                click = ClickType.RIGHT;
                            }
                            action = InventoryAction.NOTHING;
                            break;
                        }
                        case QUICK_CRAFT: {
                            this.player.containerMenu.clicked(packetplayinwindowclick.getSlotNum(), packetplayinwindowclick.getButtonNum(), packetplayinwindowclick.getClickType(), this.player);
                            break;
                        }
                        case PICKUP_ALL: {
                            click = ClickType.DOUBLE_CLICK;
                            action = InventoryAction.NOTHING;
                            if (packetplayinwindowclick.getSlotNum() < 0 || this.player.containerMenu.getCarried().isEmpty()) break;
                            ItemStack cursor = this.player.containerMenu.getCarried();
                            action = InventoryAction.NOTHING;
                            if (!inventory.getTopInventory().contains(CraftItemType.minecraftToBukkit(cursor.getItem())) && !inventory.getBottomInventory().contains(CraftItemType.minecraftToBukkit(cursor.getItem()))) break;
                            action = InventoryAction.COLLECT_TO_CURSOR;
                            break;
                        }
                    }
                    if (packetplayinwindowclick.getClickType() != InventoryClickType.QUICK_CRAFT) {
                        org.bukkit.inventory.ItemStack result;
                        Recipe recipe;
                        InventoryClickEvent event = click == ClickType.NUMBER_KEY ? new InventoryClickEvent(inventory, type, packetplayinwindowclick.getSlotNum(), click, action, packetplayinwindowclick.getButtonNum()) : new InventoryClickEvent(inventory, type, packetplayinwindowclick.getSlotNum(), click, action);
                        Inventory top = inventory.getTopInventory();
                        if (packetplayinwindowclick.getSlotNum() == 0 && top instanceof CraftingInventory && (recipe = ((CraftingInventory)top).getRecipe()) != null) {
                            event = click == ClickType.NUMBER_KEY ? new CraftItemEvent(recipe, inventory, type, packetplayinwindowclick.getSlotNum(), click, action, packetplayinwindowclick.getButtonNum()) : new CraftItemEvent(recipe, inventory, type, packetplayinwindowclick.getSlotNum(), click, action);
                        }
                        if (packetplayinwindowclick.getSlotNum() == 3 && top instanceof SmithingInventory && (result = ((SmithingInventory)top).getResult()) != null) {
                            event = click == ClickType.NUMBER_KEY ? new SmithItemEvent(inventory, type, packetplayinwindowclick.getSlotNum(), click, action, packetplayinwindowclick.getButtonNum()) : new SmithItemEvent(inventory, type, packetplayinwindowclick.getSlotNum(), click, action);
                        }
                        event.setCancelled(cancelled);
                        Container oldContainer = this.player.containerMenu;
                        this.cserver.getPluginManager().callEvent((Event)event);
                        if (this.player.containerMenu != oldContainer) {
                            return;
                        }
                        block9 : switch (event.getResult()) {
                            case ALLOW: 
                            case DEFAULT: {
                                this.player.containerMenu.clicked(i2, packetplayinwindowclick.getButtonNum(), packetplayinwindowclick.getClickType(), this.player);
                                break;
                            }
                            case DENY: {
                                switch (action) {
                                    case PICKUP_ALL: 
                                    case MOVE_TO_OTHER_INVENTORY: 
                                    case HOTBAR_MOVE_AND_READD: 
                                    case HOTBAR_SWAP: 
                                    case COLLECT_TO_CURSOR: 
                                    case UNKNOWN: {
                                        this.player.containerMenu.sendAllDataToRemote();
                                        break block9;
                                    }
                                    case PICKUP_SOME: 
                                    case PICKUP_HALF: 
                                    case PICKUP_ONE: 
                                    case PLACE_ALL: 
                                    case PLACE_SOME: 
                                    case PLACE_ONE: 
                                    case SWAP_WITH_CURSOR: {
                                        this.player.connection.send(new PacketPlayOutSetSlot(-1, -1, this.player.inventoryMenu.incrementStateId(), this.player.containerMenu.getCarried()));
                                        this.player.connection.send(new PacketPlayOutSetSlot(this.player.containerMenu.containerId, this.player.inventoryMenu.incrementStateId(), packetplayinwindowclick.getSlotNum(), this.player.containerMenu.getSlot(packetplayinwindowclick.getSlotNum()).getItem()));
                                        break block9;
                                    }
                                    case DROP_ALL_SLOT: 
                                    case DROP_ONE_SLOT: {
                                        this.player.connection.send(new PacketPlayOutSetSlot(this.player.containerMenu.containerId, this.player.inventoryMenu.incrementStateId(), packetplayinwindowclick.getSlotNum(), this.player.containerMenu.getSlot(packetplayinwindowclick.getSlotNum()).getItem()));
                                        break block9;
                                    }
                                    case DROP_ALL_CURSOR: 
                                    case DROP_ONE_CURSOR: 
                                    case CLONE_STACK: {
                                        this.player.connection.send(new PacketPlayOutSetSlot(-1, -1, this.player.inventoryMenu.incrementStateId(), this.player.containerMenu.getCarried()));
                                        break block9;
                                    }
                                }
                            }
                        }
                        if (event instanceof CraftItemEvent || event instanceof SmithItemEvent) {
                            this.player.containerMenu.sendAllDataToRemote();
                        }
                    }
                    for (Int2ObjectMap.Entry entry : Int2ObjectMaps.fastIterable(packetplayinwindowclick.getChangedSlots())) {
                        this.player.containerMenu.setRemoteSlotNoCopy(entry.getIntKey(), (ItemStack)entry.getValue());
                    }
                    this.player.containerMenu.setRemoteCarried(packetplayinwindowclick.getCarriedItem());
                    this.player.containerMenu.resumeRemoteUpdates();
                    if (flag) {
                        this.player.containerMenu.broadcastFullState();
                    } else {
                        this.player.containerMenu.broadcastChanges();
                    }
                }
            }
        }
    }

    @Override
    public void handlePlaceRecipe(PacketPlayInAutoRecipe packetplayinautorecipe) {
        PlayerConnectionUtils.ensureRunningOnSameThread(packetplayinautorecipe, this, this.player.serverLevel());
        this.player.resetLastActionTime();
        if (!this.player.isSpectator() && this.player.containerMenu.containerId == packetplayinautorecipe.getContainerId() && this.player.containerMenu instanceof ContainerRecipeBook) {
            if (!this.player.containerMenu.stillValid(this.player)) {
                LOGGER.debug("Player {} interacted with invalid menu {}", (Object)this.player, (Object)this.player.containerMenu);
            } else {
                Recipe recipe = this.cserver.getRecipe(CraftNamespacedKey.fromMinecraft(packetplayinautorecipe.getRecipe()));
                if (recipe == null) {
                    return;
                }
                PlayerRecipeBookClickEvent event = CraftEventFactory.callRecipeBookClickEvent(this.player, recipe, packetplayinautorecipe.isShiftDown());
                this.server.getRecipeManager().byKey(CraftNamespacedKey.toMinecraft(((Keyed)event.getRecipe()).getKey())).ifPresent(recipeholder -> ((ContainerRecipeBook)this.player.containerMenu).handlePlacement(event.isShiftClick(), (RecipeHolder<?>)recipeholder, this.player));
            }
        }
    }

    @Override
    public void handleContainerButtonClick(PacketPlayInEnchantItem packetplayinenchantitem) {
        PlayerConnectionUtils.ensureRunningOnSameThread(packetplayinenchantitem, this, this.player.serverLevel());
        if (this.player.isImmobile()) {
            return;
        }
        this.player.resetLastActionTime();
        if (this.player.containerMenu.containerId == packetplayinenchantitem.containerId() && !this.player.isSpectator()) {
            if (!this.player.containerMenu.stillValid(this.player)) {
                LOGGER.debug("Player {} interacted with invalid menu {}", (Object)this.player, (Object)this.player.containerMenu);
            } else {
                boolean flag = this.player.containerMenu.clickMenuButton(this.player, packetplayinenchantitem.buttonId());
                if (flag) {
                    this.player.containerMenu.broadcastChanges();
                }
            }
        }
    }

    @Override
    public void handleSetCreativeModeSlot(PacketPlayInSetCreativeSlot packetplayinsetcreativeslot) {
        PlayerConnectionUtils.ensureRunningOnSameThread(packetplayinsetcreativeslot, this, this.player.serverLevel());
        if (this.player.gameMode.isCreative()) {
            boolean flag2;
            boolean flag = packetplayinsetcreativeslot.slotNum() < 0;
            ItemStack itemstack = packetplayinsetcreativeslot.itemStack();
            if (!itemstack.isItemEnabled(this.player.level().enabledFeatures())) {
                return;
            }
            CustomData customdata = itemstack.getOrDefault(DataComponents.BLOCK_ENTITY_DATA, CustomData.EMPTY);
            if (customdata.contains("x") && customdata.contains("y") && customdata.contains("z") && this.player.getBukkitEntity().hasPermission("minecraft.nbt.copy")) {
                TileEntity tileentity;
                BlockPosition blockposition = TileEntity.getPosFromTag(customdata.getUnsafe());
                if (this.player.level().isLoaded(blockposition) && (tileentity = this.player.level().getBlockEntity(blockposition)) != null) {
                    tileentity.saveToItem(itemstack, this.player.level().registryAccess());
                }
            }
            boolean flag1 = packetplayinsetcreativeslot.slotNum() >= 1 && packetplayinsetcreativeslot.slotNum() <= 45;
            boolean bl = flag2 = itemstack.isEmpty() || itemstack.getCount() <= itemstack.getMaxStackSize();
            if (flag || flag1 && !ItemStack.matches(this.player.inventoryMenu.getSlot(packetplayinsetcreativeslot.slotNum()).getItem(), packetplayinsetcreativeslot.itemStack())) {
                CraftInventoryView inventory = this.player.inventoryMenu.getBukkitView();
                org.bukkit.inventory.ItemStack item = CraftItemStack.asBukkitCopy(packetplayinsetcreativeslot.itemStack());
                InventoryType.SlotType type = InventoryType.SlotType.QUICKBAR;
                if (flag) {
                    type = InventoryType.SlotType.OUTSIDE;
                } else if (packetplayinsetcreativeslot.slotNum() < 36) {
                    type = packetplayinsetcreativeslot.slotNum() >= 5 && packetplayinsetcreativeslot.slotNum() < 9 ? InventoryType.SlotType.ARMOR : InventoryType.SlotType.CONTAINER;
                }
                InventoryCreativeEvent event = new InventoryCreativeEvent((InventoryView)inventory, type, flag ? -999 : (int)packetplayinsetcreativeslot.slotNum(), item);
                this.cserver.getPluginManager().callEvent((Event)event);
                itemstack = CraftItemStack.asNMSCopy(event.getCursor());
                switch (event.getResult()) {
                    case ALLOW: {
                        flag2 = true;
                        break;
                    }
                    case DEFAULT: {
                        break;
                    }
                    case DENY: {
                        if (packetplayinsetcreativeslot.slotNum() >= 0) {
                            this.player.connection.send(new PacketPlayOutSetSlot(this.player.inventoryMenu.containerId, this.player.inventoryMenu.incrementStateId(), packetplayinsetcreativeslot.slotNum(), this.player.inventoryMenu.getSlot(packetplayinsetcreativeslot.slotNum()).getItem()));
                            this.player.connection.send(new PacketPlayOutSetSlot(-1, this.player.inventoryMenu.incrementStateId(), -1, ItemStack.EMPTY));
                        }
                        return;
                    }
                }
            }
            if (flag1 && flag2) {
                this.player.inventoryMenu.getSlot(packetplayinsetcreativeslot.slotNum()).setByPlayer(itemstack);
                this.player.inventoryMenu.broadcastChanges();
            } else if (flag && flag2 && this.dropSpamTickCount < 200) {
                this.dropSpamTickCount += 20;
                this.player.drop(itemstack, true);
            }
        }
    }

    @Override
    public void handleSignUpdate(PacketPlayInUpdateSign packetplayinupdatesign) {
        List<String> list = Stream.of(packetplayinupdatesign.getLines()).map(EnumChatFormat::stripFormatting).collect(Collectors.toList());
        this.filterTextPacket(list).thenAcceptAsync(list1 -> this.updateSignText(packetplayinupdatesign, (List<FilteredText>)list1), (Executor)this.server);
    }

    private void updateSignText(PacketPlayInUpdateSign packetplayinupdatesign, List<FilteredText> list) {
        if (this.player.isImmobile()) {
            return;
        }
        this.player.resetLastActionTime();
        WorldServer worldserver = this.player.serverLevel();
        BlockPosition blockposition = packetplayinupdatesign.getPos();
        if (worldserver.hasChunkAt(blockposition)) {
            TileEntity tileentity = worldserver.getBlockEntity(blockposition);
            if (!(tileentity instanceof TileEntitySign)) {
                return;
            }
            TileEntitySign tileentitysign = (TileEntitySign)tileentity;
            tileentitysign.updateSignText(this.player, packetplayinupdatesign.isFrontText(), list);
        }
    }

    @Override
    public void handlePlayerAbilities(PacketPlayInAbilities packetplayinabilities) {
        PlayerConnectionUtils.ensureRunningOnSameThread(packetplayinabilities, this, this.player.serverLevel());
        if (this.player.getAbilities().mayfly && this.player.getAbilities().flying != packetplayinabilities.isFlying()) {
            PlayerToggleFlightEvent event = new PlayerToggleFlightEvent((Player)this.player.getBukkitEntity(), packetplayinabilities.isFlying());
            this.cserver.getPluginManager().callEvent((Event)event);
            if (!event.isCancelled()) {
                this.player.getAbilities().flying = packetplayinabilities.isFlying();
            } else {
                this.player.onUpdateAbilities();
            }
        }
    }

    @Override
    public void handleClientInformation(ServerboundClientInformationPacket serverboundclientinformationpacket) {
        PlayerConnectionUtils.ensureRunningOnSameThread(serverboundclientinformationpacket, this, this.player.serverLevel());
        this.player.updateOptions(serverboundclientinformationpacket.information());
    }

    @Override
    public void handleChangeDifficulty(PacketPlayInDifficultyChange packetplayindifficultychange) {
        PlayerConnectionUtils.ensureRunningOnSameThread(packetplayindifficultychange, this, this.player.serverLevel());
        if (this.player.hasPermissions(2) || this.isSingleplayerOwner()) {
            this.server.setDifficulty(packetplayindifficultychange.getDifficulty(), false);
        }
    }

    @Override
    public void handleLockDifficulty(PacketPlayInDifficultyLock packetplayindifficultylock) {
        PlayerConnectionUtils.ensureRunningOnSameThread(packetplayindifficultylock, this, this.player.serverLevel());
        if (this.player.hasPermissions(2) || this.isSingleplayerOwner()) {
            this.server.setDifficultyLocked(packetplayindifficultylock.isLocked());
        }
    }

    @Override
    public void handleChatSessionUpdate(ServerboundChatSessionUpdatePacket serverboundchatsessionupdatepacket) {
        PlayerConnectionUtils.ensureRunningOnSameThread(serverboundchatsessionupdatepacket, this, this.player.serverLevel());
        RemoteChatSession.a remotechatsession_a = serverboundchatsessionupdatepacket.chatSession();
        ProfilePublicKey.a profilepublickey_a = this.chatSession != null ? this.chatSession.profilePublicKey().data() : null;
        ProfilePublicKey.a profilepublickey_a1 = remotechatsession_a.profilePublicKey();
        if (!Objects.equals(profilepublickey_a, profilepublickey_a1)) {
            if (profilepublickey_a != null && profilepublickey_a1.expiresAt().isBefore(profilepublickey_a.expiresAt())) {
                this.disconnect(ProfilePublicKey.EXPIRED_PROFILE_PUBLIC_KEY);
            } else {
                try {
                    SignatureValidator signaturevalidator = this.server.getProfileKeySignatureValidator();
                    if (signaturevalidator == null) {
                        LOGGER.warn("Ignoring chat session from {} due to missing Services public key", (Object)this.player.getGameProfile().getName());
                        return;
                    }
                    this.resetPlayerChatState(remotechatsession_a.validate(this.player.getGameProfile(), signaturevalidator));
                }
                catch (ProfilePublicKey.b profilepublickey_b) {
                    LOGGER.error("Failed to validate profile key: {}", (Object)profilepublickey_b.getMessage());
                    this.disconnect(profilepublickey_b.getComponent());
                }
            }
        }
    }

    @Override
    public void handleConfigurationAcknowledged(ServerboundConfigurationAcknowledgedPacket serverboundconfigurationacknowledgedpacket) {
        if (!this.waitingForSwitchToConfig) {
            throw new IllegalStateException("Client acknowledged config, but none was requested");
        }
        this.connection.setupInboundProtocol(ConfigurationProtocols.SERVERBOUND, new ServerConfigurationPacketListenerImpl(this.server, this.connection, this.createCookie(this.player.clientInformation()), this.player));
    }

    @Override
    public void handleChunkBatchReceived(ServerboundChunkBatchReceivedPacket serverboundchunkbatchreceivedpacket) {
        PlayerConnectionUtils.ensureRunningOnSameThread(serverboundchunkbatchreceivedpacket, this, this.player.serverLevel());
        this.chunkSender.onChunkBatchReceivedByClient(serverboundchunkbatchreceivedpacket.desiredChunksPerTick());
    }

    @Override
    public void handleDebugSampleSubscription(ServerboundDebugSampleSubscriptionPacket serverbounddebugsamplesubscriptionpacket) {
        PlayerConnectionUtils.ensureRunningOnSameThread(serverbounddebugsamplesubscriptionpacket, this, this.player.serverLevel());
        this.server.subscribeToDebugSample(this.player, serverbounddebugsamplesubscriptionpacket.sampleType());
    }

    private void resetPlayerChatState(RemoteChatSession remotechatsession) {
        this.chatSession = remotechatsession;
        this.signedMessageDecoder = remotechatsession.createMessageDecoder(this.player.getUUID());
        this.chatMessageChain.append(() -> {
            this.player.setChatSession(remotechatsession);
            this.server.getPlayerList().broadcastAll(new ClientboundPlayerInfoUpdatePacket(EnumSet.of(ClientboundPlayerInfoUpdatePacket.a.INITIALIZE_CHAT), List.of(this.player)));
        });
    }

    @Override
    public EntityPlayer getPlayer() {
        return this.player;
    }

    @FunctionalInterface
    private static interface a {
        public EnumInteractionResult run(EntityPlayer var1, net.minecraft.world.entity.Entity var2, EnumHand var3);
    }
}

