/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.network;

import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.internal.Streams;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import com.mojang.authlib.GameProfile;
import com.mojang.logging.LogUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Nullable;
import net.minecraft.SharedConstants;
import net.minecraft.SystemUtils;
import net.minecraft.network.chat.FilterMask;
import net.minecraft.server.network.FilteredText;
import net.minecraft.server.network.ITextFilter;
import net.minecraft.util.ChatDeserializer;
import net.minecraft.util.thread.ThreadedMailbox;
import org.slf4j.Logger;

public class TextFilter
implements AutoCloseable {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final AtomicInteger WORKER_COUNT = new AtomicInteger(1);
    private static final ThreadFactory THREAD_FACTORY = var0 -> {
        Thread var1 = new Thread(var0);
        var1.setName("Chat-Filter-Worker-" + WORKER_COUNT.getAndIncrement());
        return var1;
    };
    private static final String DEFAULT_ENDPOINT = "v1/chat";
    private final URL chatEndpoint;
    private final c chatEncoder;
    final URL joinEndpoint;
    final b joinEncoder;
    final URL leaveEndpoint;
    final b leaveEncoder;
    private final String authKey;
    final a chatIgnoreStrategy;
    final ExecutorService workerPool;

    private TextFilter(URL var0, c var1, URL var2, b var3, URL var4, b var5, String var6, a var7, int var8) {
        this.authKey = var6;
        this.chatIgnoreStrategy = var7;
        this.chatEndpoint = var0;
        this.chatEncoder = var1;
        this.joinEndpoint = var2;
        this.joinEncoder = var3;
        this.leaveEndpoint = var4;
        this.leaveEncoder = var5;
        this.workerPool = Executors.newFixedThreadPool(var8, THREAD_FACTORY);
    }

    private static URL getEndpoint(URI var0, @Nullable JsonObject var1, String var2, String var3) throws MalformedURLException {
        String var4 = TextFilter.getEndpointFromConfig(var1, var2, var3);
        return var0.resolve("/" + var4).toURL();
    }

    private static String getEndpointFromConfig(@Nullable JsonObject var0, String var1, String var2) {
        return var0 != null ? ChatDeserializer.getAsString(var0, var1, var2) : var2;
    }

    @Nullable
    public static TextFilter createFromConfig(String var0) {
        if (Strings.isNullOrEmpty((String)var0)) {
            return null;
        }
        try {
            Object var17;
            c var16;
            JsonObject var1 = ChatDeserializer.parse(var0);
            URI var22 = new URI(ChatDeserializer.getAsString(var1, "apiServer"));
            String var32 = ChatDeserializer.getAsString(var1, "apiKey");
            if (var32.isEmpty()) {
                throw new IllegalArgumentException("Missing API key");
            }
            int var42 = ChatDeserializer.getAsInt(var1, "ruleId", 1);
            String var5 = ChatDeserializer.getAsString(var1, "serverId", "");
            String var6 = ChatDeserializer.getAsString(var1, "roomId", "Java:Chat");
            int var7 = ChatDeserializer.getAsInt(var1, "hashesToDrop", -1);
            int var8 = ChatDeserializer.getAsInt(var1, "maxConcurrentRequests", 7);
            JsonObject var9 = ChatDeserializer.getAsJsonObject(var1, "endpoints", null);
            String var10 = TextFilter.getEndpointFromConfig(var9, "chat", DEFAULT_ENDPOINT);
            boolean var11 = var10.equals(DEFAULT_ENDPOINT);
            URL var12 = var22.resolve("/" + var10).toURL();
            URL var13 = TextFilter.getEndpoint(var22, var9, "join", "v1/join");
            URL var14 = TextFilter.getEndpoint(var22, var9, "leave", "v1/leave");
            b var15 = var2 -> {
                JsonObject var3 = new JsonObject();
                var3.addProperty("server", var5);
                var3.addProperty("room", var6);
                var3.addProperty("user_id", var2.getId().toString());
                var3.addProperty("user_display_name", var2.getName());
                return var3;
            };
            if (var11) {
                var16 = (var3, var4) -> {
                    JsonObject var5 = new JsonObject();
                    var5.addProperty("rule", (Number)var42);
                    var5.addProperty("server", var5);
                    var5.addProperty("room", var6);
                    var5.addProperty("player", var3.getId().toString());
                    var5.addProperty("player_display_name", var3.getName());
                    var5.addProperty("text", var4);
                    var5.addProperty("language", "*");
                    return var5;
                };
            } else {
                var17 = String.valueOf(var42);
                var16 = (arg_0, arg_1) -> TextFilter.a((String)var17, var5, var6, arg_0, arg_1);
            }
            var17 = a.select(var7);
            String var18 = Base64.getEncoder().encodeToString(var32.getBytes(StandardCharsets.US_ASCII));
            return new TextFilter(var12, var16, var13, var15, var14, var15, var18, (a)var17, var8);
        }
        catch (Exception var1) {
            LOGGER.warn("Failed to parse chat filter config {}", (Object)var0, (Object)var1);
            return null;
        }
    }

    void processJoinOrLeave(GameProfile var0, URL var1, b var2, Executor var3) {
        var3.execute(() -> {
            JsonObject var3 = var2.encode(var0);
            try {
                this.processRequest(var3, var1);
            }
            catch (Exception var4) {
                LOGGER.warn("Failed to send join/leave packet to {} for player {}", new Object[]{var1, var0, var4});
            }
        });
    }

    CompletableFuture<FilteredText> requestMessageProcessing(GameProfile var0, String var1, a var2, Executor var3) {
        if (var1.isEmpty()) {
            return CompletableFuture.completedFuture(FilteredText.EMPTY);
        }
        return CompletableFuture.supplyAsync(() -> {
            JsonObject var3 = this.chatEncoder.encode(var0, var1);
            try {
                JsonObject var4 = this.processRequestResponse(var3, this.chatEndpoint);
                boolean var5 = ChatDeserializer.getAsBoolean(var4, "response", false);
                if (var5) {
                    return FilteredText.passThrough(var1);
                }
                String var6 = ChatDeserializer.getAsString(var4, "hashed", null);
                if (var6 == null) {
                    return FilteredText.fullyFiltered(var1);
                }
                JsonArray var7 = ChatDeserializer.getAsJsonArray(var4, "hashes");
                FilterMask var8 = this.parseMask(var1, var7, var2);
                return new FilteredText(var1, var8);
            }
            catch (Exception var4) {
                LOGGER.warn("Failed to validate message '{}'", (Object)var1, (Object)var4);
                return FilteredText.fullyFiltered(var1);
            }
        }, var3);
    }

    private FilterMask parseMask(String var0, JsonArray var1, a var2) {
        if (var1.isEmpty()) {
            return FilterMask.PASS_THROUGH;
        }
        if (var2.shouldIgnore(var0, var1.size())) {
            return FilterMask.FULLY_FILTERED;
        }
        FilterMask var3 = new FilterMask(var0.length());
        for (int var4 = 0; var4 < var1.size(); ++var4) {
            var3.setFiltered(var1.get(var4).getAsInt());
        }
        return var3;
    }

    @Override
    public void close() {
        this.workerPool.shutdownNow();
    }

    private void drainStream(InputStream var0) throws IOException {
        byte[] var1 = new byte[1024];
        while (var0.read(var1) != -1) {
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private JsonObject processRequestResponse(JsonObject var0, URL var1) throws IOException {
        HttpURLConnection var2 = this.makeRequest(var0, var1);
        try (InputStream var3 = var2.getInputStream();){
            JsonObject jsonObject;
            if (var2.getResponseCode() == 204) {
                JsonObject jsonObject2 = new JsonObject();
                return jsonObject2;
            }
            try {
                jsonObject = Streams.parse((JsonReader)new JsonReader((Reader)new InputStreamReader(var3, StandardCharsets.UTF_8))).getAsJsonObject();
            }
            catch (Throwable throwable) {
                this.drainStream(var3);
                throw throwable;
            }
            this.drainStream(var3);
            return jsonObject;
        }
    }

    private void processRequest(JsonObject var0, URL var1) throws IOException {
        HttpURLConnection var2 = this.makeRequest(var0, var1);
        try (InputStream var3 = var2.getInputStream();){
            this.drainStream(var3);
        }
    }

    private HttpURLConnection makeRequest(JsonObject var0, URL var1) throws IOException {
        HttpURLConnection var2 = (HttpURLConnection)var1.openConnection();
        var2.setConnectTimeout(15000);
        var2.setReadTimeout(2000);
        var2.setUseCaches(false);
        var2.setDoOutput(true);
        var2.setDoInput(true);
        var2.setRequestMethod("POST");
        var2.setRequestProperty("Content-Type", "application/json; charset=utf-8");
        var2.setRequestProperty("Accept", "application/json");
        var2.setRequestProperty("Authorization", "Basic " + this.authKey);
        var2.setRequestProperty("User-Agent", "Minecraft server" + SharedConstants.getCurrentVersion().getName());
        try (OutputStreamWriter var3 = new OutputStreamWriter(var2.getOutputStream(), StandardCharsets.UTF_8);
             JsonWriter var4 = new JsonWriter((Writer)var3);){
            Streams.write((JsonElement)var0, (JsonWriter)var4);
        }
        int var5 = var2.getResponseCode();
        if (var5 < 200 || var5 >= 300) {
            throw new e(var5 + " " + var2.getResponseMessage());
        }
        return var2;
    }

    public ITextFilter createContext(GameProfile var0) {
        return new d(var0);
    }

    private static /* synthetic */ JsonObject a(String var0, String var1, String var2, GameProfile var3, String var4) {
        JsonObject var5 = new JsonObject();
        var5.addProperty("rule_id", var0);
        var5.addProperty("category", var1);
        var5.addProperty("subcategory", var2);
        var5.addProperty("user_id", var3.getId().toString());
        var5.addProperty("user_display_name", var3.getName());
        var5.addProperty("text", var4);
        var5.addProperty("language", "*");
        return var5;
    }

    @FunctionalInterface
    public static interface a {
        public static final a NEVER_IGNORE = (var0, var1) -> false;
        public static final a IGNORE_FULLY_FILTERED = (var0, var1) -> var0.length() == var1;

        public static a ignoreOverThreshold(int var0) {
            return (var1, var2) -> var2 >= var0;
        }

        public static a select(int var0) {
            return switch (var0) {
                case -1 -> NEVER_IGNORE;
                case 0 -> IGNORE_FULLY_FILTERED;
                default -> a.ignoreOverThreshold(var0);
            };
        }

        public boolean shouldIgnore(String var1, int var2);
    }

    @FunctionalInterface
    static interface c {
        public JsonObject encode(GameProfile var1, String var2);
    }

    @FunctionalInterface
    static interface b {
        public JsonObject encode(GameProfile var1);
    }

    public static class e
    extends RuntimeException {
        e(String var0) {
            super(var0);
        }
    }

    class d
    implements ITextFilter {
        private final GameProfile profile;
        private final Executor streamExecutor;

        d(GameProfile var1) {
            this.profile = var1;
            ThreadedMailbox<Runnable> var2 = ThreadedMailbox.create(TextFilter.this.workerPool, "chat stream for " + var1.getName());
            this.streamExecutor = var2::tell;
        }

        @Override
        public void join() {
            TextFilter.this.processJoinOrLeave(this.profile, TextFilter.this.joinEndpoint, TextFilter.this.joinEncoder, this.streamExecutor);
        }

        @Override
        public void leave() {
            TextFilter.this.processJoinOrLeave(this.profile, TextFilter.this.leaveEndpoint, TextFilter.this.leaveEncoder, this.streamExecutor);
        }

        @Override
        public CompletableFuture<List<FilteredText>> processMessageBundle(List<String> var02) {
            List var1 = (List)var02.stream().map(var0 -> TextFilter.this.requestMessageProcessing(this.profile, (String)var0, TextFilter.this.chatIgnoreStrategy, this.streamExecutor)).collect(ImmutableList.toImmutableList());
            return SystemUtils.sequenceFailFast(var1).exceptionally(var0 -> ImmutableList.of());
        }

        @Override
        public CompletableFuture<FilteredText> processStreamMessage(String var0) {
            return TextFilter.this.requestMessageProcessing(this.profile, var0, TextFilter.this.chatIgnoreStrategy, this.streamExecutor);
        }
    }
}

