/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.packs.repository;

import com.mojang.logging.LogUtils;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.SharedConstants;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.server.packs.EnumResourcePackType;
import net.minecraft.server.packs.FeatureFlagsMetadataSection;
import net.minecraft.server.packs.IResourcePack;
import net.minecraft.server.packs.OverlayMetadataSection;
import net.minecraft.server.packs.PackLocationInfo;
import net.minecraft.server.packs.PackSelectionConfig;
import net.minecraft.server.packs.metadata.pack.ResourcePackInfo;
import net.minecraft.server.packs.repository.EnumResourcePackVersion;
import net.minecraft.server.packs.repository.PackSource;
import net.minecraft.util.InclusiveRange;
import net.minecraft.world.flag.FeatureFlagSet;
import org.slf4j.Logger;

public class ResourcePackLoader {
    private static final Logger LOGGER = LogUtils.getLogger();
    private final PackLocationInfo location;
    public final c resources;
    private final a metadata;
    private final PackSelectionConfig selectionConfig;

    @Nullable
    public static ResourcePackLoader readMetaAndCreate(PackLocationInfo var0, c var1, EnumResourcePackType var2, PackSelectionConfig var3) {
        int var4 = SharedConstants.getCurrentVersion().getPackVersion(var2);
        a var5 = ResourcePackLoader.readPackMetadata(var0, var1, var4);
        return var5 != null ? new ResourcePackLoader(var0, var1, var5, var3) : null;
    }

    public ResourcePackLoader(PackLocationInfo var0, c var1, a var2, PackSelectionConfig var3) {
        this.location = var0;
        this.resources = var1;
        this.metadata = var2;
        this.selectionConfig = var3;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    public static a readPackMetadata(PackLocationInfo var0, c var1, int var2) {
        try (IResourcePack var3 = var1.openPrimary(var0);){
            ResourcePackInfo var4 = var3.getMetadataSection(ResourcePackInfo.TYPE);
            if (var4 == null) {
                LOGGER.warn("Missing metadata in pack {}", (Object)var0.id());
                a a2 = null;
                return a2;
            }
            FeatureFlagsMetadataSection var5 = var3.getMetadataSection(FeatureFlagsMetadataSection.TYPE);
            FeatureFlagSet var6 = var5 != null ? var5.flags() : FeatureFlagSet.of();
            InclusiveRange<Integer> var7 = ResourcePackLoader.getDeclaredPackVersions(var0.id(), var4);
            EnumResourcePackVersion var8 = EnumResourcePackVersion.forVersion(var7, var2);
            OverlayMetadataSection var9 = var3.getMetadataSection(OverlayMetadataSection.TYPE);
            List<String> var10 = var9 != null ? var9.overlaysForVersion(var2) : List.of();
            a a3 = new a(var4.description(), var8, var6, var10);
            return a3;
        }
        catch (Exception var32) {
            LOGGER.warn("Failed to read pack {} metadata", (Object)var0.id(), (Object)var32);
            return null;
        }
    }

    private static InclusiveRange<Integer> getDeclaredPackVersions(String var0, ResourcePackInfo var1) {
        int var2 = var1.packFormat();
        if (var1.supportedFormats().isEmpty()) {
            return new InclusiveRange<Integer>(var2);
        }
        InclusiveRange<Integer> var3 = var1.supportedFormats().get();
        if (!var3.isValueInRange(var2)) {
            LOGGER.warn("Pack {} declared support for versions {} but declared main format is {}, defaulting to {}", new Object[]{var0, var3, var2, var2});
            return new InclusiveRange<Integer>(var2);
        }
        return var3;
    }

    public PackLocationInfo location() {
        return this.location;
    }

    public IChatBaseComponent getTitle() {
        return this.location.title();
    }

    public IChatBaseComponent getDescription() {
        return this.metadata.description();
    }

    public IChatBaseComponent getChatLink(boolean var0) {
        return this.location.createChatLink(var0, this.metadata.description);
    }

    public EnumResourcePackVersion getCompatibility() {
        return this.metadata.compatibility();
    }

    public FeatureFlagSet getRequestedFeatures() {
        return this.metadata.requestedFeatures();
    }

    public IResourcePack open() {
        return this.resources.openFull(this.location, this.metadata);
    }

    public String getId() {
        return this.location.id();
    }

    public PackSelectionConfig selectionConfig() {
        return this.selectionConfig;
    }

    public boolean isRequired() {
        return this.selectionConfig.required();
    }

    public boolean isFixedPosition() {
        return this.selectionConfig.fixedPosition();
    }

    public Position getDefaultPosition() {
        return this.selectionConfig.defaultPosition();
    }

    public PackSource getPackSource() {
        return this.location.source();
    }

    public boolean equals(Object var0) {
        if (this == var0) {
            return true;
        }
        if (!(var0 instanceof ResourcePackLoader)) {
            return false;
        }
        ResourcePackLoader var1 = (ResourcePackLoader)var0;
        return this.location.equals(var1.location);
    }

    public int hashCode() {
        return this.location.hashCode();
    }

    public static interface c {
        public IResourcePack openPrimary(PackLocationInfo var1);

        public IResourcePack openFull(PackLocationInfo var1, a var2);
    }

    public static final class a
    extends Record {
        final IChatBaseComponent description;
        private final EnumResourcePackVersion compatibility;
        private final FeatureFlagSet requestedFeatures;
        private final List<String> overlays;

        public a(IChatBaseComponent var0, EnumResourcePackVersion var1, FeatureFlagSet var2, List<String> var3) {
            this.description = var0;
            this.compatibility = var1;
            this.requestedFeatures = var2;
            this.overlays = var3;
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{a.class, "description;compatibility;requestedFeatures;overlays", "description", "compatibility", "requestedFeatures", "overlays"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{a.class, "description;compatibility;requestedFeatures;overlays", "description", "compatibility", "requestedFeatures", "overlays"}, this);
        }

        @Override
        public final boolean equals(Object var0) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{a.class, "description;compatibility;requestedFeatures;overlays", "description", "compatibility", "requestedFeatures", "overlays"}, this, var0);
        }

        public IChatBaseComponent description() {
            return this.description;
        }

        public EnumResourcePackVersion compatibility() {
            return this.compatibility;
        }

        public FeatureFlagSet requestedFeatures() {
            return this.requestedFeatures;
        }

        public List<String> overlays() {
            return this.overlays;
        }
    }

    public static final class Position
    extends Enum<Position> {
        public static final /* enum */ Position TOP = new Position();
        public static final /* enum */ Position BOTTOM = new Position();
        private static final /* synthetic */ Position[] c;

        public static Position[] values() {
            return (Position[])c.clone();
        }

        public static Position valueOf(String var0) {
            return Enum.valueOf(Position.class, var0);
        }

        public <T> int insert(List<T> var0, T var1, Function<T, PackSelectionConfig> var2, boolean var3) {
            PackSelectionConfig var6;
            int var5;
            Position var4;
            Position position = var4 = var3 ? this.opposite() : this;
            if (var4 == BOTTOM) {
                PackSelectionConfig var62;
                int var52;
                for (var52 = 0; var52 < var0.size() && (var62 = var2.apply(var0.get(var52))).fixedPosition() && var62.defaultPosition() == this; ++var52) {
                }
                var0.add(var52, var1);
                return var52;
            }
            for (var5 = var0.size() - 1; var5 >= 0 && (var6 = var2.apply(var0.get(var5))).fixedPosition() && var6.defaultPosition() == this; --var5) {
            }
            var0.add(var5 + 1, var1);
            return var5 + 1;
        }

        public Position opposite() {
            return this == TOP ? BOTTOM : TOP;
        }

        private static /* synthetic */ Position[] b() {
            return new Position[]{TOP, BOTTOM};
        }

        static {
            c = Position.b();
        }
    }
}

