/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.packs.resources;

import com.google.common.collect.ImmutableMap;
import com.google.gson.JsonObject;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.Optional;
import net.minecraft.server.packs.metadata.ResourcePackMetaParser;
import net.minecraft.server.packs.resources.IoSupplier;
import net.minecraft.util.ChatDeserializer;

public interface ResourceMetadata {
    public static final ResourceMetadata EMPTY = new ResourceMetadata(){

        @Override
        public <T> Optional<T> getSection(ResourcePackMetaParser<T> var0) {
            return Optional.empty();
        }
    };
    public static final IoSupplier<ResourceMetadata> EMPTY_SUPPLIER = () -> EMPTY;

    public static ResourceMetadata fromJsonStream(InputStream var0) throws IOException {
        try (BufferedReader var1 = new BufferedReader(new InputStreamReader(var0, StandardCharsets.UTF_8));){
            final JsonObject var2 = ChatDeserializer.parse(var1);
            ResourceMetadata resourceMetadata = new ResourceMetadata(){

                @Override
                public <T> Optional<T> getSection(ResourcePackMetaParser<T> var0) {
                    String var1 = var0.getMetadataSectionName();
                    return var2.has(var1) ? Optional.of(var0.fromJson(ChatDeserializer.getAsJsonObject(var2, var1))) : Optional.empty();
                }
            };
            return resourceMetadata;
        }
    }

    public <T> Optional<T> getSection(ResourcePackMetaParser<T> var1);

    default public ResourceMetadata copySections(Collection<ResourcePackMetaParser<?>> var0) {
        a var1 = new a();
        for (ResourcePackMetaParser<?> var3 : var0) {
            this.copySection(var1, var3);
        }
        return var1.build();
    }

    private <T> void copySection(a var0, ResourcePackMetaParser<T> var1) {
        this.getSection(var1).ifPresent(var2 -> var0.put(var1, var2));
    }

    public static class a {
        private final ImmutableMap.Builder<ResourcePackMetaParser<?>, Object> map = ImmutableMap.builder();

        public <T> a put(ResourcePackMetaParser<T> var0, T var1) {
            this.map.put(var0, var1);
            return this;
        }

        public ResourceMetadata build() {
            final ImmutableMap var0 = this.map.build();
            if (var0.isEmpty()) {
                return EMPTY;
            }
            return new ResourceMetadata(this){

                @Override
                public <T> Optional<T> getSection(ResourcePackMetaParser<T> var02) {
                    return Optional.ofNullable(var0.get(var02));
                }
            };
        }
    }
}

