/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.players;

import com.google.gson.JsonObject;
import com.mojang.authlib.GameProfile;
import java.util.Date;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.server.players.ExpirableListEntry;

public class GameProfileBanEntry
extends ExpirableListEntry<GameProfile> {
    public GameProfileBanEntry(@Nullable GameProfile gameprofile) {
        this(gameprofile, (Date)null, (String)null, (Date)null, (String)null);
    }

    public GameProfileBanEntry(@Nullable GameProfile gameprofile, @Nullable Date date, @Nullable String s2, @Nullable Date date1, @Nullable String s1) {
        super(gameprofile, date, s2, date1, s1);
    }

    public GameProfileBanEntry(JsonObject jsonobject) {
        super(GameProfileBanEntry.createGameProfile(jsonobject), jsonobject);
    }

    @Override
    protected void serialize(JsonObject jsonobject) {
        if (this.getUser() != null) {
            jsonobject.addProperty("uuid", ((GameProfile)this.getUser()).getId().toString());
            jsonobject.addProperty("name", ((GameProfile)this.getUser()).getName());
            super.serialize(jsonobject);
        }
    }

    @Override
    public IChatBaseComponent getDisplayName() {
        GameProfile gameprofile = (GameProfile)this.getUser();
        return gameprofile != null ? IChatBaseComponent.literal(gameprofile.getName()) : IChatBaseComponent.translatable("commands.banlist.entry.unknown");
    }

    @Nullable
    private static GameProfile createGameProfile(JsonObject jsonobject) {
        UUID uuid = null;
        String name = null;
        if (jsonobject.has("uuid")) {
            String s2 = jsonobject.get("uuid").getAsString();
            try {
                uuid = UUID.fromString(s2);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        if (jsonobject.has("name")) {
            name = jsonobject.get("name").getAsString();
        }
        if (uuid != null || name != null) {
            return new GameProfile(uuid, name);
        }
        return null;
    }
}

