/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.players;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.io.Files;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.ProfileLookupCallback;
import com.mojang.authlib.yggdrasil.ProfileNotFoundException;
import com.mojang.logging.LogUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.UUIDUtil;
import net.minecraft.nbt.NBTCompressedStreamTools;
import net.minecraft.nbt.NBTReadLimiter;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.dedicated.DedicatedServer;
import net.minecraft.server.players.ExpirableListEntry;
import net.minecraft.server.players.GameProfileBanEntry;
import net.minecraft.server.players.GameProfileBanList;
import net.minecraft.server.players.IpBanEntry;
import net.minecraft.server.players.IpBanList;
import net.minecraft.server.players.OpList;
import net.minecraft.server.players.OpListEntry;
import net.minecraft.server.players.PlayerList;
import net.minecraft.server.players.WhiteList;
import net.minecraft.server.players.WhiteListEntry;
import net.minecraft.util.UtilColor;
import net.minecraft.world.level.storage.SavedFile;
import org.slf4j.Logger;
import org.spigotmc.SpigotConfig;

public class NameReferencingFileConverter {
    static final Logger LOGGER = LogUtils.getLogger();
    public static final File OLD_IPBANLIST = new File("banned-ips.txt");
    public static final File OLD_USERBANLIST = new File("banned-players.txt");
    public static final File OLD_OPLIST = new File("ops.txt");
    public static final File OLD_WHITELIST = new File("white-list.txt");

    static List<String> readOldListFormat(File file, Map<String, String[]> map) throws IOException {
        List list = Files.readLines((File)file, (Charset)StandardCharsets.UTF_8);
        for (String s2 : list) {
            if ((s2 = s2.trim()).startsWith("#") || s2.length() < 1) continue;
            String[] astring = s2.split("\\|");
            map.put(astring[0].toLowerCase(Locale.ROOT), astring);
        }
        return list;
    }

    private static void lookupPlayers(MinecraftServer minecraftserver, Collection<String> collection, ProfileLookupCallback profilelookupcallback) {
        String[] astring = (String[])collection.stream().filter(s2 -> !UtilColor.isNullOrEmpty(s2)).toArray(String[]::new);
        if (minecraftserver.usesAuthentication() || SpigotConfig.bungee) {
            minecraftserver.getProfileRepository().findProfilesByNames(astring, profilelookupcallback);
        } else {
            String[] astring1 = astring;
            int i2 = astring.length;
            for (int j2 = 0; j2 < i2; ++j2) {
                String s3 = astring1[j2];
                profilelookupcallback.onProfileLookupSucceeded(UUIDUtil.createOfflineProfile(s3));
            }
        }
    }

    public static boolean convertUserBanlist(final MinecraftServer minecraftserver) {
        final GameProfileBanList gameprofilebanlist = new GameProfileBanList(PlayerList.USERBANLIST_FILE);
        if (OLD_USERBANLIST.exists() && OLD_USERBANLIST.isFile()) {
            if (gameprofilebanlist.getFile().exists()) {
                try {
                    gameprofilebanlist.load();
                }
                catch (IOException ioexception) {
                    LOGGER.warn("Could not load existing file {}", (Object)gameprofilebanlist.getFile().getName());
                }
            }
            try {
                final HashMap map = Maps.newHashMap();
                NameReferencingFileConverter.readOldListFormat(OLD_USERBANLIST, map);
                ProfileLookupCallback profilelookupcallback = new ProfileLookupCallback(){

                    public void onProfileLookupSucceeded(GameProfile gameprofile) {
                        minecraftserver.getProfileCache().add(gameprofile);
                        String[] astring = (String[])map.get(gameprofile.getName().toLowerCase(Locale.ROOT));
                        if (astring == null) {
                            LOGGER.warn("Could not convert user banlist entry for {}", (Object)gameprofile.getName());
                            throw new FileConversionException("Profile not in the conversionlist");
                        }
                        Date date = astring.length > 1 ? NameReferencingFileConverter.parseDate(astring[1], null) : null;
                        String s2 = astring.length > 2 ? astring[2] : null;
                        Date date1 = astring.length > 3 ? NameReferencingFileConverter.parseDate(astring[3], null) : null;
                        String s1 = astring.length > 4 ? astring[4] : null;
                        gameprofilebanlist.add(new GameProfileBanEntry(gameprofile, date, s2, date1, s1));
                    }

                    public void onProfileLookupFailed(String s2, Exception exception) {
                        LOGGER.warn("Could not lookup user banlist entry for {}", (Object)s2, (Object)exception);
                        if (!(exception instanceof ProfileNotFoundException)) {
                            throw new FileConversionException("Could not request user " + s2 + " from backend systems", exception);
                        }
                    }
                };
                NameReferencingFileConverter.lookupPlayers(minecraftserver, map.keySet(), profilelookupcallback);
                gameprofilebanlist.save();
                NameReferencingFileConverter.renameOldFile(OLD_USERBANLIST);
                return true;
            }
            catch (IOException ioexception1) {
                LOGGER.warn("Could not read old user banlist to convert it!", (Throwable)ioexception1);
                return false;
            }
            catch (FileConversionException namereferencingfileconverter_fileconversionexception) {
                LOGGER.error("Conversion failed, please try again later", (Throwable)namereferencingfileconverter_fileconversionexception);
                return false;
            }
        }
        return true;
    }

    public static boolean convertIpBanlist(MinecraftServer minecraftserver) {
        IpBanList ipbanlist = new IpBanList(PlayerList.IPBANLIST_FILE);
        if (OLD_IPBANLIST.exists() && OLD_IPBANLIST.isFile()) {
            if (ipbanlist.getFile().exists()) {
                try {
                    ipbanlist.load();
                }
                catch (IOException ioexception) {
                    LOGGER.warn("Could not load existing file {}", (Object)ipbanlist.getFile().getName());
                }
            }
            try {
                HashMap map = Maps.newHashMap();
                NameReferencingFileConverter.readOldListFormat(OLD_IPBANLIST, map);
                for (String s2 : map.keySet()) {
                    String[] astring = (String[])map.get(s2);
                    Date date = astring.length > 1 ? NameReferencingFileConverter.parseDate(astring[1], null) : null;
                    String s1 = astring.length > 2 ? astring[2] : null;
                    Date date1 = astring.length > 3 ? NameReferencingFileConverter.parseDate(astring[3], null) : null;
                    String s22 = astring.length > 4 ? astring[4] : null;
                    ipbanlist.add(new IpBanEntry(s2, date, s1, date1, s22));
                }
                ipbanlist.save();
                NameReferencingFileConverter.renameOldFile(OLD_IPBANLIST);
                return true;
            }
            catch (IOException ioexception1) {
                LOGGER.warn("Could not parse old ip banlist to convert it!", (Throwable)ioexception1);
                return false;
            }
        }
        return true;
    }

    public static boolean convertOpsList(final MinecraftServer minecraftserver) {
        final OpList oplist = new OpList(PlayerList.OPLIST_FILE);
        if (OLD_OPLIST.exists() && OLD_OPLIST.isFile()) {
            if (oplist.getFile().exists()) {
                try {
                    oplist.load();
                }
                catch (IOException ioexception) {
                    LOGGER.warn("Could not load existing file {}", (Object)oplist.getFile().getName());
                }
            }
            try {
                List list = Files.readLines((File)OLD_OPLIST, (Charset)StandardCharsets.UTF_8);
                ProfileLookupCallback profilelookupcallback = new ProfileLookupCallback(){

                    public void onProfileLookupSucceeded(GameProfile gameprofile) {
                        minecraftserver.getProfileCache().add(gameprofile);
                        oplist.add(new OpListEntry(gameprofile, minecraftserver.getOperatorUserPermissionLevel(), false));
                    }

                    public void onProfileLookupFailed(String s2, Exception exception) {
                        LOGGER.warn("Could not lookup oplist entry for {}", (Object)s2, (Object)exception);
                        if (!(exception instanceof ProfileNotFoundException)) {
                            throw new FileConversionException("Could not request user " + s2 + " from backend systems", exception);
                        }
                    }
                };
                NameReferencingFileConverter.lookupPlayers(minecraftserver, list, profilelookupcallback);
                oplist.save();
                NameReferencingFileConverter.renameOldFile(OLD_OPLIST);
                return true;
            }
            catch (IOException ioexception1) {
                LOGGER.warn("Could not read old oplist to convert it!", (Throwable)ioexception1);
                return false;
            }
            catch (FileConversionException namereferencingfileconverter_fileconversionexception) {
                LOGGER.error("Conversion failed, please try again later", (Throwable)namereferencingfileconverter_fileconversionexception);
                return false;
            }
        }
        return true;
    }

    public static boolean convertWhiteList(final MinecraftServer minecraftserver) {
        final WhiteList whitelist = new WhiteList(PlayerList.WHITELIST_FILE);
        if (OLD_WHITELIST.exists() && OLD_WHITELIST.isFile()) {
            if (whitelist.getFile().exists()) {
                try {
                    whitelist.load();
                }
                catch (IOException ioexception) {
                    LOGGER.warn("Could not load existing file {}", (Object)whitelist.getFile().getName());
                }
            }
            try {
                List list = Files.readLines((File)OLD_WHITELIST, (Charset)StandardCharsets.UTF_8);
                ProfileLookupCallback profilelookupcallback = new ProfileLookupCallback(){

                    public void onProfileLookupSucceeded(GameProfile gameprofile) {
                        minecraftserver.getProfileCache().add(gameprofile);
                        whitelist.add(new WhiteListEntry(gameprofile));
                    }

                    public void onProfileLookupFailed(String s2, Exception exception) {
                        LOGGER.warn("Could not lookup user whitelist entry for {}", (Object)s2, (Object)exception);
                        if (!(exception instanceof ProfileNotFoundException)) {
                            throw new FileConversionException("Could not request user " + s2 + " from backend systems", exception);
                        }
                    }
                };
                NameReferencingFileConverter.lookupPlayers(minecraftserver, list, profilelookupcallback);
                whitelist.save();
                NameReferencingFileConverter.renameOldFile(OLD_WHITELIST);
                return true;
            }
            catch (IOException ioexception1) {
                LOGGER.warn("Could not read old whitelist to convert it!", (Throwable)ioexception1);
                return false;
            }
            catch (FileConversionException namereferencingfileconverter_fileconversionexception) {
                LOGGER.error("Conversion failed, please try again later", (Throwable)namereferencingfileconverter_fileconversionexception);
                return false;
            }
        }
        return true;
    }

    @Nullable
    public static UUID convertMobOwnerIfNecessary(final MinecraftServer minecraftserver, String s2) {
        if (!UtilColor.isNullOrEmpty(s2) && s2.length() <= 16) {
            Optional<UUID> optional = minecraftserver.getProfileCache().get(s2).map(GameProfile::getId);
            if (optional.isPresent()) {
                return optional.get();
            }
            if (!minecraftserver.isSingleplayer() && minecraftserver.usesAuthentication()) {
                final ArrayList list = Lists.newArrayList();
                ProfileLookupCallback profilelookupcallback = new ProfileLookupCallback(){

                    public void onProfileLookupSucceeded(GameProfile gameprofile) {
                        minecraftserver.getProfileCache().add(gameprofile);
                        list.add(gameprofile);
                    }

                    public void onProfileLookupFailed(String s1, Exception exception) {
                        LOGGER.warn("Could not lookup user whitelist entry for {}", (Object)s1, (Object)exception);
                    }
                };
                NameReferencingFileConverter.lookupPlayers(minecraftserver, Lists.newArrayList((Object[])new String[]{s2}), profilelookupcallback);
                return !list.isEmpty() ? ((GameProfile)list.get(0)).getId() : null;
            }
            return UUIDUtil.createOfflinePlayerUUID(s2);
        }
        try {
            return UUID.fromString(s2);
        }
        catch (IllegalArgumentException illegalargumentexception) {
            return null;
        }
    }

    public static boolean convertPlayers(final DedicatedServer dedicatedserver) {
        final File file = NameReferencingFileConverter.getWorldPlayersDirectory(dedicatedserver);
        final File file1 = new File(file.getParentFile(), "playerdata");
        final File file2 = new File(file.getParentFile(), "unknownplayers");
        if (file.exists() && file.isDirectory()) {
            File[] afile = file.listFiles();
            ArrayList list = Lists.newArrayList();
            File[] afile1 = afile;
            int i2 = afile.length;
            for (int j2 = 0; j2 < i2; ++j2) {
                String s1;
                File file3 = afile1[j2];
                String s2 = file3.getName();
                if (!s2.toLowerCase(Locale.ROOT).endsWith(".dat") || (s1 = s2.substring(0, s2.length() - ".dat".length())).isEmpty()) continue;
                list.add(s1);
            }
            try {
                Object[] astring = list.toArray(new String[list.size()]);
                ProfileLookupCallback profilelookupcallback = new ProfileLookupCallback(){
                    final /* synthetic */ String[] val$astring;
                    {
                        this.val$astring = stringArray;
                    }

                    public void onProfileLookupSucceeded(GameProfile gameprofile) {
                        dedicatedserver.getProfileCache().add(gameprofile);
                        UUID uuid = gameprofile.getId();
                        this.movePlayerFile(file1, this.getFileNameForProfile(gameprofile.getName()), uuid.toString());
                    }

                    public void onProfileLookupFailed(String s2, Exception exception) {
                        LOGGER.warn("Could not lookup user uuid for {}", (Object)s2, (Object)exception);
                        if (!(exception instanceof ProfileNotFoundException)) {
                            throw new FileConversionException("Could not request user " + s2 + " from backend systems", exception);
                        }
                        String s3 = this.getFileNameForProfile(s2);
                        this.movePlayerFile(file2, s3, s3);
                    }

                    private void movePlayerFile(File file4, String s2, String s3) {
                        File file5 = new File(file, s2 + ".dat");
                        File file6 = new File(file4, s3 + ".dat");
                        NBTTagCompound root = null;
                        try {
                            root = NBTCompressedStreamTools.readCompressed(new FileInputStream(file5), NBTReadLimiter.unlimitedHeap());
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                        }
                        if (root != null) {
                            if (!root.contains("bukkit")) {
                                root.put("bukkit", new NBTTagCompound());
                            }
                            NBTTagCompound data = root.getCompound("bukkit");
                            data.putString("lastKnownName", s2);
                            try {
                                NBTCompressedStreamTools.writeCompressed(root, new FileOutputStream(file2));
                            }
                            catch (Exception exception) {
                                exception.printStackTrace();
                            }
                        }
                        NameReferencingFileConverter.ensureDirectoryExists(file4);
                        if (!file5.renameTo(file6)) {
                            throw new FileConversionException("Could not convert file for " + s2);
                        }
                    }

                    private String getFileNameForProfile(String s2) {
                        String s3 = null;
                        for (String s4 : this.val$astring) {
                            if (s4 == null || !s4.equalsIgnoreCase(s2)) continue;
                            s3 = s4;
                            break;
                        }
                        if (s3 == null) {
                            throw new FileConversionException("Could not find the filename for " + s2 + " anymore");
                        }
                        return s3;
                    }
                };
                NameReferencingFileConverter.lookupPlayers(dedicatedserver, Lists.newArrayList((Object[])astring), profilelookupcallback);
                return true;
            }
            catch (FileConversionException namereferencingfileconverter_fileconversionexception) {
                LOGGER.error("Conversion failed, please try again later", (Throwable)namereferencingfileconverter_fileconversionexception);
                return false;
            }
        }
        return true;
    }

    static void ensureDirectoryExists(File file) {
        if (file.exists() ? !file.isDirectory() : !file.mkdirs()) {
            throw new FileConversionException("Can't create directory " + file.getName() + " in world save directory.");
        }
    }

    public static boolean serverReadyAfterUserconversion(MinecraftServer minecraftserver) {
        boolean flag = NameReferencingFileConverter.areOldUserlistsRemoved();
        flag = flag && NameReferencingFileConverter.areOldPlayersConverted(minecraftserver);
        return flag;
    }

    private static boolean areOldUserlistsRemoved() {
        boolean flag = false;
        if (OLD_USERBANLIST.exists() && OLD_USERBANLIST.isFile()) {
            flag = true;
        }
        boolean flag1 = false;
        if (OLD_IPBANLIST.exists() && OLD_IPBANLIST.isFile()) {
            flag1 = true;
        }
        boolean flag2 = false;
        if (OLD_OPLIST.exists() && OLD_OPLIST.isFile()) {
            flag2 = true;
        }
        boolean flag3 = false;
        if (OLD_WHITELIST.exists() && OLD_WHITELIST.isFile()) {
            flag3 = true;
        }
        if (!(flag || flag1 || flag2 || flag3)) {
            return true;
        }
        LOGGER.warn("**** FAILED TO START THE SERVER AFTER ACCOUNT CONVERSION!");
        LOGGER.warn("** please remove the following files and restart the server:");
        if (flag) {
            LOGGER.warn("* {}", (Object)OLD_USERBANLIST.getName());
        }
        if (flag1) {
            LOGGER.warn("* {}", (Object)OLD_IPBANLIST.getName());
        }
        if (flag2) {
            LOGGER.warn("* {}", (Object)OLD_OPLIST.getName());
        }
        if (flag3) {
            LOGGER.warn("* {}", (Object)OLD_WHITELIST.getName());
        }
        return false;
    }

    private static boolean areOldPlayersConverted(MinecraftServer minecraftserver) {
        File file = NameReferencingFileConverter.getWorldPlayersDirectory(minecraftserver);
        if (file.exists() && file.isDirectory() && (file.list().length > 0 || !file.delete())) {
            LOGGER.warn("**** DETECTED OLD PLAYER DIRECTORY IN THE WORLD SAVE");
            LOGGER.warn("**** THIS USUALLY HAPPENS WHEN THE AUTOMATIC CONVERSION FAILED IN SOME WAY");
            LOGGER.warn("** please restart the server and if the problem persists, remove the directory '{}'", (Object)file.getPath());
            return false;
        }
        return true;
    }

    private static File getWorldPlayersDirectory(MinecraftServer minecraftserver) {
        return minecraftserver.getWorldPath(SavedFile.PLAYER_OLD_DATA_DIR).toFile();
    }

    private static void renameOldFile(File file) {
        File file1 = new File(file.getName() + ".converted");
        file.renameTo(file1);
    }

    static Date parseDate(String s2, Date date) {
        Date date1;
        try {
            date1 = ExpirableListEntry.DATE_FORMAT.parse(s2);
        }
        catch (ParseException parseexception) {
            date1 = date;
        }
        return date1;
    }

    private static class FileConversionException
    extends RuntimeException {
        FileConversionException(String s2, Throwable throwable) {
            super(s2, throwable);
        }

        FileConversionException(String s2) {
            super(s2);
        }
    }
}

